/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata;

import com.google.common.collect.ImmutableBiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.annotation.GlobalDynamicRowPluginFlag;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchCellSummaryDto;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.helper.bd.taxcategory.TaxCategoryDataServiceHelper;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.gtcp.business.fetchitem.FetchItemBusiness;
import kd.taxc.gtcp.business.tctb.TaxPeriodBusiness;
import kd.taxc.gtcp.common.constant.GtcpConstant;
import kd.taxc.gtcp.common.enums.UsaDynRowEnum;
import kd.taxc.gtcp.common.enums.UsaTaxAreaGroupColumnEnum;
import kd.taxc.gtcp.formplugin.fetchdata.AbstractGeneralDynamicRowListFetchPlugin;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.StringUtils;

@GlobalDynamicRowPluginFlag
public class USADynamicRowListFetchPlugin
extends AbstractGeneralDynamicRowListFetchPlugin {
    private static final Log logger = LogFactory.getLog(USADynamicRowListFetchPlugin.class);

    @Override
    public List<DynamicRowModel> globalDynrowQuery(BussinessParamsVo bussinessParamsVo) {
        String areaJsonStr;
        Map extendParams = bussinessParamsVo.getExtendParams();
        Long taxAreaGroupId = Long.parseLong(extendParams.get("taxareagroup").toString());
        ArrayList<Long> areaList = new ArrayList<Long>(12);
        areaList.add(taxAreaGroupId);
        if (MapUtils.isNotEmpty((Map)bussinessParamsVo.getExtendParams()) && bussinessParamsVo.getExtendParams().get("USA_CIT_TAX_AREA_LIST") != null && StringUtils.isNotEmpty((CharSequence)(areaJsonStr = (String)bussinessParamsVo.getExtendParams().get("USA_CIT_TAX_AREA_LIST")))) {
            List listFromJsonStr = (List)SerializationUtils.fromJsonString((String)areaJsonStr, List.class);
            areaList.addAll(listFromJsonStr);
        }
        bussinessParamsVo.getExtendParams().put("usaTaxAreaGroupRange", areaList);
        return super.globalDynrowQuery(bussinessParamsVo);
    }

    @Override
    protected Map<String, String> getDynRowBizTypeMap() {
        return null;
    }

    @Override
    protected void buildFetchDynRowList(BussinessParamsVo bussinessParamsVo, Map<String, List<Map<String, Object>>> result, Map<String, String> dynRowBizTypeMap, DynamicObjectCollection fetchItems, RuleFetchMainDto ruleFetchMainDto) {
        for (Map.Entry<String, String> entry : dynRowBizTypeMap.entrySet()) {
            String dynRowNo = entry.getKey();
            UsaTaxAreaGroupColumnEnum columnEnum = UsaTaxAreaGroupColumnEnum.getEnumByDynRow(dynRowNo);
            List<DynamicObject> fetchItemsByBizType = fetchItems.stream().filter(m -> StringUtil.equalsIgnoreCase((CharSequence)((CharSequence)dynRowBizTypeMap.get(dynRowNo)), (CharSequence)m.getString("biztype.number"))).filter(n -> StringUtil.equalsIgnoreCase((CharSequence)columnEnum.getTaxAreaGroupId(), (CharSequence)n.getString("taxareagroup.id"))).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(fetchItemsByBizType)) {
                result.put(dynRowNo, new ArrayList());
                logger.info("\u83b7\u53d6{}\u52a8\u6001\u884c\u6807\u8bc6\u6240\u6709\u76f8\u5173\u53d6\u6570\u9879\u76ee\u6761\u6570\uff1a{}", (Object)dynRowNo, (Object)0);
                continue;
            }
            Map<String, Map<String, Object>> extendResultMap = this.getExtendResultMap(bussinessParamsVo, fetchItems);
            List<Map<String, Object>> mapList = this.getDynListMapByDynRowNo(bussinessParamsVo, dynRowNo, fetchItemsByBizType, ruleFetchMainDto, extendResultMap);
            result.put(dynRowNo, mapList);
        }
    }

    @Override
    protected DynamicObjectCollection getFetchItems(BussinessParamsVo bussinessParamsVo, Map<String, String> dynRowBizTypeMap) {
        Collection<String> values = dynRowBizTypeMap.values();
        Map extendParams = bussinessParamsVo.getExtendParams();
        Long orgId = Long.parseLong(bussinessParamsVo.getOrgId());
        Long taxSystemId = Long.parseLong(extendParams.get("taxationsys").toString());
        Long taxcategoryId = Long.parseLong(extendParams.get("taxcategory").toString());
        ArrayList taxAreaGroupIdList = null == bussinessParamsVo.getExtendParams().get("usaTaxAreaGroupRange") ? new ArrayList() : (List)bussinessParamsVo.getExtendParams().get("usaTaxAreaGroupRange");
        DynamicObjectCollection fetchItems = FetchItemBusiness.getFetchItems(orgId, taxSystemId, taxcategoryId, taxAreaGroupIdList, values);
        logger.info("\u83b7\u53d6\u6240\u6709\u76f8\u5173\u53d6\u6570\u9879\u76ee\u6761\u6570\uff1a{}", (Object)(CollectionUtils.isEmpty((Collection)fetchItems) ? 0 : fetchItems.size()));
        return fetchItems;
    }

    @Override
    protected Map<String, String> getDynRowBizTypeMapByCondition(BussinessParamsVo bussinessParamsVo) {
        HashMap<String, String> dynRowBizTypeMap = new HashMap<String, String>(8);
        List<UsaTaxAreaGroupColumnEnum> list = this.getTaxAreaGroupColumnEnumList(bussinessParamsVo);
        list.stream().forEach(row -> row.getUsaDynRowEnumList().stream().forEach(dynRow -> dynRowBizTypeMap.put(dynRow.getDynRow(), dynRow.getBizType())));
        return dynRowBizTypeMap;
    }

    @Override
    public List<Map<String, Object>> getDynListMapByDynRowNo(BussinessParamsVo bussinessParamsVo, String dynRowNo, List<DynamicObject> fetchItemsByBizType, RuleFetchMainDto ruleFetchMainDto, Map<String, Map<String, Object>> extenResultMap) {
        ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(16);
        HashMap taxAreaGroupProjectIdsMap = new HashMap(8);
        if (!ObjectUtils.isEmpty(fetchItemsByBizType)) {
            logger.info("usacit-getDynListMapByDynRowNo-\u83b7\u53d6\u5230\u7684\u53d6\u6570\u9879\u76ee\u4e1a\u52a1\u7c7b\u522b\u96c6\u5408:" + fetchItemsByBizType.toString());
            fetchItemsByBizType.stream().forEach(dynamicObject -> {
                String accessProjectId = dynamicObject.getString("id");
                String taxAreaGroupId = dynamicObject.getString("taxareagroup.id");
                List<String> list = new ArrayList<String>();
                if (taxAreaGroupProjectIdsMap.containsKey(taxAreaGroupId)) {
                    list = (List)taxAreaGroupProjectIdsMap.get(taxAreaGroupId);
                }
                list.add(accessProjectId);
                taxAreaGroupProjectIdsMap.put(taxAreaGroupId, list);
            });
        }
        List ruleFetchCellSummaryList = ruleFetchMainDto.getRuleFetchCellSummaryList();
        HashMap amountResultMap = new HashMap(8);
        ruleFetchCellSummaryList.stream().forEach(cell -> {
            if (StringUtil.isNotBlank((CharSequence)cell.getFetchEntryentity()) && StringUtil.equalsIgnoreCase((CharSequence)"entryentity", (CharSequence)cell.getFetchEntryentity())) {
                amountResultMap.put(cell.getRuleItem(), this.getAmount((RuleFetchCellSummaryDto)cell));
            }
        });
        logger.info("usacit-getDynListMapByDynRowNo-\u7a0e\u6536\u8f96\u533a\u5bf9\u5e94\u7684\u6240\u6709\u53d6\u6570\u9879\u76ee:" + ((Object)taxAreaGroupProjectIdsMap).toString());
        for (Map.Entry entry : taxAreaGroupProjectIdsMap.entrySet()) {
            String taxAreaGroup = (String)entry.getKey();
            if (!(entry.getValue() instanceof List)) continue;
            List fetchItemList = (List)entry.getValue();
            HashMap<String, Integer> startSequenceMap = new HashMap<String, Integer>();
            for (DynamicObject fetchItem : fetchItemsByBizType) {
                UsaDynRowEnum usaDynRowEnum;
                UsaTaxAreaGroupColumnEnum usaTaxAreaGroupColumnEnum;
                Long xmId = fetchItem.getLong("id");
                String xmIdString = String.valueOf(xmId);
                if (!fetchItemList.contains(xmIdString) && !StringUtil.equalsIgnoreCase((CharSequence)taxAreaGroup, (CharSequence)fetchItem.getString("taxareagroup.id")) || null == (usaTaxAreaGroupColumnEnum = UsaTaxAreaGroupColumnEnum.getEnumByTaxAreaGroupId(taxAreaGroup)) || null == (usaDynRowEnum = UsaDynRowEnum.getEnumByDynRow(dynRowNo))) continue;
                if (!startSequenceMap.containsKey(dynRowNo)) {
                    startSequenceMap.put(dynRowNo, Integer.parseInt(usaDynRowEnum.getStartNumber()));
                } else {
                    startSequenceMap.put(dynRowNo, (Integer)startSequenceMap.get(dynRowNo) + 1);
                }
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                String prefix = dynRowNo.split("#")[0];
                map.put(prefix + "#" + usaTaxAreaGroupColumnEnum.getSerialNoColumn(), usaDynRowEnum.getDynSerialNo() + "." + ((Integer)startSequenceMap.get(dynRowNo)).toString());
                map.put(prefix + "#" + usaTaxAreaGroupColumnEnum.getItemColumn(), xmId);
                if (amountResultMap.containsKey(xmIdString)) {
                    map.put(prefix + "#" + usaTaxAreaGroupColumnEnum.getAmountColumn(), amountResultMap.get(xmIdString));
                } else {
                    map.put(prefix + "#" + usaTaxAreaGroupColumnEnum.getAmountColumn(), "0.00");
                }
                this.setReportItem(xmId, mapList, prefix, usaTaxAreaGroupColumnEnum.getAmountColumn(), ruleFetchMainDto);
                mapList.add(map);
            }
        }
        logger.info("usacit-getDynListMapByDynRowNo-\u7ec4\u88c5\u52a8\u6001\u884c\u5bf9\u8c61\u7ed3\u679c:" + ((Object)mapList).toString());
        return mapList;
    }

    @Override
    protected RuleEngineParamDto getRuleEngineParamDto(BussinessParamsVo bussinessParamsVo, Set<Long> ids) {
        List taxcategoryIdList;
        TaxResult result;
        Map extendParams = bussinessParamsVo.getExtendParams();
        String draftpurpose = (String)extendParams.get("draftpurpose");
        if (ObjectUtils.isEmpty((Object)draftpurpose)) {
            return null;
        }
        Long templateId = (Long)extendParams.get("templateId");
        Long taxSystemId = Long.parseLong((String)extendParams.get("taxationsys"));
        Long taxcategoryId = Long.parseLong(extendParams.get("taxcategory").toString());
        Long taxareagroupId = Long.parseLong(extendParams.get("taxareagroup").toString());
        Long orgId = Long.parseLong(bussinessParamsVo.getOrgId());
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        QFilter taxcategoryQfilter = new QFilter("taxcategory", "=", (Object)taxcategoryId);
        ArrayList taxAreaGroupIdList = null == bussinessParamsVo.getExtendParams().get("usaTaxAreaGroupRange") ? new ArrayList() : (List)bussinessParamsVo.getExtendParams().get("usaTaxAreaGroupRange");
        QFilter taxAreaGroupFilter = new QFilter("taxareagroup", "in", taxAreaGroupIdList);
        QFilter accessConfigTypeQfilter = new QFilter("rulepurpose", "like", (Object)("%" + draftpurpose + "%"));
        QFilter accessWhereFilter = new QFilter("taxationsys", "=", (Object)taxSystemId).and(taxcategoryQfilter).and(taxAreaGroupFilter).and(accessConfigTypeQfilter);
        QFilter sharingPlanWhereFilter = new QFilter("taxationsys", "=", (Object)taxSystemId).and(taxcategoryQfilter).and(taxAreaGroupFilter).and(new QFilter("ruleentity.rule.accessproject", "in", ids)).and(new QFilter("ruleentity.rule.rulepurpose", "like", (Object)("%" + draftpurpose + "%")));
        if (StringUtil.equalsIgnoreCase((CharSequence)draftpurpose, (CharSequence)"sjjt")) {
            List taxcategoryIdList2;
            TaxResult result2 = TaxCategoryDataServiceHelper.queryTaxCategoryByNums(GtcpConstant.SDS);
            if (result2 != null && result2.isSuccess() && (taxcategoryIdList2 = ((List)result2.getData()).stream().map(row -> row.getLong("id")).collect(Collectors.toList())).contains(taxcategoryId)) {
                return new RuleEngineParamDto(orgId, DateUtils.getFirstDateOfYear((Date)startDate), endDate, taxSystemId, taxcategoryId, taxareagroupId, templateId, draftpurpose, accessWhereFilter, sharingPlanWhereFilter, (Map)ImmutableBiMap.of((Object)"originalSkssqq", (Object)startDate, (Object)"usaCitOrgIncludeUsaFt", bussinessParamsVo.getExtendParams().get("usaCitOrgIncludeUsaFt"), (Object)"customEvent", (Object)this.getCustomEventForCal(bussinessParamsVo)));
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)draftpurpose, (CharSequence)"nssb") && (result = TaxCategoryDataServiceHelper.queryTaxCategoryByNums(GtcpConstant.SDS)) != null && result.isSuccess() && (taxcategoryIdList = ((List)result.getData()).stream().map(row -> row.getLong("id")).collect(Collectors.toList())).contains(taxcategoryId)) {
            return new RuleEngineParamDto(orgId, TaxPeriodBusiness.getTaxPeriodStartMonthAndDay(orgId, taxSystemId, taxcategoryId, startDate), endDate, taxSystemId, taxcategoryId, taxareagroupId, templateId, draftpurpose, accessWhereFilter, sharingPlanWhereFilter, (Map)ImmutableBiMap.of((Object)"originalSkssqq", (Object)startDate, (Object)"usaCitOrgIncludeUsaFt", bussinessParamsVo.getExtendParams().get("usaCitOrgIncludeUsaFt"), (Object)"customEvent", (Object)this.getCustomEventForCal(bussinessParamsVo)));
        }
        return new RuleEngineParamDto(orgId, startDate, endDate, taxSystemId, taxcategoryId, taxareagroupId, templateId, draftpurpose, accessWhereFilter, sharingPlanWhereFilter, (Map)ImmutableBiMap.of((Object)"usaCitOrgIncludeUsaFt", bussinessParamsVo.getExtendParams().get("usaCitOrgIncludeUsaFt"), (Object)"customEvent", (Object)this.getCustomEventForCal(bussinessParamsVo)));
    }

    private List<UsaTaxAreaGroupColumnEnum> getTaxAreaGroupColumnEnumList(BussinessParamsVo bussinessParamsVo) {
        ArrayList<UsaTaxAreaGroupColumnEnum> list = new ArrayList<UsaTaxAreaGroupColumnEnum>(8);
        ArrayList taxAreaGroupIdList = null == bussinessParamsVo.getExtendParams().get("usaTaxAreaGroupRange") ? new ArrayList() : (List)bussinessParamsVo.getExtendParams().get("usaTaxAreaGroupRange");
        for (Long taxAreaGroupId : taxAreaGroupIdList) {
            UsaTaxAreaGroupColumnEnum usaTaxAreaGroupColumnEnum = UsaTaxAreaGroupColumnEnum.getEnumByTaxAreaGroupId(String.valueOf(taxAreaGroupId));
            if (null == usaTaxAreaGroupColumnEnum) continue;
            list.add(usaTaxAreaGroupColumnEnum);
        }
        return list;
    }
}

