/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata.UnutilisedLosses;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.tctb.common.util.ObjectUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;

public abstract class AbstractGeneralUnutilisedLossesDynRowPlugin
extends AbstractDynamicListBasePlugin {
    private static final Log logger = LogFactory.getLog(AbstractGeneralUnutilisedLossesDynRowPlugin.class);
    protected static final String TEMPLATE_ID = "templateId";

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        logger.info("start AbstractGeneralUnutilisedLossesDynRowPlugin query");
        Map<String, List<Map<String, Object>>> fetchItemListMap = this.batchFetchDynRowList(bussinessParamsVo);
        if (fetchItemListMap == null) {
            return new ArrayList<Map<String, Object>>();
        }
        String dynRowNo = bussinessParamsVo.getExtendParams().get("dynRowNo").toString();
        return fetchItemListMap.get(dynRowNo) == null ? new ArrayList() : fetchItemListMap.get(dynRowNo);
    }

    public List<DynamicRowModel> globalDynrowQuery(BussinessParamsVo bussinessParamsVo) {
        logger.info("start AbstractGeneralUnutilisedLossesDynRowPlugin globalDynrowQuery");
        Map extendParams = bussinessParamsVo.getExtendParams();
        Long templateId = (Long)extendParams.get(TEMPLATE_ID);
        Map<String, List<Map<String, Object>>> fetchItemListMap = this.batchFetchDynRowList(bussinessParamsVo);
        return this.buildGlobalDynRow(templateId, fetchItemListMap);
    }

    private List<DynamicRowModel> buildGlobalDynRow(Long templateId, Map<String, List<Map<String, Object>>> fetchItemListMap) {
        ArrayList<DynamicRowModel> list = new ArrayList<DynamicRowModel>(8);
        if (null == fetchItemListMap) {
            return list;
        }
        for (Map.Entry<String, List<Map<String, Object>>> entry : fetchItemListMap.entrySet()) {
            DynamicRowModel dynamicRowModel = new DynamicRowModel();
            dynamicRowModel.setTemplateId(templateId);
            dynamicRowModel.setDynRowNo(entry.getKey());
            ArrayList rowList = new ArrayList(8);
            entry.getValue().stream().forEach(row -> rowList.add(new HashMap<String, String>(){
                {
                    for (Map.Entry rowEntry : row.entrySet()) {
                        this.put(rowEntry.getKey(), ObjectUtils.getStringByType(rowEntry.getValue()));
                    }
                }
            }));
            dynamicRowModel.setRowList(rowList);
            list.add(dynamicRowModel);
        }
        return list;
    }

    private Map<String, List<Map<String, Object>>> batchFetchDynRowList(BussinessParamsVo bussinessParamsVo) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(8);
        Map extendParams = bussinessParamsVo.getExtendParams();
        logger.info("start AbstractGeneralDynamicRowListFetchPlugin batchFetchDynRowList");
        if (bussinessParamsVo.getStartDate() == null || bussinessParamsVo.getEndDate() == null || extendParams.get(TEMPLATE_ID) == null || extendParams.get("taxationsys") == null || extendParams.get("taxcategory") == null || extendParams.get("taxareagroup") == null || bussinessParamsVo.getOrgId() == null) {
            return result;
        }
        return this.buildDynRowList(bussinessParamsVo);
    }

    protected Map<String, List<Map<String, Object>>> buildDynRowList(BussinessParamsVo bussinessParamsVo) {
        HashMap<String, List<Map<String, Object>>> resultMap = new HashMap<String, List<Map<String, Object>>>(16);
        Map<String, Map<String, Map<String, String>>> listMap = this.queryBeforeLastDraftId(bussinessParamsVo);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(listMap)) {
            for (Map.Entry<String, Map<String, Map<String, String>>> entry : listMap.entrySet()) {
                String dynKey = entry.getKey();
                Map<String, Map<String, String>> indexMap = entry.getValue();
                indexMap = this.sortMap(indexMap);
                ArrayList list = new ArrayList();
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(indexMap)) {
                    for (Map.Entry<String, Map<String, String>> indexEntry : indexMap.entrySet()) {
                        HashMap<String, Object> listResultMap = new HashMap<String, Object>();
                        Map<String, String> rowMap = indexEntry.getValue();
                        BigDecimal loss_used_prior_tothisyear = BigDecimal.ZERO;
                        BigDecimal loss_used_this_year = BigDecimal.ZERO;
                        String mainDynRow = "";
                        for (Map.Entry<String, String> rowMapEntry : rowMap.entrySet()) {
                            String row;
                            String rowCol = rowMapEntry.getKey();
                            String value = rowMapEntry.getValue();
                            String[] rowCols = rowCol.split("#");
                            mainDynRow = row = rowCols[0];
                            String column = rowCols[2];
                            if (column.equalsIgnoreCase("loss_used_this_year")) {
                                listResultMap.put(row + "#" + column, "0.00");
                            } else {
                                listResultMap.put(row + "#" + column, value);
                            }
                            if (("#" + column).equalsIgnoreCase("#loss_used_prior_tothisyear")) {
                                loss_used_prior_tothisyear = StringUtil.isNumeric((String)value) ? new BigDecimal(value) : BigDecimal.ZERO;
                                continue;
                            }
                            if (!("#" + column).equalsIgnoreCase("#loss_used_this_year")) continue;
                            loss_used_this_year = StringUtil.isNumeric((String)value) ? new BigDecimal(value) : BigDecimal.ZERO;
                        }
                        if (listResultMap.containsKey(mainDynRow + "#loss_used_prior_tothisyear")) {
                            listResultMap.put(mainDynRow + "#loss_used_prior_tothisyear", loss_used_prior_tothisyear.add(loss_used_this_year));
                        }
                        list.add(listResultMap);
                    }
                }
                resultMap.put(dynKey, list);
            }
        }
        if (org.apache.commons.lang3.ObjectUtils.isEmpty(resultMap)) {
            for (Map.Entry<String, Map<String, Object>> entry : this.generarateCurrentYearMap(bussinessParamsVo).entrySet()) {
                resultMap.put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        } else {
            for (Map.Entry<String, Map<String, Object>> entry : this.generarateCurrentYearMap(bussinessParamsVo).entrySet()) {
                if (resultMap.containsKey(entry.getKey())) {
                    ((List)resultMap.get(entry.getKey())).add(entry.getValue());
                    continue;
                }
                resultMap.put(entry.getKey(), Collections.singletonList(entry.getValue()));
            }
        }
        return resultMap;
    }

    protected abstract List<String> getDynRowList();

    protected abstract Map<String, Map<String, Object>> generarateCurrentYearMap(BussinessParamsVo var1);

    protected Map<String, Map<String, Map<String, String>>> queryBeforeLastDraftId(BussinessParamsVo bussinessParamsVo) {
        Map<String, Map<String, Map<String, String>>> map = new HashMap<String, Map<String, Map<String, String>>>(16);
        Map extendParams = bussinessParamsVo.getExtendParams();
        Long orgId = Long.parseLong(bussinessParamsVo.getOrgId());
        Date startDate = bussinessParamsVo.getStartDate();
        Date endDate = bussinessParamsVo.getEndDate();
        String templateType = (String)extendParams.get("templatetype");
        Long draftId = GtcpDraftBussiness.queryBeforeLastDraftId(orgId, templateType, DateUtils.format((Date)startDate, (String)"yyyy-MM-dd"), DateUtils.format((Date)endDate, (String)"yyyy-MM-dd"), this.getDeclareMainQueryParams(bussinessParamsVo), "year");
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)draftId)) {
            map = GtcpDraftBussiness.batchQueryCellValue(draftId, this.getDynRowList());
            for (Map.Entry<String, Map<String, Map<String, String>>> entry : map.entrySet()) {
                Map<String, Map<String, String>> indexMap = entry.getValue();
                indexMap.entrySet().removeIf(indexEntry -> {
                    boolean isDelRow = false;
                    for (Map.Entry valueEntry : ((Map)indexEntry.getValue()).entrySet()) {
                        String cellKey = (String)valueEntry.getKey();
                        String value = (String)valueEntry.getValue();
                        if (!cellKey.contains("#loss_carryforward") || !StringUtil.isNotBlank((CharSequence)value) || BigDecimal.ZERO.compareTo(new BigDecimal(value)) != 0) continue;
                        isDelRow = true;
                        break;
                    }
                    return isDelRow;
                });
            }
        }
        return map;
    }

    protected QFilter getDeclareMainQueryParams(BussinessParamsVo bussinessParamsVo) {
        Map extendParams = bussinessParamsVo.getExtendParams();
        Long taxSystemId = Long.parseLong((String)extendParams.get("taxationsys"));
        Long taxcategoryId = Long.parseLong((String)extendParams.get("taxcategory"));
        Long taxareagroupId = Long.parseLong((String)extendParams.get("taxareagroup"));
        String draftpurpose = (String)extendParams.get("draftpurpose");
        Long templateId = extendParams.get(TEMPLATE_ID) instanceof Long ? (Long)extendParams.get(TEMPLATE_ID) : null;
        QFilter qFilter = new QFilter("taxsystem", "=", (Object)taxSystemId).and("taxtype", "=", (Object)taxcategoryId).and("taxareagroup", "=", (Object)taxareagroupId).and("draftpurpose", "=", (Object)draftpurpose);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)templateId)) {
            qFilter.and("templateid", "=", (Object)templateId);
        }
        return qFilter;
    }

    private Map<String, Map<String, String>> sortMap(Map<String, Map<String, String>> oldMap) {
        Set<Map.Entry<String, Map<String, String>>> mapEntries = oldMap.entrySet();
        LinkedList<Map.Entry<String, Map<String, String>>> result = new LinkedList<Map.Entry<String, Map<String, String>>>(mapEntries);
        Collections.sort(result, (d1, d2) -> ((String)d1.getKey()).compareTo((String)d2.getKey()));
        LinkedHashMap<String, Map<String, String>> linkMap = new LinkedHashMap<String, Map<String, String>>(16);
        for (Map.Entry entry : result) {
            linkMap.put((String)entry.getKey(), (Map<String, String>)entry.getValue());
        }
        return linkMap;
    }
}

