/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata.raterowstrategy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.gtcp.formplugin.fetchdata.raterowstrategy.AbstractGtcpDynamicRateStrategy;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpDynamicMinimumTaxRowStrategy
extends AbstractGtcpDynamicRateStrategy {
    private static final Log logger = LogFactory.getLog(GtcpDynamicMinimumTaxRowStrategy.class);

    @Override
    public String setDefaultValue(Context context, String reportkey) {
        return "0.00";
    }

    @Override
    public List<DynamicObject> delFilterTaxrateRow(List<DynamicObject> dynamicList) {
        return dynamicList.stream().filter(s -> s.toString().contains("bd_minimumtax")).collect(Collectors.toList());
    }

    @Override
    public String calculateResult(Context context, Map<String, Object> param, List<DynamicObject> dynamicList, List<DynamicObject> dataDynamicList, BigDecimal tabynssde, String reportkey, String codenumber, String taxcodeName) {
        long orgid = 0L;
        long country = 0L;
        long taxationsys = 0L;
        long taxtype = 0L;
        long taxareagroup = 0L;
        long draftid = 0L;
        long templateid = 0L;
        String draftpurpose = "";
        Date skssqq = new Date();
        Date skssqz = new Date();
        if (param != null && param.size() > 0) {
            orgid = Long.parseLong((String)param.get("orgid"));
            taxationsys = Long.parseLong((String)param.get("taxationsys"));
            taxtype = Long.parseLong((String)param.get("taxtype"));
            draftid = (Long)param.get("reportId");
            templateid = (Long)param.get("templateId");
            taxareagroup = Long.parseLong((String)param.get("taxareagroup"));
            skssqq = DateUtils.stringToDate((String)((String)param.get("skssqq")));
            skssqz = DateUtils.stringToDate((String)((String)param.get("skssqz")));
            draftpurpose = (String)param.get("draftpurpose");
        }
        BigDecimal taxamonut = BigDecimal.ZERO;
        for (DynamicObject dynamicObject : dynamicList) {
            DynamicObjectCollection dynamicObjects = dynamicObject.getDynamicObjectCollection("entryentity");
            if (dynamicObjects == null || dynamicObjects.size() <= 0) continue;
            boolean flag = false;
            for (DynamicObject dyn : dynamicObjects) {
                if (ObjectUtils.isEmpty((Object)dyn.getString("extent"))) continue;
                String extent = "";
                extent = dyn.getString("extent").startsWith(ResManager.loadKDString((String)"\u6700\u4f4e\u7a0e\u989d", (String)"GtcpDynamicMinimumTaxRowStrategy_0", (String)"taxc-gtcp", (Object[])new Object[0])) ? dyn.getString("extent").substring(5) : dyn.getString("extent");
                ArrayList<String> list = new ArrayList<String>(16);
                Pattern pattern = Pattern.compile(extent.trim().indexOf(".") == -1 ? "\\d+" : "\\d+\\.\\d+");
                Matcher matcher = pattern.matcher(extent.trim());
                while (matcher.find()) {
                    list.add(matcher.group());
                }
                Collections.sort(list, new Comparator<String>(){

                    @Override
                    public int compare(String p1, String p2) {
                        return new BigDecimal(p1).compareTo(new BigDecimal(p2));
                    }
                });
                if (!flag) {
                    if (list.size() == 1) {
                        BigDecimal amount = new BigDecimal((String)list.get(0));
                        if (extent.contains(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"GtcpDynamicMinimumTaxRowStrategy_1", (String)"taxc-gtcp", (Object[])new Object[0]))) {
                            if (tabynssde.compareTo(amount) > 0) {
                                taxamonut = dyn.getBigDecimal("minimumtax");
                                flag = true;
                            }
                            if (extent.contains(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"GtcpDynamicMinimumTaxRowStrategy_2", (String)"taxc-gtcp", (Object[])new Object[0])) && tabynssde.compareTo(amount) == 0) {
                                taxamonut = dyn.getBigDecimal("minimumtax");
                                flag = true;
                            }
                        } else if (extent.contains(ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"GtcpDynamicMinimumTaxRowStrategy_3", (String)"taxc-gtcp", (Object[])new Object[0]))) {
                            if (tabynssde.compareTo(amount) <= 0) {
                                taxamonut = dyn.getBigDecimal("minimumtax");
                                flag = true;
                            }
                            if (extent.contains(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"GtcpDynamicMinimumTaxRowStrategy_2", (String)"taxc-gtcp", (Object[])new Object[0])) && tabynssde.compareTo(amount) == 0) {
                                taxamonut = dyn.getBigDecimal("minimumtax");
                                flag = true;
                            }
                        } else if (extent.contains(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"GtcpDynamicMinimumTaxRowStrategy_2", (String)"taxc-gtcp", (Object[])new Object[0])) && tabynssde.compareTo(amount) == 0) {
                            taxamonut = dyn.getBigDecimal("minimumtax");
                            flag = true;
                        }
                    } else {
                        BigDecimal max = new BigDecimal((String)list.get(1));
                        BigDecimal min = new BigDecimal((String)list.get(0));
                        if (tabynssde.compareTo(min) >= 0 && tabynssde.compareTo(max) <= 0) {
                            taxamonut = dyn.getBigDecimal("minimumtax");
                            flag = true;
                        }
                    }
                }
                DynamicObject taxDetails = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_tax_details");
                taxDetails.set("orgid", (Object)orgid);
                taxDetails.set("draftid", (Object)draftid);
                taxDetails.set("range", dyn.get("extent"));
                taxDetails.set("reportkey", (Object)reportkey);
                taxDetails.set("skssqq", (Object)skssqq);
                taxDetails.set("skssqz", (Object)skssqz);
                taxDetails.set("taxareagroup", (Object)taxareagroup);
                taxDetails.set("taxationsys", (Object)taxationsys);
                taxDetails.set("taxcodetype", (Object)1652818532024594432L);
                taxDetails.set("taxrate", (Object)dyn.getString("minimumtax"));
                taxDetails.set("taxtype", (Object)taxtype);
                taxDetails.set("templateid", (Object)templateid);
                taxDetails.set("taxratetype", (Object)1652818532024594432L);
                taxDetails.set("draftpurpose", (Object)draftpurpose);
                taxDetails.set("datastatus", (Object)"0");
                dataDynamicList.add(taxDetails);
            }
            logger.info("\u6700\u5c0f\u7a0e\u989d:", (Object)tabynssde.toString());
            logger.info("\u6700\u5c0f\u7a0e\u989d\u91d1\u989d:", (Object)taxamonut.toString());
        }
        return taxamonut.toString();
    }
}

