/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchdata.raterowstrategy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.refactor.formula.context.Context;
import kd.taxc.bdtaxr.common.utils.BigDecimalUtil;
import kd.taxc.bdtaxr.common.utils.date.DateUtils;
import kd.taxc.gtcp.formplugin.fetchdata.raterowstrategy.AbstractGtcpDynamicRateStrategy;

public class GtcpDynamicRateRowStrategy
extends AbstractGtcpDynamicRateStrategy {
    private static final Log logger = LogFactory.getLog(GtcpDynamicRateRowStrategy.class);
    private static final String param_TaxRax_sumAmount = "_sumAmount";

    @Override
    public String setDefaultValue(Context context, String reportkey) {
        context.getParam().put(reportkey + param_TaxRax_sumAmount, "0.00");
        return "0.00%";
    }

    @Override
    public List<DynamicObject> delFilterTaxrateRow(List<DynamicObject> dynamicList) {
        return dynamicList.stream().filter(s -> s.toString().contains("bd_taxrate")).collect(Collectors.toList());
    }

    @Override
    public String calculateResult(Context context, Map<String, Object> param, List<DynamicObject> dynamicList, List<DynamicObject> dataDynamicList, BigDecimal tabynssde, String reportkey, String codenumber, String taxcodeName) {
        long orgid = 0L;
        long country = 0L;
        long taxationsys = 0L;
        long taxtype = 0L;
        long taxareagroup = 0L;
        long draftid = 0L;
        long templateid = 0L;
        String draftpurpose = "";
        Date skssqq = new Date();
        Date skssqz = new Date();
        if (param != null && param.size() > 0) {
            orgid = Long.parseLong((String)param.get("orgid"));
            taxationsys = Long.parseLong((String)param.get("taxationsys"));
            taxtype = Long.parseLong((String)param.get("taxtype"));
            draftid = (Long)param.get("reportId");
            templateid = (Long)param.get("templateId");
            taxareagroup = Long.parseLong((String)param.get("taxareagroup"));
            skssqq = DateUtils.stringToDate((String)((String)param.get("skssqq")));
            skssqz = DateUtils.stringToDate((String)((String)param.get("skssqz")));
            draftpurpose = (String)param.get("draftpurpose");
        }
        for (DynamicObject dynamicObject : dynamicList) {
            BigDecimal min;
            BigDecimal max;
            BigDecimal amount;
            BigDecimal totalAmount;
            DynamicObjectCollection dynamicObjects;
            DynamicObject taxratetypeDy = dynamicObject.getDynamicObject("taxratetype");
            String taxratetype = taxratetypeDy.getString("number");
            Long taxratetypeid = taxratetypeDy.getLong("id");
            if ("SLLX-04".equals(taxratetype)) {
                dynamicObjects = dynamicObject.getDynamicObjectCollection("entryentity");
                totalAmount = BigDecimal.ZERO;
                if (dynamicObjects == null || dynamicObjects.size() <= 0) continue;
                for (DynamicObject dynamicObject1 : dynamicObjects) {
                    DynamicObject taxDetails = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_tax_details");
                    String extent = dynamicObject1.getString("extent");
                    ArrayList<String> list = new ArrayList<String>(16);
                    Pattern pattern = Pattern.compile(extent.trim().indexOf(".") == -1 ? "\\d+" : "\\d+\\.\\d+");
                    Matcher matcher = pattern.matcher(extent.trim());
                    while (matcher.find()) {
                        list.add(matcher.group());
                    }
                    Collections.sort(list, new Comparator<String>(){

                        @Override
                        public int compare(String p1, String p2) {
                            return new BigDecimal(p1).compareTo(new BigDecimal(p2));
                        }
                    });
                    BigDecimal intervalamount = BigDecimal.ZERO;
                    if (list.size() == 1) {
                        amount = new BigDecimal((String)list.get(0));
                        if (extent.contains(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"GtcpDynamicRateRowStrategy_0", (String)"taxc-gtcp", (Object[])new Object[0]))) {
                            intervalamount = tabynssde.compareTo(amount) > 0 ? BigDecimalUtil.subtractObject((Object)tabynssde, (Object)amount, (int)2) : BigDecimal.ZERO;
                        } else if (extent.contains(ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"GtcpDynamicRateRowStrategy_1", (String)"taxc-gtcp", (Object[])new Object[0]))) {
                            intervalamount = tabynssde.compareTo(amount) > 0 ? amount : BigDecimalUtil.subtractObject((Object)tabynssde, (Object)BigDecimal.ZERO, (int)2);
                        }
                    } else {
                        max = new BigDecimal((String)list.get(1));
                        min = new BigDecimal((String)list.get(0));
                        intervalamount = tabynssde.compareTo(min) < 0 ? BigDecimal.ZERO : (tabynssde.compareTo(max) > 0 ? BigDecimalUtil.subtractObject((Object)max, (Object)min, (int)2) : BigDecimalUtil.subtractObject((Object)tabynssde, (Object)min, (int)2));
                    }
                    taxDetails.set("orgid", (Object)orgid);
                    taxDetails.set("intervalamount", (Object)intervalamount);
                    taxDetails.set("draftid", (Object)draftid);
                    taxDetails.set("intervalrateamount", (Object)BigDecimalUtil.divideObject((Object)BigDecimalUtil.multiplyObject((Object)intervalamount, (Object)dynamicObject1.getBigDecimal("minimumtax"), (int)4), (Object)100, (int)2));
                    taxDetails.set("range", dynamicObject1.get("extent"));
                    taxDetails.set("reportkey", (Object)reportkey);
                    taxDetails.set("skssqq", (Object)skssqq);
                    taxDetails.set("skssqz", (Object)skssqz);
                    taxDetails.set("taxareagroup", (Object)taxareagroup);
                    taxDetails.set("taxationsys", (Object)taxationsys);
                    taxDetails.set("taxcodetype", (Object)1652818108961927168L);
                    taxDetails.set("taxrate", (Object)dynamicObject1.getString("minimumtax"));
                    taxDetails.set("taxtype", (Object)taxtype);
                    taxDetails.set("templateid", (Object)templateid);
                    taxDetails.set("taxratetype", (Object)taxratetypeid);
                    taxDetails.set("draftpurpose", (Object)draftpurpose);
                    taxDetails.set("datastatus", (Object)"0");
                    dataDynamicList.add(taxDetails);
                    totalAmount = BigDecimalUtil.addObject((Object)totalAmount, (Object)BigDecimalUtil.divideObject((Object)BigDecimalUtil.multiplyObject((Object)intervalamount, (Object)dynamicObject1.getBigDecimal("minimumtax"), (int)4), (Object)100, (int)2));
                }
                logger.info("\u8d85\u989d\u7d2f\u8ba1\u7a0e\u7387\u7b97\u51fa\u7684\u6700\u7ec8\u91d1\u989d\uff1a" + totalAmount);
                context.getParam().put(reportkey + param_TaxRax_sumAmount, totalAmount);
                continue;
            }
            if ("SLLX-05".equals(taxratetype)) {
                dynamicObjects = dynamicObject.getDynamicObjectCollection("entryentity");
                totalAmount = BigDecimal.ZERO;
                BigDecimal taxrate = BigDecimal.ZERO;
                if (dynamicObjects == null || dynamicObjects.size() <= 0) continue;
                boolean flag = false;
                for (DynamicObject dyn : dynamicObjects) {
                    String extent = dyn.getString("extent");
                    ArrayList<String> list = new ArrayList<String>(16);
                    Pattern pattern = Pattern.compile(extent.trim().indexOf(".") == -1 ? "\\d+" : "\\d+\\.\\d+");
                    Matcher matcher = pattern.matcher(extent.trim());
                    while (matcher.find()) {
                        list.add(matcher.group());
                    }
                    Collections.sort(list, new Comparator<String>(){

                        @Override
                        public int compare(String p1, String p2) {
                            return new BigDecimal(p1).compareTo(new BigDecimal(p2));
                        }
                    });
                    if (!flag) {
                        if (list.size() == 1) {
                            amount = new BigDecimal((String)list.get(0));
                            if (extent.contains(ResManager.loadKDString((String)"\u5927\u4e8e", (String)"GtcpDynamicRateRowStrategy_0", (String)"taxc-gtcp", (Object[])new Object[0]))) {
                                if (tabynssde.compareTo(amount) > 0) {
                                    taxrate = dyn.getBigDecimal("minimumtax");
                                    flag = true;
                                }
                                if (extent.contains(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"GtcpDynamicRateRowStrategy_2", (String)"taxc-gtcp", (Object[])new Object[0])) && tabynssde.compareTo(amount) == 0) {
                                    taxrate = dyn.getBigDecimal("minimumtax");
                                    flag = true;
                                }
                            } else if (extent.contains(ResManager.loadKDString((String)"\u5c0f\u4e8e", (String)"GtcpDynamicRateRowStrategy_1", (String)"taxc-gtcp", (Object[])new Object[0]))) {
                                if (tabynssde.compareTo(amount) <= 0) {
                                    taxrate = dyn.getBigDecimal("minimumtax");
                                    flag = true;
                                }
                                if (extent.contains(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"GtcpDynamicRateRowStrategy_2", (String)"taxc-gtcp", (Object[])new Object[0])) && tabynssde.compareTo(amount) == 0) {
                                    taxrate = dyn.getBigDecimal("minimumtax");
                                    flag = true;
                                }
                            } else if (extent.contains(ResManager.loadKDString((String)"\u7b49\u4e8e", (String)"GtcpDynamicRateRowStrategy_2", (String)"taxc-gtcp", (Object[])new Object[0])) && tabynssde.compareTo(amount) == 0) {
                                taxrate = dyn.getBigDecimal("minimumtax");
                                flag = true;
                            }
                        } else {
                            max = new BigDecimal((String)list.get(1));
                            min = new BigDecimal((String)list.get(0));
                            if (tabynssde.compareTo(min) >= 0 && tabynssde.compareTo(max) <= 0) {
                                taxrate = dyn.getBigDecimal("minimumtax");
                                flag = true;
                            }
                        }
                    }
                    DynamicObject taxDetails = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_tax_details");
                    taxDetails.set("orgid", (Object)orgid);
                    taxDetails.set("draftid", (Object)draftid);
                    taxDetails.set("range", dyn.get("extent"));
                    taxDetails.set("reportkey", (Object)reportkey);
                    taxDetails.set("skssqq", (Object)skssqq);
                    taxDetails.set("skssqz", (Object)skssqz);
                    taxDetails.set("taxareagroup", (Object)taxareagroup);
                    taxDetails.set("taxationsys", (Object)taxationsys);
                    taxDetails.set("taxcodetype", (Object)1652818108961927168L);
                    taxDetails.set("taxrate", (Object)dyn.getString("minimumtax"));
                    taxDetails.set("taxtype", (Object)taxtype);
                    taxDetails.set("templateid", (Object)templateid);
                    taxDetails.set("taxratetype", (Object)taxratetypeid);
                    taxDetails.set("draftpurpose", (Object)draftpurpose);
                    taxDetails.set("datastatus", (Object)"0");
                    dataDynamicList.add(taxDetails);
                }
                logger.info("\u5168\u989d\u7d2f\u8fdb\u7a0e\u7387:", (Object)taxrate.toString());
                logger.info("\u5168\u989d\u7d2f\u8fdb\u91d1\u989d:", (Object)tabynssde.toString());
                totalAmount = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)tabynssde, (Object)new BigDecimal("0.01"), (int)10), (Object)taxrate, (int)2);
                logger.info("\u5168\u989d\u7d2f\u8fdb\u7a0e\u7387\u7b97\u51fa\u7684\u6700\u7ec8\u91d1\u989d\uff1a" + totalAmount);
                context.getParam().put(reportkey + param_TaxRax_sumAmount, totalAmount);
                continue;
            }
            BigDecimal amount2 = BigDecimalUtil.multiplyObject((Object)BigDecimalUtil.multiplyObject((Object)tabynssde, (Object)new BigDecimal("0.01"), (int)10), (Object)dynamicObject.getBigDecimal("taxrate"), (int)2);
            DynamicObject taxDetails = BusinessDataServiceHelper.newDynamicObject((String)"bdtaxr_tax_details");
            taxDetails.set("orgid", (Object)orgid);
            taxDetails.set("intervalamount", (Object)amount2);
            taxDetails.set("draftid", (Object)draftid);
            taxDetails.set("intervalrateamount", (Object)amount2);
            taxDetails.set("range", (Object)ResManager.loadKDString((String)"\u533a\u95f4>0", (String)"GtcpDynamicRateRowStrategy_3", (String)"taxc-gtcp", (Object[])new Object[0]));
            taxDetails.set("reportkey", (Object)reportkey);
            taxDetails.set("skssqq", (Object)skssqq);
            taxDetails.set("skssqz", (Object)skssqz);
            taxDetails.set("taxareagroup", (Object)taxareagroup);
            taxDetails.set("taxationsys", (Object)taxationsys);
            taxDetails.set("taxcodetype", (Object)1652818108961927168L);
            taxDetails.set("taxrate", (Object)dynamicObject.getString("taxrate"));
            taxDetails.set("taxtype", (Object)taxtype);
            taxDetails.set("templateid", (Object)templateid);
            taxDetails.set("taxratetype", (Object)taxratetypeid);
            taxDetails.set("draftpurpose", (Object)draftpurpose);
            taxDetails.set("datastatus", (Object)"0");
            dataDynamicList.add(taxDetails);
            context.getParam().put(reportkey + param_TaxRax_sumAmount, amount2);
            logger.info("\u6bd4\u4f8b\u7a0e\u7387\u7b97\u51fa\u7684\u6700\u7ec8\u91d1\u989d\uff1a" + amount2);
        }
        return taxcodeName + "|" + codenumber;
    }
}

