/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.fetchitem;

import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.taxorg.GtcpCombineBusiness;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;

public class FetchItemPlugin
extends AbstractBillPlugIn
implements BeforeF7SelectListener {
    private static final String CREATE_ORG = "createorg";
    private static final String PARENT = "parent";

    public void registerListener(EventObject e) {
        BasedataEdit taxationSys = (BasedataEdit)this.getControl("taxationsys");
        taxationSys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxCategory = (BasedataEdit)this.getControl("taxcategory");
        taxCategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxAreaGroup = (BasedataEdit)this.getControl("taxareagroup");
        taxAreaGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit createOrg = (BasedataEdit)this.getControl(CREATE_ORG);
        createOrg.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String key = evt.getProperty().getName();
        DynamicObject taxationSys = this.getModel().getDataEntity().getDynamicObject("taxationsys");
        DynamicObject taxCategory = this.getModel().getDataEntity().getDynamicObject("taxcategory");
        DynamicObject taxAreaGroup = this.getModel().getDataEntity().getDynamicObject("taxareagroup");
        if ("taxcategory".equals(key)) {
            if (taxationSys == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u624d\u80fd\u9009\u62e9\u7a0e\u79cd\u3002", (String)"FetchItemPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                QFilter qFilter = new QFilter("taxationsysid", "=", taxationSys.get("id"));
                evt.addCustomQFilter(qFilter);
            }
        } else if ("taxareagroup".equals(key)) {
            if (taxationSys == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5fc5\u987b\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u624d\u80fd\u9009\u62e9\u7a0e\u6536\u8f96\u533a\u3002", (String)"FetchItemPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
            } else {
                QFilter groupFilter = this.getTaxAreaGroupFilter(taxationSys);
                evt.addCustomQFilter(groupFilter);
            }
        } else if (CREATE_ORG.equals(key)) {
            List<Long> allTaxOrgList = GtcpCombineBusiness.getAllTaxOrgs(this.getView());
            QFilter filter = CollectionUtils.isEmpty(allTaxOrgList) ? new QFilter("id", "is null", null) : new QFilter("id", "in", allTaxOrgList);
            evt.addCustomQFilter(filter);
        }
    }

    private QFilter getTaxAreaGroupFilter(DynamicObject taxationsys) {
        Date now = DateUtils.getDayFirst((Date)new Date());
        QFilter endDateFilter = new QFilter("enddate", "is null", null).or("enddate", ">=", (Object)now);
        QFilter dateFilter = new QFilter("startdate", "<=", (Object)now).and(endDateFilter);
        QFilter groupFilter = new QFilter("country", "=", (Object)taxationsys.getLong("countryid.id")).and("enable", "=", (Object)"1").and(dateFilter);
        DynamicObjectCollection groups = QueryServiceHelper.query((String)"bastax_taxarea", (String)"group", (QFilter[])new QFilter[]{groupFilter});
        Set groupIds = groups.stream().map(m -> m.getLong("group")).collect(Collectors.toSet());
        return new QFilter("id", "in", groupIds);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String eventName = e.getProperty().getName();
        if ("taxationsys".equals(eventName)) {
            this.getModel().setValue(PARENT, null);
            this.getModel().setValue("taxareagroup", null);
            this.getModel().setValue("taxcategory", null);
            this.getModel().setValue("biztype", null);
        }
        if ("taxationsys".equals(eventName) || "taxcategory".equals(eventName) || "taxareagroup".equals(eventName)) {
            this.getModel().setValue("biztype", null);
        }
    }

    public void afterCreateNewData(EventObject e) {
        long id;
        DynamicObject createorg = (DynamicObject)this.getModel().getValue(CREATE_ORG);
        List<Long> allTaxOrgs = GtcpCombineBusiness.getAllTaxOrgs(this.getView());
        if (createorg != null && !allTaxOrgs.contains(id = createorg.getLong("id"))) {
            this.getModel().setValue(CREATE_ORG, null);
        }
    }

    public void preOpenForm(PreOpenFormEventArgs e) {
        Map customParams;
        Map treeParentId;
        super.preOpenForm(e);
        FormShowParameter formShowParameter = e.getFormShowParameter();
        OperationStatus status = formShowParameter.getStatus();
        if (OperationStatus.ADDNEW.equals((Object)status) && MapUtils.isNotEmpty((Map)(treeParentId = (Map)(customParams = formShowParameter.getCustomParams()).get("tree_parent_id")))) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u9009\u62e9\u5168\u90e8\u8fdb\u884c\u65b0\u589e\u3002", (String)"FetchItemPlugin_4", (String)"taxc-gtcp", (Object[])new Object[0]));
        }
    }
}

