/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.jtysbthan;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.GtcpTaxperoidAndProvisionCombineBusiness;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.provision.GtcpProvisionPlanBusiness;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import kd.taxc.gtcp.common.constant.GtcpConstant;
import kd.taxc.gtcp.formplugin.basedeclare.AbstractGtcpDeclareReportMultiPlugin;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GtcpJtAndDeclareThanMultiPlugin
extends AbstractGtcpDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationSys = (BasedataEdit)this.getControl("taxationsys");
        taxationSys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxCategory = (BasedataEdit)this.getControl("taxcategory");
        taxCategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxAreaGroup = (BasedataEdit)this.getControl("taxareagroup");
        taxAreaGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    public String getTemplateType() {
        String taxCategoryNumber;
        DynamicObject taxCategory = (DynamicObject)this.getModel().getValue("taxcategory");
        String string = taxCategoryNumber = taxCategory == null ? null : taxCategory.getString("number");
        if (GtcpConstant.ZZS.contains(taxCategoryNumber)) {
            return "Overseas_VAT_RTA";
        }
        if (GtcpConstant.SDS.contains(taxCategoryNumber)) {
            if (StringUtil.equalsIgnoreCase((CharSequence)taxCategoryNumber, (CharSequence)"USA-CIT")) {
                return "USA_CIT_RTA";
            }
            return "Overseas_CIT_RTA";
        }
        return "";
    }

    @Override
    protected void initDate(Long orgId, Long taxationSysId, Long taxTypeId, Long taxAreaId, Map<String, Object> customParams) {
        Date startDate = null;
        Date endDate = null;
        if (Boolean.TRUE.equals(customParams.get("readonly"))) {
            startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            String papersStatus = (String)customParams.get("papers_status");
            this.getModel().setValue("papers_status", (Object)papersStatus);
            this.getView().getPageCache().put("papers_status", papersStatus);
        } else {
            ImmutablePair<Date, Date> dateDateImmutablePair;
            Date skssqz;
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            String provistonPlan = GtcpTaxperoidAndProvisionCombineBusiness.queryMaxFromProvisionPlanOrTaxperiod(orgId, taxationSysId, taxTypeId, taxAreaId, skssqq, skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz"))));
            if (ObjectUtils.isNotEmpty((Object)provistonPlan) && (dateDateImmutablePair = this.provisionPeriod(new Date(), provistonPlan)) != null) {
                startDate = (Date)dateDateImmutablePair.left;
                endDate = (Date)dateDateImmutablePair.right;
            }
        }
        this.getModel().setValue("skssqq", (Object)startDate);
        this.getModel().setValue("skssqz", (Object)endDate);
        this.getView().getPageCache().put("skssqq", DateUtils.format((Date)startDate));
        this.getView().getPageCache().put("skssqz", DateUtils.format((Date)endDate));
    }

    @Override
    protected void createBillNumber() {
        long orgId = this.getModel().getValue("org") == null ? 0L : this.getModel().getDataEntity().getLong("org.id");
        Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        if (orgId == 0L || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return;
        }
        String number = "";
        DynamicObject dynamicObject = YbnsrService.queryMultiDeclareMain((String)MultiTableEnum.TSD001.getDeclareMainTable(), (long)orgId, (String)this.getTemplateType(), (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), (QFilter)this.getDeclareMainQueryParams());
        if (dynamicObject != null) {
            number = dynamicObject.getString("billno");
        } else {
            Date startDate = DateUtils.stringToDate((String)DateUtils.format((Date)skssqq), (String)"yyyy-MM-dd");
            Date endDate = DateUtils.stringToDate((String)DateUtils.format((Date)skssqz), (String)"yyyy-MM-dd");
            Long org = this.getModel().getDataEntity().getLong("org.id");
            Long taxationsysId = this.getModel().getDataEntity().getLong("taxationsys.id");
            Long taxcategoryId = this.getModel().getDataEntity().getLong("taxcategory.id");
            Long taxareagroupId = this.getModel().getDataEntity().getLong("taxareagroup.id");
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_normal_jt_list");
            dyn.set("org", (Object)org);
            dyn.set("skssqq", (Object)startDate);
            dyn.set("skssqz", (Object)endDate);
            dyn.set("taxsystem", (Object)taxationsysId);
            dyn.set("taxtype", (Object)taxcategoryId);
            if (taxationsysId == 1636078644810086400L && taxcategoryId == 1641488655174373376L) {
                taxareagroupId = 1616686278185582592L;
            }
            dyn.set("taxareagroup", (Object)taxareagroupId);
            number = codeRuleService.readNumber("gtcp_jt_declare_than_list", dyn, null);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"gtcp_jt_declare_than_list", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
            if (obj != null) {
                codeRuleService.getNumber("gtcp_jt_declare_than_list", dyn, null);
                number = codeRuleService.readNumber("gtcp_jt_declare_than_list", dyn, null);
            }
        }
        this.getModel().getDataEntity().set("number", (Object)number);
        this.getView().updateView("number");
        this.getPageCache().put("billno", number);
        this.getPageCache().put("number", number);
    }

    protected Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        DynamicObject taxSys = this.getModel().getDataEntity(true).getDynamicObject("taxationsys");
        DynamicObject taxType = this.getModel().getDataEntity(true).getDynamicObject("taxcategory");
        DynamicObject taxAreaGroup = this.getModel().getDataEntity(true).getDynamicObject("taxareagroup");
        Long taxSysId = taxSys == null ? null : Long.valueOf(taxSys.getLong("id"));
        Long taxTypeId = taxType == null ? null : Long.valueOf(taxType.getLong("id"));
        Long taxAreaGroupId = taxAreaGroup == null ? null : Long.valueOf(taxAreaGroup.getLong("id"));
        List<Long> suitableOrgIds = GtcpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm();
        if (!suitableOrgIds.contains(orgId) && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u7ec4\u7ec7\u672a\u7ef4\u62a4\u5408\u8981\u6c42\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f/\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"GtcpJtAndDeclareThanMultiPlugin_6", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        if (taxSysId == null && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u7ec4\u7ec7\u672a\u7ef4\u62a4\u5408\u8981\u6c42\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f/\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"GtcpJtAndDeclareThanMultiPlugin_6", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        if ((taxTypeId == null || taxAreaGroupId == null) && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"GtcpJtAndDeclareThanMultiPlugin_7", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        List<String> jtPlanList = GtcpProvisionPlanBusiness.queryAllJtPlanBySharePlan(orgId, taxSysId, taxTypeId, taxAreaGroupId, startDate, endDate);
        if (ObjectUtils.isEmpty(jtPlanList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u8ba1\u63d0\u65b9\u6848\u3002", (String)"GtcpJtAndDeclareThanMultiPlugin_5", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        String taxPeriod = GtcpTaxOrgCommonBusiness.queryMinHwsTaxlimitByOrgId(orgId, taxSysId, taxTypeId, taxAreaGroupId);
        String templatetype = this.getTemplateType();
        if (this.isIncomeTax(templatetype = StringUtil.splitByWholeSeparator((String)templatetype, (String)"_RTA")[0])) {
            if (ObjectUtils.isEmpty((Object)taxPeriod)) {
                taxPeriod = "year";
            } else {
                boolean isYear = DateUtils.validDateRange((String)"year", (Date)startDate, (Date)endDate);
                if (isYear) {
                    taxPeriod = "year";
                }
            }
        }
        if (ObjectUtils.isEmpty((Object)taxPeriod)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u7f34\u7eb3\u671f\u9650\u3002", (String)"GtcpJtAndDeclareThanMultiPlugin_8", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        if (ObjectUtils.isEmpty((Object)this.getTemplateType())) {
            String taxSystemName = taxSys != null ? taxSys.getString("name") : "";
            String taxCategoryName = taxType != null ? taxType.getString("name") : "";
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301%1$s - %2$s\u7684\u8ba1\u7a0e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u7a0e\u5236\u7a0e\u79cd\u3002", (String)"GtcpJtAndDeclareThanMultiPlugin_9", (String)"taxc-gtcp", (Object[])new Object[0]), taxSystemName, taxCategoryName));
            return false;
        }
        if (!this.checkTemplate(true).booleanValue()) {
            return false;
        }
        Date firstDateOfMonth = DateUtils.getFirstDateOfMonth((Date)startDate);
        Date lastDateOfMonth = DateUtils.getLastDateOfMonth((Date)endDate);
        if (!DateUtils.format((Date)firstDateOfMonth).equalsIgnoreCase(DateUtils.format((Date)startDate))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8d77\u59cb\u6bd4\u5bf9\u671f\u95f4\u6b62\u5fc5\u987b\u4e3a\u6708\u4efd\u7684\u7b2c\u4e00\u5929\u3002", (String)"GtcpJtAndDeclareThanMultiPlugin_0", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        if (!DateUtils.format((Date)lastDateOfMonth).equalsIgnoreCase(DateUtils.format((Date)endDate))) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u622a\u6b62\u6bd4\u5bf9\u671f\u95f4\u6b62\u5fc5\u987b\u4e3a\u6708\u4efd\u7684\u6700\u540e\u4e00\u5929\u3002", (String)"GtcpJtAndDeclareThanMultiPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        Boolean validDates = super.isValidDates(startDate, endDate, Boolean.valueOf(false));
        if (!validDates.booleanValue()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.getTaxLimits().length; ++i) {
                sb.append((String)cycleMap.get(this.getTaxLimits()[i]));
                if (i >= this.getTaxLimits().length - 1) continue;
                sb.append("\u3001");
            }
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6bd4\u5bf9\u5468\u671f\u4e3a%s\uff0c\u8bf7\u4fee\u6539\u6bd4\u5bf9\u671f\u95f4\u3002", (String)"GtcpJtAndDeclareThanMultiPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]), sb));
            return validDates;
        }
        List<String> nssbList = GtcpDraftBussiness.getSbbIdListByPeriod(templatetype, orgId, startDate, endDate, taxSysId, taxTypeId, taxAreaGroupId, "nssb", taxPeriod);
        if (ObjectUtils.isEmpty(nssbList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u53ea\u652f\u6301\u81ea\u7136\u5e74\u4efd\u6bd4\u5bf9\uff0c\u8bf7\u68c0\u67e5\u662f\u5426\u6709\u53ef\u7528\u7684\u7533\u62a5\u5e95\u7a3f\u3002", (String)"GtcpJtAndDeclareThanMultiPlugin_10", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    protected String[] getTaxLimits() {
        DynamicObject org = this.getModel().getDataEntity(true).getDynamicObject("org");
        DynamicObject taxationsys = this.getModel().getDataEntity(true).getDynamicObject("taxationsys");
        DynamicObject taxCategory = this.getModel().getDataEntity(true).getDynamicObject("taxcategory");
        DynamicObject taxAreaGroup = this.getModel().getDataEntity(true).getDynamicObject("taxareagroup");
        Date skssqq = this.getModel().getDataEntity(true).getDate("skssqq");
        Date skssqz = this.getModel().getDataEntity(true).getDate("skssqz");
        Long orgId = org == null ? null : Long.valueOf(org.getLong("id"));
        Long taxationsysId = taxationsys == null ? null : Long.valueOf(taxationsys.getLong("id"));
        Long taxtypeId = taxCategory == null ? null : Long.valueOf(taxCategory.getLong("id"));
        Long taxAreaGroupId = taxAreaGroup == null ? null : Long.valueOf(taxAreaGroup.getLong("id"));
        String period = GtcpTaxperoidAndProvisionCombineBusiness.queryMaxFromProvisionPlanOrTaxperiod(orgId, taxationsysId, taxtypeId, taxAreaGroupId, skssqq, skssqz);
        ArrayList<String> taxLimits = new ArrayList<String>(8);
        if (ObjectUtils.isNotEmpty((Object)period)) {
            taxLimits.add(period);
        }
        String templatetype = this.getTemplateType();
        if (this.isIncomeTax(templatetype = StringUtil.splitByWholeSeparator((String)templatetype, (String)"_RTA")[0]) && !taxLimits.contains("year")) {
            taxLimits.add("year");
        }
        return taxLimits.toArray(new String[0]);
    }

    private boolean isIncomeTax(String templatetype) {
        return "Overseas_CIT".equals(templatetype) || "USA_CIT".equals(templatetype);
    }

    private ImmutablePair<Date, Date> provisionPeriod(Date now, String provisionPlan) {
        Date endDate;
        Date startDate;
        if ("season".equals(provisionPlan)) {
            Date date = DateUtils.addMonth((Date)now, (int)-3);
            startDate = DateUtils.getFirstDateOfSeason((Date)date);
            endDate = DateUtils.getLastDateOfSeason((Date)date);
        } else if ("year".equals(provisionPlan)) {
            Date date = DateUtils.addYear((Date)now, (int)-1);
            startDate = DateUtils.getFirstDateOfYear((Date)date);
            endDate = DateUtils.getLastDateOfYear((Date)date);
        } else if ("month".equals(provisionPlan)) {
            Date date = DateUtils.addMonth((Date)now, (int)-1);
            startDate = DateUtils.getFirstDateOfMonth((Date)date);
            endDate = DateUtils.getLastDateOfMonth((Date)date);
        } else {
            return null;
        }
        return ImmutablePair.of((Object)startDate, (Object)endDate);
    }

    public void save() {
        Date endDate;
        List hasPermOrgs;
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"gtcp", (String)"gtcp_jt_declare_than", (String)"4715a0df000000ac", (Long)RequestContext.get().getCurrUserId());
        if (!allPermOrgsByUserId.hasAllOrgPerm() && !(hasPermOrgs = allPermOrgsByUserId.getHasPermOrgs()).contains(orgId)) {
            return;
        }
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Boolean validDates = this.isValidDates(startDate, endDate = (Date)this.getModel().getValue("skssqz"), true);
        if (validDates.booleanValue()) {
            super.save();
        }
    }

    @Override
    protected DeclareRequestModel setRequestModel(DeclareRequestModel requestModel) {
        DynamicObject taxSys = this.getModel().getDataEntity().getDynamicObject("taxationsys");
        requestModel.setTaxationsys(taxSys == null ? null : Long.valueOf(taxSys.getLong("id")));
        HashMap<String, String> extendParams = requestModel.getExtendParams();
        if (extendParams == null) {
            extendParams = new HashMap<String, String>(1);
        }
        extendParams.putAll(this.getBizParams());
        requestModel.setExtendParams(extendParams);
        return requestModel;
    }

    @Override
    protected String getDraftpurpose() {
        return "sbjtThan";
    }
}

