/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.jtysbthan;

import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.db.table.tctb.YbnsrService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.draft.GtcpFetchDataBussiness;
import kd.taxc.gtcp.business.provision.GtcpProvisionPlanBusiness;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import kd.taxc.gtcp.formplugin.basedeclare.AbstractGtcpDeclareReportMultiPlugin;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GtcpNormalJtysbDeclareMultiPlugin
extends AbstractGtcpDeclareReportMultiPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationSys = (BasedataEdit)this.getControl("taxationsys");
        taxationSys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxCategory = (BasedataEdit)this.getControl("taxcategory");
        taxCategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxAreaGroup = (BasedataEdit)this.getControl("taxareagroup");
        taxAreaGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    @Override
    protected void initDate(Long orgId, Long taxationSysId, Long taxTypeId, Long taxAreaId, Map<String, Object> customParams) {
        Date startDate = null;
        Date endDate = null;
        if (Boolean.TRUE.equals(customParams.get("readonly"))) {
            startDate = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            endDate = DateUtils.stringToDate((String)((String)customParams.get("skssqz")));
            String papersStatus = (String)customParams.get("papers_status");
            this.getModel().setValue("papers_status", (Object)papersStatus);
            this.getView().getPageCache().put("papers_status", papersStatus);
            this.getModel().setValue("skssqq", (Object)startDate);
            this.getView().getPageCache().put("skssqz", DateUtils.format((Date)endDate));
            this.getModel().setValue("skssqz", (Object)endDate);
            this.getView().getPageCache().put("skssqz", DateUtils.format((Date)endDate));
        } else {
            ImmutablePair<Date, Date> dateDateImmutablePair;
            Date skssqz;
            Date skssqq = DateUtils.stringToDate((String)((String)customParams.get("skssqq")));
            List<String> jtPlanList = GtcpProvisionPlanBusiness.queryAllJtPlanBySharePlan(orgId, taxationSysId, taxTypeId, taxAreaId, skssqq, skssqz = DateUtils.stringToDate((String)((String)customParams.get("skssqz"))));
            if (ObjectUtils.isNotEmpty(jtPlanList) && (dateDateImmutablePair = GtcpProvisionPlanBusiness.provisionPeriod(new Date(), jtPlanList.get(0))) != null) {
                startDate = (Date)dateDateImmutablePair.left;
                endDate = (Date)dateDateImmutablePair.right;
            }
        }
    }

    @Override
    protected void createBillNumber() {
        long orgId = this.getModel().getValue("org") == null ? 0L : this.getModel().getDataEntity().getLong("org.id");
        Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
        Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
        if (orgId == 0L || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
            return;
        }
        String number = "";
        DynamicObject dynamicObject = YbnsrService.queryMultiDeclareMain((String)MultiTableEnum.TSD001.getDeclareMainTable(), (long)orgId, (String)this.getTemplateType(), (String)DateUtils.format((Date)skssqq), (String)DateUtils.format((Date)skssqz), (QFilter)this.getDeclareMainQueryParams());
        if (dynamicObject != null) {
            number = dynamicObject.getString("billno");
        } else {
            Date startDate = DateUtils.stringToDate((String)DateUtils.format((Date)skssqq), (String)"yyyy-MM-dd");
            Date endDate = DateUtils.stringToDate((String)DateUtils.format((Date)skssqz), (String)"yyyy-MM-dd");
            Long org = this.getModel().getDataEntity().getLong("org.id");
            Long taxationsysId = this.getModel().getDataEntity().getLong("taxationsys.id");
            Long taxcategoryId = this.getModel().getDataEntity().getLong("taxcategory.id");
            Long taxareagroupId = this.getModel().getDataEntity().getLong("taxareagroup.id");
            ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
            DynamicObject dyn = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_normal_jt_list");
            dyn.set("org", (Object)org);
            dyn.set("skssqq", (Object)startDate);
            dyn.set("skssqz", (Object)endDate);
            dyn.set("taxsystem", (Object)taxationsysId);
            dyn.set("taxtype", (Object)taxcategoryId);
            if (taxationsysId == 1636078644810086400L && taxcategoryId == 1641488655174373376L) {
                taxareagroupId = 1616686278185582592L;
            }
            dyn.set("taxareagroup", (Object)taxareagroupId);
            number = codeRuleService.readNumber("gtcp_normal_jt_list", dyn, null);
            DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"gtcp_normal_jt_list", (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)number)});
            if (obj != null) {
                codeRuleService.getNumber("gtcp_normal_jt_list", dyn, null);
                number = codeRuleService.readNumber("gtcp_normal_jt_list", dyn, null);
            }
        }
        this.getModel().getDataEntity().set("number", (Object)number);
        this.getView().updateView("number");
        this.getPageCache().put("billno", number);
        this.getPageCache().put("number", number);
    }

    protected Boolean isValidDates(Date startDate, Date endDate, Boolean needMsg) {
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        DynamicObject taxSys = this.getModel().getDataEntity(true).getDynamicObject("taxationsys");
        DynamicObject taxType = this.getModel().getDataEntity(true).getDynamicObject("taxcategory");
        DynamicObject taxAreaGroup = this.getModel().getDataEntity(true).getDynamicObject("taxareagroup");
        Long taxSysId = taxSys == null ? null : Long.valueOf(taxSys.getLong("id"));
        Long taxTypeId = taxType == null ? null : Long.valueOf(taxType.getLong("id"));
        Long taxAreaGroupId = taxAreaGroup == null ? null : Long.valueOf(taxAreaGroup.getLong("id"));
        List<Long> suitableOrgIds = GtcpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm();
        if (!suitableOrgIds.contains(orgId) && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u7ec4\u7ec7\u672a\u7ef4\u62a4\u5408\u8981\u6c42\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f/\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"GtcpNormalJtysbDeclareMultiPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        if (taxSysId == null && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u6240\u9009\u7ec4\u7ec7\u672a\u7ef4\u62a4\u5408\u8981\u6c42\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f/\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"GtcpNormalJtysbDeclareMultiPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        if ((taxTypeId == null || taxAreaGroupId == null) && needMsg.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"GtcpNormalJtysbDeclareMultiPlugin_4", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        List<String> jtPlanList = GtcpProvisionPlanBusiness.queryAllJtPlanBySharePlan(orgId, taxSysId, taxTypeId, taxAreaGroupId, startDate, endDate);
        if (ObjectUtils.isEmpty(jtPlanList)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u8ba1\u63d0\u65b9\u6848\u3002", (String)"GtcpNormalJtysbDeclareMultiPlugin_5", (String)"taxc-gtcp", (Object[])new Object[0]));
            return false;
        }
        if (!this.checkTemplate(true).booleanValue()) {
            return false;
        }
        Boolean validDates = super.isValidDates(startDate, endDate, Boolean.valueOf(false));
        if (!validDates.booleanValue()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8ba1\u63d0\u671f\u95f4\u4e0e\u9002\u7528\u7684\u8ba1\u63d0\u5468\u671f\u4e0d\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GtcpNormalJtysbDeclareMultiPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]));
        }
        return validDates;
    }

    protected String[] getTaxLimits() {
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject taxationsys = this.getModel().getDataEntity(true).getDynamicObject("taxationsys");
        DynamicObject taxCategory = this.getModel().getDataEntity(true).getDynamicObject("taxcategory");
        DynamicObject taxAreaGroup = this.getModel().getDataEntity(true).getDynamicObject("taxareagroup");
        Date skssqq = this.getModel().getDataEntity(true).getDate("skssqq");
        Date skssqz = this.getModel().getDataEntity(true).getDate("skssqz");
        Long orgId = taxationsys == null ? null : Long.valueOf(org.getLong("id"));
        Long taxationsysId = taxationsys == null ? null : Long.valueOf(taxationsys.getLong("id"));
        Long taxtypeId = taxCategory == null ? null : Long.valueOf(taxCategory.getLong("id"));
        Long taxAreaGroupId = taxAreaGroup == null ? null : Long.valueOf(taxAreaGroup.getLong("id"));
        List<String> jtPlanList = GtcpProvisionPlanBusiness.queryAllJtPlanBySharePlan(orgId, taxationsysId, taxtypeId, taxAreaGroupId, skssqq, skssqz);
        ArrayList<String> taxLimits = new ArrayList<String>(8);
        if (ObjectUtils.isNotEmpty(jtPlanList)) {
            if (jtPlanList.contains("month")) {
                taxLimits.add("month");
            }
            if (jtPlanList.contains("season")) {
                taxLimits.add("season");
            }
            if (jtPlanList.contains("year")) {
                taxLimits.add("year");
            }
        }
        return taxLimits.toArray(new String[taxLimits.size()]);
    }

    public void save() {
        Date endDate;
        List hasPermOrgs;
        long orgId = this.getModel().getDataEntity().getLong("org.id");
        HasPermOrgResult allPermOrgsByUserId = PermissionUtils.getAllPermOrgsByUserId((String)"gtcp", (String)"gtcp_accrual_declare_than", (String)"4715a0df000000ac", (Long)RequestContext.get().getCurrUserId());
        if (!allPermOrgsByUserId.hasAllOrgPerm() && !(hasPermOrgs = allPermOrgsByUserId.getHasPermOrgs()).contains(orgId)) {
            return;
        }
        Date startDate = (Date)this.getModel().getValue("skssqq");
        Boolean validDates = this.isValidDates(startDate, endDate = (Date)this.getModel().getValue("skssqz"), true);
        if (validDates.booleanValue()) {
            super.save();
        }
    }

    @Override
    protected String getDraftpurpose() {
        return "sjjt";
    }

    protected String getEntity(String templateType) {
        return "gtcp_accrual_declare_than";
    }

    @Override
    protected Map<String, String> getFetchConfigParams(DeclareRequestModel requestModel) {
        Object draftpurpose = requestModel.getExtendParams().get("draftpurpose");
        if (ObjectUtils.isEmpty(draftpurpose)) {
            return null;
        }
        Long taxationsysId = this.getModel().getDataEntity().getLong("taxationsys.id");
        Long taxcategoryId = this.getModel().getDataEntity().getLong("taxcategory.id");
        Long taxareagroupId = this.getModel().getDataEntity().getLong("taxareagroup.id");
        return GtcpFetchDataBussiness.getJtFetchConfigParams(requestModel, taxationsysId, taxcategoryId, taxareagroupId, this.getModel().getDataEntity().getString("taxcategory.number"), false);
    }

    @Override
    protected Map<String, Object> paraCustomParams(Map<String, Object> customParams) {
        this.getModel().setValue("remarks", (Object)(EmptyCheckUtils.isEmpty((Object)customParams.get("remarks")) ? "" : customParams.get("remarks").toString()));
        return super.paraCustomParams(customParams);
    }

    public Map<String, String> getUpdateNsrxxMap() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("remarks", EmptyCheckUtils.isNotEmpty((Object)this.getModel().getValue("remarks")) ? (String)this.getModel().getValue("remarks") : "");
        return params;
    }

    @Override
    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if ("skssqq".equalsIgnoreCase(name) || "skssqz".equalsIgnoreCase(name)) {
            this.getModel().getDataEntity().set("remarks", null);
            this.getView().updateView("remarks");
        }
    }
}

