/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.jtysbthan.fetchdata.dyn;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.refactor.template.plugin.AbstractDynamicListBasePlugin;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.fetchitem.FetchItemBusiness;
import kd.taxc.gtcp.common.enums.GtcpComparisonSchemeEnum;

public abstract class AbstractGtcpJtAndSbThanDynRowPlugin
extends AbstractDynamicListBasePlugin {
    private static final Log logger = LogFactory.getLog(AbstractGtcpJtAndSbThanDynRowPlugin.class);

    public List<Map<String, Object>> query(BussinessParamsVo bussinessParamsVo) {
        logger.info("start AbstractGtcpJtAndSbThanDynRowPlugin query");
        Map<String, List<Map<String, Object>>> fetchItemListMap = this.batchFetchDynRowList(bussinessParamsVo);
        if (fetchItemListMap == null) {
            return new ArrayList<Map<String, Object>>();
        }
        String dynRowNo = bussinessParamsVo.getExtendParams().get("dynRowNo").toString();
        return fetchItemListMap.get(dynRowNo) == null ? new ArrayList() : fetchItemListMap.get(dynRowNo);
    }

    public List<DynamicRowModel> globalDynrowQuery(BussinessParamsVo bussinessParamsVo) {
        ArrayList<DynamicRowModel> list = new ArrayList<DynamicRowModel>(8);
        logger.info("start AbstractGtcpJtAndSbThanDynRowPlugin globalDynrowQuery");
        Map<String, List<Map<String, Object>>> resultListMap = this.batchFetchDynRowList(bussinessParamsVo);
        if (!ObjectUtils.isEmpty(resultListMap)) {
            this.buildGlobalDynRow(bussinessParamsVo, resultListMap, list);
        }
        return list;
    }

    private void buildGlobalDynRow(BussinessParamsVo bussinessParamsVo, Map<String, List<Map<String, Object>>> resultListMap, List<DynamicRowModel> list) {
        Map extendParams = bussinessParamsVo.getExtendParams();
        Long templateId = (Long)extendParams.get("templateId");
        for (Map.Entry<String, List<Map<String, Object>>> entry : resultListMap.entrySet()) {
            DynamicRowModel dynamicRowModel = new DynamicRowModel();
            dynamicRowModel.setTemplateId(templateId);
            dynamicRowModel.setDynRowNo(entry.getKey());
            ArrayList rowList = new ArrayList(8);
            entry.getValue().stream().forEach(row -> rowList.add(new HashMap<String, String>(){
                {
                    for (Map.Entry rowEntry : row.entrySet()) {
                        this.put(rowEntry.getKey(), kd.taxc.bdtaxr.common.tctb.common.util.ObjectUtils.getStringByType(rowEntry.getValue()));
                    }
                }
            }));
            dynamicRowModel.setRowList(rowList);
            list.add(dynamicRowModel);
        }
    }

    protected Map<String, List<Map<String, Object>>> batchFetchDynRowList(BussinessParamsVo bussinessParamsVo) {
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>(8);
        Map extendParams = bussinessParamsVo.getExtendParams();
        logger.info("start AbstractGtcpJtAndSbThanDynRowPlugin batchFetchDynRowList");
        if (bussinessParamsVo.getStartDate() == null || bussinessParamsVo.getEndDate() == null || extendParams.get("templateId") == null || extendParams.get("taxationsys") == null || extendParams.get("taxcategory") == null || extendParams.get("taxareagroup") == null || bussinessParamsVo.getOrgId() == null || bussinessParamsVo.getExtendParams().get("schemeEnumType") == null || ObjectUtils.isEmpty(bussinessParamsVo.getExtendParams().get("jtSbbIdList")) || ObjectUtils.isEmpty(bussinessParamsVo.getExtendParams().get("sbbIdList"))) {
            return result;
        }
        logger.info("start AbstractGtcpJtAndSbThanDynRowPlugin bussinessParamsVo");
        GtcpComparisonSchemeEnum schemeEnumType = GtcpComparisonSchemeEnum.getComparisonSchemeEnumByType(bussinessParamsVo.getExtendParams().get("schemeEnumType").toString());
        String jtSbbIdListString = bussinessParamsVo.getExtendParams().get("jtSbbIdList").toString();
        String sbbIdListString = bussinessParamsVo.getExtendParams().get("sbbIdList").toString();
        logger.info("schemeEnumType:{}", (Object)schemeEnumType.getThanPlan());
        logger.info("jtSbbIdList:{}", (Object)jtSbbIdListString);
        logger.info("sbbIdListString:{}", (Object)sbbIdListString);
        List jtSbbIdList = (List)SerializationUtils.fromJsonString((String)jtSbbIdListString, List.class);
        List sbbIdList = (List)SerializationUtils.fromJsonString((String)sbbIdListString, List.class);
        HashMap<String, Map<String, Map<String, String>>> sbCellValueMap = new HashMap<String, Map<String, Map<String, String>>>(8);
        HashMap<String, Map<String, Map<String, String>>> jtCellValueMap = new HashMap<String, Map<String, Map<String, String>>>(8);
        this.doCalculateCompareResult(bussinessParamsVo, schemeEnumType, jtSbbIdList, sbbIdList, sbCellValueMap, jtCellValueMap);
        this.getDynListMapByDynRowNo(sbCellValueMap, jtCellValueMap, result);
        logger.info("AbstractGtcpJtAndSbThanDynRowPlugin batchFetchDynRowList finish,result :{}", (Object)result.size());
        return result;
    }

    protected abstract void doCalculateCompareResult(BussinessParamsVo var1, GtcpComparisonSchemeEnum var2, List<String> var3, List<String> var4, Map<String, Map<String, Map<String, String>>> var5, Map<String, Map<String, Map<String, String>>> var6);

    protected abstract List<String> getDynrownoPrefix();

    protected abstract String getDynrownoSuffix();

    protected abstract String getRtaBbxmDynrownoSuffix(String var1);

    protected abstract String getRtaJtDynrownoSuffix(String var1);

    protected abstract String getRtaSbDynrownoSuffix(String var1);

    protected abstract String getBdColumns();

    protected void getDynListMapByDynRowNo(Map<String, Map<String, Map<String, String>>> sbCellValueMap, Map<String, Map<String, Map<String, String>>> jtCellValueMap, Map<String, List<Map<String, Object>>> result) {
        List<String> dynrownoPrefix = this.getDynrownoPrefix();
        String bdColumns = this.getBdColumns();
        HashSet fetchItemIdList = new HashSet(12);
        dynrownoPrefix.stream().forEach(dynrow -> {
            Map sbMapMap = (Map)sbCellValueMap.get(dynrow);
            Map jtMapMap = (Map)jtCellValueMap.get(dynrow);
            if (!ObjectUtils.isEmpty((Object)sbMapMap)) {
                sbMapMap.entrySet().stream().forEach(sbMap -> {
                    String sbkey = (String)sbMap.getKey();
                    fetchItemIdList.add(Long.parseLong(sbkey));
                });
            }
            if (!ObjectUtils.isEmpty((Object)jtMapMap)) {
                jtMapMap.entrySet().stream().forEach(jtMap -> {
                    String sbkey = (String)jtMap.getKey();
                    fetchItemIdList.add(Long.parseLong(sbkey));
                });
            }
        });
        HashMap<String, List<Long>> fetchItemMap = new HashMap<String, List<Long>>(16);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(fetchItemIdList)) {
            Map<String, List<Long>> fetchItemIdWithOrder = FetchItemBusiness.getFetchItemIdWithOrder(new ArrayList<Long>(fetchItemIdList));
            logger.info("fetchItemIdWithOrder size:{}", (Object)fetchItemIdWithOrder.size());
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(fetchItemIdWithOrder)) {
                this.buildFetchItemAndDynRelation(fetchItemIdWithOrder, fetchItemMap);
            }
        }
        dynrownoPrefix.stream().forEach(dynrow -> {
            ArrayList<Map<String, Object>> mapList = new ArrayList<Map<String, Object>>(16);
            Map sbMapMap = (Map)sbCellValueMap.get(dynrow);
            Map jtMapMap = (Map)jtCellValueMap.get(dynrow);
            HashMap<String, String> sbResultMap = new HashMap<String, String>(8);
            if (!ObjectUtils.isEmpty((Object)sbMapMap)) {
                sbMapMap.entrySet().stream().forEach(sbMap -> {
                    String sbkey = (String)sbMap.getKey();
                    Map mapValue = (Map)sbMap.getValue();
                    String value = (String)mapValue.get(bdColumns);
                    sbResultMap.put(sbkey, value);
                });
            }
            HashMap<String, String> jtResultMap = new HashMap<String, String>(8);
            if (!ObjectUtils.isEmpty((Object)jtMapMap)) {
                jtMapMap.entrySet().stream().forEach(jtMap -> {
                    String sbkey = (String)jtMap.getKey();
                    Map mapValue = (Map)jtMap.getValue();
                    String value = (String)mapValue.get(bdColumns);
                    jtResultMap.put(sbkey, value);
                });
            }
            List<Long> dynIdList = fetchItemMap.get(dynrow) != null ? (List)fetchItemMap.get(dynrow) : new ArrayList(2);
            logger.info("dynrow size:{}", (Object)dynIdList.size());
            if (!ObjectUtils.isEmpty(dynIdList)) {
                this.buildCellReportItem((String)dynrow, (Map<String, String>)sbResultMap, (Map<String, String>)jtResultMap, (List<Map<String, Object>>)mapList, dynIdList);
                if (!ObjectUtils.isEmpty(mapList)) {
                    result.put((String)dynrow, (List<Map<String, Object>>)mapList);
                }
            }
        });
    }

    protected abstract void buildFetchItemAndDynRelation(Map<String, List<Long>> var1, Map<String, List<Long>> var2);

    protected int initStartSequenceNumber(String dynrowprefix, Map<String, String> sbResultMap, Map<String, String> jtResultMap, List<Map<String, Object>> mapList) {
        return 1;
    }

    protected void buildCellReportItem(String dynrowprefix, Map<String, String> sbResultMap, Map<String, String> jtResultMap, List<Map<String, Object>> mapList, List<Long> dynIdList) {
        if (sbResultMap != null && jtResultMap != null) {
            HashSet<String> bbxmIdSet = new HashSet<String>(8);
            bbxmIdSet.addAll(sbResultMap.keySet());
            bbxmIdSet.addAll(jtResultMap.keySet());
            int i = this.initStartSequenceNumber(dynrowprefix, sbResultMap, jtResultMap, mapList);
            for (Long bbxm : dynIdList) {
                String bbxmId = String.valueOf(bbxm);
                logger.info("buildCellReportItem bbxmId:{}", (Object)bbxmId);
                if (!bbxmIdSet.contains(bbxmId)) continue;
                logger.info("buildCellReportItem bbxmId true:{}", (Object)bbxmId);
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                String prefix = dynrowprefix;
                if (prefix.endsWith("#1")) {
                    String[] split = prefix.split("#1");
                    prefix = split[0];
                }
                this.buildRowSequenceNumber(dynrowprefix, i++, map);
                map.put(prefix + this.getRtaBbxmDynrownoSuffix(dynrowprefix), bbxmId);
                if (sbResultMap.containsKey(bbxmId)) {
                    map.put(prefix + this.getRtaSbDynrownoSuffix(dynrowprefix), sbResultMap.get(bbxmId));
                }
                if (jtResultMap.containsKey(bbxmId)) {
                    map.put(prefix + this.getRtaJtDynrownoSuffix(dynrowprefix), jtResultMap.get(bbxmId));
                }
                mapList.add(map);
            }
        }
    }

    protected void buildRowSequenceNumber(String dynrowprefix, int i, HashMap<String, Object> map) {
        Map<String, String> dynRowSequenceNumber = this.getDynRowSequenceNumber();
        map.put(dynrowprefix + "#common_levy_sequence_number", new StringBuilder(dynRowSequenceNumber.get(dynrowprefix)).append(".").append(i));
    }

    protected abstract Map<String, String> getDynRowSequenceNumber();

    protected Map<String, Map<String, Map<String, String>>> queryCellValue(Long entryid, String dynrowno, String bbxmEndNumber, String amountEndNumber) {
        return GtcpDraftBussiness.queryCellValue(entryid, dynrowno, bbxmEndNumber, amountEndNumber);
    }

    protected Map<String, Map<String, Map<String, String>>> BatchQueryCellValue(Long entryid, List<String> dynrownoList, String bbxmEndNumber, String amountEndNumber) {
        return GtcpDraftBussiness.batchQueryCellValue(entryid, dynrownoList, bbxmEndNumber, amountEndNumber);
    }

    protected Map<String, Map<String, Map<String, String>>> BatchQueryCellValueWithSum(List<Long> entryid, List<String> dynrownoList, String bbxmEndNumber, String amountEndNumber) {
        return GtcpDraftBussiness.batchQueryCellValueWithSum(entryid, dynrownoList, bbxmEndNumber, amountEndNumber);
    }
}

