/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.jtysbthan.fetchdata.dyn.useCit;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.gtcp.common.enums.GtcpComparisonSchemeEnum;
import kd.taxc.gtcp.common.enums.UsaDynRowEnum;
import kd.taxc.gtcp.common.enums.UsaTaxAreaGroupColumnEnum;
import kd.taxc.gtcp.formplugin.jtysbthan.fetchdata.dyn.AbstractGtcpJtAndSbThanDynRowPlugin;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AbstractGtcpUsaCitJtAndSbThanDynRowPlugin
extends AbstractGtcpJtAndSbThanDynRowPlugin {
    @Override
    protected void doCalculateCompareResult(BussinessParamsVo bussinessParamsVo, GtcpComparisonSchemeEnum schemeEnum, List<String> jtSbbIdList, List<String> sbbIdList, Map<String, Map<String, Map<String, String>>> sbCellValueMap, Map<String, Map<String, Map<String, String>>> jtCellValueMap) {
        List<String> dynrownoPrefix = this.getDynrownoPrefix();
        List jtIdList = jtSbbIdList.stream().map(jt -> Long.parseLong(jt)).collect(Collectors.toList());
        List sbIdList = sbbIdList.stream().map(sb -> Long.parseLong(sb)).collect(Collectors.toList());
        sbCellValueMap.putAll(super.BatchQueryCellValue((Long)sbIdList.get(0), dynrownoPrefix, this.getDynrownoSuffix(), this.getBdColumns()));
        jtCellValueMap.putAll(super.BatchQueryCellValue((Long)jtIdList.get(0), dynrownoPrefix, this.getDynrownoSuffix(), this.getBdColumns()));
    }

    @Override
    protected String getRtaBbxmDynrownoSuffix(String dynrowprefix) {
        UsaTaxAreaGroupColumnEnum enumByusaDynRowEnum = UsaTaxAreaGroupColumnEnum.getEnumByusaDynRowEnum(dynrowprefix);
        if (ObjectUtils.isNotEmpty((Object)((Object)enumByusaDynRowEnum))) {
            String itemColumn = enumByusaDynRowEnum.getItemColumn();
            return "#RTA_" + itemColumn;
        }
        return "";
    }

    @Override
    protected String getRtaJtDynrownoSuffix(String dynrowprefix) {
        String itemColumn;
        String[] items;
        UsaTaxAreaGroupColumnEnum enumByusaDynRowEnum = UsaTaxAreaGroupColumnEnum.getEnumByusaDynRowEnum(dynrowprefix);
        if (ObjectUtils.isNotEmpty((Object)((Object)enumByusaDynRowEnum)) && ObjectUtils.isNotEmpty((Object)(items = StringUtils.splitByWholeSeparator((String)(itemColumn = enumByusaDynRowEnum.getItemColumn()), (String)"_Item")))) {
            return "#RTA_" + items[0] + "_Accrual";
        }
        return "";
    }

    @Override
    protected String getRtaSbDynrownoSuffix(String dynrowprefix) {
        String itemColumn;
        String[] items;
        UsaTaxAreaGroupColumnEnum enumByusaDynRowEnum = UsaTaxAreaGroupColumnEnum.getEnumByusaDynRowEnum(dynrowprefix);
        if (ObjectUtils.isNotEmpty((Object)((Object)enumByusaDynRowEnum)) && ObjectUtils.isNotEmpty((Object)(items = StringUtils.splitByWholeSeparator((String)(itemColumn = enumByusaDynRowEnum.getItemColumn()), (String)"_Item")))) {
            return "#RTA_" + items[0] + "_Reporting";
        }
        return "";
    }

    @Override
    protected void buildRowSequenceNumber(String dynrowprefix, int i, HashMap<String, Object> map) {
        String itemColumn;
        String[] items;
        Map<String, String> dynRowSequenceNumber = this.getDynRowSequenceNumber();
        UsaTaxAreaGroupColumnEnum enumByusaDynRowEnum = UsaTaxAreaGroupColumnEnum.getEnumByusaDynRowEnum(dynrowprefix);
        if (ObjectUtils.isNotEmpty((Object)((Object)enumByusaDynRowEnum)) && ObjectUtils.isNotEmpty((Object)(items = StringUtils.splitByWholeSeparator((String)(itemColumn = enumByusaDynRowEnum.getItemColumn()), (String)"_Item")))) {
            String prefix = dynrowprefix;
            if (prefix.endsWith("#1")) {
                String[] split = prefix.split("#1");
                prefix = split[0];
            }
            map.put(prefix + "#" + items[0] + "_serialno", new StringBuilder(dynRowSequenceNumber.get(dynrowprefix)).append(".").append(i));
        }
    }

    @Override
    protected int initStartSequenceNumber(String dynrowprefix, Map<String, String> sbResultMap, Map<String, String> jtResultMap, List<Map<String, Object>> mapList) {
        UsaDynRowEnum enumByDynRow = UsaDynRowEnum.getEnumByDynRow(dynrowprefix);
        if (ObjectUtils.isNotEmpty((Object)((Object)enumByDynRow)) && ObjectUtils.isNotEmpty((Object)enumByDynRow.getStartNumber())) {
            return Integer.parseInt(enumByDynRow.getStartNumber());
        }
        return 1;
    }

    @Override
    protected void buildFetchItemAndDynRelation(Map<String, List<Long>> fetchItemIdWithOrder, Map<String, List<Long>> fetchItemMap) {
        Map<String, List<String>> biztypeAndDynRelation = UsaDynRowEnum.getBiztypeAndDynRelation();
        Set<Map.Entry<String, List<Long>>> entries = fetchItemIdWithOrder.entrySet();
        for (Map.Entry<String, List<Long>> next : entries) {
            String nextKey = next.getKey();
            if (!biztypeAndDynRelation.containsKey(nextKey)) continue;
            List<String> list = biztypeAndDynRelation.get(nextKey);
            for (String dyn : list) {
                fetchItemMap.put(dyn, next.getValue());
            }
        }
    }
}

