/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.jtysbthan.fetchdata.dyn.vat;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.vo.BussinessParamsVo;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.common.enums.GtcpComparisonSchemeEnum;
import kd.taxc.gtcp.common.enums.GtcpPeriodEnum;
import kd.taxc.gtcp.formplugin.jtysbthan.fetchdata.dyn.AbstractGtcpJtAndSbThanDynRowPlugin;

public abstract class AbstractGtcpVatJtAndSbThanDynRowPlugin
extends AbstractGtcpJtAndSbThanDynRowPlugin {
    @Override
    protected void doCalculateCompareResult(BussinessParamsVo bussinessParamsVo, GtcpComparisonSchemeEnum schemeEnum, List<String> jtSbbIdList, List<String> sbbIdList, Map<String, Map<String, Map<String, String>>> sbCellValueMap, Map<String, Map<String, Map<String, String>>> jtCellValueMap) {
        String jtPlan = schemeEnum.getJtPlan();
        String taxperiod = schemeEnum.getTaxperiod();
        String thanPlan = schemeEnum.getThanPlan();
        List<String> dynrownoPrefix = this.getDynrownoPrefix();
        List<Long> jtIdList = jtSbbIdList.stream().map(jt -> Long.parseLong(jt)).collect(Collectors.toList());
        List<Long> sbIdList = sbbIdList.stream().map(sb -> Long.parseLong(sb)).collect(Collectors.toList());
        if (taxperiod.equalsIgnoreCase(jtPlan)) {
            sbCellValueMap.putAll(super.BatchQueryCellValue((Long)sbIdList.get(0), dynrownoPrefix, this.getDynrownoSuffix(), this.getBdColumns()));
            jtCellValueMap.putAll(super.BatchQueryCellValue((Long)jtIdList.get(0), dynrownoPrefix, this.getDynrownoSuffix(), this.getBdColumns()));
        } else if (GtcpPeriodEnum.SEASON.getNumber().equalsIgnoreCase(thanPlan)) {
            String comparePeroid = GtcpDraftBussiness.comparePeroid(taxperiod, jtPlan, thanPlan);
            if ("jt".equalsIgnoreCase(comparePeroid)) {
                sbCellValueMap.putAll(super.BatchQueryCellValue((Long)sbIdList.get(0), dynrownoPrefix, this.getDynrownoSuffix(), this.getBdColumns()));
                jtCellValueMap.putAll(super.BatchQueryCellValueWithSum(jtIdList, dynrownoPrefix, this.getDynrownoSuffix(), this.getBdColumns()));
            } else if ("sb".equalsIgnoreCase(comparePeroid)) {
                sbCellValueMap.putAll(super.BatchQueryCellValueWithSum(sbIdList, dynrownoPrefix, this.getDynrownoSuffix(), this.getBdColumns()));
                jtCellValueMap.putAll(super.BatchQueryCellValue((Long)jtIdList.get(0), dynrownoPrefix, this.getDynrownoSuffix(), this.getBdColumns()));
            }
        }
    }
}

