/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.jtysbthan.fetchdata.initparam.Strategy;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.provision.GtcpProvisionPlanBusiness;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import kd.taxc.gtcp.common.enums.GtcpComparisonSchemeEnum;

public abstract class AbstractBuildInitParamStrategy {
    public Map<String, String> buildBizParam(DeclareRequestModel requestModel) {
        List<String> hideSheetList;
        HashMap<String, String> resultMap = new HashMap<String, String>(8);
        String compareMethod = this.calculateCompareMethod(requestModel);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)compareMethod)) {
            resultMap.put("schemeEnumType", compareMethod);
            GtcpComparisonSchemeEnum comparisonSchemeEnum = GtcpComparisonSchemeEnum.getComparisonSchemeEnumByType(compareMethod);
            Map<String, String> hanleParams = this.hanleParams(requestModel, comparisonSchemeEnum);
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(hanleParams)) {
                resultMap.putAll(hanleParams);
            }
        }
        if (!ObjectUtils.isEmpty(hideSheetList = this.hideSheetList(requestModel))) {
            resultMap.put("hideSheetList", SerializationUtils.toJsonString(hideSheetList));
        }
        return resultMap;
    }

    protected abstract Map<String, String> hanleParams(DeclareRequestModel var1, GtcpComparisonSchemeEnum var2);

    protected String calculateCompareMethod(DeclareRequestModel requestModel) {
        String plan = this.queryProsionPlan(requestModel);
        if (ObjectUtils.isEmpty((Object)plan)) {
            return "";
        }
        Date startDate = DateUtils.stringToDate((String)requestModel.getSkssqq());
        Date endDate = DateUtils.stringToDate((String)requestModel.getSkssqz());
        String range = this.calculateBdPeriodDiffer(startDate, endDate);
        return this.doCalculateCompareMethod(requestModel, plan, range);
    }

    protected String doCalculateCompareMethod(DeclareRequestModel requestModel, String plan, String range) {
        String queryTaxperiod = this.queryTaxperiod(requestModel);
        GtcpComparisonSchemeEnum comparisonSchemeEnumByJtAndBdplan = GtcpComparisonSchemeEnum.getComparisonSchemeEnumByJtAndBdplan(plan, queryTaxperiod, range);
        if (!ObjectUtils.isEmpty((Object)((Object)comparisonSchemeEnumByJtAndBdplan))) {
            return comparisonSchemeEnumByJtAndBdplan.getBdtype();
        }
        return "";
    }

    protected String queryProsionPlan(DeclareRequestModel requestModel) {
        Map extendParams = requestModel.getExtendParams();
        return GtcpProvisionPlanBusiness.queryMinProvisionPlan(requestModel.getOrgId(), Long.parseLong(extendParams.get("taxationsys").toString()), Long.parseLong(extendParams.get("taxcategory").toString()), Long.parseLong(extendParams.get("taxareagroup").toString()), DateUtils.stringToDate((String)requestModel.getSkssqq()), DateUtils.stringToDate((String)requestModel.getSkssqz()));
    }

    protected String calculateBdPeriodDiffer(Date startDate, Date endDate) {
        return DateUtils.getTaxLimit((Date)startDate, (Date)endDate);
    }

    protected String queryTaxperiod(DeclareRequestModel requestModel) {
        Map extendParams = requestModel.getExtendParams();
        return GtcpTaxOrgCommonBusiness.queryMinHwsTaxlimitByOrgId(requestModel.getOrgId(), Long.parseLong(extendParams.get("taxationsys").toString()), Long.parseLong(extendParams.get("taxcategory").toString()), Long.parseLong(extendParams.get("taxareagroup").toString()));
    }

    protected List<String> hideSheetList(DeclareRequestModel requestModel) {
        return new ArrayList<String>();
    }
}

