/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.jtysbthan.fetchdata.initparam.Strategy;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.common.enums.GtcpComparisonSchemeEnum;
import kd.taxc.gtcp.formplugin.jtysbthan.fetchdata.initparam.Strategy.AbstractBuildInitParamStrategy;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class BuildCitRtaInitParamStrategy
extends AbstractBuildInitParamStrategy {
    @Override
    protected Map<String, String> hanleParams(DeclareRequestModel requestModel, GtcpComparisonSchemeEnum comparisonSchemeEnum) {
        String orgId = requestModel.getOrgId().toString();
        String skssqq = requestModel.getSkssqq();
        String skssqz = requestModel.getSkssqz();
        String taxationsys = requestModel.getTaxationsys() != null ? requestModel.getTaxationsys().toString() : "0";
        String taxcategory = requestModel.getExtendParams().get("taxcategory") != null ? requestModel.getExtendParams().get("taxcategory").toString() : "0";
        String taxareagroup = requestModel.getExtendParams() != null ? requestModel.getExtendParams().get("taxareagroup").toString() : "0";
        HashMap<String, String> resultMap = new HashMap<String, String>(8);
        ArrayList<String> sbbIdList = new ArrayList<String>(4);
        ArrayList<String> jtsbbIdList = new ArrayList<String>(4);
        String thanmethod = comparisonSchemeEnum.getThanPlan();
        String jtPlan = comparisonSchemeEnum.getJtPlan();
        String taxperiod = comparisonSchemeEnum.getTaxperiod();
        sbbIdList.add(GtcpDraftBussiness.getSbbId("Overseas_CIT", Long.parseLong(orgId), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), Long.parseLong(taxationsys), Long.parseLong(taxcategory), Long.parseLong(taxareagroup), "nssb"));
        if (jtPlan.equalsIgnoreCase(taxperiod)) {
            jtsbbIdList.add(GtcpDraftBussiness.getSbbId("Overseas_CIT", Long.parseLong(orgId), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), Long.parseLong(taxationsys), Long.parseLong(taxcategory), Long.parseLong(taxareagroup), "sjjt"));
        } else {
            ImmutablePair<Date, Date> immutablePair;
            String comparePeroid = GtcpDraftBussiness.comparePeroid(taxperiod, jtPlan, thanmethod);
            if ("jt".equalsIgnoreCase(comparePeroid) && org.apache.commons.lang3.ObjectUtils.isNotEmpty(immutablePair = GtcpDraftBussiness.getLastPeriod(DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), jtPlan))) {
                jtsbbIdList.add(GtcpDraftBussiness.getSbbId("Overseas_CIT", Long.parseLong(orgId), (Date)immutablePair.left, (Date)immutablePair.right, Long.parseLong(taxationsys), Long.parseLong(taxcategory), Long.parseLong(taxareagroup), "sjjt"));
            }
        }
        resultMap.put("jtId", org.apache.commons.lang3.ObjectUtils.isNotEmpty(jtsbbIdList) ? (String)jtsbbIdList.get(0) : "0");
        resultMap.put("sbId", org.apache.commons.lang3.ObjectUtils.isNotEmpty(sbbIdList) ? (String)sbbIdList.get(0) : "0");
        resultMap.put("jtSbbIdList", SerializationUtils.toJsonString(jtsbbIdList));
        resultMap.put("sbbIdList", SerializationUtils.toJsonString(sbbIdList));
        return resultMap;
    }

    @Override
    protected String doCalculateCompareMethod(DeclareRequestModel requestModel, String plan, String range) {
        GtcpComparisonSchemeEnum comparisonSchemeEnumByJtAndBdplan;
        String queryTaxperiod = this.queryTaxperiod(requestModel);
        if ("year".equals(range)) {
            queryTaxperiod = "year";
        }
        if (!ObjectUtils.isEmpty((Object)((Object)(comparisonSchemeEnumByJtAndBdplan = GtcpComparisonSchemeEnum.getComparisonSchemeEnumByJtAndBdplan(plan, queryTaxperiod, range))))) {
            return comparisonSchemeEnumByJtAndBdplan.getBdtype();
        }
        return "";
    }

    @Override
    protected List<String> hideSheetList(DeclareRequestModel requestModel) {
        ArrayList<String> hideSheetList = new ArrayList<String>(12);
        hideSheetList.add("Solidarity surcharge");
        hideSheetList.add("Trade tax");
        hideSheetList.add("Local income tax");
        hideSheetList.add("Inhabitants tax proportional");
        hideSheetList.add("Inhabitants tax normquota");
        hideSheetList.add("Enterprise tax");
        hideSheetList.add("Special enterprise tax");
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)requestModel)) {
            String taxationsys = requestModel.getTaxationsys().toString();
            String taxcategory = requestModel.getExtendParams().get("taxcategory").toString();
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxationsys) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxcategory)) {
                if (StringUtil.equalsIgnoreCase((CharSequence)taxationsys, (CharSequence)TaxationsysMappingEnum.JAP.getId().toString())) {
                    hideSheetList.remove("Local income tax");
                    hideSheetList.remove("Inhabitants tax proportional");
                    hideSheetList.remove("Inhabitants tax normquota");
                    hideSheetList.remove("Enterprise tax");
                    hideSheetList.remove("Special enterprise tax");
                } else if (StringUtil.equalsIgnoreCase((CharSequence)taxationsys, (CharSequence)TaxationsysMappingEnum.DEU.getId().toString())) {
                    hideSheetList.remove("Solidarity surcharge");
                    hideSheetList.remove("Trade tax");
                }
            }
        }
        return hideSheetList;
    }
}

