/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.jtysbthan.fetchdata.initparam.Strategy;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.draft.UsaCitBussiness;
import kd.taxc.gtcp.common.enums.GtcpComparisonSchemeEnum;
import kd.taxc.gtcp.common.enums.UsaTaxAreaGroupColumnEnum;
import kd.taxc.gtcp.common.enums.UsaTaxAreaGroupThanTaxesEnum;
import kd.taxc.gtcp.common.enums.UsaThanTaxAreaGroupTabEnum;
import kd.taxc.gtcp.formplugin.jtysbthan.fetchdata.initparam.Strategy.AbstractBuildInitParamStrategy;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class BuildUsaCitRtaInitParamStrategy
extends AbstractBuildInitParamStrategy {
    private static final Log logger = LogFactory.getLog(BuildUsaCitRtaInitParamStrategy.class);

    @Override
    protected Map<String, String> hanleParams(DeclareRequestModel requestModel, GtcpComparisonSchemeEnum comparisonSchemeEnum) {
        String orgId = requestModel.getOrgId().toString();
        String skssqq = requestModel.getSkssqq();
        String skssqz = requestModel.getSkssqz();
        String taxationsys = requestModel.getTaxationsys() != null ? requestModel.getTaxationsys().toString() : "0";
        String taxcategory = requestModel.getExtendParams().get("taxcategory") != null ? requestModel.getExtendParams().get("taxcategory").toString() : "0";
        String taxareagroup = requestModel.getExtendParams() != null ? requestModel.getExtendParams().get("taxareagroup").toString() : "0";
        HashMap<String, String> resultMap = new HashMap<String, String>(8);
        ArrayList<String> sbbIdList = new ArrayList<String>(4);
        ArrayList<String> jtsbbIdList = new ArrayList<String>(4);
        String thanmethod = comparisonSchemeEnum.getThanPlan();
        String jtPlan = comparisonSchemeEnum.getJtPlan();
        String taxperiod = comparisonSchemeEnum.getTaxperiod();
        sbbIdList.add(GtcpDraftBussiness.getSbbId("USA_CIT", Long.parseLong(orgId), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), Long.parseLong(taxationsys), Long.parseLong(taxcategory), Long.parseLong(taxareagroup), "nssb"));
        if (jtPlan.equalsIgnoreCase(taxperiod)) {
            jtsbbIdList.add(GtcpDraftBussiness.getSbbId("USA_CIT", Long.parseLong(orgId), DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), Long.parseLong(taxationsys), Long.parseLong(taxcategory), Long.parseLong(taxareagroup), "sjjt"));
        } else {
            ImmutablePair<Date, Date> immutablePair;
            String comparePeroid = GtcpDraftBussiness.comparePeroid(taxperiod, jtPlan, thanmethod);
            if ("jt".equalsIgnoreCase(comparePeroid) && org.apache.commons.lang3.ObjectUtils.isNotEmpty(immutablePair = GtcpDraftBussiness.getLastPeriod(DateUtils.stringToDate((String)skssqq), DateUtils.stringToDate((String)skssqz), jtPlan))) {
                jtsbbIdList.add(GtcpDraftBussiness.getSbbId("USA_CIT", Long.parseLong(orgId), (Date)immutablePair.left, (Date)immutablePair.right, Long.parseLong(taxationsys), Long.parseLong(taxcategory), Long.parseLong(taxareagroup), "sjjt"));
            }
        }
        String jtId = org.apache.commons.lang3.ObjectUtils.isNotEmpty(jtsbbIdList) ? (String)jtsbbIdList.get(0) : "0";
        String sbId = org.apache.commons.lang3.ObjectUtils.isNotEmpty(sbbIdList) ? (String)sbbIdList.get(0) : "0";
        logger.info("jtId:{} " + jtId);
        logger.info("sbId:{} " + sbId);
        resultMap.put("jtId", jtId);
        resultMap.put("sbId", sbId);
        this.fetchFixRowNumber(jtId, sbId, resultMap, requestModel.getCustomEvent(), requestModel.getId());
        resultMap.put("jtSbbIdList", SerializationUtils.toJsonString(jtsbbIdList));
        resultMap.put("sbbIdList", SerializationUtils.toJsonString(sbbIdList));
        return resultMap;
    }

    private void fetchFixRowNumber(String jtId, String sbId, Map<String, String> resultMap, String customEvent, Long draftId) {
        List<String> jtTabByDraftId = UsaCitBussiness.queryUsaCitDraftTabByDraftId(Long.parseLong(jtId));
        List<String> sbTabByDraftId = UsaCitBussiness.queryUsaCitDraftTabByDraftId(Long.parseLong(sbId));
        logger.info("jtTabByDraftId:{}", (Object)SerializationUtils.toJsonString(jtTabByDraftId));
        logger.info("sbTabByDraftId:{}", (Object)SerializationUtils.toJsonString(sbTabByDraftId));
        ArrayList<String> allhideTabs = new ArrayList<String>(12);
        ArrayList<String> allshowTabs = new ArrayList<String>(12);
        List<String> alltaxAreaGroupNameList = UsaTaxAreaGroupColumnEnum.getAlltaxAreaGroupNameList();
        alltaxAreaGroupNameList.add("Texas (FT)");
        alltaxAreaGroupNameList.add("State income tax overview");
        logger.info("customEvent" + customEvent);
        if ("recalc".equalsIgnoreCase(customEvent) || "add".equalsIgnoreCase(customEvent)) {
            logger.info("jtAndSbTabList");
            ArrayList<String> jtAndSbTabList = new ArrayList<String>(16);
            jtAndSbTabList.addAll(jtTabByDraftId);
            jtAndSbTabList.addAll(sbTabByDraftId);
            for (String taxArea : alltaxAreaGroupNameList) {
                boolean ishide = true;
                for (String tab : jtAndSbTabList) {
                    if (!taxArea.equalsIgnoreCase(tab)) continue;
                    allshowTabs.add(taxArea);
                    ishide = false;
                    break;
                }
                if (!ishide) continue;
                allhideTabs.add(taxArea);
            }
        } else {
            List<String> showTabs = UsaCitBussiness.queryUsaCitDraftThanTabByDraftId(draftId);
            for (String taxArea : alltaxAreaGroupNameList) {
                if (showTabs.contains(taxArea)) continue;
                allhideTabs.add(taxArea);
            }
            allshowTabs.addAll(showTabs);
        }
        List<String> accrualItemList = UsaTaxAreaGroupThanTaxesEnum.getAccrualItemListByTaxAreaGroupId(allshowTabs);
        List<String> reportingItemList = UsaTaxAreaGroupThanTaxesEnum.getReportingItemListByTaxAreaGroupId(allshowTabs);
        if (allshowTabs.contains("Texas (FT)")) {
            accrualItemList.add("Amount_to_be_accrued#RTA_Texas_FT_Accrual");
            reportingItemList.add("Total_amount_due_and_payable#RTA_Texas_FT_Reporting");
        }
        resultMap.put("accrualItemList", SerializationUtils.toJsonString(accrualItemList));
        resultMap.put("reportingItemList", SerializationUtils.toJsonString(reportingItemList));
        String allshowTabList = SerializationUtils.toJsonString(allshowTabs);
        String allhideTabsStr = SerializationUtils.toJsonString(allhideTabs);
        resultMap.put("allshowTabList", allshowTabList);
        resultMap.put("tabList", allhideTabsStr);
        logger.info("allshowTabList:{}", (Object)allshowTabList);
        logger.info("tabList:{}", (Object)allhideTabsStr);
        Map<String, String> accuralMap = UsaThanTaxAreaGroupTabEnum.getTabCellkeysByTabList(allshowTabs, "accural");
        Map<String, String> accuralValueMap = GtcpDraftBussiness.queryFixCellValue(Long.parseLong(jtId), new ArrayList<String>(accuralMap.keySet()));
        resultMap.putAll(this.buildFixRowResult(accuralMap, accuralValueMap));
        Map<String, String> reportingMap = UsaThanTaxAreaGroupTabEnum.getTabCellkeysByTabList(allshowTabs, "reporting");
        Map<String, String> reportingValueMap = GtcpDraftBussiness.queryFixCellValue(Long.parseLong(sbId), new ArrayList<String>(accuralMap.keySet()));
        resultMap.putAll(this.buildFixRowResult(reportingMap, reportingValueMap));
    }

    private Map<String, String> buildFixRowResult(Map<String, String> accuralMap, Map<String, String> accuralValueMap) {
        HashMap<String, String> resultMap = new HashMap<String, String>(12);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(accuralValueMap)) {
            for (Map.Entry<String, String> next : accuralValueMap.entrySet()) {
                resultMap.put(accuralMap.get(next.getKey()), next.getValue());
            }
        }
        return resultMap;
    }

    @Override
    protected String doCalculateCompareMethod(DeclareRequestModel requestModel, String plan, String range) {
        GtcpComparisonSchemeEnum comparisonSchemeEnumByJtAndBdplan;
        String queryTaxperiod = this.queryTaxperiod(requestModel);
        if ("year".equals(range)) {
            queryTaxperiod = "year";
        }
        if (!ObjectUtils.isEmpty((Object)((Object)(comparisonSchemeEnumByJtAndBdplan = GtcpComparisonSchemeEnum.getComparisonSchemeEnumByJtAndBdplan(plan, queryTaxperiod, range))))) {
            return comparisonSchemeEnumByJtAndBdplan.getBdtype();
        }
        return "";
    }
}

