/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.payrefund;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.ComboProp;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.DateEdit;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.taxpayrefund.GtcpTaxPayRefundBussiness;
import kd.taxc.gtcp.business.taxpayrefund.strategy.AbstractGtcpTaxPayRefundStrategy;
import kd.taxc.gtcp.business.taxpayrefund.strategy.GtcpTaxPayRefundStrategyFactory;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpTaxPayRefundConfirmPlugin
extends AbstractFormPlugin {
    private static final String PAY_REFUND_STATUS = "payrefundstatus";
    private static final String PAY_REFUND_DATE = "payrefunddate";
    private static final String NO_PAY = "nopay";
    private static final String NO_NEED_PAY = "noneedpay";
    private static final String NO_NEED_REFUND = "noneedrefund";
    private static final String PAY = "pay";
    private static final String REFUND = "refund";
    private static final String NO_REFUND = "norefund";

    public void afterCreateNewData(EventObject e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        if (ObjectUtils.isNotEmpty((Object)customParams)) {
            Object taxationsys = customParams.get("taxationsys");
            Object taxcategory = customParams.get("taxcategory");
            Object taxestype = customParams.get("taxestype");
            String datasouce = (String)customParams.get("datasouce");
            Date declaredate = null == customParams.get("declaredate") ? null : DateUtils.stringToDate2((String)((String)customParams.get("declaredate")));
            Date skssqz = null == customParams.get("skssqz") ? null : DateUtils.stringToDate2((String)((String)customParams.get("skssqz")));
            DateEdit dateRangeEdit = (DateEdit)this.getView().getControl(PAY_REFUND_DATE);
            if (ObjectUtils.isNotEmpty((Object)datasouce) && StringUtil.equalsIgnoreCase((CharSequence)"1", (CharSequence)datasouce)) {
                dateRangeEdit.setMinDate(declaredate);
            } else {
                dateRangeEdit.setMinDate(skssqz);
            }
            if (ObjectUtils.isNotEmpty(taxationsys) && ObjectUtils.isNotEmpty(taxcategory) && ObjectUtils.isNotEmpty((Object)datasouce) && ObjectUtils.isNotEmpty(taxestype)) {
                AbstractGtcpTaxPayRefundStrategy strategyEnumByType = GtcpTaxPayRefundStrategyFactory.getGtcpTaxPayRefundStrategyEnumByType((String)customParams.get("taxationsys.number"), (String)customParams.get("taxcategory.number"));
                if (ObjectUtils.isNotEmpty((Object)strategyEnumByType) && strategyEnumByType.checkNoCommonTaxtype(customParams)) {
                    this.setDefaultPayrefundstatus(taxestype.toString());
                } else {
                    this.getView().setVisible(Boolean.valueOf(false), new String[]{PAY_REFUND_STATUS});
                    ((ComboEdit)this.getControl(PAY_REFUND_STATUS)).setMustInput(false);
                    this.getView().getPageCache().put("isNoUsa", "true");
                }
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeData = e.getChangeSet();
        if (PAY_REFUND_STATUS.equalsIgnoreCase(name) && ObjectUtils.isNotEmpty((Object)changeData[0]) && ObjectUtils.isNotEmpty((Object)changeData[0].getNewValue())) {
            if (NO_NEED_PAY.equals(changeData[0].getNewValue()) || NO_NEED_REFUND.equals(changeData[0].getNewValue())) {
                this.getView().setVisible(Boolean.valueOf(false), new String[]{PAY_REFUND_DATE});
                ((DateEdit)this.getControl(PAY_REFUND_DATE)).setMustInput(false);
            } else {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{PAY_REFUND_DATE});
                ((DateEdit)this.getControl(PAY_REFUND_DATE)).setMustInput(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        super.afterDoOperation(afterDoOperationEventArgs);
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        Date payrefunddate = this.getModel().getDataEntity().getDate(PAY_REFUND_DATE);
        if (ObjectUtils.isNotEmpty(customParams.get("id"))) {
            Object taxestype = customParams.get("taxestype");
            DynamicObject dynamicObject = GtcpTaxPayRefundBussiness.queryTaxPayRefundById((Long)customParams.get("id"));
            if (ObjectUtils.isNotEmpty((Object)dynamicObject)) {
                OperationResult operationResult;
                dynamicObject.set(PAY_REFUND_DATE, (Object)payrefunddate);
                dynamicObject.set("remark", (Object)this.getModel().getDataEntity().getString("remark"));
                dynamicObject.set("payrefstatus", (Object)this.getModel().getDataEntity().getString(PAY_REFUND_STATUS));
                if (ObjectUtils.isNotEmpty((Object)this.getView().getPageCache().get("isNoUsa")) && "true".equals(this.getView().getPageCache().get("isNoUsa"))) {
                    if (PAY.equals(taxestype)) {
                        dynamicObject.set("payrefstatus", (Object)PAY);
                    }
                    if (REFUND.equals(taxestype)) {
                        dynamicObject.set("payrefstatus", (Object)REFUND);
                    }
                }
                if ((operationResult = OperationServiceHelper.executeOperate((String)"payrefundsave", (String)"gtcp_taxpay_refund_bill", (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create())).isSuccess()) {
                    this.getView().getParentView().showSuccessNotification(ResManager.loadKDString((String)"\u786e\u8ba4\u7f34/\u9000\u7a0e\u6210\u529f\u3002", (String)"GtcpTaxPayRefundConfirmPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]));
                    this.getView().close();
                } else {
                    List allErrorOrValidateInfo = operationResult.getAllErrorOrValidateInfo();
                    this.getView().showErrorNotification(((IOperateInfo)allErrorOrValidateInfo.get(0)).getMessage());
                }
            }
        }
    }

    private void setDefaultPayrefundstatus(String taxestype) {
        String value = PAY.equalsIgnoreCase(taxestype) ? PAY : REFUND;
        List<String> comitemList = PAY.equalsIgnoreCase(taxestype) ? Arrays.asList(PAY, NO_NEED_PAY) : Arrays.asList(REFUND, NO_NEED_REFUND);
        List comboItems = ((ComboProp)((ComboEdit)this.getControl(PAY_REFUND_STATUS)).getProperty()).getComboItems();
        Iterator iterator = comboItems.iterator();
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(4);
        while (iterator.hasNext()) {
            ValueMapItem next = (ValueMapItem)iterator.next();
            if (!comitemList.contains(next.getValue())) continue;
            ComboItem comboItem = new ComboItem();
            comboItem.setValue(next.getValue());
            comboItem.setCaption(next.getName());
            comboItem.setItemVisible(true);
            items.add(comboItem);
        }
        ((ComboEdit)this.getControl(PAY_REFUND_STATUS)).setComboItems(items);
        this.getModel().setValue(PAY_REFUND_STATUS, (Object)value);
    }
}

