/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.payrefund;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.entity.operate.Donothing;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.FilterContainerSearchClickArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.BeforeShowBillFormEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.enums.PayRefundHyperlinkParamsEnum;
import kd.taxc.bdtaxr.common.enums.TaxationSysEnum;
import kd.taxc.bdtaxr.common.helper.bd.taxationsys.TaxAtionsysDataServiceHelper;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.utils.metadata.MetadataUtil;
import kd.taxc.gtcp.business.taxpayrefund.GtcpTaxPayRefundBussiness;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpTaxPayRefundListPlugin
extends AbstractListPlugin {
    private static final String ORGID_KEY = "orgid";
    private static final String ORGNAME_KEY = "orgname";

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        if ("org.id".equalsIgnoreCase(args.getFieldName())) {
            List<Long> taxpayers = GtcpTaxPayRefundListPlugin.queryBastaxTaxOrg(this.getView());
            QFilter orgFilter = new QFilter("id", "in", taxpayers);
            args.getQfilters().add(orgFilter);
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        FilterContainerInitEvent contInitEvent = args.getFilterContainerInitEvent();
        List filterColumnList = contInitEvent.getCommonFilterColumns();
        for (FilterColumn column : filterColumnList) {
            TaxResult result;
            if ("org.name".equals(column.getFieldName())) {
                List<Long> idList = GtcpTaxPayRefundListPlugin.queryBastaxTaxOrg(this.getView());
                long orgId = RequestContext.get().getOrgId();
                QFilter authFilter = new QFilter("id", "in", idList);
                DynamicObjectCollection orgCol = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id,org.name as name", (QFilter[])new QFilter[]{authFilter});
                List comboItems = orgCol.stream().map(dyo -> {
                    ComboItem item = new ComboItem();
                    item.setValue(dyo.getString("id"));
                    item.setCaption(new LocaleString(dyo.getString("name")));
                    return item;
                }).collect(Collectors.toList());
                CommonFilterColumn typeColumn = (CommonFilterColumn)column;
                typeColumn.setComboItems(comboItems);
                if (idList.contains(orgId)) {
                    typeColumn.setDefaultValue(String.valueOf(orgId));
                    continue;
                }
                if (!CollectionUtils.isNotEmpty(idList)) continue;
                typeColumn.setDefaultValue(String.valueOf(idList.get(0)));
                continue;
            }
            if (!"taxationsys.name".equalsIgnoreCase(column.getFieldName()) || (result = TaxAtionsysDataServiceHelper.queryTaxAtionsysByIds(null)) == null || !result.isSuccess()) continue;
            List list = (List)result.getData();
            List comboItems = list.stream().filter(row -> !TaxationSysEnum.CHAIN_MAINLAND.getId().equals(row.getPkValue())).map(dyo -> {
                ComboItem item = new ComboItem();
                item.setValue(dyo.getString("id"));
                item.setCaption(new LocaleString(dyo.getString("name")));
                return item;
            }).collect(Collectors.toList());
            CommonFilterColumn typeColumn = (CommonFilterColumn)column;
            typeColumn.setComboItems(comboItems);
        }
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String isFromDraft = (String)customParams.get("isFromDraft");
        if (ObjectUtils.isNotEmpty((Object)isFromDraft)) {
            for (FilterColumn column : filterColumnList) {
                column.setDefaultValue(null);
            }
        }
    }

    public void filterContainerSearchClick(FilterContainerSearchClickArgs args) {
        super.filterContainerSearchClick(args);
        Map filterMap = args.getSearchClickEvent().getFilterValues();
        List customList = (List)filterMap.get("customfilter");
        if (null != customList && customList.size() > 0) {
            for (Map map : customList) {
                List fileName = (List)map.get("FieldName");
                int index = fileName.indexOf("skssqq");
                if (index == -1) continue;
                List valueList = (List)map.get("Value");
                this.getPageCache().put("skssqq", SerializationUtils.toJsonString((Object)valueList));
            }
        }
    }

    public void setFilter(SetFilterEvent e) {
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        String isFromDraft = (String)customParams.get("isFromDraft");
        if (ObjectUtils.isNotEmpty((Object)isFromDraft)) {
            e.getQFilters().clear();
            e.setMainOrgQFilter(new QFilter("1", "=", (Object)1));
            e.getQFilters().add(new QFilter("draftid", "=", customParams.get("draftid")));
        }
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("skssqq".equals(columnDesc.getKey())) {
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)new DateUtils().yyyymmddChinese());
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)new DateUtils().yyyymmddChinese());
            e.setFormatValue((Object)(skssqq + "-" + skssqz));
        }
    }

    public void beforeShowBill(BeforeShowBillFormEvent e) {
        List orgList;
        super.beforeShowBill(e);
        if ("ADDNEW".equalsIgnoreCase(e.getParameter().getBillStatus().toString()) && ObjectUtils.isNotEmpty((Object)(orgList = this.getControlFilters().getFilter("org.id"))) && orgList.size() == 1) {
            e.getParameter().getShowParameter().getCustomParams().put("orgId", orgList.get(0));
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        ListSelectedRowCollection listSelectedData = args.getListSelectedData();
        if (args.getSource() instanceof Donothing && "payrefund".equalsIgnoreCase(((Donothing)args.getSource()).getOperateKey())) {
            if (ObjectUtils.isNotEmpty((Object)listSelectedData) && listSelectedData.size() > 1) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6279\u91cf\u786e\u8ba4\u7f34/\u9000\u7a0e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"GtcpTaxPayRefundListPlugin_0", (String)"taxc-gtcp", (Object[])new Object[0]));
                args.setCancel(true);
                return;
            }
            Object[] primaryKeyValues = listSelectedData.getPrimaryKeyValues();
            DynamicObjectCollection dynamicObjectCollection = GtcpTaxPayRefundBussiness.queryTaxPayRefundByIdList(Arrays.asList(primaryKeyValues));
            if (ObjectUtils.isNotEmpty((Object)dynamicObjectCollection)) {
                DynamicObject dynamicObject = (DynamicObject)dynamicObjectCollection.get(0);
                String payrefstatus = dynamicObject.getString("payrefstatus");
                if (!"nopay".equalsIgnoreCase(payrefstatus) && !"norefund".equalsIgnoreCase(payrefstatus)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u4ec5\u72b6\u6001\u4e3a\u672a\u7f34\u7a0e/\u672a\u9000\u7a0e\u7684\u6570\u636e\u53ef\u786e\u8ba4\u7f34/\u9000\u7a0e\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\u3002", (String)"GtcpTaxPayRefundListPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                HashMap<String, Object> parameterMap = new HashMap<String, Object>(8);
                parameterMap.put("id", dynamicObject.getLong("id"));
                parameterMap.put("org", dynamicObject.getLong("org"));
                parameterMap.put("taxationsys", dynamicObject.getLong("taxationsys"));
                parameterMap.put("taxationsys.number", dynamicObject.getString("taxationsys.number"));
                parameterMap.put("taxcategory", dynamicObject.getLong("taxcategory"));
                parameterMap.put("taxcategory.number", dynamicObject.getString("taxcategory.number"));
                parameterMap.put("taxareagroup", dynamicObject.getLong("taxareagroup"));
                parameterMap.put("taxestype", dynamicObject.getString("taxestype"));
                parameterMap.put("datasouce", dynamicObject.getString("datasouce"));
                parameterMap.put("draftid.billno", dynamicObject.getString("draftid.billno"));
                parameterMap.put("draftid", dynamicObject.getString("draftid"));
                parameterMap.put("skssqz", dynamicObject.getDate("skssqz"));
                parameterMap.put("declaredate", dynamicObject.getDate("draftid.entryentity.declaredate"));
                ((Donothing)args.getSource()).getParameter().putAll(parameterMap);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        String operateKey = evt.getOperateKey();
        if ("payrefund".equalsIgnoreCase(operateKey) && evt.getOperationResult().isSuccess()) {
            Map parameterMap = ((Donothing)evt.getSource()).getParameter();
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId("gtcp_taxpay_refund_confim");
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            formShowParameter.getCustomParams().putAll(parameterMap);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "payrefund"));
            this.getView().showForm(formShowParameter);
        } else if ("unpayrefund".equalsIgnoreCase(operateKey)) {
            if (evt.getOperationResult().isSuccess() || evt.getOperationResult().getSuccessPkIds().size() > 0) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u7f34/\u9000\u7a0e\u6210\u529f\u3002", (String)"GtcpTaxPayRefundListPlugin_6", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        String fieldName = args.getFieldName();
        if ("draftid.billno".equals(fieldName) || "draftid_billno".equals(fieldName)) {
            boolean flag;
            args.setCancel(true);
            HasPermOrgResult allPermOrgs = PermissionUtils.getAllPermOrgs((IFormView)this.getView());
            boolean bl = flag = allPermOrgs.hasAllOrgPerm() || !allPermOrgs.hasAllOrgPerm() && PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"2KBDG21ABT42");
            if (flag) {
                long userId = RequestContext.get().getCurrUserId();
                BillList list = (BillList)args.getHyperLinkClickEvent().getSource();
                ListSelectedRow currentSelectedRowInfo = list.getCurrentSelectedRowInfo();
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"gtcp_taxpay_refund_bill", (String)"org,draftid", (QFilter[])new QFilter[]{new QFilter("id", "=", currentSelectedRowInfo.getPrimaryKeyValue())});
                if (dynamicObject == null) {
                    return;
                }
                long accountorgId = dynamicObject.getLong("org");
                if (!allPermOrgs.hasAllOrgPerm()) {
                    PayRefundHyperlinkParamsEnum hyperlinkParamsEnum;
                    QFilter qFilter = new QFilter("id", "=", (Object)dynamicObject.getLong("draftid"));
                    String table = "tpo_declare_main_tsd";
                    DynamicObject object = BusinessDataServiceHelper.loadSingle((String)table, (String)MetadataUtil.getAllFieldString((String)table), (QFilter[])new QFilter[]{qFilter});
                    if (object == null) {
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u60a8\u8981\u8bfb\u53d6\u7684\u7533\u62a5\u5e95\u7a3f\u4efb\u52a1\u6570\u636e\u5728\u7cfb\u7edf\u4e2d\u4e0d\u5b58\u5728\uff0c\u53ef\u80fd\u5df2\u7ecf\u88ab\u5220\u9664\u3002", (String)"GtcpTaxPayRefundListPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]));
                        return;
                    }
                    String templatetype = object.getString("templatetype.number");
                    if (EmptyCheckUtils.isEmpty((Object)templatetype)) {
                        QFilter idFilter = new QFilter("id", "=", (Object)object.getLong("id"));
                        DynamicObject queryObject = QueryServiceHelper.queryOne((String)table, (String)"templatetype", (QFilter[])new QFilter[]{idFilter});
                        templatetype = queryObject.getString("templatetype");
                    }
                    if (ObjectUtils.isEmpty((Object)(hyperlinkParamsEnum = PayRefundHyperlinkParamsEnum.getEnumByTemplateType((String)templatetype)))) {
                        return;
                    }
                    String draftPage = hyperlinkParamsEnum.getDraftNumber();
                    MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)draftPage);
                    String appid = mainEntityType.getAppId();
                    HasPermOrgResult orgs = PermissionUtils.getAllPermOrgsByUserId((String)appid, (String)draftPage, (String)"47150e89000000ac", (Long)userId);
                    boolean viewflag = orgs.getHasPermOrgs().contains(accountorgId);
                    if (!viewflag) {
                        String description = hyperlinkParamsEnum.getDraftName().getDescription();
                        this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u65e0\u201c%s\u201d\u7684\u201c\u67e5\u8be2\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GtcpTaxPayRefundListPlugin_3", (String)"taxc-gtcp", (Object[])new Object[0]), description));
                        return;
                    }
                }
                this.openDraftPageOrDeclarePage(dynamicObject);
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e0\u201c\u7a0e\u91d1\u7f34\u7eb3/\u9000\u8fd8\u5355\u201d\u7684\u201c\u67e5\u770b\u5e95\u7a3f\u201d\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GtcpTaxPayRefundListPlugin_4", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        this.getView().invokeOperation("refresh");
    }

    public static List<Long> queryBastaxTaxOrg(IFormView view) {
        DynamicObjectCollection taxOrgs;
        HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((IFormView)view);
        QFilter entryEntityFilter = new QFilter("entryentity.entry_taxationsys", "!=", (Object)1L);
        if (EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult) && !hasPermOrgResult.hasAllOrgPerm() && EmptyCheckUtils.isNotEmpty((Object)hasPermOrgResult.getHasPermOrgs())) {
            QFilter authFilter = new QFilter("id", "in", (Object)hasPermOrgResult.getHasPermOrgs());
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id,org.name as name,entryentity.entry_taxationsys as taxationsys", (QFilter[])new QFilter[]{authFilter, entryEntityFilter});
        } else {
            taxOrgs = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.id as id,org.name as name,entryentity.entry_taxationsys as taxationsys", (QFilter[])new QFilter[]{entryEntityFilter});
        }
        return taxOrgs.stream().map(m -> m.getLong("id")).distinct().collect(Collectors.toList());
    }

    private void openDraftPageOrDeclarePage(DynamicObject dynamicObject) {
        if (ObjectUtils.isEmpty((Object)dynamicObject) || ObjectUtils.isEmpty((Object)dynamicObject.getLong("draftid"))) {
            return;
        }
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getLong("draftid"), (String)MultiTableEnum.TSD001.getDeclareMainTable());
        String templatetype = object.getString("templatetype.number");
        HashMap<String, Object> customParams = new HashMap<String, Object>(4);
        customParams.put(ORGID_KEY, object.getLong("org.id"));
        customParams.put(ORGNAME_KEY, object.getString("org.name"));
        Date skssqq = object.getDate("skssqq");
        Date skssqz = object.getDate("skssqz");
        String startDate = DateUtils.format((Date)skssqq, (String)"yyyy-MM-dd");
        customParams.put("skssqq", startDate);
        customParams.put("skssqz", DateUtils.format((Date)skssqz, (String)"yyyy-MM-dd"));
        customParams.put("draftpurpose", object.getString("draftpurpose"));
        FormShowParameter param = new FormShowParameter();
        param.setCustomParams(customParams);
        PayRefundHyperlinkParamsEnum enumByTemplateType = PayRefundHyperlinkParamsEnum.getEnumByTemplateType((String)templatetype);
        if (enumByTemplateType != null) {
            param = enumByTemplateType.createGtcpFormShowParameter(object);
        }
        param.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        if ("nssb".equals(object.getString("draftpurpose"))) {
            param.setCaption(ResManager.loadKDString((String)"\u901a\u7528\u7533\u62a5\u5e95\u7a3f\u7f16\u5236", (String)"GtcpTaxPayRefundListPlugin_5", (String)"taxc-gtcp", (Object[])new Object[0]));
        }
        param.setFormId("gtcp_normal_declare");
        this.getView().showForm(param);
    }
}

