/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.payrefund;

import java.util.Calendar;
import java.util.Date;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import kd.taxc.gtcp.business.tctb.TaxPeriodBusiness;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GtcpTaxPayRefundPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit org = (BasedataEdit)this.getControl("org");
        org.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxationSys = (BasedataEdit)this.getControl("taxationsys");
        taxationSys.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxCategory = (BasedataEdit)this.getControl("taxcategory");
        taxCategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxAreaGroup = (BasedataEdit)this.getControl("taxareagroup");
        taxAreaGroup.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        List<Long> orgList = GtcpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm();
        Map customParams = this.getView().getFormShowParameter().getCustomParams();
        long orgId = 0L;
        if (ObjectUtils.isNotEmpty((Object)customParams) && ObjectUtils.isNotEmpty(customParams.get("orgId"))) {
            if (orgList.contains(Long.parseLong(customParams.get("orgId").toString()))) {
                orgId = Long.parseLong(customParams.get("orgId").toString());
            }
        } else {
            orgId = RequestContext.get().getOrgId();
        }
        if (orgList.contains(orgId)) {
            this.getModel().setValue("org", (Object)orgId);
        } else if (ObjectUtils.isNotEmpty(orgList)) {
            this.getModel().setValue("org", (Object)orgList.get(0));
        }
        this.getModel().setValue("isnew", (Object)true);
        this.initData(this.getModel().getDataEntity().getLong("org.id"));
    }

    private void initData(long orgId) {
        ImmutablePair<Date, Date> dateImmutablePair;
        List<Long> taxtypeList;
        if (ObjectUtils.isEmpty((Object)orgId)) {
            return;
        }
        List<Long> taxsystionList = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgId, TaxationsysMappingEnum.CHN.getId(), false);
        if (ObjectUtils.isEmpty(taxsystionList)) {
            return;
        }
        this.getModel().setValue("taxationsys", (Object)taxsystionList.get(0));
        this.getModel().setValue("coin", this.getModel().getDataEntity().get("taxationsys.currency.id"));
        if (!this.getModel().getDataEntity().getBoolean("coin.enable")) {
            this.getModel().setValue("coin", null);
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u5e01\u522b\u754c\u9762\u542f\u7528\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u5bf9\u5e94\u7684\u7533\u62a5\u5e01\u522b\u3002", (String)"GtcpTaxPayRefundPlugin_12", (String)"taxc-gtcp", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty(taxtypeList = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(orgId, taxsystionList.get(0))) || taxtypeList.get(0) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"GtcpTaxPayRefundPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("taxcategory", (Object)taxtypeList.get(0));
        List<Long> longs = GtcpTaxOrgCommonBusiness.queryHwsTaxAreaByOrgId(orgId, taxsystionList.get(0), taxtypeList.get(0));
        if (ObjectUtils.isEmpty(longs) || longs.get(0) == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"GtcpTaxPayRefundPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]));
            return;
        }
        this.getModel().setValue("taxareagroup", (Object)longs.get(0));
        String provisionPeriod = GtcpTaxOrgCommonBusiness.queryMinHwsTaxlimitByOrgId(orgId, this.getModel().getDataEntity().getLong("taxationsys.id"), this.getModel().getDataEntity().getLong("taxcategory.id"), this.getModel().getDataEntity().getLong("taxareagroup.id"));
        Date taxYearStartDate = this.getTaxYearStartDate(orgId, this.getModel().getDataEntity().getLong("taxationsys.id"), this.getModel().getDataEntity().getLong("taxcategory.id"));
        if (ObjectUtils.isNotEmpty((Object)provisionPeriod) && ObjectUtils.isNotEmpty((Object)taxYearStartDate) && ObjectUtils.isNotEmpty(dateImmutablePair = TaxPeriodBusiness.preTaxPeriod(provisionPeriod, taxYearStartDate))) {
            this.getModel().setValue("skssqq", dateImmutablePair.left);
            this.getModel().setValue("skssqz", dateImmutablePair.right);
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent evt) {
        String name = evt.getProperty().getName();
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"org")) {
            List<Long> longs = GtcpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm();
            QFilter qFilter = CollectionUtils.isEmpty(longs) ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", longs);
            evt.addCustomQFilter(qFilter);
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxationsys") || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxcategory") || StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxareagroup")) {
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            if (org == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"GtcpTaxPayRefundPlugin_0", (String)"taxc-gtcp", (Object[])new Object[0]));
                evt.setCancel(true);
                return;
            }
            long orgId = org.getLong("id");
            if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxationsys")) {
                List<Long> longs = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgId, TaxationsysMappingEnum.CHN.getId(), false);
                QFilter qFilter = CollectionUtils.isEmpty(longs) ? new QFilter("id", "=", (Object)0L) : new QFilter("id", "in", longs);
                evt.addCustomQFilter(qFilter);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxcategory")) {
                QFilter qFilter;
                DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
                if (taxationsys == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"GtcpTaxPayRefundPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List<Long> longs = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(orgId, taxationsys.getLong("id"));
                if (CollectionUtils.isEmpty(longs)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"GtcpTaxPayRefundPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]));
                    qFilter = new QFilter("id", "=", (Object)0L);
                } else {
                    qFilter = new QFilter("id", "in", longs);
                }
                evt.addCustomQFilter(qFilter);
            } else if (StringUtils.equalsIgnoreCase((CharSequence)name, (CharSequence)"taxareagroup")) {
                QFilter qFilter;
                long taxCategoryId;
                DynamicObject taxationsys = (DynamicObject)this.getModel().getValue("taxationsys");
                DynamicObject taxCategory = (DynamicObject)this.getModel().getValue("taxcategory");
                if (taxationsys == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"GtcpTaxPayRefundPlugin_1", (String)"taxc-gtcp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                long l = taxCategoryId = taxCategory == null ? 0L : taxCategory.getLong("id");
                if (taxCategoryId == 0L) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u79cd\u3002", (String)"GtcpTaxPayRefundPlugin_4", (String)"taxc-gtcp", (Object[])new Object[0]));
                    evt.setCancel(true);
                    return;
                }
                List<Long> longs = GtcpTaxOrgCommonBusiness.queryHwsTaxAreaByOrgId(orgId, taxationsys.getLong("id"), taxCategoryId);
                if (CollectionUtils.isEmpty(longs)) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u4e2d\u7ef4\u62a4\u81f3\u5c11\u4e00\u6761\u542f\u7528\u7684\u6570\u636e\u3002", (String)"GtcpTaxPayRefundPlugin_2", (String)"taxc-gtcp", (Object[])new Object[0]));
                    qFilter = new QFilter("id", "=", (Object)0L);
                } else {
                    qFilter = new QFilter("id", "in", longs);
                }
                evt.addCustomQFilter(qFilter);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        List<Long> taxCategories;
        List<Long> sysByBasTaxOrg;
        List<Long> suitableOrgIds;
        String appId = this.getView().getFormShowParameter().getFormConfig().getAppId();
        ChangeData[] changeData = e.getChangeSet();
        if (appId == null || changeData == null || changeData.length == 0) {
            return;
        }
        String name = e.getProperty().getName();
        Object newValue = changeData[0].getNewValue();
        if (newValue == null && null != changeData[0].getOldValue()) {
            this.getModel().setValue(name, changeData[0].getOldValue());
            return;
        }
        DynamicObject org = this.getModel().getDataEntity().getDynamicObject("org");
        DynamicObject taxationSys = this.getModel().getDataEntity().getDynamicObject("taxationsys");
        DynamicObject taxType = this.getModel().getDataEntity().getDynamicObject("taxcategory");
        DynamicObject taxAreaGroup = this.getModel().getDataEntity().getDynamicObject("taxareagroup");
        Date startDate = this.getModel().getDataEntity().getDate("skssqq");
        Date endDate = this.getModel().getDataEntity().getDate("skssqz");
        if (ObjectUtils.isNotEmpty((Object)startDate) && ObjectUtils.isNotEmpty((Object)endDate)) {
            this.getView().getPageCache().put("skssqq", DateUtils.format((Date)startDate));
            this.getView().getPageCache().put("skssqz", DateUtils.format((Date)endDate));
        }
        long orgId = org == null ? 0L : org.getLong("id");
        long taxationSysId = taxationSys == null ? 0L : taxationSys.getLong("id");
        long taxTypeId = taxType == null ? 0L : taxType.getLong("id");
        long taxAreaGroupId = taxAreaGroup == null ? 0L : taxAreaGroup.getLong("id");
        List<Long> sysTaxAreaIds = GtcpTaxOrgCommonBusiness.queryHwsTaxAreaByOrgId(orgId, taxationSysId, taxTypeId);
        if ("org".equalsIgnoreCase(name)) {
            this.getModel().getDataEntity().set("taxationsys", null);
            this.getModel().getDataEntity().set("taxcategory", null);
            this.getModel().getDataEntity().set("taxareagroup", null);
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            this.getView().updateView("taxationsys");
            this.getView().updateView("taxcategory");
            this.getView().updateView("taxareagroup");
            taxationSysId = 0L;
            taxTypeId = 0L;
            taxAreaGroupId = 0L;
        } else if ("taxationsys".equalsIgnoreCase(name)) {
            this.getPageCache().put("taxationsys", String.valueOf(taxationSysId));
            this.getModel().getDataEntity().set("taxcategory", null);
            this.getModel().getDataEntity().set("taxareagroup", null);
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getModel().setValue("coin", (Object)this.getModel().getDataEntity().getLong("taxationsys.currency.id"));
            if (!this.getModel().getDataEntity().getBoolean("coin.enable")) {
                this.getModel().getDataEntity().set("coin", null);
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u524d\u5f80\u5e01\u522b\u754c\u9762\u542f\u7528\u6240\u9009\u7a0e\u6536\u5236\u5ea6\u5bf9\u5e94\u7684\u7533\u62a5\u5e01\u522b\u3002", (String)"GtcpTaxPayRefundPlugin_12", (String)"taxc-gtcp", (Object[])new Object[0]));
            }
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            this.getView().updateView("coin");
            this.getView().updateView("taxcategory");
            this.getView().updateView("taxareagroup");
            taxTypeId = 0L;
            taxAreaGroupId = 0L;
        } else if ("taxcategory".equalsIgnoreCase(name)) {
            this.getPageCache().put("taxcategory", Long.toString(taxTypeId));
            this.getModel().getDataEntity().set("taxareagroup", null);
            this.getModel().getDataEntity().set("skssqq", null);
            this.getModel().getDataEntity().set("skssqz", null);
            this.getView().updateView("skssqq");
            this.getView().updateView("skssqz");
            this.getView().updateView("taxareagroup");
            taxAreaGroupId = 0L;
        } else if ("taxareagroup".equalsIgnoreCase(name)) {
            this.getPageCache().put("taxareagroup", Long.toString(taxAreaGroupId));
        } else if ("skssqq".equalsIgnoreCase(name) || "skssqz".equalsIgnoreCase(name)) {
            Date skssqq = this.getModel().getDataEntity().getDate("skssqq");
            Date skssqz = this.getModel().getDataEntity().getDate("skssqz");
            if (ObjectUtils.isNotEmpty((Object)skssqq) && ObjectUtils.isNotEmpty((Object)skssqz)) {
                Date newStartDate = this.getTaxYearStartDate(orgId, taxationSysId, taxTypeId);
                if (newStartDate == null) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7eb3\u7a0e\u671f\u95f4\u3002", (String)"GtcpTaxPayRefundPlugin_6", (String)"taxc-gtcp", (Object[])new Object[0]));
                    return;
                }
                String provisionPeriod = GtcpTaxOrgCommonBusiness.queryDefaultTaxPeriod(orgId, taxationSysId, taxTypeId);
                if (StringUtils.isEmpty((CharSequence)provisionPeriod)) {
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7f34\u7eb3\u671f\u9650\u3002", (String)"GtcpTaxPayRefundPlugin_7", (String)"taxc-gtcp", (Object[])new Object[0]));
                    return;
                }
                ImmutablePair<Date, Date> dateImmutablePair = this.calDate(newStartDate, skssqq, skssqz);
                if (dateImmutablePair == null) {
                    // empty if block
                }
            }
        }
        if (orgId != 0L && !(suitableOrgIds = GtcpTaxOrgCommonBusiness.queryTaxcOrgIdByIsTaxpayerWithPerm()).contains(orgId)) {
            String msg = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7%s\u4e0d\u53ef\u7528\u6216\u65e0\u6743\u9650\u3002", (String)"GtcpTaxPayRefundPlugin_8", (String)"taxc-gtcp", (Object[])new Object[0]), org.getString("number"));
            this.getView().showErrorNotification(msg);
            return;
        }
        if (taxationSysId != 0L && !(sysByBasTaxOrg = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgId, TaxationsysMappingEnum.CHN.getId(), false)).contains(taxationSysId)) {
            return;
        }
        if (taxTypeId != 0L && !(taxCategories = GtcpTaxOrgCommonBusiness.queryHwsCategoryByOrgId(orgId, taxationSysId)).contains(taxTypeId)) {
            return;
        }
        if (taxAreaGroupId != 0L && (CollectionUtils.isEmpty(sysTaxAreaIds) || !sysTaxAreaIds.contains(taxAreaGroupId))) {
            return;
        }
    }

    private ImmutablePair<Date, Date> calDate(Date taxYearStartDate, Date modelStartDate, Date modelEndDate) {
        if (taxYearStartDate == null || modelStartDate == null || modelEndDate == null) {
            return null;
        }
        int monthInt = 1 - DateUtils.getMonthOfDate((Date)taxYearStartDate);
        int dataInt = 1 - DateUtils.getDayOfDate((Date)taxYearStartDate);
        Date offSetStartDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)modelStartDate, (int)monthInt), (int)dataInt);
        Integer monthBetweenInOneYear = GtcpTaxPayRefundPlugin.getMonthBetweenInOneYear(modelStartDate, modelEndDate);
        if (monthBetweenInOneYear != null) {
            Date offSetEndDate = DateUtils.addDay((Date)DateUtils.addMonth((Date)offSetStartDate, (int)monthBetweenInOneYear), (int)-1);
            return ImmutablePair.of((Object)offSetStartDate, (Object)offSetEndDate);
        }
        return null;
    }

    public static Integer getMonthBetweenInOneYear(Date minDate, Date maxDate) {
        int result;
        if (minDate == null || maxDate == null || maxDate.compareTo(minDate) <= 0) {
            return null;
        }
        Calendar min = Calendar.getInstance();
        Calendar max = Calendar.getInstance();
        min.setTime(minDate);
        max.setTime(maxDate);
        for (result = 0; min.before(max) && result < 12; ++result) {
            min.add(2, 1);
        }
        min.add(5, -1);
        if (result <= 12 && min.equals(max)) {
            return result;
        }
        return null;
    }

    protected Date getTaxYearStartDate(Long orgId, Long taxSysId, Long taxTypeId) {
        return TaxPeriodBusiness.getTaxPeriodStartDate(orgId, taxSysId, taxTypeId);
    }
}

