/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.sharedplan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.RowMetaFactory;
import kd.bos.algo.input.CollectionInput;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.validate.ValidateResult;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.StyleCss;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Search;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.SelectRowsEvent;
import kd.bos.form.control.events.SelectRowsEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.formop.DeleteEntry;
import kd.bos.form.operate.formop.NewEntry;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.taxc.bdtaxr.common.db.DynamicObjectCollectionUtil;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.gtcp.business.taxorg.GtcpCombineBusiness;
import org.apache.commons.collections.CollectionUtils;

public class SharingPlanPlugin
extends AbstractFormPlugin
implements SelectRowsEventListener,
BeforeF7SelectListener,
SearchEnterListener {
    private static final Log LOGGER = LogFactory.getLog(SharingPlanPlugin.class);
    private static final String SYSTEM_TYPE = "taxc-gtcp";
    private static final String REFRESH = "refresh";
    private static final String IMPORTDATA = "importdata";
    private static final String EXPORTDATA = "exportdata";
    private static final String SAVE = "save_sharding";
    private static final String INDEX = "index";
    private static final String NUMBER = "number";
    private static final String NAME = "name";
    private static final String TAXATIONSYS = "taxationsys";
    private static final String TAXCATEGORY = "taxcategory";
    private static final String TAXAREAGROUP = "taxareagroup";
    private static final String ORG = "org";
    private static final String RULE = "rule";
    private static final String PLANENTITY = "planentity";
    private static final String RULEENTITY = "ruleentity";
    private static final String ORGENTITY = "orgentity";
    private static final String OPT_PLANADD = "planadd";
    private static final String OPT_PLANDEL = "plandel";
    private static final String NEWROW = "newRow";
    private static final String OLDROW = "oldRow";
    private static final String ITEM_CLOSE = "bar_close";
    private static final String CARDSWITCH = "cardSwitch";
    private static final String SEARCHAP = "searchap";
    private static final Map<String, String> MAP;
    private static final String[] FIELD_NAMES;
    private static final String CARD_TAXATIONSYS_ID = "cardtaxationsys.id";
    private static final String CARD_TAXCATEGORY_ID = "cardtaxcategory.id";
    private static final String GTCP_SHARDINGPLAN = "gtcp_shardingplan";

    public void registerListener(EventObject e) {
        this.addClickListeners(new String[]{"labelcreate"});
        Toolbar toolbarMain = (Toolbar)this.getControl("toolbarap");
        toolbarMain.addItemClickListener((ItemClickListener)this);
        OrgEdit taxOrgEdit = (OrgEdit)this.getControl(ORG);
        taxOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit ruleEdit = (BasedataEdit)this.getControl(RULE);
        ruleEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit taxcategory = (BasedataEdit)this.getControl(TAXCATEGORY);
        taxcategory.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        Search search = (Search)this.getControl(SEARCHAP);
        search.addEnterListener((SearchEnterListener)this);
        search.addClickListener((ClickListener)this);
    }

    public void initialize() {
        CardEntry planentity = (CardEntry)this.getControl(PLANENTITY);
        planentity.addSelectRowsListener((SelectRowsEventListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getPageCache().put("init", "true");
        this.loadFormData();
        this.checkPermission();
    }

    public void afterBindData(EventObject e) {
        String delete = this.getPageCache().get("delete");
        if (ObjectUtils.isEmpty((Object)delete)) {
            this.selectListRow(0);
        } else if (Boolean.TRUE.toString().equalsIgnoreCase(delete)) {
            String deleteAfterSelectRow = this.getPageCache().get("deleteAfterSelectRow");
            this.selectListRow(Integer.parseInt(deleteAfterSelectRow));
            this.getPageCache().put("delete", null);
        }
        this.setVisible();
    }

    public void search(SearchEnterEvent event) {
        String searchText = event.getText();
        String currentSearch = this.getPageCache().get("currentSearch");
        if (StringUtils.equalsIgnoreCase((CharSequence)currentSearch, (CharSequence)searchText)) {
            this.selectListRowAndPutCache();
        } else {
            this.generateCardIndexs(searchText);
            this.selectListRowAndPutCache();
        }
    }

    private void generateCardIndexs(String searchText) {
        this.getPageCache().put("currentSearch", searchText);
        ArrayList<Integer> list = new ArrayList<Integer>();
        HashMap map = new HashMap();
        String text = "%" + searchText + "%";
        QFilter nameQ = new QFilter(NAME, "like", (Object)text);
        QFilter numberQ = new QFilter(NUMBER, "like", (Object)text);
        DataSet dataSet = this.buildDataSet();
        DataSet tempDataSet = dataSet.filter(nameQ.or(numberQ).toString());
        for (Row row : tempDataSet) {
            list.add(row.getInteger(INDEX));
        }
        tempDataSet.close();
        Collections.sort(list);
        Stream.iterate(0, i -> i + 1).limit(list.size()).forEach(i -> {
            Integer cfr_ignored_0 = (Integer)map.put(String.valueOf(i), list.get((int)i));
        });
        this.getPageCache().put("cardIndexs", SerializationUtils.toJsonString(map));
        if (!map.isEmpty()) {
            this.getPageCache().put("focusCardIndex", "-1");
        }
    }

    public List<String> getSearchList(SearchEnterEvent evt) {
        String searchText = evt.getText();
        this.generateCardIndexs(searchText);
        return this.filterDataSet(searchText);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        boolean isF7;
        String key = e.getProperty().getName();
        Object newValue = e.getChangeSet()[0].getNewValue();
        boolean bl = isF7 = TAXATIONSYS.equalsIgnoreCase(key) || TAXCATEGORY.equalsIgnoreCase(key) || TAXAREAGROUP.equalsIgnoreCase(key);
        if (MAP.containsKey(key)) {
            int selectRow = this.getSelectRows();
            if (isF7) {
                DynamicObject newValueDyo = (DynamicObject)e.getChangeSet()[0].getNewValue();
                Object id = newValueDyo == null ? null : newValueDyo.get("id");
                this.getModel().setValue(MAP.get(key), id, selectRow);
            } else if (selectRow >= 0) {
                if (newValue instanceof LocaleDynamicObjectCollection) {
                    this.getModel().setValue(MAP.get(key), (Object)this.getLangValue(newValue), selectRow);
                } else {
                    this.getModel().setValue(MAP.get(key), newValue, selectRow);
                }
            }
        }
        HashSet ids = new HashSet();
        if (isF7) {
            DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
            DynamicObject newRowObject = (DynamicObject)collection.get(this.getSelectRows());
            DynamicObjectCollection ruleCol = newRowObject.getDynamicObjectCollection(RULEENTITY);
            ruleCol.stream().filter(ruleRow -> ruleRow.getString("rule.id") != null).forEach(ruleRow -> ids.add(ruleRow.getString("rule.id")));
            String oldValueKey = "old-" + key;
            String changeKey = key + "_change";
            if (StringUtils.equalsIgnoreCase((CharSequence)this.getPageCache().get(NEWROW), (CharSequence)this.getPageCache().get(OLDROW))) {
                if (CollectionUtils.isNotEmpty(ids)) {
                    String oldTaxSysId;
                    DynamicObject oldValue = (DynamicObject)e.getChangeSet()[0].getOldValue();
                    String string = oldTaxSysId = oldValue == null ? null : oldValue.getString("id");
                    if (!Boolean.TRUE.toString().equals(this.getPageCache().get(changeKey))) {
                        this.getPageCache().put(oldValueKey, oldTaxSysId);
                        String mainDesc = TAXATIONSYS.equalsIgnoreCase(key) ? ResManager.loadKDString((String)"\u4fee\u6539\u7a0e\u6536\u5236\u5ea6\uff0c\u5c06\u4f1a\u6e05\u7a7a\u7a0e\u79cd\uff0c\u5171\u4eab\u89c4\u5219\u4e0e\u5171\u4eab\u7ec4\u7ec7\uff0c\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"SharingPlanPlugin_15", (String)SYSTEM_TYPE, (Object[])new Object[0]) : (TAXCATEGORY.equalsIgnoreCase(key) ? ResManager.loadKDString((String)"\u4fee\u6539\u7a0e\u79cd\uff0c\u5c06\u4f1a\u6e05\u7a7a\u5171\u4eab\u89c4\u5219\u4e0e\u5171\u4eab\u7ec4\u7ec7\uff0c\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"SharingPlanPlugin_1", (String)SYSTEM_TYPE, (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4fee\u6539\u7a0e\u6536\u533a\u57df\uff0c\u5c06\u4f1a\u6e05\u7a7a\u5171\u4eab\u89c4\u5219\u4e0e\u5171\u4eab\u7ec4\u7ec7\uff0c\u786e\u5b9a\u8981\u4fee\u6539\u5417\uff1f", (String)"SharingPlanPlugin_2", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                        this.showMsg(mainDesc, key);
                    } else {
                        this.getPageCache().remove(oldValueKey);
                        this.getPageCache().put(changeKey, Boolean.FALSE.toString());
                    }
                } else if (TAXATIONSYS.equalsIgnoreCase(key)) {
                    this.getModel().setValue(TAXCATEGORY, null);
                    this.getModel().setValue(TAXAREAGROUP, null);
                }
            }
        }
    }

    private void showMsg(String mainDesc, String callBackId) {
        String leftDesc = ResManager.loadKDString((String)"\u53d6\u6d88", (String)"SharingPlanPlugin_3", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        String rightDesc = ResManager.loadKDString((String)"\u786e\u8ba4\u6e05\u7a7a", (String)"SharingPlanPlugin_4", (String)SYSTEM_TYPE, (Object[])new Object[0]);
        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(callBackId, (IFormPlugin)this);
        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
        btnNameMaps.put(MessageBoxResult.No.getValue(), leftDesc);
        btnNameMaps.put(MessageBoxResult.Yes.getValue(), rightDesc);
        MessageBoxOptions options = MessageBoxOptions.YesNo;
        this.getView().showConfirm(mainDesc, "", options, ConfirmTypes.Save, confirmCallBacks, btnNameMaps);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        DynamicObject taxationsys = (DynamicObject)this.getModel().getValue(TAXATIONSYS);
        if (TAXCATEGORY.equalsIgnoreCase(key)) {
            if (taxationsys == null) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u7a0e\u6536\u5236\u5ea6\u3002", (String)"SharingPlanPlugin_16", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            QFilter qFilter = new QFilter("taxationsysid", "=", taxationsys.get("id"));
            beforeF7SelectEvent.addCustomQFilter(qFilter);
            return;
        }
        DynamicObject taxcategory = (DynamicObject)this.getModel().getValue(TAXCATEGORY);
        DynamicObject taxareagroup = (DynamicObject)this.getModel().getValue(TAXAREAGROUP);
        if (taxationsys == null) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u5236\u5ea6\u3002", (String)"SharingPlanPlugin_5", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        if (taxcategory == null) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u7a0e\u79cd\u3002", (String)"SharingPlanPlugin_6", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        if (taxareagroup == null) {
            beforeF7SelectEvent.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u6536\u8f96\u533a\u3002", (String)"SharingPlanPlugin_7", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            return;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)ORG)) {
            this.setOrgFilter(beforeF7SelectEvent, taxationsys, taxcategory, taxareagroup);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)beforeF7SelectEvent.getProperty().getName(), (CharSequence)RULE)) {
            this.setRuleFilter(beforeF7SelectEvent, taxationsys, taxcategory, taxareagroup);
        }
    }

    private void setOrgFilter(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObject taxationSys, DynamicObject taxCategory, DynamicObject taxAreaGroup) {
        List<Long> permOrgs = GtcpCombineBusiness.getAllTaxOrgs(this.getView());
        if (ObjectUtils.isEmpty(permOrgs)) {
            QFilter filter = new QFilter("id", "=", (Object)0L);
            beforeF7SelectEvent.getCustomQFilters().add(filter);
            return;
        }
        List<Long> orgs = permOrgs;
        HashSet ids = new HashSet();
        DynamicObjectCollection allPlan = this.getModel().getEntryEntity(PLANENTITY);
        long taxareagroupid = taxAreaGroup == null ? 0L : taxAreaGroup.getLong("id");
        List<DynamicObject> filterAllPlan = allPlan.stream().filter(m -> {
            long cardtaxareagroup;
            if (m.getLong(CARD_TAXATIONSYS_ID) != taxationSys.getLong("id")) {
                return false;
            }
            if (m.getLong(CARD_TAXCATEGORY_ID) != taxCategory.getLong("id")) {
                return false;
            }
            long l = cardtaxareagroup = m.get("cardtaxareagroup") == null ? 0L : m.getLong("cardtaxareagroup.id");
            if (cardtaxareagroup != taxareagroupid) {
                return false;
            }
            return cardtaxareagroup == 0L && taxareagroupid == 0L;
        }).collect(Collectors.toList());
        filterAllPlan.forEach(plan -> ids.addAll(DynamicObjectCollectionUtil.getPkValueSet((DynamicObjectCollection)plan.getDynamicObjectCollection(ORGENTITY), (String)"org.id")));
        DynamicObjectCollection orgList = this.getModel().getEntryEntity(ORGENTITY);
        if (CollectionUtils.isNotEmpty((Collection)orgList)) {
            Set orgIds = orgList.stream().map(m -> m.getLong("org.id")).collect(Collectors.toSet());
            ids.addAll(orgIds);
        }
        if (CollectionUtils.isNotEmpty(ids)) {
            QFilter notInOrgFilter = new QFilter("id", "not in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(notInOrgFilter);
        }
        QFilter inOrgFilter = new QFilter("id", "in", orgs);
        beforeF7SelectEvent.getCustomQFilters().add(inOrgFilter);
    }

    private void setRuleFilter(BeforeF7SelectEvent beforeF7SelectEvent, DynamicObject taxationsys, DynamicObject taxcategory, DynamicObject taxareagroup) {
        Set accessprojectIds;
        DynamicObjectCollection rules = this.getModel().getEntryEntity(RULEENTITY);
        Set ids = rules.stream().filter(object -> object.getPkValue() != null && object.getDynamicObject(RULE) != null).map(o -> o.getDynamicObject(RULE).get("id")).collect(Collectors.toSet());
        if (CollectionUtils.isNotEmpty(ids)) {
            QFilter notInOrgFilter = new QFilter("id", "not in", ids);
            beforeF7SelectEvent.getCustomQFilters().add(notInOrgFilter);
        }
        if (CollectionUtils.isNotEmpty(accessprojectIds = rules.stream().filter(object -> object.getPkValue() != null && object.getDynamicObject(RULE) != null).map(o -> o.getDynamicObject(RULE).get("accessproject.id")).collect(Collectors.toSet()))) {
            QFilter accessprojectFilter = new QFilter("accessproject", "not in", accessprojectIds);
            beforeF7SelectEvent.getCustomQFilters().add(accessprojectFilter);
        }
        QFilter taxationsysFilter = new QFilter(TAXATIONSYS, "=", taxationsys.get("id"));
        QFilter taxcategoryFilter = new QFilter(TAXCATEGORY, "=", taxcategory.get("id"));
        QFilter taxareagroupFilter = new QFilter(TAXAREAGROUP, "=", taxareagroup.get("id"));
        beforeF7SelectEvent.getCustomQFilters().add(taxareagroupFilter);
        beforeF7SelectEvent.addCustomQFilter(taxationsysFilter);
        beforeF7SelectEvent.addCustomQFilter(taxcategoryFilter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        Object source = args.getSource();
        if (source instanceof NewEntry && StringUtils.equalsIgnoreCase((CharSequence)((NewEntry)source).getOperateKey(), (CharSequence)OPT_PLANADD) && this.checkChangeData(this.getSelectRows())) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u8bf7\u5148\u4fdd\u5b58\u540e\u518d\u65b0\u589e\u5171\u4eab\u65b9\u6848\u3002", (String)"SharingPlanPlugin_8", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            args.setCancel(true);
        } else if (source instanceof DeleteEntry && StringUtils.equalsIgnoreCase((CharSequence)((DeleteEntry)source).getOperateKey(), (CharSequence)OPT_PLANDEL)) {
            DynamicObject row = (DynamicObject)this.getModel().getEntryEntity(PLANENTITY).get(this.getSelectRows());
            long planId = row.getLong("id");
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)planId, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)GTCP_SHARDINGPLAN));
            OperationResult result = OperationServiceHelper.executeOperate((String)"delete", (String)GTCP_SHARDINGPLAN, (DynamicObject[])new DynamicObject[]{dynamicObject}, (OperateOption)OperateOption.create());
            if (result.isSuccess()) {
                int i = row.getInt(1) - 1;
                int entryCount = this.getModel().getEntryRowCount(PLANENTITY);
                if (entryCount == 0 || row.getInt(1) + 1 > entryCount) {
                    i = 0;
                }
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5220\u9664\u6210\u529f\u3002", (String)"SharingPlanPlugin_20", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
                this.getPageCache().put("delete", "true");
                this.getPageCache().put("deleteAfterSelectRow", String.valueOf(i));
            } else {
                List errors = result.getAllErrorInfo();
                List vas = result.getValidateResult().getValidateErrors();
                StringBuilder error = new StringBuilder(result.getMessage());
                for (OperateErrorInfo opError : errors) {
                    error.append(opError.getMessage());
                }
                for (ValidateResult va : vas) {
                    for (OperateErrorInfo operr : va.getAllErrorInfo()) {
                        error.append(operr.getMessage());
                    }
                }
                this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u5220\u9664\u5931\u8d25\uff1a%1$s\u3002", (String)"SharingPlanPlugin_18", (String)SYSTEM_TYPE, (Object[])new Object[0]), error));
                args.setCancel(true);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        this.setVisible();
        String operateKey = afterDoOperationEventArgs.getOperateKey();
        int selectRow = this.getSelectRows();
        if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OPT_PLANADD)) {
            this.selectListRow(selectRow);
            String number = this.getCodeRuleNumber();
            this.getModel().setValue(NUMBER, (Object)number, selectRow);
            this.getModel().setValue(MAP.get(NAME), null, selectRow);
            this.getModel().setValue(MAP.get(NUMBER), (Object)number, selectRow);
            this.getModel().setValue(MAP.get(TAXATIONSYS), null, selectRow);
            this.getModel().setValue(MAP.get(TAXCATEGORY), null, selectRow);
            this.getModel().setValue(MAP.get(TAXAREAGROUP), null, selectRow);
            this.getModel().setEntryCurrentRowIndex(PLANENTITY, selectRow);
            this.getModel().createNewEntryRow(RULEENTITY);
            this.getModel().createNewEntryRow(ORGENTITY);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)OPT_PLANDEL)) {
            this.getView().invokeOperation(REFRESH);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)operateKey, (CharSequence)SAVE)) {
            OperationResult result = afterDoOperationEventArgs.getOperationResult();
            int select = this.getSelectRows();
            if (result.isSuccess()) {
                this.save();
                this.selectListRow(select);
            }
        }
    }

    public void selectRowsChange(SelectRowsEvent evt) {
        List newRows = evt.getNewRows();
        List oldRows = evt.getOldRows();
        if (newRows != null && !newRows.isEmpty()) {
            Integer newRowIndex = (Integer)newRows.get(0);
            Integer oldRowIndex = (Integer)oldRows.get(0);
            if (this.checkChangeData((Integer)evt.getOldRows().get(0)) && !newRowIndex.equals(oldRowIndex)) {
                ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(CARDSWITCH, (IFormPlugin)this);
                HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
                btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingPlanPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingPlanPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
                MessageBoxOptions options = MessageBoxOptions.YesNo;
                String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingPlanPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
                this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
                this.getPageCache().put(NEWROW, String.valueOf(newRowIndex));
                this.getPageCache().put(OLDROW, String.valueOf(oldRowIndex));
                return;
            }
            this.getPageCache().put(NEWROW, String.valueOf(newRowIndex));
            this.getPageCache().put(OLDROW, newRowIndex.equals(oldRowIndex) ? String.valueOf(this.getPageCache().get(OLDROW)) : String.valueOf(oldRowIndex));
            this.resetPlanName(newRowIndex);
            this.getPageCache().put(OLDROW, String.valueOf(newRowIndex));
        }
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        if (StringUtils.equalsIgnoreCase((CharSequence)evt.getItemKey(), (CharSequence)ITEM_CLOSE) && this.checkChangeData(this.getSelectRows())) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(ITEM_CLOSE, (IFormPlugin)this);
            HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>(2);
            btnNameMaps.put(MessageBoxResult.No.getValue(), ResManager.loadKDString((String)"\u8fd4\u56de\u7f16\u8f91", (String)"SharingPlanPlugin_9", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u76f4\u63a5\u9000\u51fa", (String)"SharingPlanPlugin_10", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            MessageBoxOptions options = MessageBoxOptions.YesNo;
            String msg = ResManager.loadKDString((String)"\u68c0\u6d4b\u5230\u60a8\u6709\u66f4\u6539\u5185\u5bb9\uff0c\u662f\u5426\u4e0d\u4fdd\u5b58\u76f4\u63a5\u9000\u51fa\uff1f\r\n\u82e5\u4e0d\u4fdd\u5b58\uff0c\u5c06\u4e22\u5931\u8fd9\u4e9b\u66f4\u6539\u3002", (String)"SharingPlanPlugin_11", (String)SYSTEM_TYPE, (Object[])new Object[0]);
            this.getView().showConfirm(msg, "", options, ConfirmTypes.Default, confirmCallBacks, btnNameMaps);
        }
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)REFRESH)) {
            this.getView().invokeOperation(REFRESH);
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)IMPORTDATA)) {
            this.importData(this.getView().getFormShowParameter().getFormConfig().getCaption().getLocaleValue());
        } else if (StringUtils.equalsIgnoreCase((CharSequence)itemKey, (CharSequence)EXPORTDATA)) {
            this.showExportDataForm();
        }
    }

    private boolean checkChangeData(int row) {
        boolean change = false;
        DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
        if (collection.isEmpty()) {
            return false;
        }
        DynamicObject newRowObject = (DynamicObject)collection.get(row);
        DynamicObject planRow = BusinessDataServiceHelper.loadSingle((String)GTCP_SHARDINGPLAN, (String)"id,number,name,creator,createtime,ruleentity,ruleentity.rule,ruleentity.id,orgentity,orgentity.org,orgentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)newRowObject.getLong("id"))});
        if (ObjectUtils.isEmpty((Object)planRow)) {
            change = true;
        } else {
            List ruleEntityList = planRow.getDynamicObjectCollection(RULEENTITY).stream().map(o -> o.getString("rule.id")).collect(Collectors.toList());
            List orgEntityList = planRow.getDynamicObjectCollection(ORGENTITY).stream().map(o -> o.getString("org.id")).collect(Collectors.toList());
            List<String> planEntity = Arrays.asList(planRow.getString(NUMBER), planRow.getString(NAME));
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = newRowObject.getDynamicObjectCollection(RULEENTITY);
            ruleCol.forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = newRowObject.getDynamicObjectCollection(ORGENTITY);
            orgCol.forEach(orgRow -> orgList.add(orgRow.getString("org.id")));
            List<String> plan = Arrays.asList(newRowObject.getString(MAP.get(NUMBER)), newRowObject.getString(MAP.get(NAME)));
            if (!(CollectionUtils.isEqualCollection(plan, planEntity) && CollectionUtils.isEqualCollection(ruleList, ruleEntityList) && CollectionUtils.isEqualCollection(orgList, orgEntityList))) {
                change = true;
            }
        }
        return change;
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String fieldKey = messageBoxClosedEvent.getCallBackId();
        if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)ITEM_CLOSE)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                this.getView().close();
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)fieldKey, (CharSequence)CARDSWITCH)) {
            if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
                String number;
                DynamicObject dynamicObject;
                String oldRow = this.getPageCache().get(OLDROW);
                DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
                DynamicObject oldObject = (DynamicObject)collection.get(Integer.parseInt(oldRow));
                DynamicObject planRow = BusinessDataServiceHelper.loadSingle((String)GTCP_SHARDINGPLAN, (String)"id,number,name,taxationsys,taxcategory,taxareagroup,creator,createtime,ruleentity,ruleentity.rule,ruleentity.id,ruleentity.rule.accessproject,orgentity,orgentity.org,orgentity.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)oldObject.getLong("id"))});
                if (null != planRow) {
                    List<String> ruleList = planRow.getDynamicObjectCollection(RULEENTITY).stream().map(o -> o.getString("rule.id")).collect(Collectors.toList());
                    List<String> orgList = planRow.getDynamicObjectCollection(ORGENTITY).stream().map(o -> o.getString("org.id")).collect(Collectors.toList());
                    oldObject.set(MAP.get(NUMBER), (Object)planRow.getString(NUMBER));
                    oldObject.set(MAP.get(NAME), (Object)planRow.getString(NAME));
                    String oid = planRow.getString("id");
                    DynamicObject dynamicObject2 = BusinessDataServiceHelper.loadSingle((Object)Long.valueOf(oid), (String)GTCP_SHARDINGPLAN);
                    oldObject.set(MAP.get(TAXATIONSYS), (Object)dynamicObject2.getDynamicObject(TAXATIONSYS));
                    oldObject.set(MAP.get(TAXCATEGORY), (Object)dynamicObject2.getDynamicObject(TAXCATEGORY));
                    oldObject.set(MAP.get(TAXAREAGROUP), (Object)dynamicObject2.getDynamicObject(TAXAREAGROUP));
                    this.getModel().setEntryCurrentRowIndex(PLANENTITY, Integer.parseInt(oldRow));
                    this.getModel().deleteEntryData(RULEENTITY);
                    ruleList.forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow(RULEENTITY);
                        this.getModel().setValue(RULE, (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getModel().deleteEntryData(ORGENTITY);
                    orgList.forEach(o -> {
                        int subRowIndex = this.getModel().createNewEntryRow(ORGENTITY);
                        this.getModel().setValue(ORG, (Object)Long.valueOf(o), subRowIndex);
                    });
                    this.getView().updateView(PLANENTITY);
                }
                if ((dynamicObject = BusinessDataServiceHelper.loadSingle((String)GTCP_SHARDINGPLAN, (String)"id", (QFilter[])new QFilter[]{new QFilter(NUMBER, "=", (Object)(number = this.getModel().getDataEntity().getString(NUMBER)))})) == null) {
                    this.getModel().deleteEntryRow(PLANENTITY, Integer.parseInt(oldRow));
                }
                this.selectListRow(Integer.parseInt(this.getPageCache().get(NEWROW)));
            } else {
                this.selectListRow(Integer.parseInt(this.getPageCache().get(OLDROW)));
            }
        } else if (TAXATIONSYS.equalsIgnoreCase(fieldKey) || TAXCATEGORY.equalsIgnoreCase(fieldKey) || TAXAREAGROUP.equalsIgnoreCase(fieldKey)) {
            String oldValueKey = "old-" + fieldKey;
            String changeKey = fieldKey + "_change";
            if (messageBoxClosedEvent.getResult().equals((Object)MessageBoxResult.Yes)) {
                this.getModel().deleteEntryData(RULEENTITY);
                this.getModel().createNewEntryRow(RULEENTITY);
                this.getModel().deleteEntryData(ORGENTITY);
                this.getModel().createNewEntryRow(ORGENTITY);
                this.getPageCache().put("init", "false");
                this.getPageCache().put(changeKey, "false");
                if (TAXATIONSYS.equalsIgnoreCase(fieldKey)) {
                    this.getModel().setValue(TAXCATEGORY, null);
                    this.getModel().setValue(TAXAREAGROUP, null);
                }
            } else {
                String oldTaxSys = this.getPageCache().get(oldValueKey);
                this.getPageCache().put(changeKey, "true");
                this.getModel().setValue(fieldKey, (Object)Long.parseLong(oldTaxSys));
            }
        }
    }

    private void resetPlanName(Integer startRowIndex) {
        DynamicObject[] planentities;
        if (-1 == startRowIndex) {
            startRowIndex = 0;
        }
        if ((planentities = this.getModel().getEntryEntity(PLANENTITY, startRowIndex.intValue(), startRowIndex + 1)) != null && planentities.length > 0) {
            this.getModel().setValue(NUMBER, planentities[0].get(MAP.get(NUMBER)));
            this.getModel().setValue(NAME, planentities[0].get(MAP.get(NAME)));
            this.getModel().setValue(TAXATIONSYS, planentities[0].get(MAP.get(TAXATIONSYS)));
            this.getModel().setValue(TAXCATEGORY, planentities[0].get(MAP.get(TAXCATEGORY)));
            this.getModel().setValue(TAXAREAGROUP, planentities[0].get(MAP.get(TAXAREAGROUP)));
        } else {
            this.getModel().setValue(NUMBER, (Object)"");
            this.getModel().setValue(NAME, (Object)"");
            this.getModel().setValue(TAXATIONSYS, null);
            this.getModel().setValue(TAXCATEGORY, null);
            this.getModel().setValue(TAXAREAGROUP, null);
        }
        this.getView().updateView(NUMBER);
        this.getView().updateView(NAME);
        this.getView().updateView(TAXATIONSYS);
        this.getView().updateView(TAXCATEGORY);
        this.getView().updateView(TAXAREAGROUP);
    }

    private int getSelectRows() {
        int rowIndex = 0;
        EntryGrid planEntry = (EntryGrid)this.getControl(PLANENTITY);
        int[] ids = planEntry.getSelectRows();
        if (!ObjectUtils.isEmpty((Object)ids)) {
            rowIndex = ids[0];
        }
        return rowIndex;
    }

    private String getLangValue(Object object) {
        String value = null;
        String lang = RequestContext.get().getLang().toString();
        if (object instanceof LocaleDynamicObjectCollection) {
            LocaleDynamicObjectCollection valueCol = (LocaleDynamicObjectCollection)object;
            for (DynamicObject langObj : valueCol) {
                String localeid = langObj.getString("localeid");
                String version = langObj.getString(NAME);
                if (lang == null || !lang.equals(localeid)) continue;
                value = version;
                break;
            }
        }
        return value;
    }

    private void setVisible() {
        int row = this.getModel().getEntryRowCount(PLANENTITY);
        if (row > 0) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexdata", PLANENTITY});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"flexnodata"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"flexdata", PLANENTITY});
        }
    }

    private void selectListRow(int rowIndex) {
        CardEntry planCardEntry = (CardEntry)this.getControl(PLANENTITY);
        int entryCount = this.getModel().getEntryRowCount(PLANENTITY);
        if (entryCount == 0 || rowIndex + 1 > entryCount) {
            return;
        }
        int nowRow = this.getSelectRows();
        planCardEntry.selectCard(Integer.valueOf(rowIndex));
        planCardEntry.selectRowsChanged(Collections.singletonList(rowIndex), Collections.singletonList(nowRow));
    }

    private String getCodeRuleNumber() {
        DynamicObject dataInfo = BusinessDataServiceHelper.newDynamicObject((String)GTCP_SHARDINGPLAN);
        ICodeRuleService codeRuleService = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        return codeRuleService.readNumber(GTCP_SHARDINGPLAN, dataInfo, null);
    }

    private void loadFormData() {
        DynamicObject[] planRows = BusinessDataServiceHelper.load((String)GTCP_SHARDINGPLAN, (String)"id,number,name,taxationsys,taxcategory,taxareagroup,creator,createtime,ruleentity,ruleentity.rule,ruleentity.rule.accessproject,ruleentity.id,orgentity,orgentity.org,orgentity.id", (QFilter[])new QFilter[0], (String)"number asc");
        if (planRows.length > 0) {
            this.getModel().deleteEntryData(PLANENTITY);
            Arrays.stream(planRows).forEach(planRow -> {
                int rowIndex = this.getModel().createNewEntryRow(PLANENTITY);
                this.getModel().setValue("id", planRow.get("id"), rowIndex);
                this.getModel().setValue(MAP.get(NUMBER), planRow.get(NUMBER), rowIndex);
                this.getModel().setValue(MAP.get(NAME), planRow.get(NAME), rowIndex);
                this.getModel().setValue(MAP.get(TAXATIONSYS), planRow.get(TAXATIONSYS), rowIndex);
                this.getModel().setValue(MAP.get(TAXCATEGORY), planRow.get(TAXCATEGORY), rowIndex);
                this.getModel().setValue(MAP.get(TAXAREAGROUP), planRow.get(TAXAREAGROUP), rowIndex);
                this.getModel().setValue("creator", planRow.get("creator"), rowIndex);
                this.getModel().setValue("createtime", planRow.get("createtime"), rowIndex);
                this.getModel().setValue("modifier", (Object)RequestContext.get().getCurrUserId(), rowIndex);
                this.getModel().setValue("modifytime", (Object)new Date(), rowIndex);
                this.getModel().setEntryCurrentRowIndex(PLANENTITY, rowIndex);
                DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection(RULEENTITY);
                ruleCol.forEach(ruleRow -> {
                    int subRowIndex = this.getModel().createNewEntryRow(RULEENTITY);
                    this.getModel().setValue(RULE, ruleRow.get(RULE), subRowIndex);
                    this.getModel().setValue("accessproject", ruleRow.get("rule.accessproject"), subRowIndex);
                    this.getModel().setValue("ruleentryid", ruleRow.get("id"), subRowIndex);
                });
                DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection(ORGENTITY);
                orgCol.forEach(orgRow -> {
                    int subRowIndex = this.getModel().createNewEntryRow(ORGENTITY);
                    this.getModel().setValue(ORG, orgRow.get(ORG), subRowIndex);
                    this.getModel().setValue("orgentryid", orgRow.get("id"), subRowIndex);
                });
            });
            this.getView().updateView(RULEENTITY);
            this.getView().updateView(ORGENTITY);
        }
        this.getPageCache().put(PLANENTITY, SerializationUtils.toJsonString(this.getPlanCacheMap(planRows)));
    }

    private Map<String, Map<String, List<String>>> getPlanCacheMap(DynamicObject[] rows) {
        HashMap<String, Map<String, List<String>>> planCacheMap = new HashMap<String, Map<String, List<String>>>();
        Arrays.stream(rows).forEach(planRow -> {
            HashMap<String, List<String>> planEntityMap = new HashMap<String, List<String>>();
            ArrayList ruleList = new ArrayList();
            ArrayList orgList = new ArrayList();
            DynamicObjectCollection ruleCol = planRow.getDynamicObjectCollection(RULEENTITY);
            ruleCol.forEach(ruleRow -> ruleList.add(ruleRow.getString("rule.id")));
            DynamicObjectCollection orgCol = planRow.getDynamicObjectCollection(ORGENTITY);
            orgCol.forEach(orgRow -> orgList.add(orgRow.getString("org.id")));
            planEntityMap.put(PLANENTITY, Arrays.asList(planRow.getString(NUMBER), planRow.getString(NAME), planRow.getString("taxationsys.id")));
            planEntityMap.put(RULEENTITY, ruleList);
            planEntityMap.put(ORGENTITY, orgList);
            planCacheMap.put(planRow.getString("id"), planEntityMap);
        });
        return planCacheMap;
    }

    private void checkPermission() {
        if (!PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"4730fc9f000003ae")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{IMPORTDATA});
        }
        if (!PermissionUtils.hasSpecificPerm((IFormView)this.getView(), (String)"4730fc9f000004ae")) {
            this.getView().setEnable(Boolean.FALSE, new String[]{EXPORTDATA});
        }
    }

    private void save() {
        DynamicObjectCollection collection = this.getModel().getEntryEntity(PLANENTITY);
        if (collection.isEmpty()) {
            return;
        }
        try (TXHandle h = TX.requiresNew();){
            try {
                ArrayList<DynamicObject> forSaveObjArr = new ArrayList<DynamicObject>(10);
                DynamicObject row = (DynamicObject)collection.get(this.getSelectRows());
                Long planId = row.getLong("id");
                DynamicObject planObject = BusinessDataServiceHelper.newDynamicObject((String)GTCP_SHARDINGPLAN);
                if (!ObjectUtils.isEmpty((Object)planId) && planId > 0L) {
                    planObject = BusinessDataServiceHelper.loadSingle((Object)planId, (String)GTCP_SHARDINGPLAN);
                } else {
                    planObject.set("creator", row.get("creator"));
                    planObject.set("createtime", row.get("createtime"));
                }
                planObject.set(NUMBER, row.get(MAP.get(NUMBER)));
                planObject.set(NAME, row.get(MAP.get(NAME)));
                planObject.set(TAXATIONSYS, row.get(MAP.get(TAXATIONSYS)));
                planObject.set(TAXCATEGORY, row.get(MAP.get(TAXCATEGORY)));
                planObject.set(TAXAREAGROUP, row.get(MAP.get(TAXAREAGROUP)));
                planObject.set("modifier", row.get("modifier"));
                planObject.set("modifytime", row.get("modifytime"));
                planObject.set("status", (Object)"C");
                planObject.set("enable", (Object)1);
                DynamicObjectCollection ruleCol = row.getDynamicObjectCollection(RULEENTITY);
                DynamicObjectCollection ruleCollection = planObject.getDynamicObjectCollection(RULEENTITY);
                ruleCollection.clear();
                Stream.iterate(0, i -> i + 1).limit(ruleCol.size()).forEach(index -> {
                    DynamicObject rule = (DynamicObject)ruleCol.get(index.intValue());
                    DynamicObject ruleRow = ruleCollection.addNew();
                    ruleRow.set("seq", index);
                    ruleRow.set("id", rule.get("ruleentryid"));
                    ruleRow.set(RULE, ((DynamicObject)rule.get(RULE)).get("id"));
                });
                DynamicObjectCollection orgCol = row.getDynamicObjectCollection(ORGENTITY);
                DynamicObjectCollection orgCollection = planObject.getDynamicObjectCollection(ORGENTITY);
                orgCollection.clear();
                Stream.iterate(0, i -> i + 1).limit(orgCol.size()).forEach(index -> {
                    DynamicObject org = (DynamicObject)orgCol.get(index.intValue());
                    DynamicObject orgRow = orgCollection.addNew();
                    orgRow.set("seq", index);
                    orgRow.set("id", org.get("orgentryid"));
                    orgRow.set(ORG, ((DynamicObject)org.get(ORG)).get("id"));
                });
                forSaveObjArr.add(planObject);
                OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)GTCP_SHARDINGPLAN, (DynamicObject[])forSaveObjArr.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                if (result.isSuccess()) {
                    this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u4fdd\u5b58\u6210\u529f\u3002", (String)"SharingPlanPlugin_12", (String)SYSTEM_TYPE, (Object[])new Object[0]), Integer.valueOf(3000));
                    this.getView().invokeOperation(REFRESH);
                } else {
                    List errors = result.getAllErrorInfo();
                    List vas = result.getValidateResult().getValidateErrors();
                    StringBuilder error = new StringBuilder(result.getMessage());
                    for (OperateErrorInfo opError : errors) {
                        error.append(opError.getMessage());
                    }
                    for (ValidateResult va : vas) {
                        for (OperateErrorInfo operr : va.getAllErrorInfo()) {
                            error.append(operr.getMessage());
                        }
                    }
                    this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u4fdd\u5b58\u5931\u8d25\uff1a%1$s\u3002", (String)"SharingPlanPlugin_13", (String)SYSTEM_TYPE, (Object[])new Object[0]), error));
                }
            }
            catch (Exception ex) {
                LOGGER.error("\u4fdd\u5b58\u5931\u8d25\uff1a{}", (Object)ExceptionUtils.getExceptionStackTraceMessage((Exception)ex));
                h.markRollback();
                throw ex;
            }
        }
    }

    private void importData(String entityName) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.setFormId("bos_importstart");
        showParameter.setCustomParam("BillFormId", (Object)GTCP_SHARDINGPLAN);
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        ArrayList plugins = new ArrayList();
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        map.put("Enabled", Boolean.TRUE);
        plugins.add(map);
        showParameter.setCustomParam("ListName", (Object)entityName);
        showParameter.setCustomParam("plugins", plugins);
        showParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, IMPORTDATA));
        this.getView().showForm(showParameter);
    }

    private void showExportDataForm() {
        ListShowParameter listShowParameter = new ListShowParameter();
        listShowParameter.setFormId("bos_list");
        listShowParameter.setBillFormId(GTCP_SHARDINGPLAN);
        listShowParameter.getOpenStyle().setShowType(ShowType.Modal);
        StyleCss styleCss = new StyleCss();
        styleCss.setMarginRight("500");
        styleCss.setMarginLeft("500");
        styleCss.setWidth("1150");
        styleCss.setHeight("600");
        listShowParameter.getOpenStyle().setInlineStyleCss(styleCss);
        listShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, EXPORTDATA));
        this.getView().showForm((FormShowParameter)listShowParameter);
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actionId = closedCallBackEvent.getActionId();
        if (StringUtils.equalsIgnoreCase((CharSequence)actionId, (CharSequence)IMPORTDATA)) {
            this.getView().invokeOperation(REFRESH);
        }
    }

    private void selectListRowAndPutCache() {
        Map map = (Map)SerializationUtils.fromJsonString((String)this.getPageCache().get("cardIndexs"), Map.class);
        if (!map.isEmpty()) {
            int focusCardIndex = Integer.parseInt(this.getPageCache().get("focusCardIndex"));
            if (map.size() - 1 > focusCardIndex) {
                String nextFocusCardIndex = String.valueOf(focusCardIndex + 1);
                this.selectListRow((Integer)map.get(nextFocusCardIndex));
                this.getPageCache().put("focusCardIndex", nextFocusCardIndex);
            } else if (map.size() - 1 == focusCardIndex) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u5df2\u641c\u7d22\u5230\u6700\u540e\u4e00\u884c\u3002", (String)"SharingPlanPlugin_14", (String)SYSTEM_TYPE, (Object[])new Object[0]));
            }
        }
    }

    private DataSet buildDataSet() {
        DataType[] dataTypes = new DataType[]{DataType.IntegerType, DataType.StringType, DataType.StringType};
        RowMeta rowMeta = RowMetaFactory.createRowMeta((String[])FIELD_NAMES, (DataType[])dataTypes);
        ArrayList<Object[]> coll = new ArrayList<Object[]>(16);
        int entryRowCount = this.getModel().getEntryRowCount(PLANENTITY);
        for (int i = 0; i < entryRowCount; ++i) {
            Object[] value = new Object[FIELD_NAMES.length];
            DynamicObject planEntry = (DynamicObject)this.getModel().getEntryEntity(PLANENTITY).get(i);
            value[0] = i;
            value[1] = planEntry.getString(MAP.get(NUMBER));
            value[2] = planEntry.getString(MAP.get(NAME));
            coll.add(value);
        }
        CollectionInput inputs = new CollectionInput(rowMeta, coll);
        return Algo.create((String)GTCP_SHARDINGPLAN).createDataSet(new Input[]{inputs});
    }

    private List<String> filterDataSet(String searchText) {
        ArrayList<String> list = new ArrayList<String>();
        String text = "%" + searchText + "%";
        QFilter nameQ = new QFilter(NAME, "like", (Object)text);
        QFilter numberQ = new QFilter(NUMBER, "like", (Object)text);
        DataSet dataSet = this.buildDataSet();
        DataSet nameDataSet = dataSet.filter(nameQ.toString());
        DataSet numberDataSet = dataSet.filter(numberQ.toString());
        if (!nameDataSet.isEmpty()) {
            nameDataSet.forEach(o -> list.add(o.getString(NAME)));
        }
        if (!numberDataSet.isEmpty()) {
            numberDataSet.forEach(o -> list.add(o.getString(NUMBER)));
        }
        nameDataSet.close();
        numberDataSet.close();
        return list;
    }

    static {
        FIELD_NAMES = new String[]{INDEX, NUMBER, NAME};
        MAP = new HashMap<String, String>();
        MAP.put(NAME, "cardname");
        MAP.put(NUMBER, "cardnumber");
        MAP.put(TAXATIONSYS, "cardtaxationsys");
        MAP.put(TAXCATEGORY, "cardtaxcategory");
        MAP.put(TAXAREAGROUP, "cardtaxareagroup");
    }
}

