/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.sharefactor;

import java.util.EventObject;
import java.util.List;
import java.util.Map;
import kd.bos.bill.AbstractBillPlugIn;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.OrgEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.orm.query.QFilter;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.sharefactor.UsaShareFactorBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class UsaShareFactorEdit
extends AbstractBillPlugIn
implements BeforeF7SelectListener,
AfterF7SelectListener {
    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit orgEdit = (BasedataEdit)this.getControl("org");
        orgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        orgEdit.addAfterF7SelectListener((AfterF7SelectListener)this);
        BasedataEdit taxAreaGroupEdit = (BasedataEdit)this.getControl("taxareagroup");
        taxAreaGroupEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map<String, String> permOrgMap = UsaShareFactorBusiness.queryTaxcMainUSAMap(this.getView().getFormShowParameter().getAppId(), "gtcp_usasharefactor", "47156aff000000ac");
        if (ObjectUtils.isNotEmpty(permOrgMap)) {
            Long defaultOrg = 0L;
            if (permOrgMap.containsKey(String.valueOf(RequestContext.get().getOrgId()))) {
                this.getModel().setValue("org", (Object)RequestContext.get().getOrgId());
                defaultOrg = RequestContext.get().getOrgId();
            } else {
                String value = "";
                for (Map.Entry<String, String> entry : permOrgMap.entrySet()) {
                    if (!StringUtil.isBlank((CharSequence)value)) continue;
                    value = entry.getKey();
                    break;
                }
                this.getModel().setValue("org", (Object)Long.valueOf(value));
                defaultOrg = StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{value}) ? Long.valueOf(value) : defaultOrg;
            }
            List<Long> list = UsaShareFactorBusiness.queryOrgTaxAreaGroupByOrgId(defaultOrg, this.getView().getFormShowParameter().getAppId(), "gtcp_usasharefactor", "47156aff000000ac");
            this.getModel().setValue("taxareagroup", ObjectUtils.isEmpty(list) ? null : list.get(0));
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String key = beforeF7SelectEvent.getProperty().getName();
        if (StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)"org")) {
            List<Long> list = UsaShareFactorBusiness.queryBastaxTaxOrgIdUSA(this.getView().getFormShowParameter().getAppId(), "gtcp_usasharefactor", "47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", list);
            beforeF7SelectEvent.addCustomQFilter(qFilter);
            return;
        }
        if (StringUtil.equalsIgnoreCase((CharSequence)key, (CharSequence)"taxareagroup")) {
            if (ObjectUtils.isEmpty((Object)this.getModel().getValue("org"))) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"UsaShareFactorEdit_0", (String)"taxc-gtcp", (Object[])new Object[0]));
                beforeF7SelectEvent.setCancel(true);
                return;
            }
            DynamicObject org = (DynamicObject)this.getModel().getValue("org");
            List<Long> list = UsaShareFactorBusiness.queryOrgTaxAreaGroupByOrgId(org.getLong("id"), this.getView().getFormShowParameter().getAppId(), "gtcp_usasharefactor", "47156aff000000ac");
            QFilter qFilter = new QFilter("id", "in", list);
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
        if (afterF7SelectEvent.getSource() instanceof OrgEdit) {
            Long selectOrgId = 0L;
            ListSelectedRow listSelectedRows = afterF7SelectEvent.getListSelectedRow();
            Object inputValue = afterF7SelectEvent.getInputValue();
            if (ObjectUtils.isNotEmpty((Object)listSelectedRows)) {
                selectOrgId = listSelectedRows.getPrimaryKeyValue() instanceof Long ? (Long)listSelectedRows.getPrimaryKeyValue() : selectOrgId;
            } else if (ObjectUtils.isEmpty((Object)listSelectedRows) && ObjectUtils.isNotEmpty((Object)inputValue)) {
                selectOrgId = ObjectUtils.isNotEmpty((Object)inputValue) ? Long.valueOf((String)inputValue) : selectOrgId;
            }
            List<Long> list = UsaShareFactorBusiness.queryOrgTaxAreaGroupByOrgId(selectOrgId, this.getView().getFormShowParameter().getAppId(), "gtcp_usasharefactor", "47156aff000000ac");
            this.getModel().setValue("taxareagroup", ObjectUtils.isEmpty(list) ? null : list.get(0));
        }
    }
}

