/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.formplugin.sharefactor;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AbstractColumnDesc;
import kd.bos.filter.CommonFilterColumn;
import kd.bos.filter.FilterColumn;
import kd.bos.form.events.FilterContainerInitArgs;
import kd.bos.form.events.PreOpenFormEventArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.ComboItem;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.inte.InteServiceHelper;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.sharefactor.UsaShareFactorBusiness;
import org.apache.commons.lang3.ObjectUtils;

public class UsaShareFactorList
extends AbstractListPlugin {
    private static final String PARAM_MEETORG = "meetOrg";
    private static final String PARAM_MEETORG_AREA = "meetOrgArea";

    public void preOpenForm(PreOpenFormEventArgs e) {
        super.preOpenForm(e);
        Map<String, String> taxOrgAreaMap = UsaShareFactorBusiness.queryOrgTaxAreaGroupMapListUse(e.getFormShowParameter().getAppId(), "gtcp_usasharefactor", "47150e89000000ac");
        e.getFormShowParameter().setCustomParam(PARAM_MEETORG_AREA, taxOrgAreaMap);
        Map<String, String> permOrgMap = UsaShareFactorBusiness.queryTaxcMainUSAMapListUse(e.getFormShowParameter().getAppId(), "gtcp_usasharefactor", "47150e89000000ac");
        e.getFormShowParameter().setCustomParam(PARAM_MEETORG, permOrgMap);
    }

    public void packageData(PackageDataEvent e) {
        DynamicObject data = e.getRowData();
        AbstractColumnDesc columnDesc = (AbstractColumnDesc)e.getSource();
        if ("skssqq".equals(columnDesc.getKey())) {
            String dataFormat = InteServiceHelper.getDateFormat((Long)RequestContext.get().getCurrUserId());
            String skssqq = DateUtils.format((Date)data.getDate("skssqq"), (String)dataFormat);
            String skssqz = DateUtils.format((Date)data.getDate("skssqz"), (String)dataFormat);
            e.setFormatValue((Object)(skssqq + "~" + skssqz));
        }
    }

    public void filterContainerInit(FilterContainerInitArgs args) {
        super.filterContainerInit(args);
        List commonFilterColumns = args.getCommonFilterColumns();
        for (FilterColumn filterColumn : commonFilterColumns) {
            ComboItem comboItem;
            String defaultOrg;
            List list;
            if (filterColumn.getFieldName().contains("org")) {
                Map permOrgMap = (Map)this.getView().getFormShowParameter().getCustomParam(PARAM_MEETORG);
                list = ((CommonFilterColumn)filterColumn).getComboItems();
                list.clear();
                defaultOrg = null;
                for (Map.Entry entry : permOrgMap.entrySet()) {
                    if (StringUtil.isEmpty(defaultOrg)) {
                        defaultOrg = (String)entry.getKey();
                    }
                    comboItem = new ComboItem();
                    comboItem.setId((String)entry.getKey());
                    comboItem.setCaption(new LocaleString((String)entry.getValue()));
                    comboItem.setValue((String)entry.getKey());
                    list.add(comboItem);
                }
                filterColumn.setDefaultValue(ObjectUtils.isNotEmpty((Object)permOrgMap) && permOrgMap.containsKey(String.valueOf(RequestContext.get().getOrgId())) ? String.valueOf(RequestContext.get().getOrgId()) : defaultOrg);
                continue;
            }
            if (!filterColumn.getFieldName().contains("taxareagroup")) continue;
            Map taxOrgAreaMap = (Map)this.getView().getFormShowParameter().getCustomParam(PARAM_MEETORG_AREA);
            list = ((CommonFilterColumn)filterColumn).getComboItems();
            list.clear();
            defaultOrg = null;
            for (Map.Entry entry : taxOrgAreaMap.entrySet()) {
                if (StringUtil.isEmpty((CharSequence)defaultOrg)) {
                    defaultOrg = (String)entry.getKey();
                }
                comboItem = new ComboItem();
                comboItem.setId((String)entry.getKey());
                comboItem.setCaption(new LocaleString((String)entry.getValue()));
                comboItem.setValue((String)entry.getKey());
                list.add(comboItem);
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        if (args.getFieldName().contains("org")) {
            Map permOrgMap = (Map)this.getView().getFormShowParameter().getCustomParam(PARAM_MEETORG);
            if (ObjectUtils.isNotEmpty((Object)permOrgMap)) {
                List list = permOrgMap.keySet().stream().filter(orgId -> StringUtil.isNotBlank((CharSequence)orgId)).map(row -> Long.valueOf(row)).collect(Collectors.toList());
                QFilter idQ = new QFilter("id", "in", list);
                args.getQfilters().add(idQ);
            }
        } else if (args.getFieldName().contains("taxareagroup")) {
            Map taxOrgAreaMap = (Map)this.getView().getFormShowParameter().getCustomParam(PARAM_MEETORG_AREA);
            List list = taxOrgAreaMap.keySet().stream().filter(row -> StringUtil.isNotBlank((CharSequence)row)).map(row -> Long.valueOf(row)).collect(Collectors.toList());
            QFilter idQ = new QFilter("id", "in", list);
            args.getQfilters().add(idQ);
        }
    }

    public void setFilter(SetFilterEvent e) {
        super.setFilter(e);
        Map permOrgMap = (Map)this.getView().getFormShowParameter().getCustomParam(PARAM_MEETORG);
        if (ObjectUtils.isNotEmpty((Object)permOrgMap)) {
            List orgIdList = permOrgMap.keySet().stream().filter(row -> StringUtil.isNotBlank((CharSequence)row)).map(o -> Long.valueOf(o)).collect(Collectors.toList());
            e.getQFilters().add(new QFilter("org", "in", orgIdList));
        } else {
            e.getQFilters().add(new QFilter("org", "=", (Object)-1L));
        }
        Map taxOrgAreaMap = (Map)this.getView().getFormShowParameter().getCustomParam(PARAM_MEETORG_AREA);
        if (ObjectUtils.isNotEmpty((Object)taxOrgAreaMap)) {
            List areaList = taxOrgAreaMap.keySet().stream().filter(row -> ObjectUtils.isNotEmpty((Object)row)).map(o -> Long.valueOf(o)).collect(Collectors.toList());
            e.getQFilters().add(new QFilter("taxareagroup", "in", areaList));
        } else {
            e.getQFilters().add(new QFilter("taxareagroup", "=", (Object)-1L));
        }
    }
}

