/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.opplugin.declare;

import java.math.BigDecimal;
import java.util.concurrent.atomic.AtomicReference;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.enums.GtcpDeclarePayRefundEnum;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.taxpayrefund.strategy.AbstractGtcpTaxPayRefundStrategy;
import kd.taxc.gtcp.business.taxpayrefund.strategy.GtcpTaxPayRefundStrategyFactory;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpDeclareApplyConfirmOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String declateDate = this.getOption().getVariableValue("declaredate");
        String draftId = this.getOption().getVariableValue("id");
        DynamicObject updateObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(draftId), (String)"gtcp_normal_draft_list");
        DynamicObjectCollection collection = updateObject.getDynamicObjectCollection("entryentity");
        AtomicReference<String> payStatus = new AtomicReference<String>("unpayrefund");
        collection.stream().filter(row -> row.getBigDecimal("bqybtse").compareTo(BigDecimal.ZERO) == 0).forEach(row -> payStatus.set("nopayrefund"));
        AbstractGtcpTaxPayRefundStrategy taxPayRefundStrategy = GtcpTaxPayRefundStrategyFactory.getGtcpTaxPayRefundStrategyEnumByType(updateObject.getString("taxsystem.number"), updateObject.getString("taxtype.number"));
        if (ObjectUtils.isNotEmpty((Object)taxPayRefundStrategy) && taxPayRefundStrategy.checkNoCommonTaxtype(updateObject.getLong("taxsystem.id"), updateObject.getLong("taxtype.id"), updateObject.getLong("taxareagroup.id"), "1", null)) {
            payStatus.set(taxPayRefundStrategy.setPayStatus(payStatus.get(), draftId, GtcpDeclarePayRefundEnum.getGtcpDeclarePayEnumByMultiCondition((String)updateObject.getString("templatetype.id"), (String)updateObject.getString("taxsystem.id"), (String)updateObject.getString("taxtype.id"))));
        }
        collection.stream().forEach(row -> {
            row.set("declarestatus", (Object)"declared");
            row.set("declaredate", (Object)DateUtils.stringToDate2((String)declateDate));
            row.set("payrefundstatus", payStatus.get());
        });
        SaveServiceHelper.update((DynamicObject)updateObject);
    }
}

