/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.opplugin.declare;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;

public class GtcpDeclareListPayRefundOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(Arrays.asList("declarestatus", "payrefundstatus", "bqybtse", "templatetype"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("confirmpayrefund".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"gtcp_normal_draft_list", (String)"id,billno,billstatus,generatebusinessdoc,businessdocno,auditor,templatetype,draftstatus,templateid,datatype,nsrsbh,nsrmc,taxtype,org,currentperiodamount,currentyearamount,taxsystem,skssqq,skssqz,accountsettype,remarks,modifier,auditdate,createtime,modifytime,creator,entryentity,entryentity.declarestatus,entryentity.payrefundstatus,entryentity.bqybtse,taxareagroup,entryentity.declaredate,entryentity.payrefunddate", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            if (declares != null && declares.length > 0) {
                String templateType = "";
                String dataEntityName = "";
                block0: for (DynamicObject declare : declares) {
                    templateType = declare.getString("templatetype.id");
                    dataEntityName = declare.getDataEntityType().getName();
                    String billNo = declare.getString("billno");
                    DynamicObjectCollection collection = declare.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : collection) {
                        if (!"declared".equals(row.getString("declarestatus"))) {
                            message.append(String.format(ResManager.loadKDString((String)"\u4ec5\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\u7684\u6570\u636e\u53ef\u786e\u8ba4\u7f34/\u9000\u7a0e\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a %1$s\u3002", (String)"GtcpDeclareListPayRefundOp_0", (String)"taxc-gtcp", (Object[])new Object[0]), billNo)).append(SEPARATOR);
                            continue block0;
                        }
                        if ("unpayrefund".equals(row.getString("payrefundstatus"))) continue;
                        message.append(String.format(ResManager.loadKDString((String)"\u4ec5\u7f34/\u9000\u7a0e\u72b6\u6001\u4e3a\u672a\u7f34\u9000\u7684\u6570\u636e\u53ef\u786e\u8ba4\u7f34/\u9000\u7a0e\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a %1$s\u3002", (String)"GtcpDeclareListPayRefundOp_1", (String)"taxc-gtcp", (Object[])new Object[0]), billNo)).append(SEPARATOR);
                        continue block0;
                    }
                }
                String msg = message.toString();
                if (StringUtils.isNotBlank((CharSequence)msg)) {
                    OperatorDialogUtils.operateDialog((String)templateType, (String)dataEntityName, (String)ResManager.loadKDString((String)"\u786e\u8ba4\u7f34/\u9000\u7a0e", (String)"GtcpDeclareListPayRefundOp_2", (String)"taxc-gtcp", (Object[])new Object[0]), (String)msg);
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                    return;
                }
                this.operationResult.setSuccess(true);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Object[] dataEntities = e.getDataEntities();
        if (!ObjectUtils.isEmpty((Object[])dataEntities)) {
            List idList = Arrays.stream(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toList());
            TaxResult listTaxResult = DeclareMainServiceHelper.queryDeclareMainByIds((Long)MultiTableEnum.getModelIdByNumber((String)MultiTableEnum.TSD001.getModel()), idList);
            if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
                HashMap params = new HashMap(16);
                for (Object dynamicObject : dataEntities) {
                    HashMap<String, String> param = new HashMap<String, String>(16);
                    DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                    String paystatus = "paid";
                    if (!ObjectUtils.isEmpty((Object)entryentity) && BigDecimal.ZERO.compareTo(((DynamicObject)entryentity.get(0)).getBigDecimal("bqybtse")) == 0) {
                        paystatus = "nopay";
                    }
                    param.put("paystatus", paystatus);
                    params.put(dynamicObject.getLong("id"), param);
                }
                MultiDeclareMQSender.sendMQ((DynamicObject[])((List)listTaxResult.getData()).toArray(new DynamicObject[0]), (String)"pay", params);
            }
        }
    }
}

