/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.opplugin.declare;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.GtcpDeclarePayRefundEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.taxpayrefund.GtcpTaxPayRefundBussiness;
import kd.taxc.gtcp.business.taxpayrefund.strategy.AbstractGtcpTaxPayRefundStrategy;
import kd.taxc.gtcp.business.taxpayrefund.strategy.GtcpTaxPayRefundStrategyFactory;
import org.apache.commons.collections4.CollectionUtils;

public class GtcpDeclareListUnApplyOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(Arrays.asList("declarestatus", "payrefundstatus", "templatetype", "draftpurpose"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("canceldeclare".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"gtcp_normal_draft_list", (String)"id,billno,billstatus,generatebusinessdoc,businessdocno,auditor,templatetype,draftstatus,templateid,datatype,nsrsbh,nsrmc,taxtype,org,currentperiodamount,currentyearamount,taxsystem,skssqq,skssqz,accountsettype,remarks,modifier,auditdate,createtime,modifytime,creator,entryentity,entryentity.declarestatus,entryentity.payrefundstatus,entryentity.bqybtse,taxareagroup,entryentity.declaredate,entryentity.payrefunddate", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            if (declares != null && declares.length > 0) {
                String msg;
                HashMap<Long, Boolean> allRowTabIsZeroMap = new HashMap<Long, Boolean>(16);
                HashMap<Long, List<String>> queryParamAllRowMap = new HashMap<Long, List<String>>();
                for (DynamicObject declare : declares) {
                    GtcpDeclarePayRefundEnum payEnum = GtcpDeclarePayRefundEnum.getGtcpDeclarePayEnumByMultiCondition((String)declare.getString("templatetype.id"), (String)declare.getString("taxsystem.id"), (String)declare.getString("taxtype.id"));
                    if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)payEnum)) continue;
                    queryParamAllRowMap.put(declare.getLong("id"), payEnum.getRowColumn());
                }
                Map<Long, Map<String, String>> allRowResultMap = GtcpDraftBussiness.batchFixCellValue(queryParamAllRowMap);
                for (Map.Entry<Long, Map<String, String>> entry : allRowResultMap.entrySet()) {
                    boolean isAllZero = true;
                    for (Map.Entry entry2 : entry.getValue().entrySet()) {
                        BigDecimal bigDecimal = StringUtil.isNotBlank((CharSequence)((CharSequence)entry2.getValue())) ? new BigDecimal((String)entry2.getValue()) : BigDecimal.ZERO;
                        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
                        isAllZero = false;
                        break;
                    }
                    allRowTabIsZeroMap.put(entry.getKey(), isAllZero);
                }
                ArrayList<DynamicObject[]> allDataList = new ArrayList<DynamicObject[]>(16);
                ArrayList<Long> passList = new ArrayList<Long>(16);
                ArrayList<Object> noPassList = new ArrayList<Object>(16);
                ArrayList<DynamicObject[]> noPassDeclareStatusList = new ArrayList<DynamicObject[]>(16);
                ArrayList<String> arrayList = new ArrayList<String>(16);
                block3: for (DynamicObject declare : declares) {
                    DynamicObject[] draftId = Long.valueOf(declare.getLong("id"));
                    allDataList.add(draftId);
                    arrayList.add(declare.getString("billno"));
                    DynamicObjectCollection collection = declare.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : collection) {
                        if (!"declared".equals(row.getString("declarestatus"))) {
                            noPassDeclareStatusList.add(draftId);
                            continue block3;
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)row.getString("payrefundstatus"), (CharSequence)"payrefund") || StringUtils.equalsIgnoreCase((CharSequence)row.getString("payrefundstatus"), (CharSequence)"partpayrefund")) {
                            noPassList.add(draftId);
                            continue block3;
                        }
                        if (row.getBigDecimal("bqybtse").compareTo(BigDecimal.ZERO) == 0) {
                            if (null != allRowTabIsZeroMap.get(draftId) && ((Boolean)allRowTabIsZeroMap.get(draftId)).booleanValue()) {
                                passList.add((Long)draftId);
                                continue block3;
                            }
                            AbstractGtcpTaxPayRefundStrategy taxPayRefundStrategy = GtcpTaxPayRefundStrategyFactory.getGtcpTaxPayRefundStrategyEnumByType(declare.getString("taxsystem.number"), declare.getString("taxtype.number"));
                            if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)taxPayRefundStrategy) || !taxPayRefundStrategy.checkNoCommonTaxtype(declare.getLong("taxsystem.id"), declare.getLong("taxtype.id"), declare.getLong("taxareagroup.id"), "1", null) || !StringUtils.equalsIgnoreCase((CharSequence)row.getString("payrefundstatus"), (CharSequence)"unpayrefund")) continue;
                            passList.add((Long)draftId);
                            continue block3;
                        }
                        if (!StringUtils.equalsIgnoreCase((CharSequence)row.getString("payrefundstatus"), (CharSequence)"unpayrefund")) continue;
                        passList.add((Long)draftId);
                        continue block3;
                    }
                }
                List list = (List)CollectionUtils.subtract(allDataList, passList);
                noPassList.addAll(noPassDeclareStatusList);
                noPassList.addAll(list);
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
                String templateType = "";
                String dataEntityName = "";
                for (DynamicObject declare : declares) {
                    templateType = declare.getString("templatetype.id");
                    dataEntityName = declare.getDataEntityType().getName();
                    Long draftId = declare.getLong("id");
                    String billNo = declare.getString("billno");
                    if (noPassList.contains(draftId)) {
                        if (noPassDeclareStatusList.contains(draftId)) {
                            message.append(String.format(ResManager.loadKDString((String)"\u4ec5\u7533\u62a5\u72b6\u6001\u4e3a\u5df2\u7533\u62a5\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7533\u62a5\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a %1$s\u3002", (String)"GtcpDeclareListUnApplyOp_0", (String)"taxc-gtcp", (Object[])new Object[0]), billNo)).append(SEPARATOR);
                            continue;
                        }
                        message.append(String.format(ResManager.loadKDString((String)"\u4ec5\u672a\u786e\u8ba4\u7f34/\u9000\u7a0e\u72b6\u6001\u7684\u6570\u636e\u53ef\u53d6\u6d88\u7533\u62a5\uff0c\u5f53\u524d\u6570\u636e\u4e0d\u7b26\u5408\u6761\u4ef6\uff1a %1$s\u3002", (String)"GtcpDeclareListUnApplyOp_1", (String)"taxc-gtcp", (Object[])new Object[0]), billNo)).append(SEPARATOR);
                        continue;
                    }
                    DynamicObjectCollection collection = declare.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row : collection) {
                        row.set("declarestatus", (Object)"editing");
                        row.set("declaredate", null);
                        row.set("payrefundstatus", (Object)"unpayrefund");
                    }
                    updateList.add(declare);
                }
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
                GtcpTaxPayRefundBussiness.deleteTaxPayRefundsByDraftId(passList);
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(noPassList)) {
                    this.operationResult.getSuccessPkIds().removeAll(noPassList);
                }
                if (StringUtils.isNotBlank((CharSequence)(msg = message.toString()))) {
                    OperatorDialogUtils.operateDialog((String)templateType, (String)dataEntityName, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u7533\u62a5", (String)"GtcpDeclareListUnApplyOp_2", (String)"taxc-gtcp", (Object[])new Object[0]), (String)msg);
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                    return;
                }
                String successDraftBillNo = StringUtil.join(arrayList, (String)",");
                this.operationResult.setSuccess(true);
                OperatorDialogUtils.operateDialog((String)templateType, (String)dataEntityName, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u7533\u62a5", (String)"GtcpDeclareListUnApplyOp_2", (String)"taxc-gtcp", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s,\u53d6\u6d88\u7533\u62a5\u6210\u529f", (String)"GtcpDeclareListUnApplyOp_3", (String)"taxc-gtcp", (Object[])new Object[0]), successDraftBillNo));
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        Object[] dataEntities = e.getDataEntities();
        if (!ObjectUtils.isEmpty((Object[])dataEntities)) {
            List idList = Arrays.stream(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toList());
            TaxResult listTaxResult = DeclareMainServiceHelper.queryDeclareMainByIds((Long)MultiTableEnum.getModelIdByNumber((String)MultiTableEnum.TSD001.getModel()), idList);
            if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
                HashMap params = new HashMap(16);
                for (Object dynamicObject : dataEntities) {
                    HashMap<String, String> param = new HashMap<String, String>(16);
                    param.put("declarestatus", "editing");
                    params.put(dynamicObject.getLong("id"), param);
                }
                MultiDeclareMQSender.sendMQ((DynamicObject[])((List)listTaxResult.getData()).toArray(new DynamicObject[0]), (String)"cancelapply", params);
            }
        }
    }
}

