/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.opplugin.declare;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.GtcpDeclarePayRefundEnum;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;
import kd.taxc.bdtaxr.common.tctb.common.util.PermissionUtils;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.utils.string.StringUtil;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.taxpayrefund.GtcpTaxPayRefundBussiness;
import org.apache.commons.collections4.CollectionUtils;

public class GtcpDeclareListUnPayRefundOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(Arrays.asList("declarestatus", "payrefundstatus", "bqybtse", "templatetype"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs args) {
        String operateKey = args.getOperationKey();
        if ("unpayrefund".equals(operateKey)) {
            StringBuilder message = new StringBuilder();
            DynamicObject[] dataEntities = args.getDataEntities();
            List pkIds = Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList());
            DynamicObject[] declares = BusinessDataServiceHelper.load((String)"gtcp_normal_draft_list", (String)"id,billno,billstatus,generatebusinessdoc,businessdocno,auditor,templatetype,draftstatus,templateid,datatype,nsrsbh,nsrmc,taxtype,org,currentperiodamount,currentyearamount,taxsystem,skssqq,skssqz,accountsettype,remarks,modifier,auditdate,createtime,modifytime,creator,entryentity,entryentity.declarestatus,entryentity.payrefundstatus,entryentity.bqybtse,taxareagroup,entryentity.declaredate,entryentity.payrefunddate", (QFilter[])new QFilter[]{new QFilter("id", "in", pkIds)});
            if (declares != null && declares.length > 0) {
                String msg;
                ArrayList<String> allDraftBillno = new ArrayList<String>(16);
                HashMap<Long, Boolean> allRowTabIsZeroMap = new HashMap<Long, Boolean>(16);
                HashMap<Long, List<String>> queryParamAllRowMap = new HashMap<Long, List<String>>();
                String templateType = "";
                String dataEntityName = "";
                for (DynamicObject declare : declares) {
                    GtcpDeclarePayRefundEnum payEnum = GtcpDeclarePayRefundEnum.getGtcpDeclarePayEnumByMultiCondition((String)declare.getString("templatetype.id"), (String)declare.getString("taxsystem.id"), (String)declare.getString("taxtype.id"));
                    templateType = declare.getString("templatetype.id");
                    dataEntityName = declare.getDataEntityType().getName();
                    allDraftBillno.add(declare.getString("billno"));
                    if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)payEnum)) continue;
                    queryParamAllRowMap.put(declare.getLong("id"), payEnum.getRowColumn());
                }
                Map<Long, Map<String, String>> allRowResultMap = GtcpDraftBussiness.batchFixCellValue(queryParamAllRowMap);
                for (Map.Entry<Long, Map<String, String>> entry : allRowResultMap.entrySet()) {
                    boolean isAllZero = true;
                    for (Map.Entry entry2 : entry.getValue().entrySet()) {
                        BigDecimal bigDecimal = StringUtil.isNotBlank((CharSequence)((CharSequence)entry2.getValue())) ? new BigDecimal((String)entry2.getValue()) : BigDecimal.ZERO;
                        if (bigDecimal.compareTo(BigDecimal.ZERO) == 0) continue;
                        isAllZero = false;
                        break;
                    }
                    allRowTabIsZeroMap.put(entry.getKey(), isAllZero);
                }
                ArrayList<Long> allDataList = new ArrayList<Long>(16);
                ArrayList<Long> passList = new ArrayList();
                ArrayList<Long> noPassList = new ArrayList<Long>();
                ArrayList<Long> noPassPerList = new ArrayList<Long>();
                ArrayList<Long> arrayList = new ArrayList<Long>();
                block3: for (DynamicObject declare : declares) {
                    Long draftId = declare.getLong("id");
                    allDataList.add(draftId);
                    DynamicObjectCollection collection = declare.getDynamicObjectCollection("entryentity");
                    HasPermOrgResult hasPermOrgResult = PermissionUtils.getAllPermOrgs((String)"gtcp", (String)"gtcp_taxpay_refund_bill", (String)"3OWI=VKD2X1P");
                    if (!hasPermOrgResult.hasAllOrgPerm() && (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)hasPermOrgResult.getHasPermOrgs()) || org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)hasPermOrgResult.getHasPermOrgs()) && !hasPermOrgResult.getHasPermOrgs().contains(declare.getLong("org.id")))) {
                        noPassPerList.add(draftId);
                        continue;
                    }
                    for (DynamicObject row2 : collection) {
                        if ("unpayrefund".equals(row2.getString("payrefundstatus"))) {
                            arrayList.add(draftId);
                            continue block3;
                        }
                        if (row2.getBigDecimal("bqybtse").compareTo(BigDecimal.ZERO) != 0 || null == allRowTabIsZeroMap.get(draftId) || !((Boolean)allRowTabIsZeroMap.get(draftId)).booleanValue() || !"nopayrefund".equals(row2.getString("payrefundstatus"))) continue;
                        noPassList.add(draftId);
                    }
                }
                noPassList.addAll(arrayList);
                noPassList.addAll(noPassPerList);
                passList = (List)CollectionUtils.subtract(allDataList, noPassList);
                ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>();
                for (DynamicObject declare : declares) {
                    Long draftId = declare.getLong("id");
                    String billNo = declare.getString("billno");
                    if (noPassList.contains(draftId)) {
                        if (arrayList.contains(draftId)) {
                            message.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5c1a\u672a\u786e\u8ba4\u7f34/\u9000\u7a0e\uff1a%1$s\u3002", (String)"GtcpDeclareListUnPayRefundOp_0", (String)"taxc-gtcp", (Object[])new Object[0]), billNo)).append(SEPARATOR);
                            continue;
                        }
                        if (noPassPerList.contains(draftId)) {
                            message.append(String.format(ResManager.loadKDString((String)"\u7f16\u53f7%1$s,\u5f53\u524d\u7528\u6237\u65e0'\u53d6\u6d88\u7f34/\u9000\u7a0e'\u7684\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"GtcpDeclareListUnPayRefundOp_4", (String)"taxc-gtcp", (Object[])new Object[0]), billNo)).append(SEPARATOR);
                            continue;
                        }
                        message.append(String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u4e0d\u53ef\u53d6\u6d88\u7f34/\u9000\u7a0e\uff1a%1$s\u3002", (String)"GtcpDeclareListUnPayRefundOp_1", (String)"taxc-gtcp", (Object[])new Object[0]), billNo)).append(SEPARATOR);
                        continue;
                    }
                    DynamicObjectCollection collection = declare.getDynamicObjectCollection("entryentity");
                    for (DynamicObject row3 : collection) {
                        row3.set("payrefundstatus", (Object)"unpayrefund");
                        row3.set("payrefunddate", null);
                    }
                    updateList.add(declare);
                }
                DynamicObject[] taxPayRefunds = GtcpTaxPayRefundBussiness.queryTaxPayRefundsByDraftIdList(passList);
                Arrays.stream(taxPayRefunds).forEach(row -> {
                    if (StringUtil.equalsIgnoreCase((CharSequence)row.getString("payrefstatus"), (CharSequence)"pay")) {
                        row.set("payrefstatus", (Object)"nopay");
                    } else if (StringUtil.equalsIgnoreCase((CharSequence)row.getString("payrefstatus"), (CharSequence)"refund")) {
                        row.set("payrefstatus", (Object)"norefund");
                    }
                    row.set("payrefunddate", null);
                });
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
                SaveServiceHelper.save((DynamicObject[])taxPayRefunds);
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(noPassList)) {
                    this.operationResult.getSuccessPkIds().removeAll(noPassList);
                }
                if (StringUtils.isNotBlank((CharSequence)(msg = message.toString()))) {
                    OperatorDialogUtils.operateDialog((String)templateType, (String)dataEntityName, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u7f34/\u9000\u7a0e", (String)"GtcpDeclareListUnPayRefundOp_2", (String)"taxc-gtcp", (Object[])new Object[0]), (String)msg);
                    this.operationResult.setSuccess(false);
                    this.operationResult.setMessage(msg);
                    this.operationResult.setShowMessage(false);
                    return;
                }
                String successDraftBillNo = StringUtil.join(allDraftBillno, (String)",");
                OperatorDialogUtils.operateDialog((String)templateType, (String)dataEntityName, (String)ResManager.loadKDString((String)"\u53d6\u6d88\u7f34/\u9000\u7a0e", (String)"GtcpDeclareListUnPayRefundOp_2", (String)"taxc-gtcp", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s,\u53d6\u6d88\u7f34/\u9000\u7a0e\u6210\u529f", (String)"GtcpDeclareListUnPayRefundOp_3", (String)"taxc-gtcp", (Object[])new Object[0]), successDraftBillNo));
                this.operationResult.setSuccess(true);
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if ("unpayrefund".equals(e.getOperationKey())) {
            Object[] dataEntities;
            List<Long> collect = this.operationResult.getSuccessPkIds().stream().map(v -> Long.parseLong(v.toString())).collect(Collectors.toList());
            DynamicObject[] taxPayRefunds = GtcpTaxPayRefundBussiness.queryTaxPayRefundsByDraftIdList(collect);
            if (EmptyCheckUtils.isNotEmpty((Object)taxPayRefunds)) {
                OverSeaMQSender.sendMQ(collect, (Long)1532683517396254720L, (String)"unpayrefund", (String)this.billEntityType.getName());
            }
            if (!ObjectUtils.isEmpty((Object[])(dataEntities = e.getDataEntities()))) {
                List idList = Arrays.stream(dataEntities).map(o -> o.getLong("id")).collect(Collectors.toList());
                TaxResult listTaxResult = DeclareMainServiceHelper.queryDeclareMainByIds((Long)MultiTableEnum.getModelIdByNumber((String)MultiTableEnum.TSD001.getModel()), idList);
                if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
                    HashMap params = new HashMap(16);
                    for (Object dynamicObject : dataEntities) {
                        HashMap<String, String> param = new HashMap<String, String>(16);
                        String paystatus = "unpaid";
                        param.put("paystatus", paystatus);
                        params.put(dynamicObject.getLong("id"), param);
                    }
                    MultiDeclareMQSender.sendMQ((DynamicObject[])((List)listTaxResult.getData()).toArray(new DynamicObject[0]), (String)"cancelpay", params);
                }
            }
        }
    }
}

