/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.opplugin.declare;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.taxcalendar.GtcpTaxCalendarBussiness;
import kd.taxc.gtcp.business.taxpayrefund.GtcpTaxPayRefundBussiness;
import kd.taxc.gtcp.business.taxpayrefund.strategy.AbstractGtcpTaxPayRefundStrategy;
import kd.taxc.gtcp.business.taxpayrefund.strategy.GtcpTaxPayRefundStrategyFactory;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpDeclarePayRefundConfirmOp
extends AbstractOperationServicePlugIn {
    private static final String SEPARATOR = System.getProperty("line.separator");

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String draftId = this.getOption().getVariableValue("id");
        String templateType = this.getOption().getVariableValue("templatetype");
        String payrefundDate = this.getOption().getVariableValue("payrefunddate");
        String payrefundStatus = this.getOption().getVariableValue("payrefundstatus");
        String remark = this.getOption().getVariableValue("remark");
        DynamicObject updateObject = BusinessDataServiceHelper.loadSingle((Object)Long.parseLong(draftId), (String)"gtcp_normal_draft_list");
        DynamicObjectCollection collection = updateObject.getDynamicObjectCollection("entryentity");
        String dataEntityName = updateObject.getDataEntityType().getName();
        collection.stream().forEach(row -> {
            row.set("payrefundstatus", (Object)payrefundStatus);
            row.set("payrefunddate", (Object)DateUtils.stringToDate2((String)payrefundDate));
        });
        ArrayList<DynamicObject> updateTaxpayRefundBillList = new ArrayList<DynamicObject>();
        ArrayList deleteTaxpayRefundBillList = new ArrayList();
        DynamicObject[] dynamicObjects = GtcpTaxPayRefundBussiness.queryTaxPayRefundsByDraftIdList(Collections.singletonList(Long.valueOf(draftId)));
        if (StringUtil.equalsIgnoreCase((CharSequence)payrefundStatus, (CharSequence)"payrefund")) {
            if (ObjectUtils.isEmpty((Object)dynamicObjects)) {
                AbstractGtcpTaxPayRefundStrategy taxPayRefundStrategy = GtcpTaxPayRefundStrategyFactory.getGtcpTaxPayRefundStrategyEnumByType(updateObject.getString("taxsystem.number"), updateObject.getString("taxtype.number"));
                if (ObjectUtils.isNotEmpty((Object)taxPayRefundStrategy)) {
                    updateTaxpayRefundBillList.addAll(taxPayRefundStrategy.buildTaxPayRefunds(updateObject, payrefundDate, remark));
                } else {
                    updateTaxpayRefundBillList.addAll(new AbstractGtcpTaxPayRefundStrategy().buildTaxPayRefunds(updateObject, payrefundDate, remark));
                }
            } else {
                Arrays.stream(dynamicObjects).filter(row -> StringUtil.equalsIgnoreCase((CharSequence)"nopay", (CharSequence)row.getString("payrefstatus")) || StringUtil.equalsIgnoreCase((CharSequence)"norefund", (CharSequence)row.getString("payrefstatus"))).forEach(row -> {
                    if (StringUtil.equalsIgnoreCase((CharSequence)"nopay", (CharSequence)row.getString("payrefstatus"))) {
                        row.set("payrefstatus", (Object)"pay");
                    } else {
                        row.set("payrefstatus", (Object)"refund");
                    }
                    row.set("payrefunddate", (Object)DateUtils.stringToDate2((String)payrefundDate));
                    row.set("remark", (Object)remark);
                    updateTaxpayRefundBillList.add((DynamicObject)row);
                });
            }
        } else if (StringUtil.equalsIgnoreCase((CharSequence)payrefundStatus, (CharSequence)"nopayrefund")) {
            Arrays.stream(dynamicObjects).forEach(o -> deleteTaxpayRefundBillList.add(o.getLong("id")));
        }
        ArrayList<Map<String, Object>> taxCalendarParamMapList = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject dynamicObject : updateTaxpayRefundBillList) {
            long oid = dynamicObject.getLong("org.id");
            long taxationsysId = dynamicObject.getLong("taxationsys.id");
            long taxcategoryId = dynamicObject.getLong("taxcategory.id");
            long taxareagroupId = dynamicObject.getLong("taxareagroup.id");
            HashMap<String, Long> taxCalendarParamMap = new HashMap<String, Long>(16);
            taxCalendarParamMap.put("key_orgId", oid);
            taxCalendarParamMap.put("taxationsys", taxationsysId);
            taxCalendarParamMap.put("taxcategory", taxcategoryId);
            taxCalendarParamMap.put("taxareagroup", taxareagroupId);
            taxCalendarParamMapList.add(taxCalendarParamMap);
        }
        Map<String, Map<String, Map<String, Object>>> taxcalendarMap = GtcpTaxCalendarBussiness.queryTaxCalendarSbjzrqByDateAndTaxFields(taxCalendarParamMapList, null, null);
        for (DynamicObject dataEntity : updateTaxpayRefundBillList) {
            long oid = dataEntity.getLong("org.id");
            long taxationsysId = dataEntity.getLong("taxationsys.id");
            long taxcategoryId = dataEntity.getLong("taxcategory.id");
            long taxareagroupId = dataEntity.getLong("taxareagroup.id");
            Date skssqq = dataEntity.getDate("skssqq");
            Date skssqz = dataEntity.getDate("skssqz");
            if (!ObjectUtils.isNotEmpty(taxcalendarMap)) continue;
            dataEntity.set("paymentenddate", (Object)GtcpTaxCalendarBussiness.queryTaxCalendarJkjzrq(oid, taxationsysId, taxcategoryId, taxareagroupId, skssqq, skssqz, taxcalendarMap));
        }
        try {
            SaveServiceHelper.update((DynamicObject)updateObject);
            SaveServiceHelper.save((DynamicObject[])updateTaxpayRefundBillList.toArray(new DynamicObject[0]));
            DeleteServiceHelper.delete((IDataEntityType)MetadataServiceHelper.getDataEntityType((String)"gtcp_taxpay_refund_bill"), (Object[])deleteTaxpayRefundBillList.toArray(new Long[0]));
            this.operationResult.setMessage("success");
            this.operationResult.setSuccess(true);
            OperatorDialogUtils.operateDialog((String)templateType, (String)dataEntityName, (String)ResManager.loadKDString((String)"\u786e\u8ba4\u7f34/\u9000\u7a0e", (String)"GtcpDeclarePayRefundConfirmOp_0", (String)"taxc-gtcp", (Object[])new Object[0]), (String)String.format(ResManager.loadKDString((String)"\u7f16\u53f7%s,\u786e\u8ba4\u7f34/\u9000\u7a0e\u6210\u529f", (String)"GtcpDeclarePayRefundConfirmOp_1", (String)"taxc-gtcp", (Object[])new Object[0]), updateObject.getString("billno")));
        }
        catch (Exception exception) {
            this.operationResult.setMessage(exception.getMessage() + SEPARATOR);
            this.operationResult.setSuccess(false);
            OperatorDialogUtils.operateDialog((String)templateType, (String)dataEntityName, (String)ResManager.loadKDString((String)"\u786e\u8ba4\u7f34/\u9000\u7a0e", (String)"GtcpDeclarePayRefundConfirmOp_0", (String)"taxc-gtcp", (Object[])new Object[0]), (String)exception.getMessage());
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        String draftId = this.getOption().getVariableValue("id");
        DynamicObject[] taxPayRefunds = GtcpTaxPayRefundBussiness.queryTaxPayRefundsByDraftIdList(Collections.singletonList(Long.parseLong(draftId)));
        if (EmptyCheckUtils.isNotEmpty((Object)taxPayRefunds)) {
            OverSeaMQSender.sendMQ(Collections.singletonList(Long.parseLong(draftId)), (Long)1532683517396254720L, (String)"payrefund", (String)this.billEntityType.getName());
        }
    }
}

