/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.opplugin.payrefund;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.draft.GtcpFetchDataBussiness;
import kd.taxc.gtcp.business.taxpayrefund.GtcpTaxPayRefundBussiness;
import kd.taxc.gtcp.business.taxpayrefund.strategy.AbstractGtcpTaxPayRefundStrategy;
import kd.taxc.gtcp.business.taxpayrefund.strategy.GtcpTaxPayRefundStrategyFactory;

public class GtcpCancelTaxPayRefundUpdateSaveOP
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ArrayList<Object> idList = new ArrayList<Object>(12);
                for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    long id = dataEntity.getLong("id");
                    idList.add(id);
                }
                DynamicObjectCollection dynamicObjectCollection = GtcpTaxPayRefundBussiness.queryTaxPayRefundByIdList(idList);
                ArrayList<Long> isNotCheckList = new ArrayList<Long>(12);
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)dynamicObjectCollection)) {
                    for (DynamicObject dynamicObject : dynamicObjectCollection) {
                        String payrefstatus;
                        List<String> list = Arrays.asList("pay", "refund", "noneedpay", "noneedrefund");
                        if (list.contains(payrefstatus = dynamicObject.getString("payrefstatus"))) continue;
                        isNotCheckList.add(dynamicObject.getLong("id"));
                    }
                }
                for (ExtendedDataEntity extendedDataEntity : this.dataEntities) {
                    DynamicObject dataEntity = extendedDataEntity.getDataEntity();
                    long id = dataEntity.getLong("id");
                    if (!isNotCheckList.contains(id)) continue;
                    this.addFatalErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u5f53\u524d\u6570\u636e\u5c1a\u672a\u786e\u8ba4\u7f34/\u9000\u7a0e\u3002", (String)"GtcpCancelTaxPayRefundUpdateSaveOP_0", (String)"taxc-gtcp", (Object[])new Object[0]), new Object[0]));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Object> idList = new ArrayList<Object>(12);
        ArrayList<Long> list = new ArrayList<Long>(12);
        for (DynamicObject dynamicObject : dataEntities) {
            long id = dynamicObject.getLong("id");
            idList.add(id);
            list.add(id);
        }
        DynamicObject[] dynamicObjectCollection = GtcpTaxPayRefundBussiness.queryTaxPayRefundJgByIdList(idList);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)dynamicObjectCollection)) {
            Object[] save;
            List<Long> draftIdList = Arrays.asList(dynamicObjectCollection).stream().filter(o -> "1".equals(o.getString("datasouce")) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)o.getString("draftid")) && !StringUtil.equalsIgnoreCase((CharSequence)o.getString("draftid.id"), (CharSequence)"0")).map(o -> o.getLong("draftid.id")).collect(Collectors.toList());
            Map<String, List<DynamicObject>> draftNumbersMap = GtcpTaxPayRefundBussiness.queryTaxPayRefundsByDraftIds(draftIdList, list);
            List<Long> ids = Arrays.asList(dynamicObjectCollection).stream().map(o -> o.getLong("id")).collect(Collectors.toList());
            HashMap<String, Map<String, Object>> backWriteMap = new HashMap<String, Map<String, Object>>(12);
            ArrayList<DynamicObject> updateList = new ArrayList<DynamicObject>(12);
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                String datasouce = dynamicObject.getString("datasouce");
                String payrefstatus = dynamicObject.getString("payrefstatus");
                Long taxationsys = dynamicObject.getLong("taxationsys.id");
                Long taxcategory = dynamicObject.getLong("taxcategory.id");
                Long taxareagroup = dynamicObject.getLong("taxareagroup.id");
                dynamicObject.set("payrefstatus", (Object)("pay".equals(payrefstatus) || "noneedpay".equals(payrefstatus) ? "nopay" : "norefund"));
                dynamicObject.set("payrefunddate", null);
                if ("2".equals(datasouce) || !"1".equals(datasouce)) continue;
                AbstractGtcpTaxPayRefundStrategy payRefundStrategy = GtcpTaxPayRefundStrategyFactory.getGtcpTaxPayRefundStrategyEnumByType(dynamicObject.getString("taxationsys.number"), dynamicObject.getString("taxcategory.number"));
                if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)payRefundStrategy) && payRefundStrategy.checkNoCommonTaxtype(taxationsys, taxcategory, taxareagroup, datasouce, null)) {
                    payRefundStrategy.cancelTaxRefundRelationSbDraftStatus(dynamicObject, draftNumbersMap, ids, backWriteMap);
                    continue;
                }
                String draftId = dynamicObject.getString("draftid.id");
                HashMap<String, Object> map = new HashMap<String, Object>(8);
                map.put("updateStatus", "unpayrefund");
                map.put("updateDate", null);
                map.put("taxationsys", taxationsys);
                map.put("taxcategory", taxcategory);
                backWriteMap.put(draftId, map);
            }
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(backWriteMap)) {
                DynamicObject[] dynamicObjects;
                for (DynamicObject dynamicObject : dynamicObjects = GtcpDraftBussiness.queryDraftMainDataByDraftId(draftIdList)) {
                    String id = dynamicObject.getString("id");
                    Map objectMap = (Map)backWriteMap.get(id);
                    if (org.apache.commons.lang3.ObjectUtils.isEmpty((Object)objectMap)) continue;
                    Object updateDate = objectMap.get("updateDate");
                    Object updateStatus = objectMap.get("updateStatus");
                    DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection("entryentity");
                    if (null != collection) {
                        for (DynamicObject row : collection) {
                            row.set("payrefundstatus", updateStatus);
                            row.set("payrefunddate", updateDate);
                        }
                    }
                    updateList.add(dynamicObject);
                }
            }
            if ((save = SaveServiceHelper.save((DynamicObject[])dynamicObjectCollection)).length > 0) {
                SaveServiceHelper.save((DynamicObject[])updateList.toArray(new DynamicObject[updateList.size()]));
                TaxResult listTaxResult = DeclareMainServiceHelper.queryDeclareMainByIds((Long)MultiTableEnum.getModelIdByNumber((String)MultiTableEnum.TSD001.getModel()), draftIdList);
                if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
                    HashMap params = new HashMap(12);
                    if (org.apache.commons.lang3.ObjectUtils.isNotEmpty(backWriteMap)) {
                        backWriteMap.entrySet().stream().forEach(entry -> {
                            String entrykey = (String)entry.getKey();
                            Map value = (Map)entry.getValue();
                            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)value) && value.containsKey("updateStatus")) {
                                String paystatus = GtcpFetchDataBussiness.declareMapTaxablePaystatus(value.get("updateStatus").toString());
                                HashMap<String, String> param = new HashMap<String, String>(12);
                                param.put("paystatus", paystatus);
                                params.put(Long.parseLong(entrykey), param);
                            }
                        });
                    }
                    MultiDeclareMQSender.sendMQ((DynamicObject[])((List)listTaxResult.getData()).toArray(new DynamicObject[0]), (String)"cancelpay", params);
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("unpayrefund".equals(e.getOperationKey())) {
            DynamicObject[] dynamicObjects = GtcpTaxPayRefundBussiness.queryTaxPayRefundJgByIdList(Arrays.stream(dataEntities).map(DataEntityBase::getPkValue).collect(Collectors.toList()));
            OverSeaMQSender.sendMQForPayRefund(Arrays.asList(dynamicObjects), (String)"unpayrefund");
        }
        String name = ResManager.loadKDString((String)"\u53d6\u6d88\u7f34/\u9000\u7a0e", (String)"GtcpCancelTaxPayRefundUpdateSaveOP_1", (String)"taxc-gtcp", (Object[])new Object[0]);
        String description = ResManager.loadKDString((String)"\u53d6\u6d88\u7f34/\u9000\u7a0e\u6210\u529f\uff1a%s", (String)"GtcpCancelTaxPayRefundUpdateSaveOP_2", (String)"taxc-gtcp", (Object[])new Object[0]);
        for (DynamicObject dynamicObject : dataEntities) {
            OperatorDialogUtils.operateDialog((String)"Overseas_VAT", (String)dynamicObject.getDataEntityType().getName(), (String)name, (String)String.format(description, dynamicObject.getString("billno")));
        }
    }
}

