/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.opplugin.payrefund;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;
import kd.taxc.bdtaxr.common.util.EmptyCheckUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.draft.GtcpFetchDataBussiness;
import kd.taxc.gtcp.business.taxpayrefund.GtcpTaxPayRefundBussiness;

public class GtcpTaxPayRefundDeleteOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().addAll(Arrays.asList("org", "taxationsys", "taxareagroup", "taxcategory", "skssqq", "skssqz", "draftid", "amount", "datasouce", "payrefstatus"));
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Object> idList = new ArrayList<Object>(12);
        for (DynamicObject dynamicObject : dataEntities) {
            long id = dynamicObject.getLong("id");
            idList.add(id);
        }
        DynamicObject[] dynamicObjectCollection = GtcpTaxPayRefundBussiness.queryTaxPayRefundJgByIdList(idList);
        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)dynamicObjectCollection)) {
            DynamicObject[] draftList;
            List<Long> drafIdList = Arrays.stream(dynamicObjectCollection).filter(o -> "1".equals(o.getString("datasouce")) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)o.getString("draftid.id")) && !StringUtil.equalsIgnoreCase((CharSequence)o.getString("draftid.id"), (CharSequence)"0")).map(o -> o.getLong("draftid.id")).collect(Collectors.toList());
            DynamicObject[] dynamicObjects = GtcpTaxPayRefundBussiness.queryTaxPayRefundsByDraftIdList(drafIdList);
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
                List ids = Arrays.stream(dynamicObjects).map(o -> o.getLong("id")).collect(Collectors.toList());
                DeleteServiceHelper.delete((String)"gtcp_taxpay_refund_bill", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
            }
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(draftList = GtcpDraftBussiness.queryDraftMainDataByDraftId(drafIdList)))) {
                HashMap params = new HashMap(12);
                for (DynamicObject dynamicObject : draftList) {
                    for (DynamicObject row : dynamicObject.getDynamicObjectCollection("entryentity")) {
                        row.set("payrefundstatus", (Object)"unpayrefund");
                        row.set("payrefunddate", null);
                    }
                    HashMap<String, String> param = new HashMap<String, String>(12);
                    param.put("paystatus", GtcpFetchDataBussiness.declareMapTaxablePaystatus("unpayrefund"));
                    params.put(dynamicObject.getLong("id"), param);
                }
                SaveServiceHelper.save((DynamicObject[])draftList);
                TaxResult listTaxResult = DeclareMainServiceHelper.queryDeclareMainByIds((Long)MultiTableEnum.getModelIdByNumber((String)MultiTableEnum.TSD001.getModel()), drafIdList);
                if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
                    MultiDeclareMQSender.sendMQ((DynamicObject[])((List)listTaxResult.getData()).toArray(new DynamicObject[0]), (String)"cancelpay", params);
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        List collect;
        if ("delete".equals(e.getOperationKey()) && EmptyCheckUtils.isNotEmpty(collect = Arrays.stream(e.getDataEntities()).filter(v -> StringUtil.equals((CharSequence)"pay", (CharSequence)v.getString("payrefstatus")) || StringUtil.equals((CharSequence)"refund", (CharSequence)v.getString("payrefstatus"))).collect(Collectors.toList()))) {
            OverSeaMQSender.sendMQForPayRefund(collect, (String)e.getOperationKey());
        }
    }
}

