/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.opplugin.payrefund;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.taxc.bdtaxr.common.mq.DeclareMQEvent;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.taxcalendar.GtcpTaxCalendarBussiness;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import kd.taxc.gtcp.business.taxpayrefund.GtcpTaxPayRefundBussiness;
import kd.taxc.gtcp.business.tctb.TaxPeriodBusiness;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GtcpTaxPayRefundSaveOP
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ArrayList<Long> orgList = new ArrayList<Long>(12);
                ArrayList<Long> taxationsysList = new ArrayList<Long>(12);
                ArrayList<Long> taxcategoryList = new ArrayList<Long>(12);
                ArrayList<Long> taxareagroupList = new ArrayList<Long>(12);
                ArrayList<Map<String, Object>> taxYearParamMapList = new ArrayList<Map<String, Object>>(16);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    long oid = dataEntity.getDataEntity().getLong("org.id");
                    long taxationsysId = dataEntity.getDataEntity().getLong("taxationsys.id");
                    long taxcategoryId = dataEntity.getDataEntity().getLong("taxcategory.id");
                    long taxareagroupId = dataEntity.getDataEntity().getLong("taxareagroup.id");
                    orgList.add(oid);
                    taxationsysList.add(taxationsysId);
                    taxcategoryList.add(taxcategoryId);
                    taxareagroupList.add(taxareagroupId);
                    HashMap<String, Long> taxYearParamMap = new HashMap<String, Long>(16);
                    taxYearParamMap.put("key_orgId", oid);
                    taxYearParamMap.put("key_taxationsysId", taxationsysId);
                    taxYearParamMap.put("key_taxcategoryId", taxcategoryId);
                    taxYearParamMapList.add(taxYearParamMap);
                }
                Map<String, Map<String, Map<String, Map<String, List<String>>>>> taxcMainInfoMap = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgList, null);
                DynamicObject[] dynamicObjects = GtcpTaxPayRefundBussiness.queryTaxPayRefund(orgList, taxationsysList, taxcategoryList, taxareagroupList);
                HashMap recordMap = new HashMap(12);
                HashMap<String, String> billnoMap = new HashMap<String, String>(12);
                if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
                    for (DynamicObject dynamicObject : dynamicObjects) {
                        String id = dynamicObject.getString("id");
                        long oid = dynamicObject.getLong("org.id");
                        long taxationsysId = dynamicObject.getLong("taxationsys.id");
                        long taxcategoryId = dynamicObject.getLong("taxcategory.id");
                        long taxareagroupId = dynamicObject.getLong("taxareagroup.id");
                        String mapkey = oid + "_" + taxationsysId + "_" + taxcategoryId + "_" + taxareagroupId;
                        if (!recordMap.containsKey(mapkey)) {
                            recordMap.put(mapkey, new HashMap(2));
                        }
                        billnoMap.put(id, dynamicObject.getString("billno"));
                        ((Map)recordMap.get(mapkey)).put(id, ImmutablePair.of((Object)dynamicObject.getDate("skssqq"), (Object)dynamicObject.getDate("skssqz")));
                    }
                }
                Map<String, Date> taxPeriodStartDateMap = TaxPeriodBusiness.getOrgTaxPeriodStartDateMap(taxYearParamMapList);
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    Map objectMap;
                    String id = dataEntity.getDataEntity().getString("id");
                    String billno = dataEntity.getDataEntity().getString("billno");
                    long orgId = dataEntity.getDataEntity().getLong("org.id");
                    long taxationsysId = dataEntity.getDataEntity().getLong("taxationsys.id");
                    long taxcategoryId = dataEntity.getDataEntity().getLong("taxcategory.id");
                    long taxareagroupId = dataEntity.getDataEntity().getLong("taxareagroup.id");
                    Date skssqq = dataEntity.getDataEntity().getDate("skssqq");
                    Date skssqz = dataEntity.getDataEntity().getDate("skssqz");
                    if (!taxcMainInfoMap.containsKey(String.valueOf(orgId)) || !taxcMainInfoMap.get(String.valueOf(orgId)).containsKey(String.valueOf(taxationsysId))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u5408\u8981\u6c42\u7684\u7a0e\u52a1\u7ec4\u7ec7\u4fe1\u606f/\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f\u3002", (String)"GtcpTaxPayRefundSaveOP_0", (String)"taxc-gtcp", (Object[])new Object[0]));
                        continue;
                    }
                    if (!taxcMainInfoMap.get(String.valueOf(orgId)).get(String.valueOf(taxationsysId)).containsKey(String.valueOf(taxcategoryId)) || !taxcMainInfoMap.get(String.valueOf(orgId)).get(String.valueOf(taxationsysId)).get(String.valueOf(taxcategoryId)).containsKey(String.valueOf(taxareagroupId))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u7ef4\u62a4\u5408\u8981\u6c42\u7684\u7eb3\u7a0e\u4e3b\u4f53\u4fe1\u606f-\u7a0e\u79cd\u4fe1\u606f\u3002", (String)"GtcpTaxPayRefundSaveOP_1", (String)"taxc-gtcp", (Object[])new Object[0]));
                        continue;
                    }
                    Long coin = dataEntity.getDataEntity().getLong("coin.id");
                    if (ObjectUtils.isNotEmpty((Object)coin) && !coin.equals(dataEntity.getDataEntity().getLong("taxationsys.currency.id"))) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u5e01\u522b\u4e0e\u6b64\u7a0e\u6536\u5236\u5ea6\u4e0b\u7684\u5e01\u522b\u4e0d\u76f8\u7b26\u3002", (String)"GtcpTaxPayRefundSaveOP_2", (String)"taxc-gtcp", (Object[])new Object[0]));
                        continue;
                    }
                    Date newStartDate = TaxPeriodBusiness.getTaxPeriodStartDateByCondition(orgId, taxationsysId, taxcategoryId, taxPeriodStartDateMap);
                    if (ObjectUtils.isEmpty((Object)newStartDate)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7eb3\u7a0e\u671f\u95f4\u3002", (String)"GtcpTaxPayRefundSaveOP_3", (String)"taxc-gtcp", (Object[])new Object[0]));
                        continue;
                    }
                    List<String> provisionPeriodList = taxcMainInfoMap.get(String.valueOf(orgId)).get(String.valueOf(taxationsysId)).get(String.valueOf(taxcategoryId)).get(String.valueOf(taxareagroupId));
                    if (ObjectUtils.isEmpty(provisionPeriodList)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u627e\u5230\u53ef\u7528\u7684\u7f34\u7eb3\u671f\u9650\u3002", (String)"GtcpTaxPayRefundSaveOP_4", (String)"taxc-gtcp", (Object[])new Object[0]));
                        continue;
                    }
                    ImmutablePair<Date, Date> dateImmutablePair = TaxPeriodBusiness.calDate(newStartDate, skssqq, skssqz);
                    if (ObjectUtils.isEmpty(dateImmutablePair)) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u4e0e\u9002\u7528\u7684\u7eb3\u7a0e\u671f\u95f4\u53ca\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GtcpTaxPayRefundSaveOP_5", (String)"taxc-gtcp", (Object[])new Object[0]));
                        continue;
                    }
                    Boolean validDates = GtcpTaxPayRefundSaveOP.this.isValidDates((Date)dateImmutablePair.left, (Date)dateImmutablePair.right, provisionPeriodList.toArray(new String[provisionPeriodList.size()]));
                    if (!validDates.booleanValue()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u8d77\u6b62\u4e0e\u9002\u7528\u7684\u7eb3\u7a0e\u671f\u95f4\u53ca\u7f34\u7eb3\u671f\u9650\u4e0d\u7b26\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GtcpTaxPayRefundSaveOP_5", (String)"taxc-gtcp", (Object[])new Object[0]));
                        continue;
                    }
                    String mapkey = orgId + "_" + taxationsysId + "_" + taxcategoryId + "_" + taxareagroupId;
                    boolean isChecked = true;
                    if (recordMap.containsKey(mapkey) && ObjectUtils.isNotEmpty((Object)(objectMap = (Map)recordMap.get(mapkey)))) {
                        for (Map.Entry next : objectMap.entrySet()) {
                            int leftMonth;
                            if (((String)next.getKey()).equals(id)) continue;
                            ImmutablePair immutablePair = (ImmutablePair)next.getValue();
                            Date left = (Date)immutablePair.left;
                            Date right = (Date)immutablePair.right;
                            if (skssqz.getTime() < left.getTime() || skssqq.getTime() > right.getTime() || left.getTime() == skssqq.getTime()) continue;
                            int skssqqMonth = DateUtils.getMonthOfDate((Date)skssqq);
                            if (skssqqMonth != (leftMonth = DateUtils.getMonthOfDate((Date)left))) {
                                int month = skssqqMonth - leftMonth;
                                month = -month;
                                if (left.getTime() == DateUtils.addMonth((Date)skssqq, (int)month).getTime()) continue;
                            }
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u7a0e\u6b3e\u6240\u5c5e\u671f\u4e0e\u540c\u4e00\u7a0e\u52a1\u7ec4\u7ec7\u3001\u7a0e\u6536\u5236\u5ea6\u3001\u7a0e\u79cd\u3001\u7a0e\u6536\u8f96\u533a\u6570\u636e\uff1a%s\u7684\u7a0e\u6b3e\u6240\u5c5e\u671f\u5b58\u5728\u4ea4\u96c6\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GtcpTaxPayRefundSaveOP_6", (String)"taxc-gtcp", (Object[])new Object[0]), billnoMap.get(next.getKey())));
                            isChecked = false;
                            break;
                        }
                    }
                    if (!isChecked) continue;
                    if (!recordMap.containsKey(mapkey)) {
                        recordMap.put(mapkey, new HashMap(2));
                    }
                    if (((Map)recordMap.get(mapkey)).containsKey(id)) continue;
                    ((Map)recordMap.get(mapkey)).put(id, ImmutablePair.of((Object)skssqq, (Object)skssqz));
                    billnoMap.put(id, billno);
                }
            }
        });
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        super.beforeExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<Map<String, Object>> taxCalendarParamMapList = new ArrayList<Map<String, Object>>(16);
        for (DynamicObject dataEntity : dataEntities) {
            long oid = dataEntity.getLong("org.id");
            long taxationsysId = dataEntity.getLong("taxationsys.id");
            long taxcategoryId = dataEntity.getLong("taxcategory.id");
            long taxareagroupId = dataEntity.getLong("taxareagroup.id");
            HashMap<String, Long> taxCalendarParamMap = new HashMap<String, Long>(16);
            taxCalendarParamMap.put("key_orgId", oid);
            taxCalendarParamMap.put("taxationsys", taxationsysId);
            taxCalendarParamMap.put("taxcategory", taxcategoryId);
            taxCalendarParamMap.put("taxareagroup", taxareagroupId);
            taxCalendarParamMapList.add(taxCalendarParamMap);
        }
        Map<String, Map<String, Map<String, Object>>> taxcalendarMap = GtcpTaxCalendarBussiness.queryTaxCalendarSbjzrqByDateAndTaxFields(taxCalendarParamMapList, null, null);
        for (DynamicObject dynamicObject : dataEntities) {
            long oid = dynamicObject.getLong("org.id");
            long taxationsysId = dynamicObject.getLong("taxationsys.id");
            long taxcategoryId = dynamicObject.getLong("taxcategory.id");
            long taxareagroupId = dynamicObject.getLong("taxareagroup.id");
            Date skssqq = dynamicObject.getDate("skssqq");
            Date skssqz = dynamicObject.getDate("skssqz");
            String taxestype = dynamicObject.getString("taxestype");
            Date payrefunddate = dynamicObject.getDate("payrefunddate");
            String status = "nopay";
            if ("pay".equals(taxestype) && ObjectUtils.isNotEmpty((Object)payrefunddate)) {
                status = "pay";
            }
            if ("refund".equals(taxestype)) {
                status = ObjectUtils.isNotEmpty((Object)payrefunddate) ? "refund" : "norefund";
            }
            dynamicObject.set("payrefstatus", (Object)status);
            if (!ObjectUtils.isNotEmpty(taxcalendarMap)) continue;
            dynamicObject.set("paymentenddate", (Object)GtcpTaxCalendarBussiness.queryTaxCalendarJkjzrq(oid, taxationsysId, taxcategoryId, taxareagroupId, skssqq, skssqz, taxcalendarMap));
        }
    }

    protected Boolean isValidDates(Date startDate, Date endDate, String[] taxLimits) {
        boolean isvalid = Boolean.FALSE;
        for (String taxLimit : taxLimits) {
            boolean temp = DateUtils.validDateRange((String)taxLimit, (Date)startDate, (Date)endDate);
            isvalid |= temp;
        }
        if (!isvalid) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if (DeclareMQEvent.SAVE.name().toLowerCase().equals(e.getOperationKey())) {
            OverSeaMQSender.sendMQForPayRefund(Arrays.asList(dataEntities), (String)DeclareMQEvent.SAVE.name().toLowerCase());
        }
    }
}

