/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.opplugin.payrefund;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.DeclareMainServiceHelper;
import kd.taxc.bdtaxr.common.mq.MultiDeclareMQSender;
import kd.taxc.bdtaxr.common.mq.oversea.OverSeaMQSender;
import kd.taxc.bdtaxr.common.util.OperatorDialogUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.draft.GtcpFetchDataBussiness;
import kd.taxc.gtcp.business.taxpayrefund.GtcpTaxPayRefundBussiness;
import kd.taxc.gtcp.business.taxpayrefund.strategy.AbstractGtcpTaxPayRefundStrategy;
import kd.taxc.gtcp.business.taxpayrefund.strategy.GtcpTaxPayRefundStrategyFactory;

public class GtcpTaxPayRefundUpdateSaveOP
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                ArrayList<Long> draftIdList = new ArrayList<Long>(12);
                ArrayList<Long> idList = new ArrayList<Long>(12);
                for (ExtendedDataEntity entityDataEntity : this.dataEntities) {
                    DynamicObject dataEntity = entityDataEntity.getDataEntity();
                    Long draftid = dataEntity.getLong("draftid.id");
                    Long id = dataEntity.getLong("id");
                    String payrefstatus = dataEntity.getString("payrefstatus");
                    AbstractGtcpTaxPayRefundStrategy strategyEnumByType = GtcpTaxPayRefundStrategyFactory.getGtcpTaxPayRefundStrategyEnumByType(dataEntity.getString("taxationsys.number"), dataEntity.getString("taxcategory.number"));
                    if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)strategyEnumByType) && strategyEnumByType.checkNoCommonTaxtype(dataEntity) && ("noneedpay".equals(payrefstatus) || "noneedrefund".equals(payrefstatus))) {
                        draftIdList.add(draftid);
                    }
                    idList.add(id);
                }
                Map<String, List<DynamicObject>> draftNumbersMap = GtcpTaxPayRefundBussiness.queryTaxPayRefundsByDraftIds(draftIdList);
                for (ExtendedDataEntity entityDataEntity : this.dataEntities) {
                    DynamicObject dataEntity = entityDataEntity.getDataEntity();
                    String draftId = dataEntity.getString("draftid.id");
                    String draftnumber = dataEntity.getString("draftid.billno");
                    List<DynamicObject> dynamicObjectList = draftNumbersMap.get(draftId);
                    if (!org.apache.commons.lang3.ObjectUtils.isNotEmpty(dynamicObjectList)) continue;
                    boolean isAllNoNeed = true;
                    String paystatus = "pay";
                    for (DynamicObject dynamicObject : dynamicObjectList) {
                        if (idList.contains(dynamicObject.getLong("id"))) continue;
                        String taxestype = dynamicObject.getString("taxestype");
                        String status = dynamicObject.getString("payrefstatus");
                        List<String> list = Arrays.asList("pay", "refund", "nopay", "norefund");
                        if (!list.contains(status)) continue;
                        paystatus = taxestype;
                        isAllNoNeed = false;
                        break;
                    }
                    if (!isAllNoNeed) continue;
                    paystatus = paystatus.equalsIgnoreCase("pay") ? ResManager.loadKDString((String)"\u65e0\u9700\u7f34\u7a0e", (String)"GtcpTaxPayRefundUpdateSaveOP_0", (String)"taxc-gtcp", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u65e0\u9700\u9000\u7a0e", (String)"GtcpTaxPayRefundUpdateSaveOP_1", (String)"taxc-gtcp", (Object[])new Object[0]);
                    this.addFatalErrorMessage(entityDataEntity, String.format(ResManager.loadKDString((String)"\u6240\u9009\u72b6\u6001\u5c06\u5bfc\u81f4\u5e95\u7a3f\uff1a%1$s\u6240\u6709\u76f8\u5173\u7684\u7a0e\u91d1\u7f34\u7eb3/\u9000\u8fd8\u5355\u5747%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"GtcpTaxPayRefundUpdateSaveOP_2", (String)"taxc-gtcp", (Object[])new Object[0]), draftnumber, paystatus));
                }
            }
        });
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        if ("payrefundsave".equals(operationKey)) {
            List<Long> draftIdList = Arrays.stream(dataEntities).filter(o -> org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)o.getString("draftid.id")) && !StringUtil.equalsIgnoreCase((CharSequence)o.getString("draftid.id"), (CharSequence)"0")).map(o -> o.getLong("draftid.id")).collect(Collectors.toList());
            HashMap<String, Map<String, Object>> updateMap = new HashMap<String, Map<String, Object>>(12);
            ArrayList<Long> idList = new ArrayList<Long>(12);
            for (DynamicObject dynamicObject2 : dataEntities) {
                String datasouce = dynamicObject2.getString("datasouce");
                if (!"1".equals(datasouce)) continue;
                String draftId = dynamicObject2.getString("draftid.id");
                String payrefstatus = dynamicObject2.getString("payrefstatus");
                Date payrefunddate = dynamicObject2.getDate("payrefunddate");
                HashMap<String, Object> map = new HashMap<String, Object>(4);
                map.put("payrefstatus", payrefstatus);
                map.put("payrefunddate", payrefunddate);
                idList.add(dynamicObject2.getLong("id"));
                map.put("id", dynamicObject2.getLong("id"));
                updateMap.put(draftId, map);
            }
            DynamicObject[] dynamicObjects = GtcpDraftBussiness.queryDraftMainDataByDraftId(draftIdList);
            Map<String, List<DynamicObject>> draftIdsMap = GtcpTaxPayRefundBussiness.queryTaxPayRefundsByDraftIds(draftIdList, idList);
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
                for (DynamicObject dynamicObject3 : dynamicObjects) {
                    Long taxationsys = dynamicObject3.getLong("taxsystem.id");
                    Long taxcategory = dynamicObject3.getLong("taxtype.id");
                    long taxareagroup = dynamicObject3.getLong("taxareagroup.id");
                    AbstractGtcpTaxPayRefundStrategy payRefundStrategy = GtcpTaxPayRefundStrategyFactory.getGtcpTaxPayRefundStrategyEnumByType(dynamicObject3.getString("taxsystem.number"), dynamicObject3.getString("taxtype.number"));
                    if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)payRefundStrategy) && payRefundStrategy.checkNoCommonTaxtype(taxationsys, taxcategory, taxareagroup, "1", null)) {
                        payRefundStrategy.verifyTaxRefundRelationSbDraftStatus(dynamicObject3, draftIdsMap, updateMap);
                        continue;
                    }
                    String draftId = dynamicObject3.getString("id");
                    Map dataMap = updateMap.containsKey(draftId) ? (Map)updateMap.get(draftId) : new HashMap();
                    String payrefstatus = org.apache.commons.lang3.ObjectUtils.isNotEmpty(dataMap.get("payrefstatus")) ? dataMap.get("payrefstatus").toString() : "";
                    String status = "pay".equals(payrefstatus) || "refund".equals(payrefstatus) ? "payrefund" : "nopayrefund";
                    Object payrefunddate = dataMap.get("payrefunddate");
                    DynamicObjectCollection collection = dynamicObject3.getDynamicObjectCollection("entryentity");
                    if (null == collection) continue;
                    for (DynamicObject row : collection) {
                        row.set("payrefundstatus", (Object)status);
                        row.set("payrefunddate", payrefunddate);
                    }
                }
                SaveServiceHelper.save((DynamicObject[])dynamicObjects);
                TaxResult listTaxResult = DeclareMainServiceHelper.queryDeclareMainByIds((Long)MultiTableEnum.getModelIdByNumber((String)MultiTableEnum.TSD001.getModel()), draftIdList);
                if (!ObjectUtils.isEmpty((Object)listTaxResult) && listTaxResult.isSuccess() && !ObjectUtils.isEmpty((Object)listTaxResult.getData())) {
                    HashMap params = new HashMap(12);
                    Arrays.stream(dynamicObjects).forEach(dynamicObject -> {
                        DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                        if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)dynamicObjectCollection)) {
                            String paystatus = GtcpFetchDataBussiness.declareMapTaxablePaystatus(((DynamicObject)dynamicObjectCollection.get(0)).getString("payrefundstatus"));
                            HashMap<String, String> param = new HashMap<String, String>(12);
                            param.put("paystatus", paystatus);
                            params.put(dynamicObject.getLong("id"), param);
                        }
                    });
                    MultiDeclareMQSender.sendMQ((DynamicObject[])((List)listTaxResult.getData()).toArray(new DynamicObject[0]), (String)"cancelpay", params);
                }
            }
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        DynamicObject[] dataEntities = e.getDataEntities();
        if ("payrefundsave".equals(e.getOperationKey())) {
            OverSeaMQSender.sendMQForPayRefund(Arrays.asList(dataEntities), (String)"payrefund");
        }
        String name = ResManager.loadKDString((String)"\u786e\u8ba4\u7f34/\u9000\u7a0e", (String)"GtcpTaxPayRefundUpdateSaveOP_3", (String)"taxc-gtcp", (Object[])new Object[0]);
        String description = ResManager.loadKDString((String)"\u53d6\u6d88\u7f34/\u9000\u7a0e\u6210\u529f\uff1a%s", (String)"GtcpTaxPayRefundUpdateSaveOP_4", (String)"taxc-gtcp", (Object[])new Object[0]);
        for (DynamicObject dynamicObject : dataEntities) {
            OperatorDialogUtils.operateDialog((String)"Overseas_VAT", (String)dynamicObject.getDataEntityType().getName(), (String)name, (String)String.format(description, dynamicObject.getString("billno")));
        }
    }
}

