/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.opplugin.sharedplan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.taxc.gtcp.business.taxorg.GtcpCombineBusiness;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class SharedPlanOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        final List<Long> allTaxOrgs = GtcpCombineBusiness.getAllTaxOrgs("gtcp_shardingplan");
        e.getValidators().add(new AbstractValidator(){

            public void validate() {
                for (ExtendedDataEntity dataEntity : this.dataEntities) {
                    DynamicObject currentObj = dataEntity.getDataEntity();
                    long taxareagroup = currentObj.get("taxareagroup") == null ? 0L : currentObj.getLong("taxareagroup.id");
                    Long taxcategory = currentObj.get("taxcategory") == null ? 0L : currentObj.getLong("taxcategory.id");
                    Long taxSys = currentObj.get("taxationsys") == null ? 0L : currentObj.getLong("taxationsys.id");
                    DynamicObjectCollection rules = currentObj.getDynamicObjectCollection("ruleentity");
                    DynamicObjectCollection orgs = currentObj.getDynamicObjectCollection("orgentity");
                    if (rules.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SharedPlanOp_0", (String)"taxc-gtcp", (Object[])new Object[0]));
                        continue;
                    }
                    if (orgs.isEmpty()) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5171\u4eab\u7ec4\u7ec7\u8303\u56f4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SharedPlanOp_1", (String)"taxc-gtcp", (Object[])new Object[0]));
                        continue;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)rules) && ((DynamicObject)rules.get(0)).get("rule") instanceof Long) {
                        List ruleIds = rules.stream().map(o -> o.getLong("rule")).collect(Collectors.toList());
                        QFilter qFilter = new QFilter("id", "in", ruleIds);
                        DynamicObjectCollection collection = QueryServiceHelper.query((String)"gtcp_accessconfig", (String)"id,number,accessproject.id,taxationsys.id", (QFilter[])new QFilter[]{qFilter});
                        Set set = collection.stream().map(o -> o.getLong("accessproject.id")).collect(Collectors.toSet());
                        if (rules.size() > set.size()) {
                            StringBuilder info = new StringBuilder();
                            collection.forEach(o -> {
                                if (!set.remove(o.getLong("accessproject.id"))) {
                                    info.append(o.getString("number")).append(' ');
                                }
                            });
                            this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u6570\u9879\u76ee\u76f8\u540c\u7684\u53d6\u6570\u89c4\u5219\uff1a%1$s\u3002", (String)"SharedPlanOp_2", (String)"taxc-gtcp", (Object[])new Object[0]), info));
                            continue;
                        }
                    }
                    if (CollectionUtils.isNotEmpty((Collection)rules) && ((DynamicObject)rules.get(0)).get("rule") instanceof DynamicObject && this.checkRuleWhenImport(dataEntity, taxareagroup, taxcategory, taxSys, rules) || orgs.isEmpty() || !(((DynamicObject)orgs.get(0)).get("org") instanceof DynamicObject)) continue;
                    this.checkOgrWhenImport(dataEntity, currentObj, taxareagroup, taxcategory, taxSys, orgs);
                }
            }

            private void checkOgrWhenImport(ExtendedDataEntity dataEntity, DynamicObject currentObj, long taxareagroup, Long taxcategory, Long taxSys, DynamicObjectCollection orgs) {
                boolean orgCheckResult = false;
                for (DynamicObject org : orgs) {
                    if (org.get("org") != null && !StringUtils.isEmpty((CharSequence)((DynamicObject)org.get("org")).getString("number"))) continue;
                    orgCheckResult = true;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SharedPlanOp_3", (String)"taxc-gtcp", (Object[])new Object[0]));
                }
                if (orgCheckResult) {
                    return;
                }
                Set orgSet = orgs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toSet());
                if (orgs.size() > orgSet.size()) {
                    StringBuilder info = new StringBuilder();
                    orgs.forEach(o -> {
                        if (!orgSet.remove(o.getLong("org.id"))) {
                            info.append(o.getString("org.number")).append(' ');
                        }
                    });
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\u5b58\u5728\u91cd\u590d\u7684\u5171\u4eab\u7ec4\u7ec7\u3002", (String)"SharedPlanOp_4", (String)"taxc-gtcp", (Object[])new Object[0]), info));
                    return;
                }
                List orgsList = orgs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toList());
                QFilter statusQ = new QFilter("status", "!=", (Object)"1");
                QFilter idQ = new QFilter("id", "in", (Object)orgsList.toArray());
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"bastax_taxorg", (String)"id,org.number,org.name", (QFilter[])new QFilter[]{idQ});
                Set taxOrgIds = collection.stream().map(m -> m.getLong("id")).collect(Collectors.toSet());
                List<DynamicObject> noTaxOrg = orgs.stream().filter(m -> !taxOrgIds.contains(m.getLong("org.id"))).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(noTaxOrg)) {
                    StringBuilder info = new StringBuilder();
                    noTaxOrg.forEach(o -> info.append(o.getString("org.number")).append(' '));
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u4e3a\u975e\u7a0e\u52a1\u7ec4\u7ec7\u3002", (String)"SharedPlanOp_5", (String)"taxc-gtcp", (Object[])new Object[0]), info));
                    return;
                }
                collection = QueryServiceHelper.query((String)"bastax_taxorg", (String)"org.number,org.name", (QFilter[])new QFilter[]{statusQ, idQ});
                if (!collection.isEmpty()) {
                    StringBuilder info = new StringBuilder();
                    collection.forEach(o -> info.append(o.getString("org.number")).append(' '));
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u88ab\u7981\u7528\u3002", (String)"SharedPlanOp_6", (String)"taxc-gtcp", (Object[])new Object[0]), info));
                    return;
                }
                for (Long orgId : orgsList) {
                    if (allTaxOrgs.contains(orgId)) continue;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8be5\u7ec4\u7ec7\u4e0d\u6ee1\u8db3\u6821\u9a8c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"SharedPlanOp_7", (String)"taxc-gtcp", (Object[])new Object[0]));
                    return;
                }
                ArrayList otherOrgList = new ArrayList();
                Arrays.stream(this.dataEntities).forEach(o -> {
                    long localtaxareagroup;
                    DynamicObject obj = o.getDataEntity();
                    long localTaxSys = obj.get("taxationsys") == null ? 0L : obj.getLong("taxationsys.id");
                    long localtaxcategory = obj.get("taxcategory") == null ? 0L : obj.getLong("taxcategory.id");
                    long l = localtaxareagroup = obj.get("taxareagroup") == null ? 0L : obj.getLong("taxareagroup.id");
                    if (localTaxSys != 0L && !StringUtils.equalsIgnoreCase((CharSequence)obj.getString("id"), (CharSequence)currentObj.getString("id"))) {
                        DynamicObjectCollection dynamicObjects = obj.getDynamicObjectCollection("orgentity");
                        otherOrgList.addAll(dynamicObjects.stream().map(row -> row.getLong("org.id") + "#" + localTaxSys + "#" + localtaxcategory + "#" + localtaxareagroup).collect(Collectors.toList()));
                    }
                });
                List orgsStrList = orgs.stream().map(o -> o.getLong("org.id") + "#" + taxSys + "#" + taxcategory + "#" + taxareagroup).collect(Collectors.toList());
                List intersection = (List)CollectionUtils.intersection(otherOrgList, orgsList);
                if (intersection.isEmpty()) {
                    QFilter idFilter = new QFilter("id", "!=", currentObj.get("id"));
                    List orgIds = orgs.stream().map(o -> o.getLong("org.id")).collect(Collectors.toList());
                    QFilter orgQ = new QFilter("orgentity.org", "in", orgIds);
                    QFilter taxQ = new QFilter("taxationsys", "=", (Object)taxSys);
                    QFilter taxcategoryQ = new QFilter("taxcategory", "=", (Object)taxcategory);
                    QFilter taxareagroupQ = taxareagroup == 0L ? new QFilter("taxareagroup", "is null", null) : new QFilter("taxareagroup", "=", (Object)taxareagroup);
                    DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"gtcp_shardingplan", (String)"orgentity.org.id", (QFilter[])new QFilter[]{idFilter, orgQ, taxQ, taxcategoryQ, taxareagroupQ});
                    dynamicObjectCollection.forEach(row -> intersection.add(row.getLong("orgentity.org.id") + "#" + taxSys + "#" + taxcategory + "#" + taxareagroup));
                }
                if (!intersection.isEmpty()) {
                    StringBuilder error = new StringBuilder();
                    List dupOrgs = intersection.stream().map(m -> m.split("#")[0]).collect(Collectors.toList());
                    orgs.forEach(o -> {
                        if (dupOrgs.contains(o.getString("org.id")) && !error.toString().contains(o.getString("org.number"))) {
                            error.append(o.getString("org.number")).append(' ');
                        }
                    });
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"%1$s\uff1a\u7ec4\u7ec7\u5df2\u914d\u7f6e\u5171\u4eab\u65b9\u6848\u3002", (String)"SharedPlanOp_8", (String)"taxc-gtcp", (Object[])new Object[0]), error));
                }
            }

            private boolean checkRuleWhenImport(ExtendedDataEntity dataEntity, long taxareagroup, Long taxcategory, Long taxSys, DynamicObjectCollection rules) {
                boolean flag = false;
                for (DynamicObject rule : rules) {
                    if (rule.get("rule") != null && !StringUtils.isEmpty((CharSequence)((DynamicObject)rule.get("rule")).getString("number"))) continue;
                    flag = true;
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5171\u4eab\u89c4\u5219\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"SharedPlanOp_9", (String)"taxc-gtcp", (Object[])new Object[0]));
                }
                if (flag) {
                    return true;
                }
                Set ruleSet = rules.stream().filter(o -> null != o.getDynamicObject("rule")).map(o -> o.getDynamicObject("rule").getLong("id")).collect(Collectors.toSet());
                if (rules.size() > ruleSet.size()) {
                    StringBuilder info = new StringBuilder();
                    rules.forEach(o -> {
                        if (!ruleSet.remove(o.getLong("rule.id"))) {
                            info.append(o.getString("rule.number")).append(' ');
                        }
                    });
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u6570\u9879\u76ee\u76f8\u540c\u7684\u53d6\u6570\u89c4\u5219\uff1a%1$s\u3002", (String)"SharedPlanOp_2", (String)"taxc-gtcp", (Object[])new Object[0]), info));
                    return true;
                }
                Set fetchItemSet = rules.stream().filter(o -> null != o.getDynamicObject("rule")).map(o -> o.getDynamicObject("rule").getLong("accessproject.id")).collect(Collectors.toSet());
                if (rules.size() > fetchItemSet.size()) {
                    StringBuilder info = new StringBuilder();
                    rules.forEach(o -> {
                        if (o.getDynamicObject("rule") != null && !fetchItemSet.remove(o.getDynamicObject("rule").getLong("accessproject.id"))) {
                            info.append(o.getString("rule.number")).append(' ');
                        }
                    });
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u5b58\u5728\u53d6\u6570\u9879\u76ee\u76f8\u540c\u7684\u53d6\u6570\u89c4\u5219\uff1a%1$s\u3002", (String)"SharedPlanOp_2", (String)"taxc-gtcp", (Object[])new Object[0]), info));
                    return true;
                }
                rules.forEach(o -> {
                    if (!StringUtils.equalsIgnoreCase((CharSequence)o.getString("rule.enable"), (CharSequence)"1")) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6b64\u53d6\u6570\u89c4\u5219\u672a\u542f\u7528\u3002", (String)"SharedPlanOp_10", (String)"taxc-gtcp", (Object[])new Object[0]));
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)o.getString("rule.ruletype"), (CharSequence)"public")) {
                        this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u53ea\u6709\u53ef\u5206\u914d\u89c4\u5219\u53ef\u4ee5\u5171\u4eab\u3002", (String)"SharedPlanOp_11", (String)"taxc-gtcp", (Object[])new Object[0]));
                    }
                });
                QFilter qFilter = new QFilter("id", "in", ruleSet);
                DynamicObjectCollection collection = QueryServiceHelper.query((String)"gtcp_accessconfig", (String)"id,number,accessproject.id,taxationsys.id,taxcategory.id,taxareagroup.id", (QFilter[])new QFilter[]{qFilter});
                Set taxSysSet = collection.stream().map(m -> m.getLong("taxationsys.id")).collect(Collectors.toSet());
                if (!CollectionUtils.isNotEmpty(taxSysSet) || taxSysSet.size() != 1 || !((Long)taxSysSet.stream().findFirst().get()).equals(taxSys)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6536\u5236\u5ea6\u4e0d\u4e00\u81f4\u3002", (String)"SharedPlanOp_12", (String)"taxc-gtcp", (Object[])new Object[0]));
                    return true;
                }
                Set taxcategorySet = collection.stream().map(m -> m.getLong("taxcategory.id")).collect(Collectors.toSet());
                if (!CollectionUtils.isNotEmpty(taxcategorySet) || taxcategorySet.size() != 1 || !((Long)taxcategorySet.stream().findFirst().get()).equals(taxcategory)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u79cd\u4e0d\u4e00\u81f4\u3002", (String)"SharedPlanOp_13", (String)"taxc-gtcp", (Object[])new Object[0]));
                    return true;
                }
                Set taxareagroupSet = collection.stream().map(m -> m.getLong("taxareagroup.id")).collect(Collectors.toSet());
                if (!CollectionUtils.isNotEmpty(taxareagroupSet) || taxareagroupSet.size() != 1 || !((Long)taxareagroupSet.stream().findFirst().get()).equals(taxareagroup)) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u7a0e\u6536\u533a\u57df\u4e0d\u4e00\u81f4\u3002", (String)"SharedPlanOp_14", (String)"taxc-gtcp", (Object[])new Object[0]));
                    return true;
                }
                QFilter taxCategoryFilter = new QFilter("taxationsysid", "=", (Object)taxSys).and("id", "=", (Object)taxcategory);
                boolean exists = QueryServiceHelper.exists((String)"bd_taxcategory", (QFilter[])new QFilter[]{taxCategoryFilter});
                if (!exists) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5f53\u524d\u7a0e\u79cd\u4e0e\u7a0e\u6536\u5236\u5ea6\u4e0d\u5339\u914d\u3002", (String)"SharedPlanOp_15", (String)"taxc-gtcp", (Object[])new Object[0]));
                    return true;
                }
                return false;
            }
        });
    }
}

