/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.mservice.api;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.taxc.bdtaxr.common.taxdeclare.dto.AccrualListDto;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.taxdeclare.taxrange.TaxableListQueryService;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface GtcpTaxableListQueryService
extends TaxableListQueryService {
    public static final Logger log = LoggerFactory.getLogger(GtcpTaxableListQueryService.class);

    default public List<Map<String, Object>> queryDeclareTaxableList(List<Long> orgList, List<String> declareCategories, Date declareDate) {
        return new ArrayList<Map<String, Object>>(0);
    }

    default public List<Map<String, Object>> queryDraftTaxableList(List<Long> orgList, List<String> draftCategories, Date declareDate) {
        log.info("GtcpTaxableListQueryServiceImpl queryDraftTaxableList \u8bf7\u6c42\u53c2\u6570\uff1aorgList\uff1a{}\uff0cdraftCategories\uff1a{}\uff0cdeclareDate\uff1a{}", new Object[]{orgList, draftCategories, declareDate});
        ArrayList taxableListDtos = ObjectUtils.isNotEmpty(draftCategories) && ObjectUtils.isNotEmpty(orgList) ? this.queryTaxableList(orgList, draftCategories, declareDate) : new ArrayList();
        return taxableListDtos.stream().map(a -> a.transformToMap()).collect(Collectors.toList());
    }

    default public List<Map<String, Object>> queryAccrualList(List<Long> orgList, List<String> draftCategories, Date declareDate) {
        log.info("GtcpTaxableListQueryServiceImpl queryDraftTaxableList \u8bf7\u6c42\u53c2\u6570\uff1aorgList\uff1a{}\uff0cdraftCategories\uff1a{}\uff0cdeclareDate\uff1a{}", new Object[]{orgList, draftCategories, declareDate});
        ArrayList taxableListDtos = ObjectUtils.isNotEmpty(draftCategories) && ObjectUtils.isNotEmpty(orgList) ? this.queryTaxableList(orgList, draftCategories, declareDate) : new ArrayList();
        ArrayList<AccrualListDto> accrualListDtoList = new ArrayList<AccrualListDto>(12);
        if (ObjectUtils.isNotEmpty(taxableListDtos)) {
            for (TaxableListDto taxableListDto : taxableListDtos) {
                AccrualListDto accrualListDto = new AccrualListDto();
                accrualListDto.setOrg(taxableListDto.getOrg());
                accrualListDto.setTaxsystem(taxableListDto.getTaxationsys());
                accrualListDto.setTaxcatetory(taxableListDto.getTaxcatetory());
                accrualListDto.setCategory(taxableListDto.getDgcategory());
                accrualListDto.setBillstatus(taxableListDto.getDraftstatus());
                accrualListDto.setTaxareagroup(taxableListDto.getTaxareagroup());
                accrualListDto.setSkssqq(taxableListDto.getSkssqq());
                accrualListDto.setSkssqz(taxableListDto.getSkssqz());
                accrualListDto.setAccrualDate(taxableListDto.getMonth());
                accrualListDto.setTemplatetype(taxableListDto.getTemplatetype());
                accrualListDto.setBillno(taxableListDto.getDraftNo());
                accrualListDtoList.add(accrualListDto);
            }
            if (ObjectUtils.isNotEmpty(accrualListDtoList)) {
                return accrualListDtoList.stream().map(a -> a.transformToMap()).collect(Collectors.toList());
            }
        }
        return taxableListDtos.stream().map(a -> a.transformToMap()).collect(Collectors.toList());
    }

    public List<TaxableListDto> queryTaxableList(List<Long> var1, List<String> var2, Date var3);
}

