/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.mservice.draft.detaillist;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.DraftCateGory;
import kd.taxc.bdtaxr.common.helper.bd.taxcategory.TaxCategoryDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.util.json.JsonUtil;
import kd.taxc.gtcp.business.draft.GtcpDraftBussiness;
import kd.taxc.gtcp.business.draft.GtcpFetchDataBussiness;
import kd.taxc.gtcp.business.draft.UsaCitBussiness;
import kd.taxc.gtcp.business.taxorg.GtcpTaxOrgCommonBusiness;
import kd.taxc.gtcp.common.constant.GtcpConstant;
import kd.taxc.gtcp.common.dto.TaxableInfoDto;
import kd.taxc.gtcp.mservice.api.GtcpTaxableListQueryService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractGtcpListQueryServiceImpl
implements GtcpTaxableListQueryService {
    private static final Logger log = LoggerFactory.getLogger(AbstractGtcpListQueryServiceImpl.class);

    @Override
    public List<TaxableListDto> queryTaxableList(List<Long> orgList, List<String> draftCategories, Date declareDate) {
        ArrayList<TaxableListDto> taxableListDtoList = new ArrayList<TaxableListDto>(12);
        List<TaxableInfoDto> taxableInfoDtoList = this.queryTaxcMainByOrgIds(orgList);
        if (ObjectUtils.isNotEmpty(taxableInfoDtoList)) {
            log.info("AbstractGtcpListQueryServiceImpl queryTaxcMainByOrgIds orgList : {}", (Object)JsonUtil.toJson(orgList));
            log.info("AbstractGtcpListQueryServiceImpl draftCategories : {}, declareDate : {}", (Object)JsonUtil.toJson(draftCategories), (Object)declareDate);
            log.info("AbstractGtcpListQueryServiceImpl queryTaxableList taxableInfoDtoList size : {}", (Object)taxableInfoDtoList.size());
            this.recalHwsdeadlineList(taxableInfoDtoList, declareDate);
            Map<String, Date> taxPeriodStartDateMap = this.calculateTaxPeriod(taxableInfoDtoList);
            this.calculateTaxcYearFistDate(taxableInfoDtoList, taxPeriodStartDateMap);
            this.calculatePreTaxPeriod(taxableInfoDtoList, declareDate);
            List<TaxableListDto> detailedList = this.createDetailedList(taxableInfoDtoList, draftCategories, declareDate);
            this.dealWithTaxableDtoList(detailedList);
            taxableListDtoList.addAll(detailedList);
        }
        return taxableListDtoList;
    }

    public void recalHwsdeadlineList(List<TaxableInfoDto> taxableInfoDtoList, Date declareDate) {
    }

    public Map<String, Date> calculateTaxPeriod(List<TaxableInfoDto> taxableInfoDtoList) {
        HashMap<String, Date> resultMap = new HashMap<String, Date>(12);
        return resultMap;
    }

    public void calculateTaxcYearFistDate(List<TaxableInfoDto> taxableInfoDtoList, Map<String, Date> taxPeriodStartDateMap) {
        if (ObjectUtils.isEmpty(taxableInfoDtoList) || ObjectUtils.isEmpty(taxPeriodStartDateMap)) {
            return;
        }
        for (TaxableInfoDto taxableInfoDto : taxableInfoDtoList) {
            String key = taxableInfoDto.getOrgId() + "_" + taxableInfoDto.getTaxSystem() + "_" + taxableInfoDto.getTaxType();
            taxableInfoDto.setTaxcYearFistDate(taxPeriodStartDateMap.get(key));
        }
    }

    public void dealWithTaxableDtoList(List<TaxableListDto> detailedList) {
        if (ObjectUtils.isEmpty(detailedList)) {
            return;
        }
        Map<String, Map<String, String>> historyDraftMap = this.dealWithHistoryDraft(detailedList);
        for (TaxableListDto infoDto : detailedList) {
            String org = infoDto.getOrg().toString();
            String taxsystem = infoDto.getTaxationsys().toString();
            String taxtype = infoDto.getTaxcatetory().toString();
            String taxareagroup = infoDto.getTaxareagroup().toString();
            String skssqq = ObjectUtils.isNotEmpty((Object)infoDto.getSkssqq()) ? DateUtils.format((Date)infoDto.getSkssqq()) : "";
            String skssqz = ObjectUtils.isNotEmpty((Object)infoDto.getSkssqz()) ? DateUtils.format((Date)infoDto.getSkssqz()) : "";
            String mapkey = org + "_" + taxsystem + "_" + taxtype + "_" + taxareagroup + "_" + skssqq + "_" + skssqz;
            if (historyDraftMap.containsKey(mapkey)) {
                infoDto.setDraftstatus(this.getDraftStatus(historyDraftMap.get(mapkey).get("billstatus"), "billstatus"));
                infoDto.setDeclarestatus(this.getDraftStatus(historyDraftMap.get(mapkey).get("declarestatus"), "declarestatus"));
                infoDto.setPaystatus(this.getDraftStatus(historyDraftMap.get(mapkey).get("payrefundstatus"), "payrefundstatus"));
                infoDto.setDraftNo(historyDraftMap.get(mapkey).get("billno"));
                continue;
            }
            infoDto.setDraftstatus(TaxableListDto.DRAFTSTATUS_WBZ);
            infoDto.setPaystatus(TaxableListDto.PAYSTATUS_WJK);
            infoDto.setDeclarestatus("editing");
        }
    }

    public String getDraftStatus(String status, String type) {
        return status;
    }

    private List<TaxableListDto> createDetailedList(List<TaxableInfoDto> taxableInfoDtoList, List<String> draftCategories, Date declareDate) {
        ArrayList<TaxableListDto> listDtoList = new ArrayList<TaxableListDto>(12);
        if (ObjectUtils.isEmpty(taxableInfoDtoList) || ObjectUtils.isEmpty(draftCategories)) {
            return listDtoList;
        }
        Date month = DateUtils.getFirstDateOfMonth((Date)declareDate);
        Map<String, String> taxTypeIdsMap = this.queryTaxTypeIdsByNumber(draftCategories);
        if (ObjectUtils.isEmpty(taxTypeIdsMap)) {
            return listDtoList;
        }
        Set<String> taxTypeIdList = taxTypeIdsMap.keySet();
        for (TaxableInfoDto taxableInfoDto : taxableInfoDtoList) {
            String taxtype;
            Long taxationsysId = taxableInfoDto.getTaxSystem();
            Long taxtypeId = taxableInfoDto.getTaxType();
            String string = taxtype = ObjectUtils.isNotEmpty((Object)taxTypeIdsMap.get(taxtypeId.toString())) ? taxTypeIdsMap.get(taxtypeId.toString()) : "";
            String temp = DraftCateGory.HW_QYSDS.getCategory().equals(taxtype) ? "SDS" : (DraftCateGory.HW_ZZS.getCategory().equals(taxtype) ? "ZZS" : "");
            temp = UsaCitBussiness.checkIsUsaSds((String)taxationsysId.toString(), (String)taxtypeId.toString()) ? "USA_CIT" : temp;
            String templatetype = GtcpDraftBussiness.getTemplateTypeByTaxtype((String)temp);
            String templateId = DraftCateGory.HW_QYSDS.getCategory().equals(taxtype) ? "1657982743440669696" : (DraftCateGory.HW_ZZS.getCategory().equals(taxtype) ? "1657311429247904768" : "");
            String string2 = templateId = UsaCitBussiness.checkIsUsaSds((String)taxationsysId.toString(), (String)taxtypeId.toString()) ? "1686895520800370688" : templateId;
            if (!this.checkIsSupprotCreateDetailedList(taxationsysId, taxtypeId, new ArrayList<String>(taxTypeIdList)) || !ObjectUtils.isNotEmpty((Object)taxableInfoDto.getPeriodList())) continue;
            for (ImmutablePair dateImmutablePair : taxableInfoDto.getPeriodList()) {
                TaxableListDto infoDto = new TaxableListDto();
                infoDto.setOrg(taxableInfoDto.getOrgId());
                infoDto.setSkssqq((Date)dateImmutablePair.left);
                infoDto.setSkssqz((Date)dateImmutablePair.right);
                infoDto.setTemplatetype(templatetype);
                infoDto.setTaxcatetory(taxtypeId);
                infoDto.setTemplateid(templateId);
                infoDto.setTaxationsys(taxationsysId);
                infoDto.setTaxareagroup(taxableInfoDto.getTaxareagroup());
                infoDto.setDgcategory(taxTypeIdsMap.get(taxtypeId.toString()));
                infoDto.setDraftstatus(TaxableListDto.DRAFTSTATUS_WBZ);
                infoDto.setMonth(month);
                listDtoList.add(infoDto);
            }
        }
        log.info("AbstractGtcpListQueryServiceImpl createDetailedList size : {}", (Object)listDtoList.size());
        return listDtoList;
    }

    public Map<String, String> queryTaxTypeIdsByNumber(List<String> draftCategories) {
        TaxResult result;
        HashMap<String, String> resultMap = new HashMap<String, String>(12);
        ArrayList taxtypeNumberList = new ArrayList(12);
        List sdsNumberList = GtcpConstant.SDS;
        if (draftCategories.contains(DraftCateGory.HW_QYSDS.getCategory()) && ObjectUtils.isNotEmpty((Object)sdsNumberList)) {
            taxtypeNumberList.addAll(sdsNumberList);
        }
        List zzsNumberList = GtcpConstant.ZZS;
        if (draftCategories.contains(DraftCateGory.HW_ZZS.getCategory()) && ObjectUtils.isNotEmpty((Object)zzsNumberList)) {
            taxtypeNumberList.addAll(zzsNumberList);
        }
        if (ObjectUtils.isNotEmpty((Object)(result = TaxCategoryDataServiceHelper.queryTaxCategoryByNums(taxtypeNumberList))) && result.isSuccess() && ObjectUtils.isNotEmpty((Object)result.getData())) {
            List dynamicObjects = (List)result.getData();
            dynamicObjects.stream().forEach(o -> {
                if (sdsNumberList.contains(o.getString("number"))) {
                    resultMap.put(o.getString("id"), DraftCateGory.HW_QYSDS.getCategory());
                }
                if (zzsNumberList.contains(o.getString("number"))) {
                    resultMap.put(o.getString("id"), DraftCateGory.HW_ZZS.getCategory());
                }
            });
        }
        return resultMap;
    }

    public Map<String, Map<String, String>> dealWithHistoryDraft(List<TaxableListDto> detailedList) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(16);
        HashSet<Long> taxOrgIdList = new HashSet<Long>(16);
        HashSet<Long> taxTypeIdList = new HashSet<Long>(16);
        HashSet<String> templateTypeList = new HashSet<String>(16);
        Date minDate = null;
        Date maxDate = null;
        for (TaxableListDto infoDto : detailedList) {
            taxOrgIdList.add(infoDto.getOrg());
            taxTypeIdList.add(infoDto.getTaxcatetory());
            templateTypeList.add(infoDto.getTemplatetype());
            minDate = ObjectUtils.isEmpty(minDate) || infoDto.getSkssqq().getTime() < minDate.getTime() ? infoDto.getSkssqq() : minDate;
            maxDate = ObjectUtils.isEmpty(maxDate) || infoDto.getSkssqz().getTime() > maxDate.getTime() ? infoDto.getSkssqz() : maxDate;
        }
        if (ObjectUtils.isNotEmpty(minDate) && ObjectUtils.isNotEmpty(maxDate)) {
            DynamicObject[] dynamicObjects = GtcpDraftBussiness.queryRangeDraftMainDataByOrgsAndTaxType(new ArrayList(taxOrgIdList), new ArrayList(taxTypeIdList), new ArrayList(templateTypeList), (String)this.getDraftpurpose(), minDate, maxDate);
            resultMap.putAll(this.buildHistoryDraftRecordMap(dynamicObjects));
        }
        return resultMap;
    }

    public boolean checkIsSupprotCreateDetailedList(Long taxationsysId, Long taxtypeId, List<String> draftCategories) {
        if (ObjectUtils.isEmpty(draftCategories)) {
            return false;
        }
        return draftCategories.contains(taxtypeId.toString());
    }

    public void calculatePreTaxPeriod(List<TaxableInfoDto> taxableInfoDtoList, Date declareDate) {
        if (ObjectUtils.isNotEmpty(taxableInfoDtoList) && ObjectUtils.isNotEmpty((Object)declareDate)) {
            for (TaxableInfoDto taxableInfoDto : taxableInfoDtoList) {
                List hwsdeadlineList = taxableInfoDto.getHwsdeadlineList();
                if (!ObjectUtils.isNotEmpty((Object)hwsdeadlineList)) continue;
                ArrayList<ImmutablePair<Date, Date>> immutablePairList = new ArrayList<ImmutablePair<Date, Date>>(12);
                for (String hwsdeadline : hwsdeadlineList) {
                    ImmutablePair<Date, Date> dateDateImmutablePair = this.calculatePreTaxPeriodByHwsdeadlineList(hwsdeadline, taxableInfoDto.getTaxcYearFistDate(), declareDate);
                    if (!ObjectUtils.isNotEmpty(dateDateImmutablePair)) continue;
                    immutablePairList.add(dateDateImmutablePair);
                }
                taxableInfoDto.setPeriodList(immutablePairList);
            }
        }
    }

    public abstract ImmutablePair<Date, Date> calculatePreTaxPeriodByHwsdeadlineList(String var1, Date var2, Date var3);

    public List<TaxableInfoDto> queryTaxcMainByOrgIds(List<Long> orgList) {
        ArrayList<TaxableInfoDto> taxableInfoDtoList = new ArrayList<TaxableInfoDto>(12);
        if (ObjectUtils.isEmpty(orgList)) {
            return taxableInfoDtoList;
        }
        Map taxcMainOrgMap = GtcpTaxOrgCommonBusiness.queryTaxcMainByOrgIds(orgList, null);
        if (ObjectUtils.isNotEmpty((Object)taxcMainOrgMap)) {
            taxcMainOrgMap.entrySet().stream().forEach(taxMain -> {
                String taxMainId;
                String string = taxMainId = ObjectUtils.isNotEmpty(taxMain.getKey()) ? (String)taxMain.getKey() : "0";
                if (ObjectUtils.isNotEmpty(taxMain.getValue())) {
                    Set taxentrySet = ((Map)taxMain.getValue()).entrySet();
                    for (Map.Entry taxsystem : taxentrySet) {
                        String taxsystemId = ObjectUtils.isNotEmpty(taxsystem.getKey()) ? (String)taxsystem.getKey() : "0";
                        boolean isreadditionUsaCit = false;
                        if (!ObjectUtils.isNotEmpty(taxsystem.getValue())) continue;
                        Set taxtypeentry = ((Map)taxsystem.getValue()).entrySet();
                        for (Map.Entry taxtype : taxtypeentry) {
                            String taxtypeId;
                            String string2 = taxtypeId = ObjectUtils.isNotEmpty(taxtype.getKey()) ? (String)taxtype.getKey() : "0";
                            if (ObjectUtils.isNotEmpty(taxtype.getValue())) {
                                Set entrySet = ((Map)taxtype.getValue()).entrySet();
                                for (Map.Entry entry : entrySet) {
                                    String taxareagroupId;
                                    String string3 = taxareagroupId = ObjectUtils.isNotEmpty(entry.getKey()) ? (String)entry.getKey() : "0";
                                    if (this.checkTaxareagroupIsNeedCreateTaxableInfo(taxsystemId, taxtypeId, taxareagroupId)) {
                                        TaxableInfoDto taxableInfoDto = new TaxableInfoDto();
                                        taxableInfoDto.setOrgId(Long.valueOf(Long.parseLong(taxMainId)));
                                        taxableInfoDto.setTaxSystem(Long.valueOf(Long.parseLong(taxsystemId)));
                                        taxableInfoDto.setTaxType(Long.valueOf(Long.parseLong(taxtypeId)));
                                        taxableInfoDto.setTaxareagroup(Long.valueOf(Long.parseLong(taxareagroupId)));
                                        taxableInfoDto.setHwsdeadlineList((List)entry.getValue());
                                        taxableInfoDtoList.add(taxableInfoDto);
                                        continue;
                                    }
                                    if (!UsaCitBussiness.checkIsUsaSds((String)taxsystemId, (String)taxtypeId)) continue;
                                    isreadditionUsaCit = true;
                                }
                            }
                            if (!isreadditionUsaCit || !UsaCitBussiness.checkIsUsaSds((String)taxsystemId, (String)taxtypeId)) continue;
                            TaxableInfoDto taxableInfoDto = new TaxableInfoDto();
                            taxableInfoDto.setOrgId(Long.valueOf(Long.parseLong(taxMainId)));
                            taxableInfoDto.setTaxSystem(Long.valueOf(Long.parseLong(taxsystemId)));
                            taxableInfoDto.setTaxType(Long.valueOf(Long.parseLong(taxtypeId)));
                            taxableInfoDto.setTaxareagroup(Long.valueOf(Long.parseLong("1616686278185582592")));
                            ArrayList<String> list = new ArrayList<String>(2);
                            list.add("year");
                            taxableInfoDto.setHwsdeadlineList(list);
                            taxableInfoDtoList.add(taxableInfoDto);
                        }
                    }
                }
            });
        }
        return taxableInfoDtoList;
    }

    protected boolean checkTaxareagroupIsNeedCreateTaxableInfo(String taxsystemId, String taxtypeId, String taxareagroupId) {
        return !UsaCitBussiness.checkIsUsaTaxSystem((String)taxsystemId) || UsaCitBussiness.checkIsUsaSds((String)taxsystemId, (String)taxtypeId, (String)taxareagroupId);
    }

    public String getDraftpurpose() {
        return "nssb";
    }

    public Map<String, Map<String, String>> buildHistoryDraftRecordMap(DynamicObject[] dynamicObjects) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(16);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String billno = ObjectUtils.isNotEmpty((Object)dynamicObject.getString("billno")) ? dynamicObject.getString("billno") : "";
                String org = dynamicObject.getString("org.id");
                String taxsystem = dynamicObject.getString("taxsystem.id");
                String taxtype = dynamicObject.getString("taxtype.id");
                String taxareagroup = dynamicObject.getString("taxareagroup.id");
                String skssqq = ObjectUtils.isNotEmpty((Object)dynamicObject.getDate("skssqq")) ? DateUtils.format((Date)dynamicObject.getDate("skssqq")) : "";
                String skssqz = ObjectUtils.isNotEmpty((Object)dynamicObject.getDate("skssqz")) ? DateUtils.format((Date)dynamicObject.getDate("skssqz")) : "";
                String mapkey = org + "_" + taxsystem + "_" + taxtype + "_" + taxareagroup + "_" + skssqq + "_" + skssqz;
                HashMap<String, String> infoMap = new HashMap<String, String>(16);
                infoMap.put("billstatus", dynamicObject.getString("billstatus"));
                DynamicObjectCollection dynamicObjectCollection = dynamicObject.getDynamicObjectCollection("entryentity");
                String declarestatus = "editing";
                String payrefundstatus = "unpaid";
                if (ObjectUtils.isNotEmpty((Object)dynamicObjectCollection)) {
                    declarestatus = ObjectUtils.isEmpty((Object)dynamicObjectCollection.get(0)) || "editing".equals(((DynamicObject)dynamicObjectCollection.get(0)).getString("declarestatus")) ? "editing" : "declared";
                    payrefundstatus = GtcpFetchDataBussiness.declareMapTaxablePaystatus((DynamicObject)((DynamicObject)dynamicObjectCollection.get(0)));
                }
                infoMap.put("billno", billno);
                infoMap.put("declarestatus", declarestatus);
                infoMap.put("payrefundstatus", payrefundstatus);
                resultMap.put(mapkey, infoMap);
            }
        }
        return resultMap;
    }
}

