/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.mservice.draft.detaillist.accrual;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.provision.GtcpProvisionPlanBusiness;
import kd.taxc.gtcp.common.dto.TaxableInfoDto;
import kd.taxc.gtcp.mservice.draft.detaillist.AbstractGtcpListQueryServiceImpl;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GtcpAccrualListQueryServiceImpl
extends AbstractGtcpListQueryServiceImpl {
    @Override
    public void recalHwsdeadlineList(List<TaxableInfoDto> taxableInfoDtoList, Date declareDate) {
        if (ObjectUtils.isEmpty(taxableInfoDtoList)) {
            return;
        }
        HashSet<Long> orgList = new HashSet<Long>(12);
        for (TaxableInfoDto infoDto : taxableInfoDtoList) {
            infoDto.setHwsdeadlineList(null);
            orgList.add(infoDto.getOrgId());
        }
        Map planByOrgIds = GtcpProvisionPlanBusiness.querySharePlanByOrgIds(new ArrayList(orgList));
        if (ObjectUtils.isEmpty((Object)planByOrgIds)) {
            return;
        }
        for (TaxableInfoDto infoDto : taxableInfoDtoList) {
            Long orgId = infoDto.getOrgId();
            Long taxSystem = infoDto.getTaxSystem();
            Long taxType = infoDto.getTaxType();
            Long taxareagroup = infoDto.getTaxareagroup();
            planByOrgIds.entrySet().stream().forEach(entry -> {
                ImmutablePair dateDateImmutablePair;
                boolean contains;
                String[] split = ((String)entry.getKey()).split("_");
                String plantaxSystem = split[0];
                String planTaxType = split[1];
                String planTaxareagroup = split[2];
                String skssqq = split[3];
                String skssqz = split[4];
                String cycle = split[5];
                if (plantaxSystem.equals(taxSystem.toString()) && planTaxType.equals(taxType.toString()) && planTaxareagroup.equals(taxareagroup.toString()) && (contains = ((Set)entry.getValue()).contains(orgId)) && ObjectUtils.isNotEmpty((Object)(dateDateImmutablePair = GtcpProvisionPlanBusiness.provisionPeriod((Date)declareDate, (String)cycle)))) {
                    Date left = (Date)dateDateImmutablePair.getLeft();
                    Date right = (Date)dateDateImmutablePair.getRight();
                    if (DateUtils.stringToDate2((String)skssqq).getTime() <= left.getTime() && ("null".equals(skssqz) || DateUtils.stringToDate2((String)skssqz).getTime() >= right.getTime())) {
                        if (ObjectUtils.isEmpty((Object)infoDto.getHwsdeadlineList())) {
                            infoDto.setHwsdeadlineList(new ArrayList());
                        }
                        infoDto.getHwsdeadlineList().add(cycle);
                    }
                }
            });
        }
    }

    @Override
    public ImmutablePair<Date, Date> calculatePreTaxPeriodByHwsdeadlineList(String hwsdeadline, Date taxYearStartDate, Date declareDate) {
        return GtcpProvisionPlanBusiness.provisionPeriod((Date)declareDate, (String)hwsdeadline);
    }

    @Override
    public Map<String, Map<String, String>> buildHistoryDraftRecordMap(DynamicObject[] dynamicObjects) {
        HashMap<String, Map<String, String>> resultMap = new HashMap<String, Map<String, String>>(16);
        if (ObjectUtils.isNotEmpty((Object)dynamicObjects)) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                String billno = ObjectUtils.isNotEmpty((Object)dynamicObject.getString("billno")) ? dynamicObject.getString("billno") : "";
                String org = dynamicObject.getString("org.id");
                String taxsystem = dynamicObject.getString("taxsystem.id");
                String taxtype = dynamicObject.getString("taxtype.id");
                String taxareagroup = dynamicObject.getString("taxareagroup.id");
                String skssqq = ObjectUtils.isNotEmpty((Object)dynamicObject.getDate("skssqq")) ? DateUtils.format((Date)dynamicObject.getDate("skssqq")) : "";
                String skssqz = ObjectUtils.isNotEmpty((Object)dynamicObject.getDate("skssqz")) ? DateUtils.format((Date)dynamicObject.getDate("skssqz")) : "";
                String mapkey = org + "_" + taxsystem + "_" + taxtype + "_" + taxareagroup + "_" + skssqq + "_" + skssqz;
                HashMap<String, String> infoMap = new HashMap<String, String>(16);
                infoMap.put("billstatus", dynamicObject.getString("billstatus"));
                infoMap.put("billno", billno);
                resultMap.put(mapkey, infoMap);
            }
        }
        return resultMap;
    }

    @Override
    public void dealWithTaxableDtoList(List<TaxableListDto> detailedList) {
        if (ObjectUtils.isEmpty(detailedList)) {
            return;
        }
        Map<String, Map<String, String>> historyDraftMap = this.dealWithHistoryDraft(detailedList);
        for (TaxableListDto infoDto : detailedList) {
            String org = infoDto.getOrg().toString();
            String taxsystem = infoDto.getTaxationsys().toString();
            String taxtype = infoDto.getTaxcatetory().toString();
            String taxareagroup = infoDto.getTaxareagroup().toString();
            String skssqq = ObjectUtils.isNotEmpty((Object)infoDto.getSkssqq()) ? DateUtils.format((Date)infoDto.getSkssqq()) : "";
            String skssqz = ObjectUtils.isNotEmpty((Object)infoDto.getSkssqz()) ? DateUtils.format((Date)infoDto.getSkssqz()) : "";
            String mapkey = org + "_" + taxsystem + "_" + taxtype + "_" + taxareagroup + "_" + skssqq + "_" + skssqz;
            if (historyDraftMap.containsKey(mapkey)) {
                infoDto.setDraftstatus(this.getDraftStatus(historyDraftMap.get(mapkey).get("billstatus"), "billstatus"));
                infoDto.setDraftNo(historyDraftMap.get(mapkey).get("billno"));
                continue;
            }
            infoDto.setDraftstatus(TaxableListDto.DRAFTSTATUS_WBZ);
        }
    }

    @Override
    public String getDraftpurpose() {
        return "sjjt";
    }
}

