/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.mservice.draft.detaillist.declare;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.taxc.bdtaxr.common.taxdeclare.dto.TaxableListDto;
import kd.taxc.gtcp.business.taxcalendar.GtcpTaxCalendarBussiness;
import kd.taxc.gtcp.business.tctb.TaxPeriodBusiness;
import kd.taxc.gtcp.common.dto.TaxableInfoDto;
import kd.taxc.gtcp.mservice.draft.detaillist.AbstractGtcpListQueryServiceImpl;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class GtcpTaxableListQueryServiceImpl
extends AbstractGtcpListQueryServiceImpl {
    @Override
    public Map<String, Date> calculateTaxPeriod(List<TaxableInfoDto> taxableInfoDtoList) {
        HashMap<String, Date> resultMap = new HashMap<String, Date>(12);
        if (ObjectUtils.isNotEmpty(taxableInfoDtoList)) {
            ArrayList taxYearParamMapList = new ArrayList(16);
            for (TaxableInfoDto taxableInfoDto : taxableInfoDtoList) {
                HashMap<String, Long> taxYearParamMap = new HashMap<String, Long>(16);
                taxYearParamMap.put("key_orgId", taxableInfoDto.getOrgId());
                taxYearParamMap.put("key_taxationsysId", taxableInfoDto.getTaxSystem());
                taxYearParamMap.put("key_taxcategoryId", taxableInfoDto.getTaxType());
                taxYearParamMapList.add(taxYearParamMap);
            }
            resultMap.putAll(TaxPeriodBusiness.getOrgTaxPeriodStartDateMap(taxYearParamMapList));
        }
        return resultMap;
    }

    @Override
    public ImmutablePair<Date, Date> calculatePreTaxPeriodByHwsdeadlineList(String hwsdeadline, Date taxYearStartDate, Date declareDate) {
        return TaxPeriodBusiness.preTaxPeriod((String)hwsdeadline, (Date)taxYearStartDate, (Date)declareDate);
    }

    @Override
    public void dealWithTaxableDtoList(List<TaxableListDto> detailedList) {
        super.dealWithTaxableDtoList(detailedList);
        if (ObjectUtils.isEmpty(detailedList)) {
            return;
        }
        ArrayList taxCalendarParamMapList = new ArrayList(16);
        for (TaxableListDto infoDto : detailedList) {
            Long oid = infoDto.getOrg();
            Long taxationsysId = infoDto.getTaxationsys();
            Long taxcategoryId = infoDto.getTaxcatetory();
            Long taxareagroupId = infoDto.getTaxareagroup();
            HashMap<String, Long> taxCalendarParamMap = new HashMap<String, Long>(16);
            taxCalendarParamMap.put("key_orgId", oid);
            taxCalendarParamMap.put("taxationsys", taxationsysId);
            taxCalendarParamMap.put("taxcategory", taxcategoryId);
            taxCalendarParamMap.put("taxareagroup", taxareagroupId);
            taxCalendarParamMapList.add(taxCalendarParamMap);
        }
        Map taxcalendarMap = GtcpTaxCalendarBussiness.queryTaxCalendarSbjzrqByDateAndTaxFields(taxCalendarParamMapList, null, null);
        for (TaxableListDto infoDto : detailedList) {
            if (!ObjectUtils.isNotEmpty((Object)taxcalendarMap)) continue;
            Date sbjzrq = GtcpTaxCalendarBussiness.queryTaxCalendarSbjzrq((Long)infoDto.getOrg(), (Long)infoDto.getTaxationsys(), (Long)infoDto.getTaxcatetory(), (Long)infoDto.getTaxareagroup(), (Date)infoDto.getSkssqq(), (Date)infoDto.getSkssqz(), (Map)taxcalendarMap);
            infoDto.setDeadline(sbjzrq);
        }
    }
}

