/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.mservice.draft.generate;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.vo.AccrualRequest;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.gtcp.common.dto.DraftRequestVo;
import kd.taxc.gtcp.mservice.api.GtcpDeclareReportService;
import kd.taxc.gtcp.mservice.draft.generate.engine.GtcpEngineService;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpAccrualReportServiceImpl
implements GtcpDeclareReportService {
    private static Log logger = LogFactory.getLog(GtcpAccrualReportServiceImpl.class);

    @Override
    public String generate(String request) {
        HashMap<String, Date> resultMap = new HashMap<String, Date>(2);
        try {
            AccrualRequest requestVo = (AccrualRequest)SerializationUtils.fromJsonString((String)request, AccrualRequest.class);
            String orgId = requestVo.getOrgId();
            Long taxationsys = requestVo.getTaxsystem();
            String category = requestVo.getCategory();
            Long taxcatetory = requestVo.getTaxcatetory();
            Long taxareagroup = requestVo.getTaxareagroup();
            Date skssqq = requestVo.getSkssqq();
            Date skssqz = requestVo.getSkssqz();
            resultMap.put("skssqq", skssqq);
            resultMap.put("skssqz", skssqz);
            logger.info("GtcpAccrualReportServiceImpl generate start category={} orgId={},taxationsys={},taxcatetory={},taxareagroup={},startDate={},endDate={}", new Object[]{category, orgId, taxationsys, taxcatetory, taxareagroup, skssqq, skssqz});
            if (ObjectUtils.isEmpty((Object)category) || ObjectUtils.isEmpty((Object)orgId) || ObjectUtils.isEmpty((Object)taxationsys) || ObjectUtils.isEmpty((Object)taxcatetory) || ObjectUtils.isEmpty((Object)taxareagroup) || ObjectUtils.isEmpty((Object)skssqq) || ObjectUtils.isEmpty((Object)skssqz)) {
                return SerializationUtils.toJsonString((Object)EngineResponse.fail((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"GtcpAccrualReportServiceImpl_0", (String)"taxc-gtcp-mservice", (Object[])new Object[0]), resultMap));
            }
            GtcpEngineService strategy = new GtcpEngineService();
            DraftRequestVo draftRequestVo = new DraftRequestVo(requestVo);
            DeclareRequestModel declareRequest = new DeclareRequestModel();
            return strategy.doGenerate(declareRequest, draftRequestVo);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            return SerializationUtils.toJsonString((Object)EngineResponse.fail((String)e.getMessage(), resultMap));
        }
    }
}

