/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.mservice.draft.generate.engine;

import java.util.Date;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.TaxResult;
import kd.taxc.bdtaxr.common.enums.MultiTableEnum;
import kd.taxc.bdtaxr.common.helper.tpo.declare.MultiDeclareReportDataServiceHelper;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.bdtaxr.common.vo.EngineResponse;
import kd.taxc.bdtaxr.formplugin.pluginService.taxdeclare.TaxDeclarePluginService;
import kd.taxc.gtcp.common.dto.DataResultVo;
import kd.taxc.gtcp.common.dto.DraftRequestVo;
import kd.taxc.gtcp.mservice.api.GtcpBatchService;
import kd.taxc.gtcp.mservice.draft.generate.strategy.GtcpBatchServiceFactory;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpEngineService {
    private static Log logger = LogFactory.getLog(GtcpEngineService.class);
    private static DeclareReportService declareReportService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String doGenerate(DeclareRequestModel declareRequest, DraftRequestVo requestVo) {
        logger.info("GtcpEngineService start doGenerate");
        DLock lock = DLock.create((String)("GtcpEngineService_BATCH_LOCK_" + requestVo.getOrgId() + requestVo.getTaxationsys() + requestVo.getTaxcatetory() + requestVo.getRequestType()));
        try {
            if (lock.tryLock(60000L)) {
                GtcpBatchService batchService = GtcpBatchServiceFactory.createHandler(requestVo.getCategory(), requestVo.getTemplateType());
                DataResultVo vo = this.checkRequestParam(requestVo, batchService);
                if (!vo.getSuccess().booleanValue()) {
                    HashMap<String, Date> resultMap = new HashMap<String, Date>(2);
                    resultMap.put("skssqq", requestVo.getSkssqq());
                    resultMap.put("skssqz", requestVo.getSkssqz());
                    String string = SerializationUtils.toJsonString((Object)EngineResponse.fail((String)vo.getMessage(), resultMap));
                    return string;
                }
                logger.info("GtcpEngineService checkRequestParam finish");
                DataResultVo initData = this.initData(declareRequest, requestVo, batchService);
                try {
                    if (!initData.getSuccess().booleanValue()) {
                        String string = SerializationUtils.toJsonString((Object)EngineResponse.fail((String)initData.getMessage(), (Object)initData.getData()));
                        return string;
                    }
                    this.createCustomMap(declareRequest);
                    String string = this.saveDraftData(declareRequest, initData, batchService);
                    return string;
                }
                catch (KDBizException exception) {
                    String string = SerializationUtils.toJsonString((Object)EngineResponse.fail((String)exception.getMessage(), (Object)initData.getData()));
                    return string;
                }
            }
            String batchService = SerializationUtils.toJsonString((Object)EngineResponse.fail((String)ResManager.loadKDString((String)"\u4efb\u52a1\u751f\u6210\u5931\u8d25\uff0c\u5df2\u5b58\u5728\u76f8\u540c\u4efb\u52a1\u6b63\u5728\u6267\u884c\u3002", (String)"GtcpEngineService_0", (String)"taxc-gtcp-mservice", (Object[])new Object[0]), null));
            return batchService;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            String string = SerializationUtils.toJsonString((Object)EngineResponse.failByMsgCode((String)String.format(ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5931\u8d25,\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"GtcpEngineService_1", (String)"taxc-gtcp-mservice", (Object[])new Object[0]), e.getMessage()), (String)"500"));
            return string;
        }
        finally {
            lock.unlock();
        }
    }

    protected DataResultVo checkRequestParam(DraftRequestVo requestVo, GtcpBatchService batchService) {
        if (ObjectUtils.isNotEmpty((Object)batchService)) {
            return batchService.checkRequestParam(requestVo);
        }
        return DataResultVo.success((String)"200");
    }

    protected DataResultVo initData(DeclareRequestModel declareRequest, DraftRequestVo requestVo, GtcpBatchService batchService) {
        logger.info("GtcpEngineService initData start");
        String orgId = requestVo.getOrgId();
        String startDate = DateUtils.format((Date)requestVo.getSkssqq());
        String endDate = DateUtils.format((Date)requestVo.getSkssqz());
        declareRequest.setOrgId(Long.valueOf(orgId));
        declareRequest.setSkssqq(startDate);
        declareRequest.setSkssqz(endDate);
        declareRequest.setTaxationsys(requestVo.getTaxationsys());
        declareRequest.setRefresh(Boolean.valueOf(true));
        declareRequest.setCustomEvent("add");
        declareRequest.setOperation("edit");
        declareRequest.setTemplateType(this.getTemplateType(requestVo, batchService));
        declareRequest.setId(TaxDeclarePluginService.generateSBBId((String)this.getMainTable()));
        if (ObjectUtils.isEmpty((Object)declareRequest.getExtendParams())) {
            declareRequest.setExtendParams(new HashMap());
        }
        declareRequest.getExtendParams().put("taxtype", requestVo.getTaxcatetory());
        declareRequest.getExtendParams().put("templateid", requestVo.getTemplateId());
        declareRequest.getExtendParams().put("taxationsys", requestVo.getTaxationsys().toString());
        declareRequest.getExtendParams().put("draftpurpose", requestVo.getRequestType());
        declareRequest.getExtendParams().put("taxcategory", requestVo.getTaxcatetory());
        declareRequest.getExtendParams().put("taxareagroup", requestVo.getTaxcatetory());
        HashMap<String, String> businessMap = new HashMap<String, String>(12);
        businessMap.put("billno", declareRequest.getBillNo());
        businessMap.put("taxsystem", declareRequest.getTaxationsys().toString());
        businessMap.put("billstatus", "A");
        businessMap.put("createtime", DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        businessMap.put("taxtype", requestVo.getTaxcatetory().toString());
        businessMap.put("draftpurpose", requestVo.getRequestType());
        businessMap.put("taxareagroup", requestVo.getTaxareagroup().toString());
        if (ObjectUtils.isNotEmpty((Object)declareRequest.getBusinessMap())) {
            declareRequest.getBusinessMap().putAll(businessMap);
        } else {
            declareRequest.setBusinessMap(businessMap);
        }
        declareRequest.getExtendParams().putAll(businessMap);
        declareReportService = DeclareReportFactory.createHandler((String)requestVo.getTemplateType());
        if (ObjectUtils.isNotEmpty((Object)declareReportService)) {
            declareRequest.setModelId(declareReportService.getModleId());
        }
        if (ObjectUtils.isNotEmpty((Object)batchService)) {
            batchService.initData(declareRequest, requestVo);
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("org", orgId);
        result.put("skssqq", startDate);
        result.put("skssqz", endDate);
        logger.info("GtcpEngineService initData finish");
        return DataResultVo.success((String)"create data success", result);
    }

    protected void createCustomMap(DeclareRequestModel declareRequest) {
    }

    protected String saveDraftData(DeclareRequestModel declareRequest, DataResultVo initData, GtcpBatchService batchService) {
        logger.info("GtcpEngineService doGenerate start MultiDeclareDataServiceHelper.create");
        TaxResult taxResult = MultiDeclareReportDataServiceHelper.create((String)SerializationUtils.toJsonString((Object)declareRequest));
        logger.info("GtcpEngineService doGenerate start MultiDeclareDataServiceHelper.create finish");
        if (ObjectUtils.isNotEmpty((Object)taxResult) && taxResult.isSuccess() && ObjectUtils.isNotEmpty((Object)taxResult.getData())) {
            if (ObjectUtils.isNotEmpty((Object)batchService)) {
                batchService.saveDraftData(declareRequest, initData);
            }
            return SerializationUtils.toJsonString((Object)EngineResponse.success((String)String.format(ResManager.loadKDString((String)"\u5e95\u7a3f%s\u751f\u6210\u6210\u529f\u3002", (String)"GtcpEngineService_2", (String)"taxc-gtcp-mservice", (Object[])new Object[0]), declareRequest.getBillNo()), (Object)initData.getData()));
        }
        return SerializationUtils.toJsonString((Object)EngineResponse.fail((String)taxResult.getMessage(), (Object)initData.getData()));
    }

    public String getTemplateType(DraftRequestVo requestVo, GtcpBatchService batchService) {
        if (ObjectUtils.isNotEmpty((Object)batchService) && ObjectUtils.isNotEmpty((Object)batchService.getTemplateType(requestVo))) {
            return batchService.getTemplateType(requestVo);
        }
        return requestVo.getTemplateType();
    }

    public String getMainTable() {
        return MultiTableEnum.TSD001.getDeclareMainTable();
    }
}

