/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.mservice.draft.generate.strategy;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.DeclareReportFactory;
import kd.taxc.bdtaxr.common.taxdeclare.extensionpoint.declarereport.service.DeclareReportService;
import kd.taxc.bdtaxr.common.util.date.DateUtils;
import kd.taxc.gtcp.business.draft.GtcpFetchDataBussiness;
import kd.taxc.gtcp.common.dto.DataResultVo;
import kd.taxc.gtcp.common.dto.DraftRequestVo;
import kd.taxc.gtcp.mservice.draft.generate.strategy.AbstractGtcpBatchService;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.ObjectUtils;

public class GtcpUsaCitBatchServiceImpl
extends AbstractGtcpBatchService {
    public static final List<String> ALL_VALUEABLE_AREA_LIST = Arrays.asList("Federation", "Texas (FT)", "State income tax overview", "Alabama", "Alaska", "Arizona", "Arkansas", "California", "Colorado", "Connecticut", "Delaware", "Florida", "Georgia", "Hawaii", "Idaho", "Illinois", "Indiana", "Iowa", "Kansas", "Kentucky", "Louisiana", "Maine", "Maryland", "Massachusetts", "Michigan", "Minnesota", "Mississippi", "Missouri", "Montana", "Nebraska", "New Hampshire", "New Jersey", "New Mexico", "New York", "North Carolina", "North Dakota", "Oklahoma", "Oregon", "Pennsylvania", "Rhode Island", "South Carolina", "Tennessee", "Utah", "Vermont", "Virginia", "West Virginia", "Wisconsin", "Washington D.C.");

    @Override
    public DataResultVo initData(DeclareRequestModel declareRequest, DraftRequestVo requestVo) {
        HashMap fetchConfigParams;
        Map bizParams;
        DataResultVo dataResultVo = super.initData(declareRequest, requestVo);
        if (!dataResultVo.getSuccess().booleanValue()) {
            return dataResultVo;
        }
        DeclareReportService declareReportService = DeclareReportFactory.createHandler((String)requestVo.getTemplateType());
        if (declareReportService != null) {
            HashMap<String, String> unikeyMap = new HashMap<String, String>(16);
            unikeyMap.put("org", requestVo.getOrgId());
            unikeyMap.put("skssqq", DateUtils.format((Date)requestVo.getSkssqq()));
            unikeyMap.put("skssqz", DateUtils.format((Date)requestVo.getSkssqz()));
            unikeyMap.put("taxationsys", ObjectUtils.isNotEmpty((Object)requestVo.getTaxationsys()) ? requestVo.getTaxationsys().toString() : "");
            unikeyMap.put("taxtype", ObjectUtils.isNotEmpty((Object)requestVo.getTaxcatetory()) ? requestVo.getTaxcatetory().toString() : "");
            unikeyMap.put("taxareagroup", ObjectUtils.isNotEmpty((Object)requestVo.getTaxareagroup()) ? requestVo.getTaxareagroup().toString() : "");
            unikeyMap.put("templateType", requestVo.getTemplateType());
            unikeyMap.put("draftpurpose", requestVo.getRequestType());
            declareRequest.setUniKey(declareReportService.getUniKey(unikeyMap));
            String billNumber = declareReportService.getBillNumber(requestVo.getSkssqq(), requestVo.getSkssqz(), String.valueOf(requestVo.getOrgId()), declareRequest.getBusinessMap());
            declareRequest.setBillNo(billNumber);
            bizParams = GtcpFetchDataBussiness.getBizParams((String)requestVo.getTemplateType(), (Long)Long.parseLong(requestVo.getOrgId()), (Long)requestVo.getTaxationsys(), (Long)requestVo.getTaxcatetory(), (Date)requestVo.getSkssqq(), (String)requestVo.getRequestType());
            fetchConfigParams = new HashMap(16);
            if ("nssb".equals(requestVo.getRequestType())) {
                fetchConfigParams.putAll(GtcpFetchDataBussiness.getSbFetchConfigParams((DeclareRequestModel)declareRequest, (Long)requestVo.getTaxationsys(), (Long)requestVo.getTaxcatetory(), (Long)requestVo.getTaxareagroup(), (RuleEngineParamDto)this.getSbRuleEngineParamDto(declareRequest, requestVo)));
            } else if ("sjjt".equals(requestVo.getRequestType())) {
                fetchConfigParams.putAll(GtcpFetchDataBussiness.getJtFetchConfigParams((DeclareRequestModel)declareRequest, (Long)requestVo.getTaxationsys(), (Long)requestVo.getTaxcatetory(), (Long)requestVo.getTaxareagroup(), (String)"", (boolean)requestVo.isSds()));
            }
        } else {
            return DataResultVo.fail((String)"declareReportService init fail");
        }
        declareRequest.getBusinessMap().putAll(bizParams);
        declareRequest.getBusinessMap().putAll(fetchConfigParams);
        declareRequest.getExtendParams().putAll(bizParams);
        declareRequest.getExtendParams().putAll(fetchConfigParams);
        return DataResultVo.success((String)"init data sucess");
    }

    @Override
    public String saveDraftData(DeclareRequestModel declareRequest, DataResultVo initData) {
        Map extendParams = declareRequest.getExtendParams();
        if (MapUtils.isEmpty((Map)extendParams)) {
            return "";
        }
        Long id = declareRequest.getId();
        if (extendParams.containsKey("USA_CIT_TAX_AREA_LIST") && extendParams.get("USA_CIT_TAX_AREA_LIST") != null) {
            String taxAreaIdsStr = extendParams.get("USA_CIT_TAX_AREA_LIST").toString();
            List taxAreaIds = SerializationUtils.fromJsonStringToList((String)taxAreaIdsStr, Long.class);
            taxAreaIds.add(1616686278185582592L);
            QFilter filter = new QFilter("id", "is not null", null);
            DynamicObjectCollection taxareagroupList = QueryServiceHelper.query((String)"bastax_taxareagroup", (String)"id,name", (QFilter[])filter.toArray());
            Map<Long, String> map = taxareagroupList.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v.getString("name"), (k1, k2) -> k1));
            DeleteServiceHelper.delete((String)"gtcp_draft_tab", (QFilter[])new QFilter[]{new QFilter("draftid", "=", (Object)id)});
            List<DynamicObject> tableInfoList = taxAreaIds.stream().filter(taxAreaId -> ALL_VALUEABLE_AREA_LIST.contains(map.get(taxAreaId)) || 1681071243350195200L == taxAreaId || 1616686278185582592L == taxAreaId).map(taxAreaId -> {
                Long taxareagroupId = taxAreaId;
                String taxAreaName = (String)map.get(taxAreaId);
                if (1681071243350195200L == taxAreaId) {
                    taxAreaName = "Texas (FT)";
                } else if (1616686278185582592L == taxAreaId) {
                    taxAreaName = "State income tax overview";
                }
                DynamicObject dynamicObject = BusinessDataServiceHelper.newDynamicObject((String)"gtcp_draft_tab");
                dynamicObject.set("tab", (Object)taxAreaName);
                dynamicObject.set("draftid", (Object)id);
                dynamicObject.set("taxareagroup", (Object)taxareagroupId);
                return dynamicObject;
            }).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(tableInfoList)) {
                SaveServiceHelper.save((DynamicObject[])tableInfoList.toArray(new DynamicObject[0]));
            }
        }
        return id + "";
    }

    public RuleEngineParamDto getSbRuleEngineParamDto(DeclareRequestModel requestModel, DraftRequestVo requestVo) {
        RuleEngineParamDto ruleEngineParamDto = GtcpFetchDataBussiness.getSbRuleEngineParamDto((DeclareRequestModel)requestModel, (Long)requestVo.getTaxationsys(), (Long)requestVo.getTaxcatetory(), (Long)requestVo.getTaxareagroup());
        if (ObjectUtils.isNotEmpty((Object)ruleEngineParamDto)) {
            GtcpFetchDataBussiness.dealWithSbRuleEngineParamDto((DeclareRequestModel)requestModel, (RuleEngineParamDto)ruleEngineParamDto, (String)"", (Long)Long.parseLong(requestVo.getOrgId()), (Long)requestVo.getTaxationsys(), (Long)requestVo.getTaxcatetory(), (String)requestVo.getRequestType(), (boolean)requestVo.isSds());
        }
        return ruleEngineParamDto;
    }

    public RuleEngineParamDto getJtRuleEngineParamDto(DeclareRequestModel requestModel, DraftRequestVo requestVo) {
        Object usaCitOrgIncludeUsaFt = requestModel.getExtendParams().get("usaCitOrgIncludeUsaFt");
        return GtcpFetchDataBussiness.getJtRuleEngineParamDto((DeclareRequestModel)requestModel, (Long)requestVo.getTaxationsys(), (Long)requestVo.getTaxcatetory(), (Long)requestVo.getTaxareagroup(), usaCitOrgIncludeUsaFt, (String)"", (boolean)requestVo.isSds());
    }
}

