/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.mservice.upgrade;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.enums.GtcpDeclarePayRefundEnum;
import kd.taxc.bdtaxr.common.util.db.DBUtils;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import org.apache.commons.lang3.ObjectUtils;

public class TaxGtcpDeclareDraftUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TaxGtcpDeclareDraftUpgradeServiceImpl.class);
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String msg = this.doUpgrade();
        if (msg.contains("success")) {
            this.result.setSuccess(this.success);
        } else {
            this.result.setSuccess(false);
        }
        this.result.setLog(msg);
        return this.result;
    }

    public String doUpgrade() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(64);
        HashSet cellSet = new HashSet();
        final HashMap map = new HashMap();
        Arrays.stream(GtcpDeclarePayRefundEnum.values()).forEach(row -> row.getRowColumn().stream().forEach(cell -> cellSet.add("'" + cell + "'")));
        String selectSql = " select a.fid,a.ftemplatetype,a.ftaxsystem,a.ftaxtype,b.fcellnumber,b.fvalue from  t_tpo_declare_main_tsd a join t_tpo_declare_detail_tsd b on a.fid =b.fentryid  where a.ftemplatetype in ('Overseas_CIT','Overseas_VAT','USA_CIT') and fdraftpurpose = 'nssb' and a.fid not in (select fid from t_gtcp_declare_payrefund)  and b.fcellnumber  in (" + StringUtil.join(cellSet, (String)",") + ")";
        String insertSql = " insert into t_gtcp_declare_payrefund (fentryid, fid, fseq, fdeclarestatus, fdeclaredate, fpayrefundstatus,fpayrefunddate, fbqybtse) VALUES(?,?,?,?,?,?,?,?) ";
        try {
            logger.info("\u5347\u7ea7\u7a0e\u91d1\u7f34\u9000\u5355 \u5f00\u59cb\u6267\u884c");
            long start = System.currentTimeMillis();
            DB.query((DBRoute)DBRoute.of((String)"taxc"), (String)selectSql, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

                public Map<String, Object> handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long id = resultSet.getLong("fid");
                        String templatetype = resultSet.getString("ftemplatetype");
                        String taxsystem = resultSet.getString("ftaxsystem");
                        String taxtype = resultSet.getString("ftaxtype");
                        String cellnumber = resultSet.getString("fcellnumber");
                        String value = resultSet.getString("fvalue");
                        GtcpDeclarePayRefundEnum declarePayRefundEnum = GtcpDeclarePayRefundEnum.getGtcpDeclarePayEnumByMultiCondition((String)templatetype, (String)taxsystem, (String)taxtype);
                        if (null == declarePayRefundEnum || !declarePayRefundEnum.getRowColumn().contains(cellnumber)) continue;
                        if (map.containsKey(id)) {
                            ((List)map.get(id)).add(StringUtil.isNotEmpty((CharSequence)value) ? new BigDecimal(value) : BigDecimal.ZERO);
                            map.put(id, map.get(id));
                            continue;
                        }
                        ArrayList<BigDecimal> list = new ArrayList<BigDecimal>();
                        list.add(StringUtil.isNotEmpty((CharSequence)value) ? new BigDecimal(value) : BigDecimal.ZERO);
                        map.put(id, list);
                    }
                    return null;
                }
            });
            if (ObjectUtils.isNotEmpty(map)) {
                for (Map.Entry entry : map.entrySet()) {
                    BigDecimal lastBigDecimal = BigDecimal.ZERO;
                    boolean isAllZero = true;
                    for (BigDecimal amount : (List)entry.getValue()) {
                        if (BigDecimal.ZERO.compareTo(amount) == 0) continue;
                        lastBigDecimal = lastBigDecimal.add(amount);
                        isAllZero = false;
                    }
                    params.add(new Object[]{DBUtils.getLongId((String)"gtcp_declare_payrefund"), entry.getKey(), 1, "editing", null, isAllZero ? "nopayrefund" : "unpayrefund", null, lastBigDecimal});
                }
                DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)insertSql, params);
            }
            logger.info("\u5347\u7ea7\u7a0e\u91d1\u7f34\u9000\u5355 \u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return String.format("GtcpDeclareData success update\uff1a%s", params.size());
        }
        catch (Throwable t) {
            logger.info("\u5347\u7ea7\u7a0e\u91d1\u7f34\u9000\u5355 \u5f02\u5e38\u62a5\u9519" + t.getMessage());
            return "TaxGtcpDeclareDraftUpgradeServiceImpl update error" + t.getMessage();
        }
    }
}

