/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.gtcp.mservice.upgrade;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.taxc.bdtaxr.common.enums.GtcpDeclarePayRefundEnum;
import org.apache.commons.lang3.ObjectUtils;

public class TaxGtcpTaxPayRefundDraftNumberUpgradeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(TaxGtcpTaxPayRefundDraftNumberUpgradeServiceImpl.class);
    UpgradeResult result = new UpgradeResult();
    boolean success = true;

    public UpgradeResult beforeExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        String msg = this.doUpgrade();
        if (msg.contains("success")) {
            this.result.setSuccess(this.success);
        } else {
            this.result.setSuccess(false);
        }
        this.result.setLog(msg);
        return this.result;
    }

    public String doUpgrade() {
        ArrayList<Object[]> params = new ArrayList<Object[]>(64);
        HashSet cellSet = new HashSet();
        Arrays.stream(GtcpDeclarePayRefundEnum.values()).forEach(row -> row.getRowColumn().stream().forEach(cell -> cellSet.add("'" + cell + "'")));
        String selectSql = "select fid,fbillno from t_tpo_declare_main_tsd where fid in (select fdraftid from t_gtcp_taxpay_refund_bill where fdraftid != 0);";
        String updatesql = "update t_gtcp_taxpay_refund_bill set fdraftnumber = ? where fdraftid = ?";
        try {
            logger.info("\u5347\u7ea7\u7a0e\u91d1\u7f34\u9000\u5355 \u5f00\u59cb\u6267\u884c");
            long start = System.currentTimeMillis();
            final HashMap draftMap = new HashMap();
            DB.query((DBRoute)DBRoute.of((String)"taxc"), (String)selectSql, (ResultSetHandler)new ResultSetHandler<Map<String, Object>>(){

                public Map<String, Object> handle(ResultSet resultSet) throws Exception {
                    while (resultSet.next()) {
                        Long id = resultSet.getLong("fid");
                        String billno = resultSet.getString("fbillno");
                        if (!ObjectUtils.isNotEmpty((Object)id)) continue;
                        draftMap.put(id, billno);
                    }
                    return null;
                }
            });
            if (ObjectUtils.isNotEmpty(draftMap)) {
                for (Map.Entry entry : draftMap.entrySet()) {
                    params.add(new Object[]{entry.getValue(), entry.getKey()});
                }
                DB.executeBatch((DBRoute)DBRoute.of((String)"taxc"), (String)updatesql, params);
            }
            logger.info("\u5347\u7ea7\u7a0e\u91d1\u7f34\u9000\u5355 \u603b\u4f53\u8017\u65f6\uff1a" + (System.currentTimeMillis() - start));
            return String.format("GtcpDeclareData success update\uff1a%s", params.size());
        }
        catch (Throwable t) {
            logger.info("\u5347\u7ea7\u7a0e\u91d1\u7f34\u9000\u5355 \u5f02\u5e38\u62a5\u9519" + t.getMessage());
            return "TaxGtcpDeclareDraftUpgradeServiceImpl update error" + t.getMessage();
        }
    }
}

