/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.declaredetailhis;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.IPageCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.ictm.business.declaredetailhis.DeclareDetailHisDao;
import org.apache.commons.collections4.MapUtils;

public class DeclareDetailHisBusiness {
    public static Map<String, String> getDeclareDetailHis(Long orgId, Date startDate, Date endDate, String formNumber, IPageCache pageCache) {
        String formValueCache = pageCache.get("declareFillValueCache");
        if (StringUtils.isNotEmpty((String)formValueCache)) {
            Map fillFormValue = (Map)SerializationUtils.fromJsonString((String)formValueCache, Map.class);
            return (Map)fillFormValue.get(formNumber);
        }
        DynamicObject declareDetailHis = DeclareDetailHisDao.getDeclareDetailHis(orgId, startDate, endDate, formNumber);
        if (declareDetailHis != null && StringUtils.isNotEmpty((String)declareDetailHis.getString("value_tag"))) {
            return (Map)SerializationUtils.fromJsonString((String)declareDetailHis.getString("value_tag"), Map.class);
        }
        return new HashMap<String, String>(0);
    }

    public static void saveDeclareDetailHisData(Long orgId, Date startDate, Date endDate, Map<String, Map<String, String>> data) {
        if (MapUtils.isEmpty(data)) {
            return;
        }
        ArrayList<DynamicObject> objects = new ArrayList<DynamicObject>(data.size());
        for (Map.Entry<String, Map<String, String>> dataEntry : data.entrySet()) {
            DynamicObject object;
            DynamicObject declareDetailHis = DeclareDetailHisDao.getDeclareDetailHis(orgId, startDate, endDate, dataEntry.getKey());
            if (declareDetailHis != null) {
                object = declareDetailHis;
            } else {
                object = BusinessDataServiceHelper.newDynamicObject((String)"ictm_declare_detail_his");
                object.set("orgid", (Object)orgId);
                object.set("startdate", (Object)startDate);
                object.set("enddate", (Object)endDate);
                object.set("tablenumber", (Object)dataEntry.getKey());
            }
            object.set("value_tag", (Object)SerializationUtils.toJsonString(dataEntry.getValue()));
            objects.add(object);
        }
        DeclareDetailHisDao.saveDeclareDetailHisData(objects.toArray(new DynamicObject[objects.size()]));
    }
}

