/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.declarereport;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.util.StringUtils;
import kd.taxc.ictm.common.dto.OtherTransDetailDto;
import kd.taxc.ictm.common.dto.RelatedFinancingDto;
import kd.taxc.ictm.common.util.DateUtils;

public class DraftDynCellDataConvertBusiness {
    public static final String OTHER_TRANS_DETAIL_RELATED_PARTY_COL_DIMENSION = "qtjymxb_jyf";
    public static final String RELATED_FINANCING_RELATED_PARTY_COL_DIMENSION = "glzjrt_jyf";

    public static List<OtherTransDetailDto> getOtherTransDetailList(Map<String, String> showData, String dynRowDimension) {
        String cellRowDimension = dynRowDimension + "#";
        List rows = showData.keySet().stream().filter(p -> p.contains(cellRowDimension) && p.substring(p.lastIndexOf("#") + 1).equals(OTHER_TRANS_DETAIL_RELATED_PARTY_COL_DIMENSION)).collect(Collectors.toList());
        ArrayList<OtherTransDetailDto> result = new ArrayList<OtherTransDetailDto>(rows.size());
        for (String row : rows) {
            String cellKeyPrefix = row.substring(0, row.lastIndexOf("#") + 1);
            OtherTransDetailDto otherTransDetail = new OtherTransDetailDto(Long.parseLong(showData.get(cellKeyPrefix + "qtjymxb_id")), Long.parseLong(showData.get(cellKeyPrefix + OTHER_TRANS_DETAIL_RELATED_PARTY_COL_DIMENSION)), showData.get(cellKeyPrefix + "qtjymxb_ywmc"), new BigDecimal(showData.get(cellKeyPrefix + "qtjymxb_jyje")));
            otherTransDetail.setCountryId(Long.parseLong(showData.get(cellKeyPrefix + "qtjymxb_gjdq")));
            if (StringUtils.isEmpty((String)showData.get(cellKeyPrefix + "qtjymxb_jynr"))) {
                otherTransDetail.setTransContentId(new ArrayList<Long>(0));
            } else {
                otherTransDetail.setTransContentId(Arrays.stream(showData.get(cellKeyPrefix + "qtjymxb_jynr").split("\u3001")).map(p -> Long.parseLong(p)).collect(Collectors.toList()));
            }
            result.add(otherTransDetail);
        }
        return result;
    }

    public static List<RelatedFinancingDto> getRelatedFinancingList(Map<String, String> showData, String dynRowDimension) {
        String cellRowDimension = dynRowDimension + "#";
        List rows = showData.keySet().stream().filter(p -> p.contains(cellRowDimension) && p.substring(p.lastIndexOf("#") + 1).equals(RELATED_FINANCING_RELATED_PARTY_COL_DIMENSION)).collect(Collectors.toList());
        ArrayList<RelatedFinancingDto> result = new ArrayList<RelatedFinancingDto>(rows.size());
        for (String row : rows) {
            String cellKeyPrefix = row.substring(0, row.lastIndexOf("#") + 1);
            RelatedFinancingDto relatedFinancing = new RelatedFinancingDto(Long.valueOf(showData.get(cellKeyPrefix + "glzjrt_id")), (Long)Long.parseLong(showData.get(cellKeyPrefix + RELATED_FINANCING_RELATED_PARTY_COL_DIMENSION)), (Long)Long.parseLong(showData.get(cellKeyPrefix + "glzjrt_gjdq")), showData.get(cellKeyPrefix + "glzjrt_ywmc"), Arrays.stream(showData.get(cellKeyPrefix + "glzjrt_jynr").split("\u3001")).map(p -> Long.parseLong(p)).collect(Collectors.toList()), new BigDecimal(showData.get(cellKeyPrefix + "glzjrt_jdjebj")), DateUtils.stringToDate(showData.get(cellKeyPrefix + "glzjrt_startdate")), DateUtils.stringToDate(showData.get(cellKeyPrefix + "glzjrt_enddate")), new BigDecimal(showData.get(cellKeyPrefix + "glzjrt_ydll")), new BigDecimal(showData.get(cellKeyPrefix + "glzjrt_jyjelx")));
            result.add(relatedFinancing);
        }
        return result;
    }
}

