/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.declarereport;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.ictm.business.admindivision.AdminDivisionBusiness;
import kd.taxc.ictm.business.bizdefinition.BizDefBusiness;
import kd.taxc.ictm.business.currency.CurrencyBusiness;
import kd.taxc.ictm.business.declarereport.DeclareMainTscBusiness;
import kd.taxc.ictm.business.fetchdata.IctmDraftGlobalDynRowListFetchBusiness;
import kd.taxc.ictm.business.taxmain.IctmTaxMainCommonBusiness;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import kd.taxc.ictm.common.dto.DeclareReportAndDraftTransFormRelationDto;
import kd.taxc.ictm.common.enums.DeclareFixCellWithDraftFixCellEnum;
import kd.taxc.ictm.common.enums.DeclareReportTransFormEnum;
import kd.taxc.ictm.common.enums.FillFormCatalogEnum;
import kd.taxc.ictm.common.enums.IctmBizdefBdCountryMapEnum;
import org.apache.commons.collections4.MapUtils;

public class IctmDeclareReportFixCellDataBusiness {
    private static final Log log = LogFactory.getLog(IctmDeclareReportFixCellDataBusiness.class);

    public static Map<String, String> getFixCellValueMap(Long orgId, Date skssqq, Date skssqz) {
        Map<String, String> cellKeyAndValueMap;
        HashMap<String, String> result = new HashMap<String, String>(500);
        DynamicObject draftObject = DeclareMainTscBusiness.getDeclareMainTable(orgId, skssqq, skssqz, "gljydg");
        if (draftObject == null) {
            cellKeyAndValueMap = new HashMap<String, String>(0);
        } else {
            DynamicObject[] details = DeclareMainTscBusiness.getDeclareDetailTable((Long)draftObject.getLong("id"), new String[0]);
            cellKeyAndValueMap = Arrays.stream(details).collect(Collectors.toMap(k -> k.getString("cellnumber"), v -> v.getString("value")));
        }
        Map<String, String> fillFormCatalogFixCellValueMap = IctmDeclareReportFixCellDataBusiness.getFillFormCatalogFixCellValueMap(orgId, skssqq, skssqz, cellKeyAndValueMap);
        result.putAll(fillFormCatalogFixCellValueMap);
        Map<String, String> reportEnterpriseInfoFixCellValueMap = IctmDeclareReportFixCellDataBusiness.getReportEnterpriseInfoFixCellValueMap(orgId, skssqq, skssqz);
        result.putAll(reportEnterpriseInfoFixCellValueMap);
        Map<String, String> transTableRelatedFixCellValueMap = IctmDeclareReportFixCellDataBusiness.getTransTableRelatedFixCellValueMap(cellKeyAndValueMap);
        result.putAll(transTableRelatedFixCellValueMap);
        Map<String, String> declareFixCellFromDraftFixCellValueMap = IctmDeclareReportFixCellDataBusiness.getDeclareFixCellFromDraftFixCellValue(cellKeyAndValueMap);
        result.putAll(declareFixCellFromDraftFixCellValueMap);
        return result;
    }

    public static Map<String, String> getFillFormCatalogFixCellValueMap(Long orgId, Date skssqq, Date skssqz, Map<String, String> cellKeyAndValueMap) {
        HashMap<String, String> result = new HashMap<String, String>(17);
        for (FillFormCatalogEnum fillFormCatalogEnum : FillFormCatalogEnum.values()) {
            String value = fillFormCatalogEnum.getFillFormCatalogFillState().fillFormIsNeedFill(orgId, skssqq, skssqz, cellKeyAndValueMap) != false ? "1" : "";
            result.put(fillFormCatalogEnum.getCellKey(), value);
        }
        return result;
    }

    public static Map<String, String> getReportEnterpriseInfoFixCellValueMap(Long orgId, Date skssqq, Date skssqz) {
        Long holdingCompanyOrgId;
        DynamicObject holdingCompanyRegisterTaxMain;
        List<DynamicObject> taxMains = IctmTaxMainCommonBusiness.getAllTaxMainByOrgId(Stream.of(orgId).collect(Collectors.toList()));
        DynamicObject chinaTaxMain = taxMains.stream().filter(p -> p.getLong("taxationsys.id") == TaxationsysMappingEnum.CHN.getId().longValue()).findFirst().orElse(null);
        DynamicObject registerAreaTaxMain = taxMains.stream().filter(p -> p.getBoolean("registerplace")).findFirst().orElse(null);
        HashMap<String, String> result = new HashMap<String, String>(30);
        IctmDeclareReportFixCellDataBusiness.putAreaDataValue(registerAreaTaxMain, "registeraddress", "bgqyxxb_zcdzgjdq#bgqyxxb_zcdzgjdql", "bgqyxxb_zcdzsf#bgqyxxb_zcdzsfl", "bgqyxxb_zcdzdjs#bgqyxxb_zcdzdjsl", result);
        IctmDeclareReportFixCellDataBusiness.putAreaDataValue(registerAreaTaxMain, "actualaddress", "bgqyxxb_jydzgjdq#bgqyxxb_jydzgjdql", "bgqyxxb_jydzsf#bgqyxxb_jydzsfl", "bgqyxxb_jydzdjs#bgqyxxb_jydzdjsl", result);
        if (registerAreaTaxMain != null) {
            result.put("bgqyxxb_jyfw#bgqyxxb_jyfwl", registerAreaTaxMain.getString("businessscop"));
            DynamicObject registeredCurrency = registerAreaTaxMain.getDynamicObject("registeredcurrency");
            DynamicObject bizDefEntryCurrencyObject = null;
            if (registeredCurrency != null) {
                bizDefEntryCurrencyObject = BizDefBusiness.getBizDefEntryObject("BZ-01", registeredCurrency.getString("number"), "standardnumber");
            }
            result.put("bgqyxxb_zczbbz#bgqyxxb_zczbbzl", bizDefEntryCurrencyObject == null ? "0" : bizDefEntryCurrencyObject.getString("id"));
            result.put("bgqyxxb_tzzebz#bgqyxxb_tzzebzl", bizDefEntryCurrencyObject == null ? "0" : bizDefEntryCurrencyObject.getString("id"));
            result.put("bgqyxxb_zczbje#bgqyxxb_zczbjel", registerAreaTaxMain.getString("registeredcapital"));
            result.put("bgqyxxb_tzzeje#bgqyxxb_tzzejel", registerAreaTaxMain.getString("registeredcapital"));
            Boolean isLegal = registerAreaTaxMain.getString("entitytype").equals("legal");
            result.put("bgqyxxb_dlfr#bgqyxxb_dlfrl", isLegal != false ? Boolean.TRUE.toString() : Boolean.FALSE.toString());
            result.put("bgqyxxb_fzr#bgqyxxb_fzrl", registerAreaTaxMain.getString("legalpeople"));
            result.put("bgqyxxb_dlhs#bgqyxxb_dlhsl", Boolean.TRUE.toString());
        }
        if (chinaTaxMain != null) {
            result.put("bgqyxxb_zgswjg#bgqyxxb_zgswjgl", chinaTaxMain.getString("taxoffice.id"));
            boolean isRegisterPlace = chinaTaxMain.getBoolean("registerplace");
            if (isRegisterPlace) {
                result.put("bgqyxxb_djzclx#bgqyxxb_djzclxl", chinaTaxMain.getString("registertype.id"));
                result.put("bgqyxxb_sshy#bgqyxxb_sshyl", chinaTaxMain.getString("codeandname.id"));
                long idValue = chinaTaxMain.getLong("accountingstandards.id");
                result.put("bgqyxxb_syhjzd#bgqyxxb_syhjzdl", idValue == 1072508277482326032L ? "1072508277482326033" : String.valueOf(idValue));
            }
        }
        result.put("bgqyxxb_ssgs#bgqyxxb_ssgsl", Boolean.FALSE.toString());
        Long accountOrgBaseCurrencyId = IctmTaxOrgCommonBusiness.getAccountOrgBaseCurrencyByTaxOrg(orgId, skssqq, skssqz);
        DynamicObject currency = CurrencyBusiness.getCurrencyById(accountOrgBaseCurrencyId);
        if (currency != null) {
            DynamicObject bizDefEntryCurrencyObject = BizDefBusiness.getBizDefEntryObject("BZ-01", currency.getString("number"), "standardnumber");
            result.put("bgqyxxb_jzbwb#bgqyxxb_jzbwbl", bizDefEntryCurrencyObject == null ? "0" : bizDefEntryCurrencyObject.getString("id"));
        }
        if ((holdingCompanyRegisterTaxMain = (holdingCompanyOrgId = IctmTaxOrgCommonBusiness.getHoldingCompanyOrgId(skssqz)).longValue() == orgId.longValue() ? registerAreaTaxMain : IctmTaxMainCommonBusiness.getRegisterAreaTaxMainByOrgId(holdingCompanyOrgId)) != null) {
            long taxationSysId = holdingCompanyRegisterTaxMain.getLong("taxationsys.id");
            DynamicObject holdingCompanyRegisterTaxOrg = IctmTaxOrgCommonBusiness.queryTaxcOrgByOrgId(holdingCompanyOrgId, taxationSysId);
            String string = ((DynamicObject)holdingCompanyRegisterTaxOrg.getDynamicObjectCollection("entryentity").get(0)).getString("entry_taxpayer");
        }
        result.put("bgqyxxb_bzdwgbbgdbsqy#bgqyxxb_bzdwgbbgdbsqyl", Boolean.FALSE.toString());
        result.put("bgqyxxb_zxyydjap#bgqyxxb_zxyydjapl", Boolean.FALSE.toString());
        result.put("bgqyxxb_qdhzzxcbftxy#bgqyxxb_qdhzzxcbftxyl", Boolean.FALSE.toString());
        result.putAll(IctmDeclareReportFixCellDataBusiness.getShareholderTop5Info(registerAreaTaxMain));
        return result;
    }

    private static void putAreaDataValue(DynamicObject taxMainObject, String adminDivisionFieldSign, String countryRowColDimension, String provinceRowColDimension, String cityRowColDimension, Map<String, String> result) {
        Boolean isChinaCountry;
        if (taxMainObject == null) {
            return;
        }
        long adminDivisionId = taxMainObject.getLong(adminDivisionFieldSign);
        DynamicObject registerAreaAdminDivisionObject = AdminDivisionBusiness.getAdminDivisionById(adminDivisionId);
        DynamicObject countryObject = BizDefBusiness.getBizDefEntryObject("GJDQ-01", registerAreaAdminDivisionObject.getString("country.fullname"), "projectfullname");
        if (countryObject != null && StringUtils.isNotEmpty((String)countryRowColDimension)) {
            result.put(countryRowColDimension, countryObject.getString("id"));
        }
        if (!(isChinaCountry = Boolean.valueOf(IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.stream().anyMatch(p -> p.longValue() == countryObject.getLong("id")))).booleanValue() || StringUtils.isEmpty((String)provinceRowColDimension) && StringUtils.isEmpty((String)cityRowColDimension)) {
            return;
        }
        Tuple<List<Long>, List<String>> registerAreaTuple = AdminDivisionBusiness.getAllLevelAdminDivisionById(registerAreaAdminDivisionObject, 2);
        if (registerAreaTuple == null || CollectionUtils.isEmpty((Collection)((Collection)registerAreaTuple.item2))) {
            return;
        }
        String provinceName = (String)((List)registerAreaTuple.item2).get(0);
        result.put(provinceRowColDimension, provinceName);
        if (AdminDivisionBusiness.getAdministeredId().contains(provinceName)) {
            result.put(cityRowColDimension, provinceName);
        } else if (((List)registerAreaTuple.item2).size() >= 2) {
            result.put(cityRowColDimension, (String)((List)registerAreaTuple.item2).get(1));
        }
    }

    private static Map<String, String> getShareholderTop5Info(DynamicObject registerAreaTaxMain) {
        if (registerAreaTaxMain == null) {
            return new HashMap<String, String>(0);
        }
        DynamicObjectCollection shareholderCollection = registerAreaTaxMain.getDynamicObjectCollection("entryentity1");
        if (CollectionUtils.isEmpty((Collection)shareholderCollection)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        List shareholderList = shareholderCollection.stream().sorted((a, b) -> b.getBigDecimal("investrate").compareTo(a.getBigDecimal("investrate"))).collect(Collectors.toList());
        for (int i = 0; i < shareholderList.size() && i < 5; ++i) {
            DynamicObject shareholder = (DynamicObject)shareholderList.get(i);
            int index = i + 1;
            result.put("bgqyxxb_qygdxx" + index + "#bgqyxxb_qygdxxgdmc", shareholder.getString("name"));
            DynamicObject country = shareholder.getDynamicObject("nationality");
            DynamicObject countryObject = null;
            if (country != null) {
                countryObject = BizDefBusiness.getBizDefEntryObject("GJDQ-01", country.getString("fullname"), "projectfullname");
                if (countryObject != null) {
                    result.put("bgqyxxb_qygdxx" + index + "#bgqyxxb_qygdxxgjdq", countryObject.getString("id"));
                } else {
                    String ictmBizdefEntryId = IctmBizdefBdCountryMapEnum.getIctmBizdefEntryIdByBdCountryId(country.getString("id"));
                    if (ictmBizdefEntryId != null) {
                        result.put("bgqyxxb_qygdxx" + index + "#bgqyxxb_qygdxxgjdq", ictmBizdefEntryId);
                    }
                }
            }
            result.put("bgqyxxb_qygdxx" + index + "#bgqyxxb_qygdxsfzjhm", shareholder.getString("idnumber"));
            result.put("bgqyxxb_qygdxx" + index + "#bgqyxxb_qygdxxcgbl", shareholder.getBigDecimal("investrate").divide(new BigDecimal("100")).toString());
        }
        return result;
    }

    public static Map<String, String> getTransTableRelatedFixCellValueMap(Map<String, String> cellKeyAndValueMap) {
        if (MapUtils.isEmpty(cellKeyAndValueMap)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> result = new HashMap<String, String>(300);
        for (DeclareReportTransFormEnum declareReportTransFormEnum : DeclareReportTransFormEnum.values()) {
            for (DeclareReportAndDraftTransFormRelationDto reportAndDraftTransFormRelation : declareReportTransFormEnum.getReportAndDraftTransFormRelations()) {
                IctmDeclareReportFixCellDataBusiness.putTransFormTop5TableValue(reportAndDraftTransFormRelation, declareReportTransFormEnum.getColDimensionMap(), cellKeyAndValueMap, result);
            }
            String amountColDimension = declareReportTransFormEnum.getAmountFieldColDimension();
            String draftAmountColDimension = declareReportTransFormEnum.getColDimensionMap().get(amountColDimension);
            for (Map.Entry<String, String> amountColRowDimensionMapEntry : declareReportTransFormEnum.getOnlyAmountColRowDimensionMap().entrySet()) {
                result.put(IctmDeclareReportFixCellDataBusiness.compositeRowColDimension(amountColRowDimensionMapEntry.getKey(), amountColDimension), cellKeyAndValueMap.get(IctmDeclareReportFixCellDataBusiness.compositeRowColDimension(amountColRowDimensionMapEntry.getValue(), draftAmountColDimension)));
            }
        }
        return result;
    }

    private static void putTransFormTop5TableValue(DeclareReportAndDraftTransFormRelationDto reportAndDraftTransFormRelation, Map<String, String> colDimensionMap, Map<String, String> cellKeyAndValueMap, Map<String, String> result) {
        String draftRowDimension = reportAndDraftTransFormRelation.getDraftTransFormTop5DynRowDimension();
        for (int i = 1; i <= 5; ++i) {
            String rowDimension = reportAndDraftTransFormRelation.getRowDimensionPrefix() + (reportAndDraftTransFormRelation.getStartRowIndex() + i - 1);
            for (Map.Entry<String, String> colDimensionEntry : colDimensionMap.entrySet()) {
                String value = cellKeyAndValueMap.get(IctmDeclareReportFixCellDataBusiness.compositeRowColDimension(draftRowDimension, String.valueOf(i), colDimensionEntry.getValue()));
                result.put(IctmDeclareReportFixCellDataBusiness.compositeRowColDimension(rowDimension, colDimensionEntry.getKey()), value == null ? "" : value);
            }
        }
    }

    public static Map<String, String> getDeclareFixCellFromDraftFixCellValue(Map<String, String> draftCellMap) {
        if (MapUtils.isEmpty(draftCellMap)) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> result = new HashMap<String, String>(100);
        for (DeclareFixCellWithDraftFixCellEnum declareFixCellWithDraftFixCellEnum : DeclareFixCellWithDraftFixCellEnum.values()) {
            declareFixCellWithDraftFixCellEnum.getCellKeyMap().entrySet().forEach(p -> result.put((String)p.getKey(), (String)draftCellMap.get(p.getValue())));
        }
        return result;
    }

    public static String compositeRowColDimension(String ... values) {
        StringJoiner joiner = new StringJoiner("#");
        for (String value : values) {
            joiner.add(value);
        }
        return joiner.toString();
    }
}

