/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.declarereport.extension;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.AbstractFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declaredynamicrowcalculate.service.DeclareDynamicRowCalculateService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.DeclareDynamicRowCalculateServiceResult;
import kd.taxc.bdtaxr.formplugin.taxdeclare.MultiDeclarePlugin;
import kd.taxc.ictm.business.fetchdata.IctmDeclareGlobalDynRowListFetchBusiness;
import kd.taxc.ictm.business.fetchdata.IctmDraftGlobalDynRowListFetchBusiness;
import kd.taxc.ictm.business.relatedparty.RelatedPartyBusiness;
import kd.taxc.ictm.common.dto.IctmDeclareDynamicRowCalculateServiceResultDto;
import kd.taxc.ictm.common.enums.DeclareReportDynRowEnum;
import kd.taxc.ictm.common.enums.FillFormCatalogEnum;
import kd.taxc.ictm.common.enums.business.fillformcatalog.FillFormHideOrShowService;
import kd.taxc.ictm.common.util.DateUtils;

public class IctmDeclareDynamicRowCalculateServiceImpl
implements DeclareDynamicRowCalculateService {
    private static final Log log = LogFactory.getLog(IctmDeclareDynamicRowCalculateServiceImpl.class);
    private static final Map<String, String> GBBG_DYN_ROW_LINKAGE_MAP = new HashMap<String, String>(2){
        {
            this.put(DeclareReportDynRowEnum.GBBG_INCOME_TAXATION_BUSINESS_COUNTRY_DISTRIBUTION_DYN_ROW.getDynRowDimension(), DeclareReportDynRowEnum.GBBG_INCOME_TAXATION_BUSINESS_COUNTRY_DISTRIBUTION_ENG_DYN_ROW.getDynRowDimension());
            this.put(DeclareReportDynRowEnum.GBBG_MULTINATIONAL_ENTERPRISES_GROUP_MEMBER_ENTITY_LIST_DYN_ROW.getDynRowDimension(), DeclareReportDynRowEnum.GBBG_MULTINATIONAL_ENTERPRISES_GROUP_MEMBER_ENTITY_LIST_ENG_DYN_ROW.getDynRowDimension());
        }
    };

    public DeclareDynamicRowCalculateServiceResult dynamicRowCalculate(Map<String, String> changeCellMap, DeclareRequestModel requestModel, DeclareResponseModel responseModel, MultiDeclarePlugin plugin) {
        AbstractFormView pluginView = (AbstractFormView)plugin.getView();
        Map showData = (Map)SerializationUtils.fromJsonString((String)pluginView.getPageCache().get("showData"), Map.class);
        HashMap<String, String> oldCellMap = new HashMap<String, String>(changeCellMap.size());
        for (Map.Entry<String, String> changeCellEntry : changeCellMap.entrySet()) {
            oldCellMap.put(changeCellEntry.getKey(), (String)showData.get(changeCellEntry.getKey()));
            showData.put(changeCellEntry.getKey(), changeCellEntry.getValue());
        }
        return this.dynamicRowCalculate(changeCellMap, oldCellMap, showData, requestModel, responseModel, plugin);
    }

    private DeclareDynamicRowCalculateServiceResult dynamicRowCalculate(Map<String, String> changeCellMap, Map<String, String> oldCellMap, Map<String, String> showData, DeclareRequestModel requestModel, DeclareResponseModel responseModel, MultiDeclarePlugin plugin) {
        DeclareDynamicRowCalculateServiceResult result = new DeclareDynamicRowCalculateServiceResult(new HashMap(16), new HashMap(16), new HashMap(16));
        for (Map.Entry<String, String> changeCellEntry : changeCellMap.entrySet()) {
            List<Long> fundsInflowOrOutflowRelatedPartyIds;
            List<Long> transFormRelatedPartyIds;
            List<Long> relatedRelationshipRelatedPartyIds;
            if (changeCellEntry.getValue().equals(oldCellMap.get(changeCellEntry.getKey())) || this.changeFillFormCatalog(plugin, result, requestModel, responseModel, showData, changeCellEntry.getKey(), changeCellEntry.getValue()).booleanValue() || this.changeReportEnterpriseInfo(result, showData, changeCellEntry.getKey()).booleanValue() || this.changeRelatedRelationship(result, requestModel, showData, changeCellEntry.getKey(), changeCellEntry.getValue()).booleanValue()) continue;
            String dynRowDimension = changeCellEntry.getKey().split("#")[0];
            String linkageDynRowDimension = GBBG_DYN_ROW_LINKAGE_MAP.get(dynRowDimension);
            if (StringUtils.isNotEmpty((String)linkageDynRowDimension)) {
                result.getChangeCells().put(changeCellEntry.getKey().replaceFirst(dynRowDimension, linkageDynRowDimension), changeCellEntry.getValue());
            }
            if (this.isChangeTransFormRelatedParty(changeCellEntry.getKey()).booleanValue()) {
                relatedRelationshipRelatedPartyIds = this.getRelatedRelationshipRelatedPartyIds(showData);
                transFormRelatedPartyIds = this.getTransFormRelatedPartyIds(showData);
                fundsInflowOrOutflowRelatedPartyIds = this.getFundsInflowOrOutflowRelatedParty(showData);
                this.changeTransFormRelatedParty(result, requestModel, showData, relatedRelationshipRelatedPartyIds, transFormRelatedPartyIds, fundsInflowOrOutflowRelatedPartyIds, oldCellMap.get(changeCellEntry.getKey()), changeCellEntry.getValue());
                continue;
            }
            if (!this.isChangeFundsInflowOrOutflowRelatedParty(changeCellEntry.getKey()).booleanValue()) continue;
            relatedRelationshipRelatedPartyIds = this.getRelatedRelationshipRelatedPartyIds(showData);
            transFormRelatedPartyIds = this.getTransFormRelatedPartyIds(showData);
            fundsInflowOrOutflowRelatedPartyIds = this.getFundsInflowOrOutflowRelatedParty(showData);
            this.changeFundsInflowOrOutflowRelatedParty(result, requestModel, showData, relatedRelationshipRelatedPartyIds, transFormRelatedPartyIds, fundsInflowOrOutflowRelatedPartyIds, oldCellMap.get(changeCellEntry.getKey()), changeCellEntry.getValue());
        }
        return result;
    }

    public DeclareDynamicRowCalculateServiceResult dynamicRowCalculateAfterDelRow(ArrayList<Map<String, String>> delCells, DeclareRequestModel requestModel, DeclareResponseModel responseModel, MultiDeclarePlugin plugin) {
        AbstractFormView pluginView = (AbstractFormView)plugin.getView();
        Map showData = (Map)SerializationUtils.fromJsonString((String)pluginView.getPageCache().get("showData"), Map.class);
        return this.dynamicRowCalculateAfterDelRow(delCells, showData, requestModel);
    }

    private DeclareDynamicRowCalculateServiceResult dynamicRowCalculateAfterDelRow(ArrayList<Map<String, String>> delCells, Map<String, String> showData, DeclareRequestModel requestModel) {
        DeclareDynamicRowCalculateServiceResult result = new DeclareDynamicRowCalculateServiceResult(new HashMap(16), new HashMap(16), new HashMap(16));
        List delCellKeys = delCells.stream().flatMap(p -> p.entrySet().stream().filter(t -> "cellKey".equals(t.getKey()))).map(p -> (String)p.getValue()).collect(Collectors.toList());
        String delRowFirstCellKey = (String)delCellKeys.get(0);
        this.deleteDynRowChangeRowIndex(result, showData, delRowFirstCellKey.split("#")[0], delRowFirstCellKey.substring(0, delRowFirstCellKey.lastIndexOf("#")));
        if (delCellKeys.stream().anyMatch(p -> this.isChangeFundsInflowOrOutflowRelatedParty((String)p))) {
            String cellKey = delCellKeys.stream().filter(p -> this.isChangeFundsInflowOrOutflowRelatedParty((String)p)).findFirst().get();
            String oldValue = showData.remove(cellKey);
            List<Long> relatedRelationshipRelatedPartyIds = this.getRelatedRelationshipRelatedPartyIds(showData);
            List<Long> transFormRelatedPartyIds = this.getTransFormRelatedPartyIds(showData);
            List<Long> fundsInflowOrOutflowRelatedPartyIds = this.getFundsInflowOrOutflowRelatedParty(showData);
            this.changeFundsInflowOrOutflowRelatedParty(result, requestModel, showData, relatedRelationshipRelatedPartyIds, transFormRelatedPartyIds, fundsInflowOrOutflowRelatedPartyIds, oldValue, null);
            return result;
        }
        String cellKey = (String)delCellKeys.get(0);
        String cellRowDimension = cellKey.split("#")[0];
        String linkageDynRowDimension = GBBG_DYN_ROW_LINKAGE_MAP.get(cellRowDimension);
        if (StringUtils.isNotEmpty((String)linkageDynRowDimension)) {
            ArrayList<Integer> delRowIndexes = (ArrayList<Integer>)result.getDynRowCellListForDel().get(linkageDynRowDimension + "#1");
            if (delRowIndexes == null) {
                delRowIndexes = new ArrayList<Integer>(1);
                result.getDynRowCellListForDel().put(linkageDynRowDimension + "#1", delRowIndexes);
            }
            delRowIndexes.add(Integer.parseInt(cellKey.split("#")[1]));
            this.deleteDynRowChangeRowIndex(result, showData, linkageDynRowDimension, IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(linkageDynRowDimension, cellKey.split("#")[1]));
        }
        return result;
    }

    public DeclareDynamicRowCalculateServiceResult dynamicRowCalculateAfterAddRow(String dynamicRowNo, DeclareRequestModel requestModel, DeclareResponseModel responseModel, MultiDeclarePlugin plugin) {
        String dynRowDimension;
        AbstractFormView pluginView = (AbstractFormView)plugin.getView();
        Map showData = (Map)SerializationUtils.fromJsonString((String)pluginView.getPageCache().get("showData"), Map.class);
        DeclareDynamicRowCalculateServiceResult result = new DeclareDynamicRowCalculateServiceResult(new HashMap(16), new HashMap(16), new HashMap(16));
        DeclareReportDynRowEnum dynRowEnum = DeclareReportDynRowEnum.getEnumByDynRowNo(dynamicRowNo);
        if (dynRowEnum == null) {
            return result;
        }
        Integer maxIndex = 0;
        Integer dynRowIndex = 0;
        if (StringUtils.isNotEmpty((String)dynRowEnum.getRowIndexColDimension())) {
            Map<String, String> rowIndexMap = showData.entrySet().stream().filter(p -> ((String)p.getKey()).startsWith(dynRowEnum.getDynRowDimension()) && ((String)p.getKey()).endsWith(dynRowEnum.getRowIndexColDimension())).collect(Collectors.toMap(k -> (String)k.getKey(), v -> (String)v.getValue()));
            dynRowIndex = rowIndexMap.keySet().stream().map(p -> Integer.parseInt(p.split("#")[1])).sorted(Comparator.reverseOrder()).findFirst().orElse(0);
            maxIndex = rowIndexMap.values().stream().filter(p -> StringUtils.isNotEmpty((String)p)).map(p -> Integer.parseInt(p)).sorted(Comparator.reverseOrder()).findFirst().orElse(0);
            if (maxIndex == 0) {
                maxIndex = maxIndex + dynRowEnum.getStartRowIndex() - 1;
            }
            String rowIndexDimension = IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowEnum.getDynRowDimension(), dynRowIndex.toString(), dynRowEnum.getRowIndexColDimension());
            showData.put(rowIndexDimension, String.valueOf(maxIndex + 1));
            result.getChangeCells().put(rowIndexDimension, String.valueOf(maxIndex + 1));
        }
        if (GBBG_DYN_ROW_LINKAGE_MAP.containsKey(dynRowDimension = dynamicRowNo.split("#")[0])) {
            ArrayList addRows = new ArrayList(1);
            HashMap<String, String> defaultValue = new HashMap<String, String>(1);
            addRows.add(defaultValue);
            DeclareReportDynRowEnum linkDynRowEnum = DeclareReportDynRowEnum.getEnumByDynRowNo(GBBG_DYN_ROW_LINKAGE_MAP.get(dynRowDimension));
            if (linkDynRowEnum != null && StringUtils.isNotEmpty((String)dynRowEnum.getRowIndexColDimension())) {
                defaultValue.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(linkDynRowEnum.getDynRowDimension(), dynRowIndex.toString(), linkDynRowEnum.getRowIndexColDimension()), String.valueOf(maxIndex + 1));
            }
            result.getDynRowForAdd().put(GBBG_DYN_ROW_LINKAGE_MAP.get(dynRowDimension) + "#1", addRows);
        }
        return result;
    }

    private Boolean changeFillFormCatalog(MultiDeclarePlugin plugin, DeclareDynamicRowCalculateServiceResult result, DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, String> showData, String cellKey, String newValue) {
        FillFormCatalogEnum fillFormCatalogEnum = this.getChangeFillFormCatalog(cellKey);
        if (fillFormCatalogEnum == null) {
            return false;
        }
        if (fillFormCatalogEnum.getFillFormDefaultValueService() == null) {
            return true;
        }
        FillFormHideOrShowService fillFormDefaultValueService = fillFormCatalogEnum.getFillFormDefaultValueService();
        IctmDeclareDynamicRowCalculateServiceResultDto serviceResult = new IctmDeclareDynamicRowCalculateServiceResultDto(new HashMap<String, List<Map<String, String>>>(16), new HashMap<String, List<Integer>>(16), new HashMap<String, String>(16));
        String formNumber = fillFormCatalogEnum.getNumber().get(0);
        if ("1".equals(newValue)) {
            fillFormDefaultValueService.showForm(serviceResult, plugin, requestModel, formNumber);
        } else {
            fillFormDefaultValueService.hideForm(serviceResult, plugin, showData, formNumber);
        }
        result.getChangeCells().putAll(serviceResult.getChangeCells());
        result.getDynRowForAdd().putAll(serviceResult.getDynRowForAdd());
        result.getDynRowCellListForDel().putAll(serviceResult.getDynRowCellListForDel());
        serviceResult.getCascadeChangeCellValue().putAll(serviceResult.getChangeCells());
        HashMap<String, String> oldCellMap = new HashMap<String, String>(serviceResult.getCascadeChangeCellValue().size());
        for (Map.Entry<String, String> changeCellEntry : serviceResult.getCascadeChangeCellValue().entrySet()) {
            oldCellMap.put(changeCellEntry.getKey(), showData.get(changeCellEntry.getKey()));
            showData.put(changeCellEntry.getKey(), changeCellEntry.getValue());
        }
        DeclareDynamicRowCalculateServiceResult changeCellResult = this.dynamicRowCalculate(serviceResult.getCascadeChangeCellValue(), oldCellMap, showData, requestModel, responseModel, plugin);
        if (changeCellResult != null) {
            this.mergeDeclareDynamicRowCalculateServiceResult(result, changeCellResult);
        }
        for (ArrayList<Map<String, String>> delRowCell : serviceResult.getDelRowCells()) {
            DeclareDynamicRowCalculateServiceResult delRowResult = this.dynamicRowCalculateAfterDelRow(delRowCell, showData, requestModel);
            this.mergeDeclareDynamicRowCalculateServiceResult(result, delRowResult);
        }
        return true;
    }

    private Boolean changeReportEnterpriseInfo(DeclareDynamicRowCalculateServiceResult result, Map<String, String> showData, String cellKey) {
        String cellRowDimension;
        String rowDimensionPrefix = "bgqyxxb_qygdxx";
        String shareHolderTypeColDimension = "bgqyxxb_qygdxxgdlx";
        String countryColDimension = "bgqyxxb_qygdxxgjdq";
        String registrationTypeColDimension = "bgqyxxb_qygdxxdjzclx";
        String idTypeColDimension = "bgqyxxb_qygdxxzjzl";
        String cellColDimension = cellKey.substring(cellKey.lastIndexOf("#") + 1);
        if (cellKey.startsWith(rowDimensionPrefix) && shareHolderTypeColDimension.equals(cellColDimension)) {
            cellRowDimension = cellKey.split("#")[0];
            result.getChangeCells().put(cellRowDimension + "#" + registrationTypeColDimension, "0");
            result.getChangeCells().put(cellRowDimension + "#" + idTypeColDimension, "0");
        }
        if (cellKey.startsWith(rowDimensionPrefix) && Stream.of(shareHolderTypeColDimension, countryColDimension).anyMatch(p -> p.equals(cellColDimension)) && Long.parseLong(showData.get((cellRowDimension = cellKey.split("#")[0]) + "#" + shareHolderTypeColDimension)) == 1899377451617086465L) {
            String registrationTypeRowColDimension = cellRowDimension + "#" + registrationTypeColDimension;
            Long countryId = Long.parseLong(showData.get(cellRowDimension + "#" + countryColDimension));
            if (countryId == 1555086414142877696L) {
                result.getChangeCells().put(registrationTypeRowColDimension, "1916119342601346048");
                return true;
            }
            if (Stream.of(1555086414142877698L, 1555086414142877699L, 1555086414142877697L).anyMatch(p -> p.longValue() == countryId.longValue())) {
                result.getChangeCells().put(registrationTypeRowColDimension, "1916119342601346049");
                return true;
            }
            if (countryId != 0L) {
                result.getChangeCells().put(registrationTypeRowColDimension, "1916119342601346050");
            }
            return true;
        }
        return false;
    }

    private void mergeDeclareDynamicRowCalculateServiceResult(DeclareDynamicRowCalculateServiceResult result, DeclareDynamicRowCalculateServiceResult mergeResult) {
        result.getChangeCells().putAll(mergeResult.getChangeCells());
        for (Map.Entry addRow : mergeResult.getDynRowForAdd().entrySet()) {
            if (result.getDynRowForAdd().containsKey(addRow.getKey())) {
                ((List)result.getDynRowForAdd().get(addRow.getKey())).addAll((Collection)addRow.getValue());
                continue;
            }
            result.getDynRowForAdd().put(addRow.getKey(), addRow.getValue());
        }
        for (Map.Entry delRow : mergeResult.getDynRowCellListForDel().entrySet()) {
            if (result.getDynRowCellListForDel().containsKey(delRow.getKey())) {
                ((List)result.getDynRowCellListForDel().get(delRow.getKey())).addAll((Collection)delRow.getValue());
                continue;
            }
            result.getDynRowCellListForDel().put(delRow.getKey(), delRow.getValue());
        }
    }

    private void changeTransFormRelatedParty(DeclareDynamicRowCalculateServiceResult result, DeclareRequestModel requestModel, Map<String, String> showData, List<Long> relatedRelationshipRelatedPartyIds, List<Long> transFormRelatedPartyIds, List<Long> fundsInflowOrOutflowRelatedPartyIds, String oldValue, String newValue) {
        DynamicObject newRelatedParty;
        Boolean isDelRelatedRelationshipDynRow = false;
        if (StringUtils.isNotEmpty((String)oldValue) && transFormRelatedPartyIds.stream().noneMatch(p -> p == Long.parseLong(oldValue)) && fundsInflowOrOutflowRelatedPartyIds.stream().noneMatch(p -> p == Long.parseLong(oldValue))) {
            isDelRelatedRelationshipDynRow = this.deleteRelatedRelationshipDynRow(result, showData, oldValue);
        }
        DynamicObject oldRelatedParty = StringUtils.isNotEmpty((String)oldValue) ? RelatedPartyBusiness.getRelatedPartyById(Long.parseLong(oldValue)) : null;
        Boolean isDelOverseasRelatedPartyDynRow = false;
        if (oldRelatedParty != null && IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.stream().noneMatch(p -> p.longValue() == oldRelatedParty.getLong("area.id")) && !"2".equals(oldRelatedParty.getString("type.number")) && transFormRelatedPartyIds.stream().noneMatch(p -> p == Long.parseLong(oldValue))) {
            isDelOverseasRelatedPartyDynRow = this.deleteOverseasRelatedPartyDynRow(result, showData, oldValue);
        }
        DynamicObject dynamicObject = newRelatedParty = StringUtils.isNotEmpty((String)newValue) ? RelatedPartyBusiness.getRelatedPartyById(Long.parseLong(newValue)) : null;
        if (newRelatedParty != null && relatedRelationshipRelatedPartyIds.stream().noneMatch(p -> p == Long.parseLong(newValue))) {
            this.addRelatedRelationshipDynRow(result, showData, newRelatedParty, DateUtils.stringToDate(requestModel.getSkssqq()), DateUtils.stringToDate(requestModel.getSkssqz()), isDelRelatedRelationshipDynRow);
            if (IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.stream().noneMatch(p -> p.longValue() == newRelatedParty.getLong("area.id")) && !"2".equals(newRelatedParty.getString("type.number"))) {
                this.addOverseasRelatedPartyDynRow(result, showData, newRelatedParty, DateUtils.stringToDate(requestModel.getSkssqq()), null, isDelOverseasRelatedPartyDynRow);
            }
        }
    }

    private void changeFundsInflowOrOutflowRelatedParty(DeclareDynamicRowCalculateServiceResult result, DeclareRequestModel requestModel, Map<String, String> showData, List<Long> relatedRelationshipRelatedPartyIds, List<Long> transFormRelatedPartyIds, List<Long> fundsInflowOrOutflowRelatedPartyIds, String oldValue, String newValue) {
        DynamicObject newRelatedParty;
        Boolean isDelRelatedRelationshipDynRow = false;
        if (StringUtils.isNotEmpty((String)oldValue) && transFormRelatedPartyIds.stream().noneMatch(p -> p == Long.parseLong(oldValue)) && fundsInflowOrOutflowRelatedPartyIds.stream().noneMatch(p -> p == Long.parseLong(oldValue))) {
            isDelRelatedRelationshipDynRow = this.deleteRelatedRelationshipDynRow(result, showData, oldValue);
        }
        DynamicObject dynamicObject = newRelatedParty = StringUtils.isNotEmpty((String)newValue) ? RelatedPartyBusiness.getRelatedPartyById(Long.parseLong(newValue)) : null;
        if (newRelatedParty != null && relatedRelationshipRelatedPartyIds.stream().noneMatch(p -> p == Long.parseLong(newValue))) {
            this.addRelatedRelationshipDynRow(result, showData, newRelatedParty, DateUtils.stringToDate(requestModel.getSkssqq()), DateUtils.stringToDate(requestModel.getSkssqz()), isDelRelatedRelationshipDynRow);
        }
    }

    private Boolean changeRelatedRelationship(DeclareDynamicRowCalculateServiceResult result, DeclareRequestModel requestModel, Map<String, String> showData, String changeCellKey, String newValue) {
        if (!changeCellKey.startsWith(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension()) || Stream.of(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getRelatedPartyColDimension(), "glgxb_nsrsbhhsfzjhml").noneMatch(p -> changeCellKey.endsWith((String)p))) {
            return false;
        }
        String cellKeyPrefix = changeCellKey.substring(0, changeCellKey.lastIndexOf("#") + 1);
        if (changeCellKey.endsWith(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getRelatedPartyColDimension())) {
            if ("0".equals(newValue)) {
                showData.put(cellKeyPrefix + "glgxb_zjzll", "0");
                showData.put(cellKeyPrefix + "glgxb_nsrsbhhsfzjhml", "");
                showData.put(cellKeyPrefix + "glgxb_glgxlxl", "");
                showData.put(cellKeyPrefix + "glgxb_qsrql", "");
                showData.put(cellKeyPrefix + "glgxb_jzrql", "");
            } else {
                DynamicObject relatedParty = RelatedPartyBusiness.getRelatedPartyById(Long.parseLong(newValue));
                Map<String, String> relatedRelationshipDynRowMap = IctmDeclareGlobalDynRowListFetchBusiness.getRelatedRelationshipDynRowMap(relatedParty, changeCellKey.split("#")[1], showData.get(cellKeyPrefix + "glgxb_seq"), DateUtils.stringToDate(requestModel.getSkssqq()), DateUtils.stringToDate(requestModel.getSkssqz()));
                result.getChangeCells().putAll(relatedRelationshipDynRowMap);
            }
            return true;
        }
        String relatedPartyRowColDimension = cellKeyPrefix + DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getRelatedPartyColDimension();
        String relatedPartyId = showData.get(relatedPartyRowColDimension);
        if (showData.entrySet().stream().noneMatch(p -> ((String)p.getKey()).startsWith(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension()) && ((String)p.getKey()).endsWith(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getRelatedPartyColDimension()) && ((String)p.getValue()).equals(relatedPartyId))) {
            return false;
        }
        Map.Entry overseasRelatedPartyCellEntry = showData.entrySet().stream().filter(p -> ((String)p.getKey()).startsWith(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension()) && ((String)p.getKey()).endsWith(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getRelatedPartyColDimension()) && ((String)p.getValue()).equals(relatedPartyId)).findFirst().get();
        String idNumberCellKey = ((String)overseasRelatedPartyCellEntry.getKey()).substring(0, ((String)overseasRelatedPartyCellEntry.getKey()).lastIndexOf("#") + 1) + "jwglfxxb_nsrsbh";
        result.getChangeCells().put(idNumberCellKey, newValue);
        return true;
    }

    private Boolean deleteRelatedRelationshipDynRow(DeclareDynamicRowCalculateServiceResult result, Map<String, String> showData, String relatedPartyId) {
        Optional<String> cellKeyOptional = showData.entrySet().stream().filter(p -> ((String)p.getKey()).startsWith(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension()) && ((String)p.getKey()).endsWith("glgxb_glfmcl") && ((String)p.getValue()).equals(relatedPartyId)).map(p -> (String)p.getKey()).findFirst();
        if (cellKeyOptional.isPresent()) {
            ArrayList<Integer> deleteRowIndexes = (ArrayList<Integer>)result.getDynRowCellListForDel().get(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension() + "#1");
            if (CollectionUtils.isEmpty((Collection)deleteRowIndexes)) {
                deleteRowIndexes = new ArrayList<Integer>(1);
                result.getDynRowCellListForDel().put(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension() + "#1", deleteRowIndexes);
            }
            int delRowIndex = Integer.parseInt(cellKeyOptional.get().split("#")[1]);
            deleteRowIndexes.add(delRowIndex);
            this.deleteDynRowChangeRowIndex(result, showData, DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension(), IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension(), cellKeyOptional.get().split("#")[1]));
            String cellKeyPrefix = DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension() + "#" + delRowIndex + "#";
            List<String> delCellKeys = showData.keySet().stream().filter(p -> p.startsWith(cellKeyPrefix)).collect(Collectors.toList());
            delCellKeys.forEach(p -> {
                String cfr_ignored_0 = (String)showData.remove(p);
            });
            return true;
        }
        return false;
    }

    private Boolean deleteOverseasRelatedPartyDynRow(DeclareDynamicRowCalculateServiceResult result, Map<String, String> showData, String relatedPartyId) {
        Optional<String> cellKeyOptional = showData.entrySet().stream().filter(p -> ((String)p.getKey()).startsWith(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension()) && ((String)p.getKey()).endsWith("jwglfxxb_nsrmc") && ((String)p.getValue()).equals(relatedPartyId)).map(p -> (String)p.getKey()).findFirst();
        if (cellKeyOptional.isPresent()) {
            ArrayList<Integer> deleteRowIndexes = (ArrayList<Integer>)result.getDynRowCellListForDel().get(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension() + "#1");
            if (CollectionUtils.isEmpty((Collection)deleteRowIndexes)) {
                deleteRowIndexes = new ArrayList<Integer>(1);
                result.getDynRowCellListForDel().put(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension() + "#1", deleteRowIndexes);
            }
            int delRowIndex = Integer.parseInt(cellKeyOptional.get().split("#")[1]);
            deleteRowIndexes.add(delRowIndex);
            this.deleteDynRowChangeRowIndex(result, showData, DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension(), IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension(), cellKeyOptional.get().split("#")[1]));
            String cellKeyPrefix = DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension() + "#" + delRowIndex + "#";
            List<String> delCellKeys = showData.keySet().stream().filter(p -> p.startsWith(cellKeyPrefix)).collect(Collectors.toList());
            delCellKeys.forEach(p -> {
                String cfr_ignored_0 = (String)showData.remove(p);
            });
            return true;
        }
        return false;
    }

    private void deleteDynRowChangeRowIndex(DeclareDynamicRowCalculateServiceResult result, Map<String, String> showData, String dynRowDimension, String delRowColDimensionPrefix) {
        DeclareReportDynRowEnum dynRowEnum = DeclareReportDynRowEnum.getEnumByDynRowNo(dynRowDimension);
        if (dynRowEnum == null || StringUtils.isEmpty((String)dynRowEnum.getRowIndexColDimension())) {
            return;
        }
        Integer delRowIndex = Integer.parseInt(showData.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(delRowColDimensionPrefix, dynRowEnum.getRowIndexColDimension())));
        Map<String, Integer> changeRowIndexCell = showData.entrySet().stream().filter(p -> ((String)p.getKey()).startsWith(dynRowEnum.getDynRowDimension()) && ((String)p.getKey()).endsWith(dynRowEnum.getRowIndexColDimension()) && Integer.parseInt((String)p.getValue()) > delRowIndex).collect(Collectors.toMap(k -> (String)k.getKey(), v -> Integer.parseInt((String)v.getValue())));
        for (Map.Entry<String, Integer> changeRowIndexEntry : changeRowIndexCell.entrySet()) {
            result.getChangeCells().put(changeRowIndexEntry.getKey(), String.valueOf(changeRowIndexEntry.getValue() - 1));
            showData.put(changeRowIndexEntry.getKey(), String.valueOf(changeRowIndexEntry.getValue() - 1));
        }
    }

    private void addRelatedRelationshipDynRow(DeclareDynamicRowCalculateServiceResult result, Map<String, String> showData, DynamicObject relatedParty, Date startDate, Date endDate, Boolean isDelRow) {
        Integer maxRowIndex = showData.keySet().stream().filter(p -> p.startsWith(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension()) && p.endsWith("glgxb_glfmcl")).map(p -> Integer.parseInt(p.split("#")[1])).sorted(Comparator.reverseOrder()).findFirst().orElse(0);
        ArrayList<Map<String, String>> addRows = (ArrayList<Map<String, String>>)result.getDynRowForAdd().get(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension() + "#1");
        if (addRows == null) {
            addRows = new ArrayList<Map<String, String>>(16);
            result.getDynRowForAdd().put(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension() + "#1", addRows);
        }
        Integer seq = maxRowIndex;
        if (isDelRow.booleanValue()) {
            seq = seq - 1;
        }
        Map<String, String> addRowDataMap = IctmDeclareGlobalDynRowListFetchBusiness.getRelatedRelationshipDynRowMap(relatedParty, String.valueOf(maxRowIndex + 1), String.valueOf(seq + 1), startDate, endDate);
        showData.putAll(addRowDataMap);
        addRows.add(addRowDataMap);
    }

    private void addOverseasRelatedPartyDynRow(DeclareDynamicRowCalculateServiceResult result, Map<String, String> showData, DynamicObject relatedParty, Date startDate, String idNumberCellKey, Boolean isDelRow) {
        Integer maxRowIndex = showData.keySet().stream().filter(p -> p.startsWith(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension()) && p.endsWith("jwglfxxb_nsrmc")).map(p -> Integer.parseInt(p.split("#")[1])).sorted(Comparator.reverseOrder()).findFirst().orElse(0);
        ArrayList<Map<String, String>> addRows = (ArrayList<Map<String, String>>)result.getDynRowForAdd().get(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension() + "#1");
        if (addRows == null) {
            addRows = new ArrayList<Map<String, String>>(16);
            result.getDynRowForAdd().put(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension() + "#1", addRows);
        }
        String rowIndex = String.valueOf(maxRowIndex + 1);
        Integer seq = maxRowIndex;
        if (isDelRow.booleanValue()) {
            seq = maxRowIndex - 1;
        }
        Map<String, String> overseasRelatedPartyDynRowMap = IctmDeclareGlobalDynRowListFetchBusiness.getOverseasRelatedPartyDynRowMap(relatedParty, rowIndex, String.valueOf(seq + 1), startDate);
        if (StringUtils.isNotEmpty((String)idNumberCellKey)) {
            overseasRelatedPartyDynRowMap.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension(), rowIndex, "jwglfxxb_nsrsbh"), showData.get(idNumberCellKey));
        }
        addRows.add(overseasRelatedPartyDynRowMap);
        showData.putAll(overseasRelatedPartyDynRowMap);
    }

    private List<Long> getRelatedRelationshipRelatedPartyIds(Map<String, String> showData) {
        return showData.entrySet().stream().filter(p -> this.isChangeRelatedRelationshipRelatedParty((String)p.getKey()) != false && StringUtils.isNotEmpty((String)((String)p.getValue()))).map(p -> Long.parseLong((String)p.getValue())).collect(Collectors.toList());
    }

    private List<Long> getTransFormRelatedPartyIds(Map<String, String> showData) {
        return showData.entrySet().stream().filter(p -> this.isChangeTransFormRelatedParty((String)p.getKey()) != false && StringUtils.isNotEmpty((String)((String)p.getValue()))).map(p -> Long.parseLong((String)p.getValue())).collect(Collectors.toList());
    }

    private List<Long> getFundsInflowOrOutflowRelatedParty(Map<String, String> showData) {
        return showData.entrySet().stream().filter(p -> this.isChangeFundsInflowOrOutflowRelatedParty((String)p.getKey()) != false && StringUtils.isNotEmpty((String)((String)p.getValue()))).map(p -> Long.parseLong((String)p.getValue())).collect(Collectors.toList());
    }

    private FillFormCatalogEnum getChangeFillFormCatalog(String cellKey) {
        return FillFormCatalogEnum.getFillFormCatalogEnumByCellKey(cellKey);
    }

    private Boolean isChangeTransFormRelatedParty(String cellKey) {
        return cellKey.startsWith("yxzcsyqjyb_h") && cellKey.endsWith("yxzcsyqjyb_glfmcl") || cellKey.startsWith("wxzcsyqjyb_h") && cellKey.endsWith("wxzcsyqjyb_glfmcl") || cellKey.startsWith("yxzcshiyqjyb_h") && cellKey.endsWith("yxzcshiyqjyb_glfmcl") || cellKey.startsWith("wxzcshiyqjyb_h") && cellKey.endsWith("wxzcshiyqjyb_glfmcl") || cellKey.startsWith("jrzcjyb_h") && cellKey.endsWith("jrzcjyb_glfmcl") || cellKey.startsWith("gllwb_h") && cellKey.endsWith("gllwb_glfmcl");
    }

    private Boolean isChangeFundsInflowOrOutflowRelatedParty(String cellKey) {
        return cellKey.startsWith("glrrzjb_fetch_item") && cellKey.endsWith("glrrandrczjb_glfmc") || cellKey.startsWith("glrczjb_fetch_item") && cellKey.endsWith("glrrandrczjb_glfmc");
    }

    private Boolean isChangeRelatedRelationshipRelatedParty(String cellKey) {
        return cellKey.startsWith(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension()) && cellKey.endsWith("glgxb_glfmcl");
    }
}

