/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.declarereport.extension;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttemplate.service.DeclareReportTemplateService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.enums.TaxationsysMappingEnum;
import kd.taxc.bdtaxr.common.refactor.template.domain.Cell;
import kd.taxc.bdtaxr.common.refactor.template.domain.Style;
import kd.taxc.bdtaxr.common.util.metadata.domain.EntityField;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.ictm.business.fetchdata.IctmDraftGlobalDynRowListFetchBusiness;
import kd.taxc.ictm.business.relatedparty.RelatedPartyBusiness;
import kd.taxc.ictm.business.taxmain.IctmTaxMainCommonBusiness;
import kd.taxc.ictm.business.taxorg.IctmTaxOrgCommonBusiness;
import kd.taxc.ictm.common.enums.DeclareReportDynRowEnum;
import kd.taxc.ictm.common.enums.FillFormCatalogEnum;
import kd.taxc.ictm.common.util.DateUtils;

public class IctmDeclareReportTemplateServiceImpl
implements DeclareReportTemplateService {
    public TemplateVo parseTemplateByCurrentData(TemplateVo template, DeclareRequestModel requestModel, DeclareResponseModel responseModel, Map<String, EntityField> typeMap, Map<String, String> showData) {
        Map<String, Cell> fixCellMap = template.getTemplate().stream().flatMap(p -> p.getRowList().stream().flatMap(t -> t.stream())).filter(t -> t.isDimensionCell()).collect(Collectors.toMap(k -> k.getCellKey(), v -> v));
        this.setFillFormCatalogLockCell(fixCellMap, requestModel);
        this.setReportingEnterpriseInfoLockCell(fixCellMap, showData, requestModel);
        Map dynamicRowMap = template.getDynamicRow();
        Map<String, Cell> dynamicRowCellMap = dynamicRowMap.values().stream().flatMap(p -> p.stream().flatMap(t -> t.stream())).filter(t -> t.isDimensionCell()).collect(Collectors.toMap(k -> k.getCellKey(), v -> v));
        this.setRelatedRelationshipLockCell(dynamicRowCellMap, showData);
        this.setFundsInflowOrOutflowLockCell(dynamicRowCellMap, showData);
        this.setEquityInvestmentLockCell(fixCellMap, showData);
        return template;
    }

    private void setFillFormCatalogLockCell(Map<String, Cell> fixCellMap, DeclareRequestModel requestModel) {
        if (!IctmTaxOrgCommonBusiness.isHoldingCompany(requestModel.getOrgId(), DateUtils.stringToDate(requestModel.getSkssqz())).booleanValue()) {
            fixCellMap.get(FillFormCatalogEnum.COUNTRY_REPORT_FORM_FILL.getCellKey()).getStyle().setLocked(Boolean.valueOf(true));
        }
    }

    private void setReportingEnterpriseInfoLockCell(Map<String, Cell> fixCellMap, Map<String, String> showData, DeclareRequestModel requestModel) {
        String isListedCompany;
        DynamicObject registerAreaTaxMain;
        String registerAddressCountry = showData.get("bgqyxxb_zcdzgjdq#bgqyxxb_zcdzgjdql");
        if (StringUtils.isNotEmpty((CharSequence)registerAddressCountry) && IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.stream().noneMatch(p -> p == Long.parseLong(registerAddressCountry))) {
            fixCellMap.get("bgqyxxb_zcdzsf#bgqyxxb_zcdzsfl").getStyle().setLocked(Boolean.valueOf(true));
            fixCellMap.get("bgqyxxb_zcdzdjs#bgqyxxb_zcdzdjsl").getStyle().setLocked(Boolean.valueOf(true));
        }
        String businessAddressCountry = showData.get("bgqyxxb_jydzgjdq#bgqyxxb_jydzgjdql");
        if (StringUtils.isNotEmpty((CharSequence)registerAddressCountry) && IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.stream().noneMatch(p -> p == Long.parseLong(businessAddressCountry))) {
            fixCellMap.get("bgqyxxb_jydzsf#bgqyxxb_jydzsfl").getStyle().setLocked(Boolean.valueOf(true));
            fixCellMap.get("bgqyxxb_jydzsf#bgqyxxb_jydzsfl").getStyle().setLocked(Boolean.valueOf(true));
        }
        if ((registerAreaTaxMain = IctmTaxMainCommonBusiness.getRegisterAreaTaxMainByOrgId(requestModel.getOrgId())) != null && registerAreaTaxMain.getLong("taxationsys.id") == TaxationsysMappingEnum.CHN.getId().longValue()) {
            fixCellMap.get("bgqyxxb_djzclx#bgqyxxb_djzclxl").getStyle().setLocked(Boolean.valueOf(true));
            fixCellMap.get("bgqyxxb_djzclx#bgqyxxb_djzclxl").getStyle().setLocked(Boolean.valueOf(true));
            fixCellMap.get("bgqyxxb_syhjzd#bgqyxxb_syhjzdl").getStyle().setLocked(Boolean.valueOf(true));
        }
        if (StringUtils.isNotEmpty((CharSequence)(isListedCompany = showData.get("bgqyxxb_ssgs#bgqyxxb_ssgsl"))) && "0".equals(isListedCompany)) {
            fixCellMap.get("bgqyxxb_ssgpdm#bgqyxxb_ssgpdml").getStyle().setLocked(Boolean.valueOf(true));
            fixCellMap.get("bgqyxxb_ssjys#bgqyxxb_ssjysl").getStyle().setLocked(Boolean.valueOf(true));
        }
        for (int i = 1; i <= 5; ++i) {
            String shareHolderType = showData.get("bgqyxxb_qygdxx" + i + "#bgqyxxb_qygdxxgdlx");
            if (!this.baseDataValueIsEmpty(shareHolderType).booleanValue() && Long.parseLong(shareHolderType) != 1899377451617086465L) continue;
            fixCellMap.get("bgqyxxb_qygdxx" + i + "#bgqyxxb_qygdxxdjzclx").getStyle().setLocked(Boolean.valueOf(true));
        }
    }

    private void setRelatedRelationshipLockCell(Map<String, Cell> dynamicRowCellMap, Map<String, String> showData) {
        List relatedPartyIds = showData.entrySet().stream().filter(p -> this.baseDataValueIsEmpty((String)p.getValue()) == false && (this.isTransFormRelatedPartyCellKey((String)p.getKey()) != false || this.isFundsInflowOrOutflowRelatedPartyCellKey((String)p.getKey()) != false)).map(p -> Long.parseLong((String)p.getValue())).collect(Collectors.toList());
        Map<String, Long> relatedRelationshipRelatedParty = showData.entrySet().stream().filter(p -> this.isRelatedRelationshipRelatedPartyCellKey((String)p.getKey())).collect(Collectors.toMap(k -> (String)k.getKey(), v -> StringUtils.isEmpty((CharSequence)((CharSequence)v.getValue())) ? 0L : Long.parseLong((String)v.getValue())));
        for (Map.Entry<String, Long> entry : relatedRelationshipRelatedParty.entrySet()) {
            String dynRowCellKeyPrefix = entry.getKey().substring(0, entry.getKey().lastIndexOf("#") + 1);
            this.setDynamicRowCellLocked(dynamicRowCellMap.get(entry.getKey()), false);
            if (relatedPartyIds.stream().anyMatch(p -> p.longValue() == ((Long)entry.getValue()).longValue())) {
                this.setDynamicRowCellLocked(dynamicRowCellMap.get(entry.getKey()), true);
                dynamicRowCellMap.get(dynRowCellKeyPrefix + DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getRowIndexColDimension()).setDisabledelrow(true);
            }
            long relatedPartyTypeId = StringUtils.isEmpty((CharSequence)showData.get((dynRowCellKeyPrefix = entry.getKey().substring(0, entry.getKey().lastIndexOf("#") + 1)) + "glgxb_glflxl")) ? 0L : Long.parseLong(showData.get(dynRowCellKeyPrefix + "glgxb_glflxl"));
            long countryId = StringUtils.isEmpty((CharSequence)showData.get(dynRowCellKeyPrefix + "glgxb_gjdql")) ? 0L : Long.parseLong(showData.get(dynRowCellKeyPrefix + "glgxb_gjdql"));
            this.setDynamicRowCellLocked(dynamicRowCellMap.get(dynRowCellKeyPrefix + "glgxb_zjzll"), false);
            this.setDynamicRowCellLocked(dynamicRowCellMap.get(dynRowCellKeyPrefix + "glgxb_nsrsbhhsfzjhml"), false);
            if (Stream.of(1899377451617086464L, 1899377451617086466L).noneMatch(p -> p == relatedPartyTypeId) || IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.stream().anyMatch(p -> p == countryId)) {
                this.setDynamicRowCellLocked(dynamicRowCellMap.get(dynRowCellKeyPrefix + "glgxb_zjzll"), true);
                this.setDynamicRowCellLocked(dynamicRowCellMap.get(dynRowCellKeyPrefix + "glgxb_nsrsbhhsfzjhml"), true);
            }
            String relatedPartyValue = showData.get(dynRowCellKeyPrefix + DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getRelatedPartyColDimension());
            this.setDynamicRowCellLocked(dynamicRowCellMap.get(dynRowCellKeyPrefix + "glgxb_qsrql"), false);
            this.setDynamicRowCellLocked(dynamicRowCellMap.get(dynRowCellKeyPrefix + "glgxb_jzrql"), false);
            if (!this.baseDataValueIsEmpty(relatedPartyValue).booleanValue()) continue;
            this.setDynamicRowCellLocked(dynamicRowCellMap.get(dynRowCellKeyPrefix + "glgxb_qsrql"), true);
            this.setDynamicRowCellLocked(dynamicRowCellMap.get(dynRowCellKeyPrefix + "glgxb_jzrql"), true);
        }
    }

    private void setFundsInflowOrOutflowLockCell(Map<String, Cell> dynamicRowCellMap, Map<String, String> showData) {
        Map<String, Long> relatedPartyCellMap = showData.entrySet().stream().filter(p -> this.isFundsInflowOrOutflowRelatedPartyCellKey((String)p.getKey()) != false && StringUtils.isNotEmpty((CharSequence)((CharSequence)p.getValue()))).collect(Collectors.toMap(k -> (String)k.getKey(), v -> Long.parseLong((String)v.getValue())));
        List<Long> relatedPartyIds = relatedPartyCellMap.values().stream().collect(Collectors.toList());
        Map<Long, DynamicObject> relatedPartyMap = Arrays.stream(RelatedPartyBusiness.getDataByIds(relatedPartyIds)).collect(Collectors.toMap(k -> k.getLong("id"), v -> v));
        for (Map.Entry<String, Long> relatedPartyCellEntry : relatedPartyCellMap.entrySet()) {
            DynamicObject relatedParty = relatedPartyMap.get(relatedPartyCellEntry.getValue());
            if (relatedParty == null) continue;
            String cellKeyPrefix = relatedPartyCellEntry.getKey().substring(0, relatedPartyCellEntry.getKey().lastIndexOf("#") + 1);
            dynamicRowCellMap.get(cellKeyPrefix + "glrrandrczjb_jwgljyjelx").getStyle().setLocked(Boolean.valueOf(false));
            dynamicRowCellMap.get(cellKeyPrefix + "glrrandrczjb_jngljyjelx").getStyle().setLocked(Boolean.valueOf(false));
            if (IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.contains(relatedParty.getLong("area.id"))) {
                dynamicRowCellMap.get(cellKeyPrefix + "glrrandrczjb_jwgljyjelx").getStyle().setLocked(Boolean.valueOf(true));
                continue;
            }
            dynamicRowCellMap.get(cellKeyPrefix + "glrrandrczjb_jngljyjelx").getStyle().setLocked(Boolean.valueOf(true));
        }
    }

    private void setEquityInvestmentLockCell(Map<String, Cell> fixCellMap, Map<String, String> showData) {
        String rowDimensionPrefix = "qyxtzb_qyxtzgxhlfpgtop5gd_";
        HashMap<String, String> colDimensionDefaultValueMap = new HashMap<String, String>(3);
        colDimensionDefaultValueMap.put("qyxtzb_gdmc", "");
        colDimensionDefaultValueMap.put("qyxtzb_gdlx", "0");
        colDimensionDefaultValueMap.put("qyxtzb_gjdq", "0");
        for (int i = 1; i <= 5; ++i) {
            Boolean isLocked = false;
            for (Map.Entry colDimensionDefaultValueEntry : colDimensionDefaultValueMap.entrySet()) {
                if (!((String)colDimensionDefaultValueEntry.getValue()).equals(showData.get(rowDimensionPrefix + i + "#" + (String)colDimensionDefaultValueEntry.getKey()))) continue;
                isLocked = true;
                break;
            }
            if (!isLocked.booleanValue()) continue;
            fixCellMap.get(rowDimensionPrefix + i + "#" + "qyxtzb_gxhlje").getStyle().setLocked(Boolean.valueOf(true));
        }
    }

    private Boolean isTransFormRelatedPartyCellKey(String cellKey) {
        return cellKey.startsWith("yxzcsyqjyb_h") && cellKey.endsWith("yxzcsyqjyb_glfmcl") || cellKey.startsWith("wxzcsyqjyb_h") && cellKey.endsWith("wxzcsyqjyb_glfmcl") || cellKey.startsWith("yxzcshiyqjyb_h") && cellKey.endsWith("yxzcshiyqjyb_glfmcl") || cellKey.startsWith("wxzcshiyqjyb_h") && cellKey.endsWith("wxzcshiyqjyb_glfmcl") || cellKey.startsWith("jrzcjyb_h") && cellKey.endsWith("jrzcjyb_glfmcl") || cellKey.startsWith("gllwb_h") && cellKey.endsWith("gllwb_glfmcl");
    }

    private Boolean isFundsInflowOrOutflowRelatedPartyCellKey(String cellKey) {
        return cellKey.startsWith(DeclareReportDynRowEnum.INCORPORATING_FUNDS_DYN_ROW.getDynRowDimension()) && cellKey.endsWith(DeclareReportDynRowEnum.INCORPORATING_FUNDS_DYN_ROW.getRelatedPartyColDimension()) || cellKey.startsWith(DeclareReportDynRowEnum.FINANCING_FUNDS_DYN_ROW.getDynRowDimension()) && cellKey.endsWith(DeclareReportDynRowEnum.FINANCING_FUNDS_DYN_ROW.getRelatedPartyColDimension());
    }

    private Boolean isRelatedRelationshipRelatedPartyCellKey(String cellKey) {
        return cellKey.startsWith(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension()) && cellKey.endsWith(DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getRelatedPartyColDimension());
    }

    private Boolean baseDataValueIsEmpty(String value) {
        return StringUtils.isEmpty((CharSequence)value) || "0".equals(value);
    }

    private void setDynamicRowCellLocked(Cell cell, Boolean locked) {
        if (cell == null || cell.getStyle() == null) {
            return;
        }
        if (locked.equals(cell.getStyle().getLocked())) {
            return;
        }
        Style style = (Style)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)cell.getStyle()), Style.class);
        style.setLocked(locked);
        cell.setStyle(style);
    }
}

