/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.declarereport.extension;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.tree.TreeNode;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declarereporttree.service.DeclareReportTreeService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.tctb.common.util.TreeUtils;
import kd.taxc.ictm.business.declaretree.DeclareTreeBusiness;
import kd.taxc.ictm.common.enums.FillFormCatalogEnum;
import org.apache.commons.collections4.MapUtils;

public class IctmDeclareReportTreeServiceImpl
implements DeclareReportTreeService {
    public Map<String, Object> loadTreeByCurrentData(DeclareRequestModel requestModel, DeclareResponseModel responseModel, String selectNode, String sourceFrom, Map<String, String> currentData) {
        ArrayList<String> notFillFormNumber = new ArrayList<String>(20);
        if (MapUtils.isNotEmpty(currentData)) {
            for (Map.Entry<String, String> currentDataEntry : currentData.entrySet()) {
                FillFormCatalogEnum fillFormCatalogEnum = FillFormCatalogEnum.getFillFormCatalogEnumByCellKey(currentDataEntry.getKey());
                if (fillFormCatalogEnum == null || currentDataEntry.getValue().equals("1")) continue;
                notFillFormNumber.addAll(fillFormCatalogEnum.getNumber());
            }
        }
        List<TreeNode> allTreeData = this.getAllTreeData(requestModel.getTemplateType(), notFillFormNumber);
        List treeNodes = TreeUtils.buildWithChildren(allTreeData);
        HashMap<String, Object> data = new HashMap<String, Object>(2);
        data.put("treeData", treeNodes);
        data.put("selected", ((TreeNode)treeNodes.get(0)).getType());
        return data;
    }

    public Map<String, Object> loadTree(DeclareRequestModel requestModel, String selectNode, String sourceFrom) {
        return null;
    }

    private List<TreeNode> getAllTreeData(String templateType, List<String> excludeDataNumbers) {
        DynamicObject[] treeData = DeclareTreeBusiness.getDeclareTreeByType(templateType);
        ArrayList<TreeNode> allData = new ArrayList<TreeNode>(treeData.length);
        for (DynamicObject treeDatum : treeData) {
            if (excludeDataNumbers.contains(treeDatum.getString("number"))) continue;
            allData.add(this.getTreeNode(treeDatum.getString("id"), treeDatum.getString("alias"), treeDatum.getString("name"), treeDatum.getString("parent.id")));
        }
        return allData;
    }

    private TreeNode getTreeNode(String id, String name, String type, String parentId) {
        TreeNode treeNode = new TreeNode();
        treeNode.setId(id);
        treeNode.setText(name);
        treeNode.setType(type);
        treeNode.setParentid(parentId);
        return treeNode;
    }
}

