/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.declarereport.extension;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.AbstractFormView;
import kd.taxc.bdtaxr.business.constant.CheckFailTypeEnum;
import kd.taxc.bdtaxr.business.domain.CheckResultDto;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.buttoncalculate.service.ButtonCalculateService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.formplugin.taxdeclare.MultiDeclarePlugin;
import kd.taxc.ictm.common.enums.ButtonEnum;
import kd.taxc.ictm.common.enums.business.button.ButtonClickHandle;

public class IctmDraftButtonCalculateServiceImpl
implements ButtonCalculateService {
    public Map<String, String> buttonCalculate(DeclareRequestModel requestModel, DeclareResponseModel responseModel, MultiDeclarePlugin plugin) {
        AbstractFormView multiDeclareView = (AbstractFormView)plugin.getView();
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)multiDeclareView.getPageCache().get("CUSTOMARGS"), Map.class);
        String buttonKey = (String)paramMap.get("buttonKey");
        List selectRows = (List)paramMap.get("checkedList");
        List selectRowIndexes = selectRows.stream().map(p -> Integer.parseInt(p)).collect(Collectors.toList());
        AbstractFormView parentView = (AbstractFormView)multiDeclareView.getParentView();
        Map showData = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("showData"), Map.class);
        ButtonEnum buttonEnum = ButtonEnum.getEnumByButtonKey(buttonKey);
        ButtonClickHandle buttonClickHandle = buttonEnum.getButtonClickHandle();
        Map<String, String> result = buttonClickHandle.buttonClickChangeData(requestModel, buttonEnum, buttonClickHandle.getRowDimensions(buttonEnum, selectRowIndexes.stream().map(p -> p.toString()).collect(Collectors.toList())), showData);
        return result;
    }

    public CheckResultDto checkButtonCalculate(DeclareRequestModel requestModel, DeclareResponseModel responseModel, MultiDeclarePlugin plugin) {
        AbstractFormView multiDeclareView = (AbstractFormView)plugin.getView();
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)multiDeclareView.getPageCache().get("CUSTOMARGS"), Map.class);
        String buttonKey = (String)paramMap.get("buttonKey");
        List selectRows = (List)paramMap.get("checkedList");
        List selectRowIndexes = selectRows.stream().map(p -> Integer.parseInt(p)).collect(Collectors.toList());
        AbstractFormView parentView = (AbstractFormView)multiDeclareView.getParentView();
        Map showData = (Map)SerializationUtils.fromJsonString((String)parentView.getPageCache().get("showData"), Map.class);
        ButtonEnum buttonEnum = ButtonEnum.getEnumByButtonKey(buttonKey);
        ButtonClickHandle buttonClickHandle = buttonEnum.getButtonClickHandle();
        Map.Entry<Boolean, String> entry = buttonClickHandle.verifyButtonClick(buttonEnum, buttonClickHandle.getRowDimensions(buttonEnum, selectRowIndexes.stream().map(p -> p.toString()).collect(Collectors.toList())), showData);
        if (entry == null) {
            return new CheckResultDto(true, "", false, null);
        }
        if (entry.getKey().booleanValue()) {
            return new CheckResultDto(false, entry.getValue(), false, CheckFailTypeEnum.SHOW_CONFIRM);
        }
        return new CheckResultDto(false, entry.getValue(), true, CheckFailTypeEnum.SHOW_ALERT);
    }
}

