/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.declarereport.extension;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.AbstractFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.taxc.bdtaxr.business.taxdeclare.extensionpoint.declaredynamicrowcalculate.service.DeclareDynamicRowCalculateService;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.declare.model.response.DeclareResponseModel;
import kd.taxc.bdtaxr.common.declare.model.result.DeclareDynamicRowCalculateServiceResult;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.bdtaxr.formplugin.taxdeclare.MultiDeclarePlugin;
import kd.taxc.ictm.business.declarereport.DraftDynCellDataConvertBusiness;
import kd.taxc.ictm.business.fetchdata.IctmDraftGlobalDynRowListFetchBusiness;
import kd.taxc.ictm.common.dto.OtherTransDetailDto;
import kd.taxc.ictm.common.dto.OtherTransSummaryDynRowDto;
import kd.taxc.ictm.common.dto.RelatedFinancingDto;
import kd.taxc.ictm.common.enums.DeclareRuleConfigEnum;
import kd.taxc.ictm.common.enums.DynRowDataTypeEnum;
import kd.taxc.ictm.common.enums.OtherTransSummaryEnum;
import kd.taxc.ictm.common.util.DateUtils;
import org.apache.commons.collections4.CollectionUtils;

public class IctmDraftDeclareDynamicRowCalculateServiceImpl
implements DeclareDynamicRowCalculateService {
    private static final Log log = LogFactory.getLog(IctmDraftDeclareDynamicRowCalculateServiceImpl.class);

    public DeclareDynamicRowCalculateServiceResult dynamicRowCalculate(Map<String, String> changeCellMap, DeclareRequestModel requestModel, DeclareResponseModel responseModel, MultiDeclarePlugin plugin) {
        AbstractFormView pluginView = (AbstractFormView)plugin.getView();
        Map showData = (Map)SerializationUtils.fromJsonString((String)pluginView.getPageCache().get("showData"), Map.class);
        HashMap<String, String> changeDataMap = new HashMap<String, String>(16);
        DeclareDynamicRowCalculateServiceResult result = new DeclareDynamicRowCalculateServiceResult(new HashMap(16), new HashMap(16), changeDataMap);
        for (Map.Entry<String, String> entry : changeCellMap.entrySet()) {
            String colDimension;
            String cellKey = entry.getKey();
            String value = entry.getValue();
            String rowDimension = cellKey.split("#")[0];
            DeclareRuleConfigEnum detailRowEnum = DeclareRuleConfigEnum.getEnumByRowColDimension(rowDimension, colDimension = cellKey.substring(cellKey.lastIndexOf("#") + 1));
            if (detailRowEnum == null) continue;
            showData.put(cellKey, value);
            if (detailRowEnum.getDataType() == DynRowDataTypeEnum.OTHER_TRANS_DETAIL.getDataTypeCode().intValue() && Long.parseLong((String)showData.get(cellKey.substring(0, cellKey.lastIndexOf("#") + 1) + "qtjymxb_jyf")) == IctmDraftGlobalDynRowListFetchBusiness.nonRelatedPartyId) continue;
            ArrayList summaryDynRows = new ArrayList(1);
            for (OtherTransSummaryEnum otherTransSummaryEnum : OtherTransSummaryEnum.values()) {
                List dynRows = otherTransSummaryEnum.getDynRows().stream().filter(p -> p.getDependencyDynRowDimension().equals(rowDimension)).collect(Collectors.toList());
                summaryDynRows.addAll(dynRows);
            }
            if (CollectionUtils.isEmpty(summaryDynRows)) continue;
            long countryId = Long.parseLong((String)showData.get(cellKey.substring(0, cellKey.lastIndexOf("#") + 1) + "qtjymxb_gjdq"));
            boolean isDomestic = IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.contains(countryId);
            for (OtherTransSummaryDynRowDto summaryDynRow : summaryDynRows) {
                Map<String, String> changeCellDataMap = this.getSummaryChangedCellDataMap(showData, summaryDynRow, isDomestic);
                this.handleDynRows(changeCellDataMap, showData, summaryDynRow, isDomestic, result);
                changeDataMap.putAll(changeCellDataMap);
            }
        }
        log.info("===========IctmDraftDeclareDynamicRowCalculateServiceImpl#dynamicRowCalculate===return:{}", (Object)JSONObject.toJSONString(changeDataMap));
        return result;
    }

    public List<OtherTransDetailDto> getOtherTransDetailList(Map<String, String> showData, String changedCellKey) {
        String[] cellKeySplit = changedCellKey.split("#");
        return DraftDynCellDataConvertBusiness.getOtherTransDetailList(showData, cellKeySplit[0]);
    }

    public Map<String, String> getDetailChangedCellDataMap(List<OtherTransDetailDto> otherTransDetailList, String dynRowDimension) {
        HashMap<String, String> result = new HashMap<String, String>(otherTransDetailList.size() * 5);
        int index = 1;
        for (OtherTransDetailDto otherTransDetail : otherTransDetailList) {
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_seq"), String.valueOf(index));
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_jyf"), otherTransDetail.getRelatedPartyId().toString());
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_ywmc"), otherTransDetail.getBizName());
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_jynr"), String.join((CharSequence)"\u3001", otherTransDetail.getTransContentId().stream().map(p -> p.toString()).collect(Collectors.toList())));
            String amountDimension = IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_jyje");
            result.put(amountDimension, otherTransDetail.getTransAmount().toString());
            ++index;
        }
        return result;
    }

    public Map<String, String> getRelatedFinancingChangedCellDataMap(List<RelatedFinancingDto> relatedFinancingList, String dynRowDimension) {
        HashMap<String, String> result = new HashMap<String, String>(relatedFinancingList.size() * 9);
        int index = 1;
        for (RelatedFinancingDto relatedFinancing : relatedFinancingList) {
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_seq"), String.valueOf(index));
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_jyf"), relatedFinancing.getRelatedPartyId().toString());
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_ywmc"), relatedFinancing.getBizName());
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_jynr"), String.join((CharSequence)"\u3001", relatedFinancing.getTransContentId().stream().map(p -> p.toString()).collect(Collectors.toList())));
            String amountDimension = IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_jyjelx");
            result.put(amountDimension, relatedFinancing.getTransAmount().toString());
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_jdjebj"), relatedFinancing.getLoanAmount().toString());
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_startdate"), DateUtils.format(relatedFinancing.getYearStartDate()));
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_enddate"), DateUtils.format(relatedFinancing.getYearEndDate()));
            result.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_ydll"), relatedFinancing.getAgreedInterestRate().toString());
            ++index;
        }
        return result;
    }

    public Map<String, String> getSummaryChangedCellDataMap(Map<String, String> showData, OtherTransSummaryDynRowDto summaryDynRow, Boolean isDomestic) {
        HashMap<String, String> result;
        block6: {
            List<OtherTransDetailDto> otherTransDetailList;
            block5: {
                Map<String, List<OtherTransDetailDto>> otherTransDetails = this.getOtherTransDetails(showData);
                log.info("===========IctmDraftDeclareDynamicRowCalculateServiceImpl#getSummaryChangedCellDataMap===otherTransDetails:{}", (Object)JSONObject.toJSONString(otherTransDetails));
                Set<Long> questionDataIdList = IctmDraftGlobalDynRowListFetchBusiness.getQuestionDataIdList(otherTransDetails);
                log.info("===========IctmDraftDeclareDynamicRowCalculateServiceImpl#getSummaryChangedCellDataMap===questionDataIdList:{}", (Object)JSONObject.toJSONString(questionDataIdList));
                otherTransDetailList = IctmDraftGlobalDynRowListFetchBusiness.getSummaryNeedOtherTransDetailData(otherTransDetails.get(summaryDynRow.getDependencyDynRowDimension()), questionDataIdList);
                log.info("===========IctmDraftDeclareDynamicRowCalculateServiceImpl#getSummaryChangedCellDataMap===otherTransDetailList:{}", (Object)JSONObject.toJSONString(otherTransDetailList));
                result = new HashMap<String, String>(16);
                if (!isDomestic.booleanValue()) break block5;
                List<OtherTransDetailDto> domesticOtherTransDetailList = otherTransDetailList.stream().filter(p -> IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.contains(p.getCountryId())).sorted(Comparator.comparing(OtherTransDetailDto::getTransAmount).reversed()).collect(Collectors.toList());
                DynamicRowModel summaryTop5DynData = IctmDraftGlobalDynRowListFetchBusiness.getSummaryTop5DynData(summaryDynRow.getDomesticTop5DynRowDimension(), 0L, domesticOtherTransDetailList, summaryDynRow.getTransDirection(), summaryDynRow.getDomesticTop5DynRowStartIndex());
                for (Object dynDataMap : summaryTop5DynData.getRowList()) {
                    result.putAll((Map<String, String>)dynDataMap);
                }
                if (domesticOtherTransDetailList.size() <= IctmDraftGlobalDynRowListFetchBusiness.FIVE) break block6;
                DynamicRowModel summaryOtherDynData = IctmDraftGlobalDynRowListFetchBusiness.getSummaryOtherDynData(summaryDynRow.getDomesticOtherDynRowDimension(), 0L, domesticOtherTransDetailList, summaryDynRow.getTransDirection(), summaryDynRow.getDomesticOtherDynRowStartIndex());
                for (Map otherDynDataMap : summaryOtherDynData.getRowList()) {
                    result.putAll(otherDynDataMap);
                }
                break block6;
            }
            List<OtherTransDetailDto> domesticOtherTransDetailList = otherTransDetailList.stream().filter(p -> !IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.contains(p.getCountryId())).sorted(Comparator.comparing(OtherTransDetailDto::getTransAmount).reversed()).collect(Collectors.toList());
            DynamicRowModel summaryTop5DynData = IctmDraftGlobalDynRowListFetchBusiness.getSummaryTop5DynData(summaryDynRow.getAbroadTop5DynRowDimension(), 0L, domesticOtherTransDetailList, summaryDynRow.getTransDirection(), summaryDynRow.getAbroadTop5DynRowStartIndex());
            for (Map dynDataMap : summaryTop5DynData.getRowList()) {
                result.putAll(dynDataMap);
            }
            if (domesticOtherTransDetailList.size() > IctmDraftGlobalDynRowListFetchBusiness.FIVE) {
                DynamicRowModel summaryOtherDynData = IctmDraftGlobalDynRowListFetchBusiness.getSummaryOtherDynData(summaryDynRow.getAbroadOtherDynRowDimension(), 0L, domesticOtherTransDetailList, summaryDynRow.getTransDirection(), summaryDynRow.getAbroadOtherDynRowStartIndex());
                for (Map otherDynDataMap : summaryOtherDynData.getRowList()) {
                    result.putAll(otherDynDataMap);
                }
            }
        }
        return result;
    }

    public Map<String, List<OtherTransDetailDto>> getOtherTransDetails(Map<String, String> showData) {
        HashMap<String, List<OtherTransDetailDto>> otherTransDetails = new HashMap<String, List<OtherTransDetailDto>>(12);
        for (DeclareRuleConfigEnum value : DeclareRuleConfigEnum.values()) {
            otherTransDetails.put(value.getDynRowDimension(), DraftDynCellDataConvertBusiness.getOtherTransDetailList(showData, value.getDynRowDimension()));
        }
        return otherTransDetails;
    }

    public void handleDynRows(Map<String, String> changeCellDataMap, Map<String, String> showData, OtherTransSummaryDynRowDto summaryDynRow, Boolean isDomestic, DeclareDynamicRowCalculateServiceResult result) {
        List<Map.Entry<String, String>> changeDynRowCellData;
        int changeCellDataMaxRowIndex;
        String dynRowDimension = isDomestic != false ? summaryDynRow.getDomesticOtherDynRowDimension() : summaryDynRow.getAbroadOtherDynRowDimension();
        List<Map.Entry<String, String>> showDynRowDataMap = showData.entrySet().stream().filter(p -> ((String)p.getKey()).startsWith(dynRowDimension)).collect(Collectors.toList());
        int showDataMaxRowIndex = this.getDynRowMaxRowIndex(showDynRowDataMap);
        if (showDataMaxRowIndex > (changeCellDataMaxRowIndex = this.getDynRowMaxRowIndex(changeDynRowCellData = changeCellDataMap.entrySet().stream().filter(p -> ((String)p.getKey()).startsWith(dynRowDimension)).collect(Collectors.toList())).intValue())) {
            ArrayList<Integer> deleteRowIndexes = new ArrayList<Integer>(showDataMaxRowIndex - changeCellDataMaxRowIndex);
            for (int i = changeCellDataMaxRowIndex + 1; i <= showDataMaxRowIndex; ++i) {
                deleteRowIndexes.add(i);
            }
            result.getDynRowCellListForDel().put(dynRowDimension + "#1", deleteRowIndexes);
        } else if (showDataMaxRowIndex < changeCellDataMaxRowIndex) {
            HashMap<String, String> addRowCellDataMap = new HashMap<String, String>((changeCellDataMaxRowIndex - showDataMaxRowIndex) * 6);
            for (int i = showDataMaxRowIndex + 1; i <= changeCellDataMaxRowIndex; ++i) {
                addRowCellDataMap.putAll(IctmDraftGlobalDynRowListFetchBusiness.getSummaryDynRowData(dynRowDimension, i, changeCellDataMap.get(this.getDynRowColDimension(dynRowDimension, i, "qtjymxb_seq")), changeCellDataMap.get(this.getDynRowColDimension(dynRowDimension, i, "qtjymxb_jyf")), changeCellDataMap.get(this.getDynRowColDimension(dynRowDimension, i, "qtjymxb_ywmc")), changeCellDataMap.get(this.getDynRowColDimension(dynRowDimension, i, "qtjymxb_jynr")), changeCellDataMap.get(this.getDynRowColDimension(dynRowDimension, i, "qtjymxb_jyfx")), changeCellDataMap.get(this.getDynRowColDimension(dynRowDimension, i, "qtjymxb_jyje"))));
            }
            ArrayList<HashMap<String, String>> addRows = new ArrayList<HashMap<String, String>>(1);
            addRows.add(addRowCellDataMap);
            result.getDynRowForAdd().put(dynRowDimension + "#1", addRows);
        }
    }

    private Integer getDynRowMaxRowIndex(Collection<Map.Entry<String, String>> dynRowDataMap) {
        return dynRowDataMap.stream().filter(p -> ((String)p.getKey()).split("#").length == 3).map(p -> Integer.parseInt(((String)p.getKey()).split("#")[1])).sorted((a, b) -> Integer.compare(b, a)).findFirst().orElse(0);
    }

    private String getDynRowColDimension(String dynRowDimension, int index, String colDimension) {
        return IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, colDimension);
    }
}

