/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.fetchdata;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.util.StringUtils;
import kd.taxc.ictm.business.declarereport.IctmDeclareReportFixCellDataBusiness;
import kd.taxc.ictm.business.fetchdata.IctmDraftGlobalDynRowListFetchBusiness;
import kd.taxc.ictm.common.enums.DeclareReportDynRowEnum;
import kd.taxc.ictm.common.util.DateUtils;

public class IctmDeclareGlobalDynRowListFetchBusiness {
    public static Map<String, String> getRelatedRelationshipDynRowMap(DynamicObject relatedParty, String rowIndex, String seq, Date startDate, Date endDate) {
        HashMap<String, String> result = new HashMap<String, String>(9);
        String dynRowDimension = DeclareReportDynRowEnum.RELATED_RELATIONSHIP_DYN_ROW.getDynRowDimension();
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "glgxb_seq"), seq);
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "glgxb_glfmcl"), relatedParty.getString("id"));
        long typeId = relatedParty.getLong("type.id");
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "glgxb_glflxl"), String.valueOf(typeId));
        long areaId = relatedParty.getLong("area.id");
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "glgxb_gjdql"), String.valueOf(areaId));
        String idNumber = relatedParty.getString("idnumber");
        if (Stream.of("1", "3").anyMatch(p -> p.equals(relatedParty.getString("type.number"))) && IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.stream().noneMatch(p -> p == areaId)) {
            if (StringUtils.isNotEmpty((String)idNumber)) {
                result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "glgxb_zjzll"), "1899969749635689474");
            }
        } else {
            result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "glgxb_zjzll"), relatedParty.getString("idtype.id"));
        }
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "glgxb_nsrsbhhsfzjhml"), idNumber);
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "glgxb_glgxlxl"), "1899388771951183872");
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "glgxb_qsrql"), DateUtils.format(startDate));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "glgxb_jzrql"), DateUtils.format(endDate));
        return result;
    }

    public static Map<String, String> getOverseasRelatedPartyDynRowMap(DynamicObject relatedParty, String rowIndex, String seq, Date startDate) {
        HashMap<String, String> result = new HashMap<String, String>(24);
        String dynRowDimension = DeclareReportDynRowEnum.OVERSEAS_RELATED_PARTY_DYN_ROW.getDynRowDimension();
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_seq"), seq);
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_nsrmc"), relatedParty.getString("id"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_nsrsbh"), relatedParty.getString("idnumber"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_zcgjdq"), relatedParty.getString("area.id"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_jygjdq"), relatedParty.getString("businessplace.id"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_jyfw"), relatedParty.getString("businessscope"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_sysdsxzdszmc"), relatedParty.getString("taxtype"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_sssdsxzdszdssyh"), relatedParty.getString("taxdiscount"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_sjsf"), BigDecimal.ZERO.toString());
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_zczbbz"), relatedParty.getString("registercurrency.id"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_zczbje"), relatedParty.getString("registervalue"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_tzzebz"), relatedParty.getString("totalcurrency.id"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_tzzeje"), relatedParty.getString("totalvalue"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_sshy"), relatedParty.getString("industrycode.id"));
        if (relatedParty.getDate("paystartdate") != null && relatedParty.getDate("payenddate") != null) {
            int year = DateUtils.getYear(startDate);
            String payStartDateStr = DateUtils.format(relatedParty.getDate("paystartdate"));
            Date payEndDate = relatedParty.getDate("payenddate");
            String startDateStr = payStartDateStr.replace(payStartDateStr.substring(0, 4), String.valueOf(year));
            String payEndDateStr = DateUtils.format(relatedParty.getDate("payenddate"));
            String endDateStr = payEndDateStr.replace(payEndDateStr.substring(0, 4), String.valueOf(year));
            if (DateUtils.getMonthOfDate(payEndDate) != 12 || DateUtils.getDayOfDate(payEndDate) != 31) {
                endDateStr = payEndDateStr.replace(payEndDateStr.substring(0, 4), String.valueOf(year + 1));
            }
            result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_szgnsndqsrq"), startDateStr);
            result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_szgnsndjzrq"), endDateStr);
        }
        String isLegalPerson = "1".equals(relatedParty.getString("type.number")) ? "1" : "0";
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_dlfr"), isLegalPerson);
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_fddbrhfzr"), relatedParty.getString("legalperson"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_dlhs"), relatedParty.getBoolean("alonecal") ? "1" : "0");
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_bzgbcwbb"), relatedParty.getBoolean("individualrpt") ? "1" : "0");
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_ssgs"), relatedParty.getBoolean("islistedcompany") ? "1" : "0");
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_ssgpdm"), relatedParty.getString("stockcode"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_ssjys"), relatedParty.getString("exchange.id"));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(dynRowDimension, rowIndex, "jwglfxxb_jzbwb"), relatedParty.getString("recordingcurrency.id"));
        return result;
    }

    public static Map<String, String> getIncorporatingAndReleasingFundDynRowMap(String draftDynRowDimension, String declareDynRowDimension, Map<String, String> cellKeyValueMap, String declareRowIndex, String draftRowIndex) {
        HashMap<String, String> result = new HashMap<String, String>(7);
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(declareDynRowDimension, declareRowIndex, "common_item_sequence_number"), declareRowIndex);
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(declareDynRowDimension, declareRowIndex, "glrrandrczjb_glfmc"), cellKeyValueMap.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(draftDynRowDimension, draftRowIndex, "glzjrt_jyf")));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(declareDynRowDimension, declareRowIndex, "glrrandrczjb_gljynr"), cellKeyValueMap.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(draftDynRowDimension, draftRowIndex, "glzjrt_jynr")));
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(declareDynRowDimension, declareRowIndex, "glrrandrczjb_jdje"), cellKeyValueMap.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(draftDynRowDimension, draftRowIndex, "glzjrt_jdjebj")));
        Integer yearOccupyDays = Integer.parseInt(cellKeyValueMap.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(draftDynRowDimension, draftRowIndex, "glzjrt_nrzyts")));
        yearOccupyDays = yearOccupyDays == 366 ? Integer.valueOf(365) : yearOccupyDays;
        result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(declareDynRowDimension, declareRowIndex, "glrrandrczjb_bnsjzyts"), yearOccupyDays.toString());
        Long countryId = Long.parseLong(cellKeyValueMap.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(draftDynRowDimension, draftRowIndex, "glzjrt_gjdq")));
        if (IctmDraftGlobalDynRowListFetchBusiness.domesticCountryIds.contains(countryId)) {
            result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(declareDynRowDimension, declareRowIndex, "glrrandrczjb_jngljyjelx"), cellKeyValueMap.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(draftDynRowDimension, draftRowIndex, "glzjrt_jyjelx")));
        } else {
            result.put(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(declareDynRowDimension, declareRowIndex, "glrrandrczjb_jwgljyjelx"), cellKeyValueMap.get(IctmDeclareGlobalDynRowListFetchBusiness.compositeRowColDimension(draftDynRowDimension, draftRowIndex, "glzjrt_jyjelx")));
        }
        return result;
    }

    public static String compositeRowColDimension(String ... values) {
        return IctmDeclareReportFixCellDataBusiness.compositeRowColDimension(values);
    }
}

