/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.fetchdata;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.taxc.bdtaxr.common.tctb.common.vo.formula.DynamicRowModel;
import kd.taxc.ictm.common.dto.OtherTransDetailDto;
import kd.taxc.ictm.common.dto.OtherTransSummaryDynRowDto;
import kd.taxc.ictm.common.dto.RelatedFinancingDto;
import kd.taxc.ictm.common.enums.OtherTransSummaryEnum;
import kd.taxc.ictm.common.util.DateUtils;

public class IctmDraftGlobalDynRowListFetchBusiness {
    private static final Log log = LogFactory.getLog(IctmDraftGlobalDynRowListFetchBusiness.class);
    public static long nonRelatedPartyId = 1559306370707441664L;
    public static List<Long> domesticCountryIds = Stream.of(Long.valueOf(1555086414142877696L)).collect(Collectors.toList());
    public static final Integer FIVE = 5;

    public static DynamicRowModel getOtherTransDetailDynRowData(Long templateId, String dynRowDimension, List<OtherTransDetailDto> otherTransDetails, Map<String, BigDecimal> reportItemAmountMap, Map<List<String>, String> reportItemRowColDimensionMap) {
        otherTransDetails.forEach(otherTransDetail -> IctmDraftGlobalDynRowListFetchBusiness.setTransAmount(otherTransDetail, reportItemAmountMap));
        otherTransDetails = IctmDraftGlobalDynRowListFetchBusiness.recombineOtherTransDetailData(otherTransDetails);
        DynamicRowModel dynamicRowModel = IctmDraftGlobalDynRowListFetchBusiness.getDynamicRowModel(templateId, dynRowDimension, otherTransDetails.size());
        int index = 1;
        for (OtherTransDetailDto otherTransDetail2 : otherTransDetails) {
            HashMap<String, String> rowData = new HashMap<String, String>(7);
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_id"), otherTransDetail2.getId().toString());
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_seq"), String.valueOf(index));
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_jyf"), otherTransDetail2.getRelatedPartyId().toString());
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_gjdq"), otherTransDetail2.getCountryId().toString());
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_ywmc"), otherTransDetail2.getBizName());
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_jynr"), String.join((CharSequence)"\u3001", otherTransDetail2.getTransContentId().stream().map(p -> p.toString()).collect(Collectors.toList())));
            String amountDimension = IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "qtjymxb_jyje");
            rowData.put(amountDimension, otherTransDetail2.getTransAmount().toString());
            reportItemRowColDimensionMap.put(otherTransDetail2.getReportItemId(), amountDimension);
            dynamicRowModel.getRowList().add(rowData);
            ++index;
        }
        return dynamicRowModel;
    }

    public static DynamicRowModel getRelatedFinancingDynRowData(Long templateId, String dynRowDimension, List<RelatedFinancingDto> relatedFinancingList, Map<String, BigDecimal> reportItemAmountMap, Map<List<String>, String> reportItemRowColDimensionMap) {
        relatedFinancingList.forEach(relatedFinancing -> IctmDraftGlobalDynRowListFetchBusiness.setTransAmount(relatedFinancing, reportItemAmountMap));
        relatedFinancingList = IctmDraftGlobalDynRowListFetchBusiness.recombineRelatedFinancingData(relatedFinancingList);
        DynamicRowModel dynamicRowModel = IctmDraftGlobalDynRowListFetchBusiness.getDynamicRowModel(templateId, dynRowDimension, relatedFinancingList.size());
        int index = 1;
        for (RelatedFinancingDto relatedFinancing2 : relatedFinancingList) {
            HashMap<String, String> rowData = new HashMap<String, String>(11);
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_id"), relatedFinancing2.getId().toString());
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_checkbox"), "#checkBox");
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_seq"), String.valueOf(index));
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_jyf"), relatedFinancing2.getRelatedPartyId().toString());
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_gjdq"), relatedFinancing2.getCountryId().toString());
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_ywmc"), relatedFinancing2.getBizName());
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_jynr"), String.join((CharSequence)"\u3001", relatedFinancing2.getTransContentId().stream().map(p -> p.toString()).collect(Collectors.toList())));
            String amountDimension = IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_jyjelx");
            rowData.put(amountDimension, relatedFinancing2.getTransAmount().toString());
            reportItemRowColDimensionMap.put(relatedFinancing2.getReportItemId(), amountDimension);
            BigDecimal loanAmount = relatedFinancing2.getLoanAmount() == null ? BigDecimal.ZERO : relatedFinancing2.getLoanAmount();
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_jdjebj"), loanAmount.toString());
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_startdate"), DateUtils.format(relatedFinancing2.getYearStartDate()));
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_enddate"), DateUtils.format(relatedFinancing2.getYearEndDate()));
            rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowDimension, index, "glzjrt_ydll"), relatedFinancing2.getAgreedInterestRate().toString());
            dynamicRowModel.getRowList().add(rowData);
            ++index;
        }
        return dynamicRowModel;
    }

    public static List<DynamicRowModel> getOtherTransDetailSummaryDynRowData(Long templateId, Map<String, List<OtherTransDetailDto>> otherTransDetails) {
        ArrayList<DynamicRowModel> result = new ArrayList<DynamicRowModel>();
        Set<Long> questionDataIdList = IctmDraftGlobalDynRowListFetchBusiness.getQuestionDataIdList(otherTransDetails);
        for (OtherTransSummaryEnum otherTransSummaryEnum : OtherTransSummaryEnum.values()) {
            List<OtherTransSummaryDynRowDto> dynRows = otherTransSummaryEnum.getDynRows();
            for (OtherTransSummaryDynRowDto dynRow : dynRows) {
                List<OtherTransDetailDto> otherTransDetailList = IctmDraftGlobalDynRowListFetchBusiness.getSummaryNeedOtherTransDetailData(otherTransDetails.get(dynRow.getDependencyDynRowDimension()), questionDataIdList);
                List<OtherTransDetailDto> domesticOtherTransDetailList = otherTransDetailList.stream().filter(p -> domesticCountryIds.contains(p.getCountryId())).sorted(Comparator.comparing(OtherTransDetailDto::getTransAmount).reversed()).collect(Collectors.toList());
                List<OtherTransDetailDto> aboardOtherTransDetailList = otherTransDetailList.stream().filter(p -> !domesticCountryIds.contains(p.getCountryId())).sorted(Comparator.comparing(OtherTransDetailDto::getTransAmount).reversed()).collect(Collectors.toList());
                result.add(IctmDraftGlobalDynRowListFetchBusiness.getSummaryTop5DynData(dynRow.getAbroadTop5DynRowDimension(), templateId, aboardOtherTransDetailList, dynRow.getTransDirection(), dynRow.getAbroadTop5DynRowStartIndex()));
                if (aboardOtherTransDetailList.size() > FIVE) {
                    result.add(IctmDraftGlobalDynRowListFetchBusiness.getSummaryOtherDynData(dynRow.getAbroadOtherDynRowDimension(), templateId, aboardOtherTransDetailList, dynRow.getTransDirection(), dynRow.getAbroadOtherDynRowStartIndex()));
                }
                result.add(IctmDraftGlobalDynRowListFetchBusiness.getSummaryTop5DynData(dynRow.getDomesticTop5DynRowDimension(), templateId, domesticOtherTransDetailList, dynRow.getTransDirection(), dynRow.getDomesticTop5DynRowStartIndex()));
                if (domesticOtherTransDetailList.size() <= FIVE) continue;
                result.add(IctmDraftGlobalDynRowListFetchBusiness.getSummaryOtherDynData(dynRow.getDomesticOtherDynRowDimension(), templateId, domesticOtherTransDetailList, dynRow.getTransDirection(), dynRow.getDomesticOtherDynRowStartIndex()));
            }
        }
        return result;
    }

    private static DynamicRowModel getDynamicRowModel(Long templateId, String dynRowNo, Integer rowListSize) {
        DynamicRowModel rowModel = new DynamicRowModel();
        rowModel.setTemplateId(templateId);
        rowModel.setDynRowNo(dynRowNo + "#1");
        rowModel.setRowList(new ArrayList(rowListSize));
        return rowModel;
    }

    private static void setTransAmount(OtherTransDetailDto otherTransDetail, Map<String, BigDecimal> reportItemAmountMap) {
        BigDecimal amount = BigDecimal.ZERO;
        for (String reportItemId : otherTransDetail.getReportItemId()) {
            amount = amount.add(reportItemAmountMap.get(reportItemId));
        }
        otherTransDetail.setTransAmount(amount);
    }

    public static List<OtherTransDetailDto> recombineOtherTransDetailData(List<OtherTransDetailDto> otherTransDetails) {
        ArrayList<OtherTransDetailDto> nonRelatedParties = new ArrayList<OtherTransDetailDto>();
        ArrayList<OtherTransDetailDto> relatedParties = new ArrayList<OtherTransDetailDto>();
        for (OtherTransDetailDto otherTransDetail : otherTransDetails) {
            if (otherTransDetail.getRelatedPartyId() == nonRelatedPartyId) {
                nonRelatedParties.add(otherTransDetail);
                continue;
            }
            relatedParties.add(otherTransDetail);
        }
        ArrayList<OtherTransDetailDto> result = new ArrayList<OtherTransDetailDto>(otherTransDetails.size());
        result.addAll(relatedParties.stream().sorted(Comparator.comparing(OtherTransDetailDto::getTransAmount).reversed()).collect(Collectors.toList()));
        result.addAll(nonRelatedParties.stream().sorted(Comparator.comparing(OtherTransDetailDto::getTransAmount).reversed()).collect(Collectors.toList()));
        return result;
    }

    public static List<RelatedFinancingDto> recombineRelatedFinancingData(List<RelatedFinancingDto> relatedFinancingList) {
        ArrayList<RelatedFinancingDto> nonRelatedParties = new ArrayList<RelatedFinancingDto>();
        ArrayList<RelatedFinancingDto> relatedParties = new ArrayList<RelatedFinancingDto>();
        for (RelatedFinancingDto relatedFinancingDto : relatedFinancingList) {
            if (relatedFinancingDto.getRelatedPartyId() == nonRelatedPartyId) {
                nonRelatedParties.add(relatedFinancingDto);
                continue;
            }
            relatedParties.add(relatedFinancingDto);
        }
        ArrayList<RelatedFinancingDto> result = new ArrayList<RelatedFinancingDto>(relatedFinancingList.size());
        result.addAll(relatedParties.stream().sorted(Comparator.comparing(OtherTransDetailDto::getTransAmount).reversed()).collect(Collectors.toList()));
        result.addAll(nonRelatedParties.stream().sorted(Comparator.comparing(OtherTransDetailDto::getTransAmount).reversed()).collect(Collectors.toList()));
        return result;
    }

    public static String getDynRowColDimension(String dynRowDimension, int index, String colDimension) {
        StringJoiner joiner = new StringJoiner("#");
        joiner.add(dynRowDimension).add(String.valueOf(index)).add(colDimension);
        return joiner.toString();
    }

    public static Set<Long> getQuestionDataIdList(Map<String, List<OtherTransDetailDto>> otherTransDetails) {
        List allOtherTransDetailData = otherTransDetails.values().stream().flatMap(p -> p.stream()).collect(Collectors.toList());
        HashSet<Long> questionDataIds = new HashSet<Long>();
        questionDataIds.addAll(allOtherTransDetailData.stream().filter(p -> p.getTransAmount().compareTo(BigDecimal.ZERO) < 0).map(p -> p.getId()).collect(Collectors.toList()));
        log.info("1===========IctmDraftGlobalDynRowListFetchBusiness#getQuestionDataIdList===questionDataIdList:{}", (Object)JSONObject.toJSONString(questionDataIds));
        Map<Long, List<OtherTransDetailDto>> idAndOtherTransDetailMap = allOtherTransDetailData.stream().collect(Collectors.groupingBy(p -> p.getId()));
        for (Map.Entry<Long, List<OtherTransDetailDto>> entry : idAndOtherTransDetailMap.entrySet()) {
            if (entry.getValue().size() <= 1) continue;
            questionDataIds.add(entry.getKey());
        }
        log.info("2===========IctmDraftGlobalDynRowListFetchBusiness#getQuestionDataIdList===questionDataIdList:{}", (Object)JSONObject.toJSONString(questionDataIds));
        Map<String, List<OtherTransDetailDto>> bizNameRelatedPartyAndOtherTransDetailMap = allOtherTransDetailData.stream().collect(Collectors.groupingBy(p -> p.getBizName() + "#" + p.getRelatedPartyId()));
        for (Map.Entry<String, List<OtherTransDetailDto>> entry : bizNameRelatedPartyAndOtherTransDetailMap.entrySet()) {
            if (entry.getValue().size() == 1) continue;
            questionDataIds.addAll(entry.getValue().stream().map(p -> p.getId()).collect(Collectors.toList()));
        }
        log.info("3===========IctmDraftGlobalDynRowListFetchBusiness#getQuestionDataIdList===questionDataIdList:{}", (Object)JSONObject.toJSONString(questionDataIds));
        return questionDataIds;
    }

    public static List<OtherTransDetailDto> getSummaryNeedOtherTransDetailData(List<OtherTransDetailDto> originalOtherTransDetailData, Set<Long> questionDataIds) {
        List otherTransDetailList = originalOtherTransDetailData.stream().filter(p -> !questionDataIds.contains(p.getId()) && p.getRelatedPartyId() != nonRelatedPartyId).collect(Collectors.toList());
        Map<Long, List<OtherTransDetailDto>> relatedPartyIdAndOtherTransDetailMap = otherTransDetailList.stream().collect(Collectors.groupingBy(p -> p.getRelatedPartyId()));
        ArrayList<OtherTransDetailDto> targetOtherTransDetailData = new ArrayList<OtherTransDetailDto>(otherTransDetailList.size());
        for (Map.Entry<Long, List<OtherTransDetailDto>> entry : relatedPartyIdAndOtherTransDetailMap.entrySet()) {
            OtherTransDetailDto otherTransDetailDto = entry.getValue().get(0);
            if (entry.getValue().size() == 1) {
                targetOtherTransDetailData.add(otherTransDetailDto);
                continue;
            }
            BigDecimal amount = BigDecimal.ZERO;
            ArrayList<String> bizNames = new ArrayList<String>(entry.getValue().size());
            ArrayList<Long> transContentIds = new ArrayList<Long>();
            ArrayList<String> transContents = new ArrayList<String>();
            for (OtherTransDetailDto transDetailDto : entry.getValue()) {
                amount = amount.add(transDetailDto.getTransAmount());
                bizNames.add(transDetailDto.getBizName());
                if (CollectionUtils.isNotEmpty(transDetailDto.getTransContentId())) {
                    transContentIds.addAll(transDetailDto.getTransContentId());
                }
                if (!CollectionUtils.isNotEmpty(transDetailDto.getTransContent())) continue;
                transContents.addAll(transDetailDto.getTransContent());
            }
            OtherTransDetailDto otherTransDetail = new OtherTransDetailDto(otherTransDetailDto.getEntityName(), otherTransDetailDto.getId(), otherTransDetailDto.getRelatedPartyId(), otherTransDetailDto.getRelatedPartyName(), otherTransDetailDto.getCountryId(), otherTransDetailDto.getCountryName(), otherTransDetailDto.getAccessProjectId(), String.join((CharSequence)"\u3001", bizNames), transContentIds, transContents);
            otherTransDetail.setTransAmount(amount);
            targetOtherTransDetailData.add(otherTransDetail);
        }
        return targetOtherTransDetailData;
    }

    public static DynamicRowModel getSummaryTop5DynData(String dynRowNo, Long templateId, List<OtherTransDetailDto> otherTransDetailList, String transDirection, Integer startRowIndex) {
        DynamicRowModel rowModel = IctmDraftGlobalDynRowListFetchBusiness.getDynamicRowModel(templateId, dynRowNo, 5);
        for (int i = 0; i < FIVE; ++i) {
            if (i < otherTransDetailList.size()) {
                OtherTransDetailDto otherTransDetail = otherTransDetailList.get(i);
                rowModel.getRowList().add(IctmDraftGlobalDynRowListFetchBusiness.getSummaryDynRowData(dynRowNo, i + 1, String.valueOf(startRowIndex + i + 1), otherTransDetail.getRelatedPartyId().toString(), otherTransDetail.getBizName(), String.join((CharSequence)"\u3001", otherTransDetail.getTransContentId().stream().distinct().map(p -> p.toString()).collect(Collectors.toList())), transDirection, otherTransDetail.getTransAmount().toString()));
                continue;
            }
            rowModel.getRowList().add(IctmDraftGlobalDynRowListFetchBusiness.getSummaryDynRowData(dynRowNo, i + 1, String.valueOf(startRowIndex + i + 1), "", "", "", "", "0"));
        }
        return rowModel;
    }

    public static DynamicRowModel getSummaryOtherDynData(String dynRowNo, Long templateId, List<OtherTransDetailDto> otherTransDetailList, String transDirection, Integer startRowIndex) {
        DynamicRowModel rowModel = IctmDraftGlobalDynRowListFetchBusiness.getDynamicRowModel(templateId, dynRowNo, otherTransDetailList.size() - FIVE);
        int index = 1;
        for (int i = FIVE.intValue(); i < otherTransDetailList.size(); ++i) {
            OtherTransDetailDto otherTransDetail = otherTransDetailList.get(i);
            rowModel.getRowList().add(IctmDraftGlobalDynRowListFetchBusiness.getSummaryDynRowData(dynRowNo, index, startRowIndex + "." + index, otherTransDetail.getRelatedPartyId().toString(), otherTransDetail.getBizName(), String.join((CharSequence)"\u3001", otherTransDetail.getTransContentId().stream().distinct().map(p -> p.toString()).collect(Collectors.toList())), transDirection, otherTransDetail.getTransAmount().toString()));
            ++index;
        }
        return rowModel;
    }

    public static Map<String, String> getSummaryDynRowData(String dynRowNo, int dynRowIndex, String rowNo, String relatedParty, String bizName, String transContent, String transDirection, String transAmount) {
        HashMap<String, String> rowData = new HashMap<String, String>(7);
        rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowNo, dynRowIndex, "qtjymxb_seq"), rowNo);
        rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowNo, dynRowIndex, "qtjymxb_jyf"), relatedParty);
        rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowNo, dynRowIndex, "qtjymxb_ywmc"), bizName);
        rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowNo, dynRowIndex, "qtjymxb_jynr"), transContent);
        rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowNo, dynRowIndex, "qtjymxb_jyfx"), transDirection);
        rowData.put(IctmDraftGlobalDynRowListFetchBusiness.getDynRowColDimension(dynRowNo, dynRowIndex, "qtjymxb_jyje"), transAmount);
        return rowData;
    }
}

