/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.fetchdata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.taxc.bdtaxr.business.rulefetch.RuleFetchServiceImpl;
import kd.taxc.bdtaxr.common.constant.DeclareConstant;
import kd.taxc.bdtaxr.common.declare.model.request.DeclareRequestModel;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.enums.DeclareServiceEnum;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.vo.TemplateVo;
import kd.taxc.ictm.business.rulefetch.impl.DefaultRuleCalculateServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.IctmExternalPaymentSituationRuleEnginServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.IctmFixRowRuleEnginServiceImpl;
import kd.taxc.ictm.business.rulefetch.impl.IctmRuleAccessConfigServiceImpl;
import kd.taxc.ictm.common.enums.AccessConfigRowDimensionEnum;
import kd.taxc.ictm.common.enums.ExternalPaymentSituationEnum;
import kd.taxc.ictm.common.util.DateUtils;
import kd.taxc.ictm.common.util.StringUtil;

public class IctmFetchDataBusiness {
    public static Map<String, String> getFetchConfigParams(DeclareRequestModel requestModel) {
        TemplateVo templateVo = (TemplateVo)DeclareServiceEnum.getMethod((DeclareServiceEnum)DeclareServiceEnum.GET_BASE_TEMPLATE, (Object[])new Object[]{requestModel.getModelId(), requestModel.getTemplateType(), String.valueOf(requestModel.getOrgId()), DateUtils.stringToDate(requestModel.getSkssqq(), "yyyy-MM-dd"), DateUtils.stringToDate(requestModel.getSkssqz(), "yyyy-MM-dd")});
        if (templateVo == null) {
            return new HashMap<String, String>(0);
        }
        requestModel.setTemplateId(templateVo.getTemplateId());
        requestModel.setBaseTemplate(templateVo.getTemplate());
        Map<String, Long> reportItemNumberFetchProjectIdMap = IctmFetchDataBusiness.getReportItemNumberFetchProjectIdMap(templateVo.getTemplateId());
        ArrayList<RuleEngineParamDto> ruleEngineParamDtoList = new ArrayList<RuleEngineParamDto>(14);
        HashSet usedFetchProjectIds = new HashSet(3);
        for (AccessConfigRowDimensionEnum rowDimensionEnum : AccessConfigRowDimensionEnum.values()) {
            ArrayList<Long> fetchProjectIds = new ArrayList<Long>(3);
            HashMap<String, String> reportItemAccessProjectMap = new HashMap<String, String>(3);
            for (Map.Entry<String, Long> entry : reportItemNumberFetchProjectIdMap.entrySet()) {
                if (!entry.getKey().split("#")[0].equals(rowDimensionEnum.getRowDimension())) continue;
                fetchProjectIds.add(entry.getValue());
                reportItemAccessProjectMap.put(entry.getValue().toString(), entry.getKey());
            }
            usedFetchProjectIds.addAll(fetchProjectIds);
            QFilter accessWhereFilter = new QFilter("itemname.id", "in", fetchProjectIds);
            QFilter sharingSchemeWhereFilter = new QFilter("ruleentity.rule.itemname.id", "in", fetchProjectIds);
            HashMap<String, Cloneable> extendParams = new HashMap<String, Cloneable>(1);
            extendParams.put("reportItemAccessProjectMap", reportItemAccessProjectMap);
            Date skssqq = DateUtils.stringToDate(requestModel.getSkssqq(), "yyyy-MM-dd");
            extendParams.put("skssqq", rowDimensionEnum.getStartDate(skssqq));
            extendParams.put("skssqz", rowDimensionEnum.getEndDate(skssqq));
            RuleEngineParamDto ruleEngineParamDto = new RuleEngineParamDto(requestModel.getOrgId(), skssqq, DateUtils.stringToDate(requestModel.getSkssqz(), "yyyy-MM-dd"), requestModel.getTemplateId(), accessWhereFilter, sharingSchemeWhereFilter, extendParams);
            ruleEngineParamDtoList.add(ruleEngineParamDto);
        }
        ArrayList<Long> fetchProjectIds = new ArrayList<Long>(10);
        HashMap<String, String> reportItemAccessProjectMap = new HashMap<String, String>(10);
        for (Map.Entry<String, Long> entry : reportItemNumberFetchProjectIdMap.entrySet()) {
            if (usedFetchProjectIds.contains(entry.getValue())) continue;
            fetchProjectIds.add(entry.getValue());
            reportItemAccessProjectMap.put(entry.getValue().toString(), entry.getKey());
        }
        QFilter accessWhereFilter = new QFilter("itemname.id", "in", fetchProjectIds);
        QFilter sharingSchemeWhereFilter = new QFilter("ruleentity.rule.itemname.id", "in", fetchProjectIds);
        HashMap<String, HashMap<String, String>> extendParams = new HashMap<String, HashMap<String, String>>(1);
        extendParams.put("reportItemAccessProjectMap", reportItemAccessProjectMap);
        RuleEngineParamDto ruleEngineParam = new RuleEngineParamDto(requestModel.getOrgId(), DateUtils.stringToDate(requestModel.getSkssqq(), "yyyy-MM-dd"), DateUtils.stringToDate(requestModel.getSkssqz(), "yyyy-MM-dd"), requestModel.getTemplateId(), accessWhereFilter, sharingSchemeWhereFilter, extendParams);
        ruleEngineParamDtoList.add(ruleEngineParam);
        ArrayList<RuleFetchMainDto> allData = new ArrayList<RuleFetchMainDto>(ruleEngineParamDtoList.size());
        for (RuleEngineParamDto ruleEngineParamDto : ruleEngineParamDtoList) {
            allData.addAll(new DefaultRuleCalculateServiceImpl().calculateRuleAccess(ruleEngineParamDto, Stream.of(new IctmFixRowRuleEnginServiceImpl()).collect(Collectors.toList()), new IctmRuleAccessConfigServiceImpl("ictm_declare_rule_config", "ictm_sharing_scheme")));
        }
        RuleFetchMainDto saveData = (RuleFetchMainDto)allData.get(0);
        for (int i = 1; i < allData.size(); ++i) {
            saveData.getRuleFetchCellSummaryList().addAll(((RuleFetchMainDto)allData.get(i)).getRuleFetchCellSummaryList());
        }
        saveData.setCustomEvent(requestModel.getCustomEvent());
        HashMap<String, String> businessMap = new HashMap<String, String>(16);
        if (0L == IctmFetchDataBusiness.callRuleFetchService(saveData)) {
            return businessMap;
        }
        saveData.getRuleFetchCellSummaryList().forEach(cell -> {
            if (StringUtils.isNotEmpty((String)cell.getReportItem())) {
                businessMap.put(cell.getReportItem(), String.valueOf(cell.getAmount()));
            }
        });
        return businessMap;
    }

    public static Map<String, String> getExternalPaymentSituationValue(DeclareRequestModel requestModel) {
        List fetchProjectIds = Arrays.stream(ExternalPaymentSituationEnum.values()).map(p -> p.getAccessProjectId()).collect(Collectors.toList());
        QFilter accessWhereFilter = new QFilter("itemname.id", "in", fetchProjectIds);
        QFilter sharingSchemeWhereFilter = new QFilter("ruleentity.rule.itemname.id", "in", fetchProjectIds);
        RuleEngineParamDto ruleEngineParam = new RuleEngineParamDto(requestModel.getOrgId(), DateUtils.stringToDate(requestModel.getSkssqq(), "yyyy-MM-dd"), DateUtils.stringToDate(requestModel.getSkssqz(), "yyyy-MM-dd"), requestModel.getTemplateId(), accessWhereFilter, sharingSchemeWhereFilter, new HashMap(0));
        List<RuleFetchMainDto> ruleFetchMains = new DefaultRuleCalculateServiceImpl().calculateRuleAccess(ruleEngineParam, Stream.of(new IctmExternalPaymentSituationRuleEnginServiceImpl()).collect(Collectors.toList()), new IctmRuleAccessConfigServiceImpl("ictm_declare_rule_config", "ictm_sharing_scheme"));
        RuleFetchMainDto saveData = ruleFetchMains.get(0);
        for (int i = 1; i < ruleFetchMains.size(); ++i) {
            saveData.getRuleFetchCellSummaryList().addAll(ruleFetchMains.get(i).getRuleFetchCellSummaryList());
        }
        HashMap<String, String> businessMap = new HashMap<String, String>(16);
        if (0L == new RuleFetchServiceImpl().addCellData(saveData)) {
            return businessMap;
        }
        saveData.getRuleFetchCellSummaryList().forEach(cell -> {
            if (StringUtils.isNotEmpty((String)cell.getReportItem())) {
                businessMap.put(cell.getReportItem(), String.valueOf(cell.getAmount()));
            }
        });
        return businessMap;
    }

    public static Map<String, Long> getReportItemNumberFetchProjectIdMap(Long templateId) {
        DynamicObjectCollection templateRuleFetchCollection = QueryServiceHelper.query((String)"tpo_template_rule_fetch", (String)"reportitem,formula,reportitem.number", (QFilter[])new QFilter[]{new QFilter("template", "=", (Object)templateId)});
        Map<Long, String> formulaReportItemMap = templateRuleFetchCollection.stream().collect(Collectors.toMap(k -> k.getLong("formula"), v -> v.getString("reportitem.number"), (k, v) -> k));
        Set<Long> formulaIds = formulaReportItemMap.keySet();
        QFilter ruleFetchFilter = new QFilter("id", "in", formulaIds).and("formula", "like", (Object)"{P[%").and("datatype", "=", (Object)"number");
        DynamicObjectCollection formulaNameList = QueryServiceHelper.query((String)"tpo_rule_fetch", (String)"id,name", (QFilter[])new QFilter[]{ruleFetchFilter});
        HashMap<String, Long> result = new HashMap<String, Long>(formulaNameList.size());
        for (DynamicObject object : formulaNameList) {
            if (!StringUtil.isPositiveInteger(object.getString("name"))) continue;
            long projectId = object.getLong("name");
            long formulaId = object.getLong("id");
            result.put(formulaReportItemMap.get(formulaId), projectId);
        }
        return result;
    }

    protected static long callRuleFetchService(RuleFetchMainDto ruleFetchMainDto) {
        RuleFetchServiceImpl ruleFetchService = new RuleFetchServiceImpl();
        RuleFetchMainDto finalRuleFetchMainDto = ruleFetchMainDto;
        if (DeclareConstant.REGETDATA_KEY.equals(ruleFetchMainDto.getCustomEvent())) {
            RuleFetchMainDto queryAllMainDataFromDb = ruleFetchService.queryAllMainDataFromDb(ruleFetchMainDto);
            finalRuleFetchMainDto = ruleFetchService.mergeData(ruleFetchMainDto, queryAllMainDataFromDb);
        }
        return ruleFetchService.saveFetchResult(finalRuleFetchMainDto, true);
    }
}

