/*
 * Decompiled with CFR 0.152.
 */
package kd.taxc.ictm.business.rulefetch;

import java.math.BigDecimal;
import java.math.RoundingMode;
import kd.taxc.bdtaxr.common.dto.rulefetch.RuleFetchMainDto;
import kd.taxc.bdtaxr.common.enums.DataType;
import kd.taxc.bdtaxr.common.rule.dto.RuleEngineParamDto;
import kd.taxc.bdtaxr.common.util.string.StringUtil;
import kd.taxc.ictm.business.rulefetch.impl.DefaultRuleAccessConfigServiceImpl;
import kd.taxc.ictm.common.dto.RuleAccessDetailDto;

public interface RuleEngineService {
    public RuleFetchMainDto businessHandler(RuleEngineParamDto var1, DefaultRuleAccessConfigServiceImpl var2);

    default public BigDecimal convertFetchAmount(BigDecimal originAmount, RuleAccessDetailDto detailRowDto) {
        String absolute = detailRowDto.getAbsolute();
        BigDecimal numAfterPositive = StringUtil.equalsIgnoreCase((CharSequence)absolute, (CharSequence)"true") ? originAmount.abs() : originAmount;
        String dataDirection = detailRowDto.getFetchDirection();
        BigDecimal reverse = new BigDecimal(-1);
        BigDecimal resultAmount = StringUtil.equalsIgnoreCase((CharSequence)"positive", (CharSequence)dataDirection) ? numAfterPositive : numAfterPositive.multiply(reverse);
        String datatypeS = detailRowDto.getFetchType();
        BigDecimal vatRate = detailRowDto.getVatRate();
        if (StringUtil.isNotEmpty((CharSequence)datatypeS) && null != vatRate) {
            if (DataType.JSFLQS.getCode().equals(datatypeS)) {
                resultAmount = resultAmount.divide(BigDecimal.ONE.add(vatRate), 2, RoundingMode.HALF_UP);
            } else if (DataType.CYSLDSQS.getCode().equals(datatypeS)) {
                if (vatRate.compareTo(BigDecimal.ZERO) != 0) {
                    resultAmount = resultAmount.divide(vatRate, 2, RoundingMode.HALF_UP);
                }
            } else if (DataType.SEHSHSJ.getCode().equals(datatypeS)) {
                if (!vatRate.equals(BigDecimal.ZERO)) {
                    resultAmount = resultAmount.divide(vatRate, 2, RoundingMode.HALF_UP).multiply(BigDecimal.ONE.add(vatRate));
                }
            } else if (DataType.HSJHSSE.getCode().equals(datatypeS)) {
                if (!vatRate.equals(BigDecimal.ZERO)) {
                    BigDecimal numerator = resultAmount.multiply(vatRate);
                    BigDecimal denominator = vatRate.add(new BigDecimal(1));
                    resultAmount = numerator.divide(denominator, 2, RoundingMode.HALF_UP);
                }
            } else if (DataType.BHSJHSSE.getCode().equals(datatypeS) && !vatRate.equals(BigDecimal.ZERO)) {
                resultAmount = resultAmount.multiply(vatRate).setScale(2, RoundingMode.HALF_UP);
            }
        }
        return resultAmount;
    }
}

